<?php

class cuti_model extends CI_Model

{
	function __construct()
	{
        parent::__construct();
    }

	public function cuti_tahunan($tahun)
	{
	  $sql ="
			select a.*, b.id_pengelola as nis, b.nama_lengkap from m_cuti_tahunan a left join m_pengelola b 
			on a.id_pengelola = b.id where tahun_cuti = '$tahun' order by b.id_pengelola;			  
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}
	
	public function ambil_cuti($idPengelola)
	{
	  $sql ="
			select ifnull(sum(lama_cuti),0) as lama_cuti From tr_permohonan_cuti where id_pengelola = $idPengelola and tindakan_kadiv = 1 and tindakan_hrd = 1 and 
            left(tgl_permohonan_mulai,4)=(select periode_cuti from m_periode_cuti where is_aktif=1) ;
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}
	
	public function ambil_ijin($idPengelola)
	{
	  $sql ="
			select ifnull(sum(lama_ijin),0)/4 as lama_ijin From tr_permohonan_ijin where id_pengelola = $idPengelola and tindakan_kadiv = 1 and tindakan_hrd = 1 and 
            left(tgl_ijin,4)=(select periode_cuti from m_periode_cuti where is_aktif=1) ;
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}
	
	public function jatah_cuti($pengelola)
	{
	  	$sql ="
			select id_pengelola, tahun_cuti, cuti_tahun_ini, sisa_cuti_tahun_lalu,
			sisa_cuti_2_tahun_lalu, ijin, (select count(a.id) from m_detail_kebijakan_cuti a left join m_kebijakan_cuti b on a.id_header=b.id
			where b.is_cuti_tahunan = 1 and a.tanggal between (select tanggal_awal from m_periode_cuti where is_aktif = 1) 
			and (select tanggal_akhir from m_periode_cuti where is_aktif = 1)) as jumlah_cuti_bersama
			From m_cuti_tahunan where id_pengelola = $pengelola and tahun_cuti = (
			select periode_cuti from m_periode_cuti where is_aktif = 1);
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}
	
	public function cuti_terpakai($pengelola)
	{
	  	$sql ="
		  select id_pengelola, sum(lama_cuti) as cuti_disetujui
		  From tr_permohonan_cuti where id_pengelola = $pengelola and tindakan_hrd = 1 and left(tgl_permohonan_mulai,4) = (
		  select periode_cuti from m_periode_cuti where is_aktif = 1);
		  
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function ijin_terpakai($pengelola)
	{
	  	$sql ="
		  select id_pengelola, count(lama_ijin) as ijin_disetujui
		  From tr_permohonan_ijin where id_pengelola = $pengelola and tindakan_hrd = 1 and left(tgl_ijin,4) = (
		  select periode_cuti from m_periode_cuti where is_aktif = 1);
		  
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

    public function sakit_terpakai($pengelola)
	{
	  	$sql ="
		  select id_pengelola, count(lama_sakit) as sakit_disetujui
		  From tr_permohonan_sakit where id_pengelola = $pengelola and tindakan_hrd = 1 and left(tgl_sakit_awal,4) = (
		  select periode_cuti from m_periode_cuti where is_aktif = 1);
		  
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

    public function telat($pengelola)
	{
	  	$sql ="
		  select id_pengelola, count(telat_masuk) as telat
		  From tr_absen where id_pengelola = '$pengelola' and telat_masuk > 0 and left(tanggal,4) = (
		  select periode_cuti from m_periode_cuti where is_aktif = 1);
		  
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

    public function tidak_absen_pulang($pengelola)
	{
	  	$sql ="
		  select id_pengelola, count(absen_pulang) as tidak_absen_pulang
		  From tr_absen where id_pengelola = '$pengelola' and absen_pulang is null and left(tanggal,4) = (
		  select periode_cuti from m_periode_cuti where is_aktif = 1);
		  
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function sp_hitung_lama_cuti($dt1, $dt2)
	{
		$sql = "CALL sp_hitung_lama_cuti(?, ?)";
		$query = $this->db->query($sql, array($dt1, $dt2));
		mysqli_next_result($this->db->conn_id);
		return $query->result();
	}

	public function permohonan($pengelola)
	{
	    if($pengelola==0){
    	  	$sql ="
    			select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur
    			from tr_permohonan_cuti a left join m_pengelola b on a.id_pengelola = b.id
    			left join m_divisi c on b.divisi=c.id
    			where (b.persetujuan_lembur = 0 and a.tindakan_hrd = 0) or 
                (b.persetujuan_lembur > 0 and a.tindakan_kadiv = 1 and a.tindakan_hrd = 0);
    		";
	    } else {
	        $sql ="
    			select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur
    			from tr_permohonan_cuti a left join m_pengelola b on a.id_pengelola = b.id
    			left join m_divisi c on b.divisi=c.id
    			where b.persetujuan_lembur = $pengelola and a.tindakan_kadiv = 0;
    		";
	    }
	    //where a.tindakan_hrd = 0 order by a.tgl_permohonan desc;    
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function riwayat_permohonan($pengelola)
	{
		if($pengelola==0){
			$sql ="
				select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur, 'HRD' as title
				from tr_permohonan_cuti a left join m_pengelola b on a.id_pengelola = b.id
				left join m_divisi c on b.divisi=c.id
				where (b.persetujuan_lembur = 0 and a.tindakan_hrd > 0) or 
                (b.persetujuan_lembur > 0 and a.tindakan_kadiv = 1 and a.tindakan_hrd > 0) or 
                (b.persetujuan_lembur > 0 and a.tindakan_kadiv = 2) ;
			";
		} else {
			$sql ="
				select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur, 'PENGELOLA' as title  
				from tr_permohonan_cuti a left join m_pengelola b on a.id_pengelola = b.id
				left join m_divisi c on b.divisi=c.id
				where a.id_pengelola = $pengelola and a.tindakan_kadiv > 0;
			";
		}
	   // where a.tindakan_hrd = 1 or a.tindakan_hrd = 2 order by a.tgl_permohonan desc;
	   //where a.id_pengelola = $pengelola and (a.tindakan_hrd = 1 or a.tindakan_hrd = 2) order by a.tgl_permohonan desc;
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}


	public function permohonan_ijin($pengelola)
	{
	
		if($pengelola==0){
    	  	$sql ="
    			select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur
    			from tr_permohonan_ijin a left join m_pengelola b on a.id_pengelola = b.id
    			left join m_divisi c on b.divisi=c.id
    			where (b.persetujuan_lembur = 0 and a.tindakan_hrd = 0) or 
                (b.persetujuan_lembur > 0 and a.tindakan_kadiv = 1 and a.tindakan_hrd = 0);
    		";
	    } else {
	        $sql ="
    			select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur
    			from tr_permohonan_ijin a left join m_pengelola b on a.id_pengelola = b.id
    			left join m_divisi c on b.divisi=c.id
    			where b.persetujuan_lembur = $pengelola and a.tindakan_kadiv = 0;
    		";
	    }
	    

		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function riwayat_permohonan_ijin($pengelola)
	{
	    
	    	if($pengelola==0){
			$sql ="
				select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur, 'HRD' as title
				from tr_permohonan_ijin a left join m_pengelola b on a.id_pengelola = b.id
				left join m_divisi c on b.divisi=c.id
				where (b.persetujuan_lembur = 0 and a.tindakan_hrd > 0) or 
                (b.persetujuan_lembur > 0 and a.tindakan_kadiv = 1 and a.tindakan_hrd > 0) or 
                (b.persetujuan_lembur > 0 and a.tindakan_kadiv = 2) ;
			";
		} else {
			$sql ="
				select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur, 'PENGELOLA' as title  
				from tr_permohonan_ijin a left join m_pengelola b on a.id_pengelola = b.id
				left join m_divisi c on b.divisi=c.id
				where a.id_pengelola = $pengelola and a.tindakan_kadiv > 0;
			";
		}

	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function informasi_sakit($pengelola)
	{
	    if($pengelola==0){
    	  	$sql ="
    			select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur  
    			from tr_permohonan_sakit a left join m_pengelola b on a.id_pengelola = b.id
    			left join m_divisi c on b.divisi=c.id
    			where (b.persetujuan_lembur = 0 and a.tindakan_hrd = 0) or 
                (b.persetujuan_lembur > 0 and a.tindakan_kadiv = 1 and a.tindakan_hrd = 0);
    		";
	    } else {
	        $sql ="
    			select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur 
    			from tr_permohonan_sakit a left join m_pengelola b on a.id_pengelola = b.id
    			left join m_divisi c on b.divisi=c.id
                where b.persetujuan_lembur = $pengelola and a.tindakan_kadiv = 0;
    		";
	    }
	    
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function riwayat_informasi_sakit($pengelola)
	{
		if($pengelola==0){
			$sql ="
				select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur, 'HRD' as title,
				d.keterangan_file, d.nama_file
				from tr_permohonan_sakit a left join m_pengelola b on a.id_pengelola = b.id
				left join m_divisi c on b.divisi=c.id
				left join surat_ket_sakit d on a.id=d.id_permohonan_sakit
				where (b.persetujuan_lembur = 0 and a.tindakan_hrd > 0) or 
                (b.persetujuan_lembur > 0 and a.tindakan_kadiv = 1 and a.tindakan_hrd > 0) or 
                (b.persetujuan_lembur > 0 and a.tindakan_kadiv = 2) ;
			";
		} else {
			$sql ="
				select a.*, b.id_pengelola as nik, b.nama_lengkap, c.divisi, b.jabatan, b.persetujuan_lembur, 'PENGELOLA' as title,
				d.keterangan_file, d.nama_file
				from tr_permohonan_sakit a left join m_pengelola b on a.id_pengelola = b.id
				left join m_divisi c on b.divisi=c.id
				left join surat_ket_sakit d on a.id=d.id_permohonan_sakit
				where a.id_pengelola = $pengelola and a.tindakan_kadiv > 0;
			";
		}
	
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}


	public function tanggal_sakit($id)
	{
	  $sql ="
			select * from tr_permohonan_sakit where id_pengelola = $id 
			and tindakan_hrd = 1 and left(tgl_sakit_awal,4) = (select periode_cuti from m_periode_cuti
			where is_aktif = 1);			  
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function cuti_hari_ini()
	{
	  $sql ="
		select a.*, b.nama_lengkap From tr_permohonan_cuti a left join m_pengelola b on a.id_pengelola=b.id
		where left(now(),10) BETWEEN a.tgl_permohonan_mulai and a.tgl_permohonan_akhir and a.tindakan_hrd = 1;
	";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function ijin_hari_ini()
	{
	  $sql ="
		select a.*, b.nama_lengkap From tr_permohonan_ijin a left join m_pengelola b on a.id_pengelola=b.id
		where left(now(),10) = a.tgl_ijin and a.tindakan_hrd = 1;
	";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function sakit_hari_ini()
	{
	  $sql ="
		select a.*, b.nama_lengkap From tr_permohonan_sakit a left join m_pengelola b on a.id_pengelola=b.id
		where left(now(),10) BETWEEN a.tgl_sakit_awal and a.tgl_sakit_akhir and a.tindakan_hrd = 1;
	";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}



    public function laporancuti($tanggal1, $tanggal2)
	{
	  $sql ="
			select a.id_pengelola, b.id_pengelola as kode_pengelola, b.nama_lengkap, a.tgl_permohonan_mulai, a.tgl_permohonan_akhir, 
			a.keperluan, a.lama_cuti 
            from tr_permohonan_cuti a left join m_pengelola b on a.id_pengelola=b.id 
            where a.tindakan_kadiv = 1 and a.tindakan_hrd = 1 and ((a.tgl_permohonan_mulai BETWEEN '$tanggal1' and '$tanggal2') or 
            (a.tgl_permohonan_akhir BETWEEN '$tanggal1' and '$tanggal2')) order by a.tgl_permohonan_mulai, a.id_pengelola;

		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

    public function laporanijin($tanggal1, $tanggal2)
	{
	  $sql ="
    	    select a.id_pengelola, b.id_pengelola as kode_pengelola, b.nama_lengkap, a.tgl_ijin, a.keperluan, a.lama_ijin, a.jam_ijin_mulai, a.jam_ijin_akhir
            from tr_permohonan_ijin a left join m_pengelola b on a.id_pengelola=b.id 
            where a.tindakan_kadiv = 1 and a.tindakan_hrd = 1 and a.tgl_ijin BETWEEN '$tanggal1' and '$tanggal2' order by a.tgl_ijin, a.id_pengelola ;

		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}
	
	public function laporankunjungan($tanggal1, $tanggal2)
	{
	  $sql ="
            select a.id_pengelola, b.id_pengelola as kode_pengelola, b.nama_lengkap, a.tgl_dinas, a.keperluan, a.jam_pergi, a.jam_pulang
            from tr_permohonan_kunjungan a left join m_pengelola b on a.id_pengelola=b.id 
            where a.tindakan_kadiv = 1 and a.tindakan_hrd = 1 and a.tgl_dinas BETWEEN '$tanggal1' and '$tanggal2' order by a.tgl_dinas, a.id_pengelola ;

		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}
	
	public function laporansakit($tanggal1, $tanggal2)
	{
	  $sql ="
            select a.id_pengelola, b.id_pengelola as kode_pengelola, b.nama_lengkap, a.tgl_sakit_awal, a.tgl_sakit_akhir, a.keterangan_sakit, a.lama_sakit
            from tr_permohonan_sakit a left join m_pengelola b on a.id_pengelola=b.id 
            where a.tindakan_kadiv = 1 and a.tindakan_hrd = 1 and ((a.tgl_sakit_awal BETWEEN '$tanggal1' and '$tanggal2') or 
            (a.tgl_sakit_akhir BETWEEN '$tanggal1' and '$tanggal2')) order by a.tgl_sakit_awal, a.id_pengelola ;
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}
	
}

?>
