<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class pengelola extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('pengelola_model');
	}

	public function daftar_pengelola($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kelompok']   = $this->master_model->select_in('m_divisi','*',"order by id");
			$this->load->view('pengelola/list', $data);
	    }
	}

	public function input_pengelola($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where 1=0");
			$this->load->view('pengelola/input_pengelola', $data);
	    }
	}

	public function insert_pengelola($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$this->load->helper(array('form', 'url')); 
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'jpg|png|jpeg|bmp';
		$config['max_size'] = '12048';		
			
		$this->upload->initialize($config);
		if(!$this->upload->do_upload('photo')){
			$photo="";
		}else{
			$photo=$this->upload->file_name;
		}

		$pengelola = $this->master_model->select_in('m_pengelola', '*', "order by NIP desc limit 1;");
		if(empty($pengelola)){
			$kode = 'KMW-'.'0001';
			$nip = '000001';
		} else {
			$no = substr($pengelola[0]->NIP,0,6);
			$next1 = $no + 1;
			$panjang = strlen($next1);
			$next2 = str_repeat('0',6-$panjang).$next1;
			$nip = $next2;

			$no = substr($pengelola[0]->id_pengelola,4,4);
			$next1 = $no + 1;
			$panjang = strlen($next1);
			$next2 = str_repeat('0',4-$panjang).$next1;
			$kode = 'KMW-'.$next2;
		}

		$this->master_model->qrcode($kode);
		$qr = $kode.".png";

		$data = array(
			'id_pengelola' => $kode,
			'nip' => $nip,
			'nama_lengkap' => $this->input->post('nama_lengkap'),
			'referentor' => $this->input->post('referentor'),			
			'divisi' => $this->input->post('divisi'),
			'jabatan' => $this->input->post('jabatan'),
			'tempat_lahir' => $this->input->post('tempat_lahir'),
			'tanggal_lahir' => $this->input->post('tanggal_lahir'),						
			'jenis_kelamin' => $this->input->post('jenis_kelamin'),
			'golongan_darah' => $this->input->post('golongan_darah'),
			'warga_negara' => $this->input->post('warga_negara'),
			'agama' => $this->input->post('agama'),			
			'alamat' => $this->input->post('alamat'),
			'status_rumah' => $this->input->post('status_rumah'),
			'no_tlp_rumah' => $this->input->post('no_tlp_rumah'),
			'no_hp' => $this->input->post('no_hp'),			
			'email' => $this->input->post('email'),
			'no_ktp' => $this->input->post('no_ktp'),
			'berlaku_ktp' => $this->input->post('berlaku_ktp'),
			'no_jamsostek' => $this->input->post('no_jamsostek'),			
			'no_npwp' => $this->input->post('no_npwp'),
			'jenis_sim' => $this->input->post('jenis_sim'),
			'kendaraan' => $this->input->post('kendaraan'),
			'status_kendaraan' => $this->input->post('status_kendaraan'),
			'status_pengelola' => $this->input->post('status_pengelola'),
			'tgl_resign' => $this->input->post('tgl_resign'),
			'persetujuan_lembur' => $this->input->post('persetujuan_lembur'),
			'foto_pengelola' => $photo,
			'qr_code' => $qr,
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);
		$this->db->insert('m_pengelola', $data);
		redirect('pengelola/daftar_pengelola/'.$menuid);
	}



	public function update_pengelola($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$id");
			$this->load->view('pengelola/update_pengelola', $data);
	    }
	}

	public function edit_pengelola($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$pengelola = $this->master_model->select_in('m_pengelola', 'foto_pengelola', "where id = $id");

		$this->load->helper(array('form', 'url')); 
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'jpg|png|jpeg|bmp';
		$config['max_size'] = '12048';						

		$this->upload->initialize($config);
		if(!$this->upload->do_upload('photo')){
			$photo=$pengelola[0]->foto_pengelola;
		}else{
			$photo=$this->upload->file_name;
		}
		
		$resign = $this->input->post('tgl_resign');
		
		if(empty($resign)){
		    $active = 1;
		} else {
		    $active = 0;
		}
		
		$data = array(			
			'nama_lengkap' => $this->input->post('nama_lengkap'),
			'referentor' => $this->input->post('referentor'),			
			'divisi' => $this->input->post('divisi'),
			'jabatan' => $this->input->post('jabatan'),
			'tempat_lahir' => $this->input->post('tempat_lahir'),
			'tanggal_lahir' => $this->input->post('tanggal_lahir'),						
			'jenis_kelamin' => $this->input->post('jenis_kelamin'),
			'golongan_darah' => $this->input->post('golongan_darah'),
			'warga_negara' => $this->input->post('warga_negara'),
			'agama' => $this->input->post('agama'),			
			'alamat' => $this->input->post('alamat'),
			'status_rumah' => $this->input->post('status_rumah'),
			'no_tlp_rumah' => $this->input->post('no_tlp_rumah'),
			'no_hp' => $this->input->post('no_hp'),			
			'email' => $this->input->post('email'),
			'no_ktp' => $this->input->post('no_ktp'),
			'berlaku_ktp' => $this->input->post('berlaku_ktp'),
			'no_jamsostek' => $this->input->post('no_jamsostek'),			
			'no_npwp' => $this->input->post('no_npwp'),
			'jenis_sim' => $this->input->post('jenis_sim'),
			'kendaraan' => $this->input->post('kendaraan'),
			'status_kendaraan' => $this->input->post('status_kendaraan'),			
			'status_pengelola' => $this->input->post('status_pengelola'),
			'is_active' => $active,
			'tgl_resign' => $this->input->post('tgl_resign'),
			'persetujuan_lembur' => $this->input->post('persetujuan_lembur'),
			'foto_pengelola' => $photo,			
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);

		$this->db->where('id', $id);
		$this->db->update('m_pengelola', $data);

		redirect('pengelola/daftar_pengelola/'.$menuid);
	}

	public function struktur_jabatan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_struktur']= $this->pengelola_model->struktur_jabatan();

			$this->load->view('pengelola/struktur_jabatan', $data);
	    }
	}

	public function insert_struktur_jabatan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	

		$data = array(
			'kode_struktur' => $this->input->post('kode_struktur'),
			'nama_pengelola' => $this->input->post('nama_pengelola'),
			'jabatan' => $this->input->post('jabatan'),
			'struktur_parent' => $this->input->post('parent'),
			'status' =>	'Aktif',
			'is_kadiv' => $this->input->post('is_kadiv')
		);
		$this->db->insert('m_jabatan', $data);

		$data_bid=$this->pengelola_model->getStrukturID();
		$id = $data_bid[0]->last_id;

		$data_level=$this->pengelola_model->spGetLevelStruktur($id);

		redirect('pengelola/struktur_jabatan/'.$menuid);
	}


	public function generate_qr_anggota()
	{	
		$anggota = $this->master_model->select_in('anggota', '*', "order by id");

		foreach($anggota as $ang1 =>$ang):
			$this->master_model->qrcode($ang->no_anggota);
			$qr = $ang->no_anggota.".png";

			$data = array(				
				'qr_file' => $qr
			);

			$this->db->where('id', $ang->id);
			$this->db->update('anggota', $data);
		endforeach;

		redirect('pengelola/daftar_pengelola/'.$menuid);
	}

	public function generate_qr_pengelola()
	{	
		$anggota = $this->master_model->select_in('m_pengelola', '*', "order by id");

		foreach($anggota as $ang1 =>$ang):
			$this->master_model->qrcode($ang->id_pengelola);
			$qr = $ang->id_pengelola.".png";

			$data = array(				
				'qr_code' => $qr
			);

			$this->db->where('id', $ang->id);
			$this->db->update('m_pengelola', $data);
		endforeach;

		redirect('pengelola/daftar_pengelola/'.$menuid);
	}
}
?>
