<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class master_anggota extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('backend_model');
  	}

	public function daftar_anggota($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_member'] = $this->backend_model->member();

    		$this->load->view('member/list', $data);
	    }
	}

	public function input_anggota($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_member']    = $this->master_model->select_in('anggota','*',"order by no_anggota");

    		$this->load->view('member/input_anggota', $data);
	    }
	}

	public function insert_anggota($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$data = array(			
			'no_anggota' => $this->input->post('no_anggota'),			
			'nama_anggota' => $this->input->post('nama_anggota'),
			'no_ktp' => $this->input->post('no_ktp'),
			'tempat_lahir' => $this->input->post('tempat_lahir'),
			'tgl_lahir' => $this->input->post('tgl_lahir'),
			'no_referentor' => $this->input->post('no_ref'),
			'nama_referentor' => $this->input->post('nama_ref'),
			'hubungan_referentor' => $this->input->post('hub_ref'),
			'nama_ibu_kandung' => $this->input->post('nama_ibu'),
			'alamat_ktp' => $this->input->post('alamat_ktp'),
			'alamat_domisili' => $this->input->post('alamat_domisili'),
			'no_hp' => $this->input->post('no_hp'),
			'nama_usaha' => $this->input->post('nama_usaha'),
			'alamat_usaha' => $this->input->post('alamat_usaha'),
			'no_telp_usaha' => $this->input->post('no_telp_usaha'),
			'bidang_usaha' => $this->input->post('bidang_usaha'),
			'lama_bekerja' => $this->input->post('lama_bekerja'),
			'nama_pasangan' => $this->input->post('nama_pasangan'),
			'hubungan' => $this->input->post('hubungan'),
			'no_ktp_pasangan' => $this->input->post('no_ktp_pasangan'),
			'tempat_lahir_pasangan' => $this->input->post('tempat_lahir_pasangan'),
			'tgl_lahir_pasangan' => $this->input->post('tgl_lahir_pasangan'),
			'alamat_pasangan' => $this->input->post('alamat_pasangan'),
			'bidang_usaha_pasangan' => $this->input->post('bidang_usaha_pasangan'),
			'create_date' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('anggota', $data);
		redirect('master_anggota/daftar_anggota/'.$menuid);
	}	

	public function edit_anggota($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_member']    = $this->master_model->select_in('anggota','*',"WHERE id = $id");

    		$this->load->view('member/edit_anggota', $data);
	    }
	}

	public function update_anggota($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$data = array(			
			'no_anggota' => $this->input->post('no_anggota'),
			'nama_anggota' => $this->input->post('nama_anggota'),
			'no_ktp' => $this->input->post('no_ktp'),
			'tempat_lahir' => $this->input->post('tempat_lahir'),
			'tgl_lahir' => $this->input->post('tgl_lahir'),
			'no_referentor' => $this->input->post('no_ref'),
			'nama_referentor' => $this->input->post('nama_ref'),
			'hubungan_referentor' => $this->input->post('hub_ref'),
			'nama_ibu_kandung' => $this->input->post('nama_ibu'),
			'alamat_ktp' => $this->input->post('alamat_ktp'),
			'alamat_domisili' => $this->input->post('alamat_domisili'),
			'no_hp' => $this->input->post('no_hp'),
			'nama_usaha' => $this->input->post('nama_usaha'),
			'alamat_usaha' => $this->input->post('alamat_usaha'),
			'no_telp_usaha' => $this->input->post('no_telp_usaha'),
			'bidang_usaha' => $this->input->post('bidang_usaha'),
			'lama_bekerja' => $this->input->post('lama_bekerja'),
			'nama_pasangan' => $this->input->post('nama_pasangan'),
			'hubungan' => $this->input->post('hubungan'),
			'no_ktp_pasangan' => $this->input->post('no_ktp_pasangan'),
			'tempat_lahir_pasangan' => $this->input->post('tempat_lahir_pasangan'),
			'tgl_lahir_pasangan' => $this->input->post('tgl_lahir_pasangan'),
			'alamat_pasangan' => $this->input->post('alamat_pasangan'),
			'bidang_usaha_pasangan' => $this->input->post('bidang_usaha_pasangan'),
			'update_date' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('anggota', $data);

		redirect('master_anggota/daftar_anggota/'.$menuid);
	}	

	public function pesan_member($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pesan']    = $this->backend_model->pesan_member($id);

    		$this->load->view('member/pesan', $data);
	    }
	}

	public function pesan_member_unread($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$sql="update pesan set status = 'Read' where ID = $id;";
		$qry = $this->db->query($sql);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pesan']    = $this->backend_model->pesan_member($member);

    		$this->load->view('member/pesan', $data);
	    }
	}

	public function detail_pesan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pesan']    = $this->master_model->select_in('pesan','*',"WHERE ID = $id");

    		$this->load->view('member/detail_pesan', $data);
	    }
	}

	public function insert_pesan($menuid, $member)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data_urut = $this->master_model->select_in('pesan', 'urutan', "WHERE member_id = $member ORDER BY urutan Desc limit 1");
		if(empty($data_urut[0]->urutan)){$urut=0;}else{$urut=$data_urut[0]->urutan + 1;}

		$data = array(
			'member_id' => $member,
			'pesan_dari' => 'Admin',
			'urutan' => $urut,
			'datetime_pesan' => date('Y-m-d H:i:s'),
			'admin_id' => $user_id,
			'isi_pesan' => $this->input->post('isi_pesan'),
			'status' => 'Unread'
		);
		$this->db->insert('pesan', $data);
		redirect('master_member/pesan_member/'.$menuid.'/'.$member);
	}

	public function lokasi_layanan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_lokasi']    = $this->backend_model->lokasi_layanan($id);

    		$this->load->view('member/lokasi_layanan', $data);
	    }
	}

	
}
?>
