<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class master_pasien extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
  	}

	public function pasien($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pasien']    = $this->master_model->select_in('MST_PATIENT','*',"ORDER BY id DESC");

    		$this->load->view('pasien/list', $data);
	    }
	}

	public function input_pasien($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pasien']    = $this->master_model->select_in('MST_PATIENT','*',"ORDER BY id DESC");

    		$this->load->view('pasien/input_pasien', $data);
	    }
	}

	public function ubah_pasien($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pasien']    = $this->master_model->select_in('MST_PATIENT','*',"WHERE ID = $id");

    		$this->load->view('pasien/edit_pasien', $data);
	    }
	}

	public function insert_pasien($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$this->load->helper(array('form', 'url')); 
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'gif|jpg|png|jpeg|bmp|pdf';
		$config['max_size'] = '2048';
		// $config['max_width']  = '1288';
		// $config['max_height']  = '768';
		
		$this->upload->initialize($config);
		  if(!$this->upload->do_upload('photo')){
			  $photo="";
		  }else{
			  $photo=$this->upload->file_name;
		}

		$data_code = $this->master_model->genPasien();
		
		$data = array(
			'code' => $data_code[0]->code,
			'name' => $this->input->post('name'),
			'nick_name' => $this->input->post('nick_name'),
			'gender' => $this->input->post('gender'),
			'birth_place' => $this->input->post('birth_place'),
			'birth_date' => $this->input->post('birth_date'),
			'occupation' => $this->input->post('occupation'),
			'blood_type' => $this->input->post('blood_type'),
			'bpjs_no' => $this->input->post('bpjs_no'),
			'alergy' => $this->input->post('alergy'),
			'patient_type' => $this->input->post('patient_type'),
			'company' => $this->input->post('company'),	
			'address' => $this->input->post('address'),
			'city' => $this->input->post('city'),
			'district' => $this->input->post('district'),
			'subdistrict' => $this->input->post('subdistrict'),
			'zipcode' => $this->input->post('zipcode'),
			'country' => $this->input->post('country'),
			'id_card_type' => $this->input->post('id_card_type'),
			'id_card_no' => $this->input->post('id_card_no'),
			'religion' => $this->input->post('religion'),
			'phone' => $this->input->post('phone'),
			'handphone_1' => $this->input->post('handphone_1'),
			'handphone_2' => $this->input->post('handphone_2'),
			'email' => $this->input->post('email'),
			'emergency_contact' => $this->input->post('emergency_contact'),
			'emergency_phone' => $this->input->post('emergency_phone'),
			'emergency_relationship' => $this->input->post('emergency_relationship'),
			'photograph' => $photo,
			'payment_type' => $this->input->post('payment_type'),
			'insurance_name' => $this->input->post('insurance_name'),
			'insurance_branch' => $this->input->post('insurance_branch'),
			'insurance_no' => $this->input->post('insurance_no'),
			'notes' => $this->input->post('notes'),
			'konsultasi' => $this->input->post('konsultasi'),
			'keluhan_utama' => $this->input->post('keluhan_utama'),
			'penyakit' => $this->input->post('penyakit'),
			'minum_obat_tertentu' => $this->input->post('minum_obat_tertentu'),
			'sikat_gigi' => $this->input->post('sikat_gigi'),
			'waktu_sikat_gigi' => $this->input->post('waktu_sikat_gigi'),
			'kebiasaan_buruk' => $this->input->post('kebiasaan_buruk'),
			'warna_gigi' => $this->input->post('warna_gigi'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1
			
			
		);
		$this->db->insert('MST_PATIENT', $data);
		redirect('master_pasien/pasien/'.$menuid);
	}

	public function edit_pasien($menuid)
	{
		$ID = $this->input->post('id');		
		$data_edit=$this->master_model->mst_edit_dr('MST_PATIENT',$ID);
		
		echo'
			<form method="post" action="'.base_url().'master_pasien/edit_process_pasien/'.$menuid.'/'.$ID.'" enctype="multipart/form-data">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Pasien</h4>
				</div>
				<div class="modal-body">				

						<div class="form-group">
							<label>No. Rekam Medis</label>
							<input type="text" name="label_code" value="'.$data_edit[0]->code.'" class="form-control" required="required" disabled>
							<input type="hidden" name="code" value="'.$data_edit[0]->code.'" >
						</div>

						<div class="form-group">
							<label>Nama Pasien</label>
							<input type="text" name="name" value="'.$data_edit[0]->name.'" class="form-control" required="required" >
						</div>

						<div class="form-group">
							<label>Nama Panggilan Pasien</label>
							<input type="text" name="nick_name" value="'.$data_edit[0]->nick_name.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Jenis Kelamin </label>
							
							<select name="gender" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Jenis Kelamin --
								</option>
								';
									$idGender = $data_edit[0]->gender;
									$data_gender = $this->master_model->select_in('MST_GENDER','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_gender); $a++)
									{
										if($idGender == $data_gender[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_gender[$a]->id.'" '.$select.'>
												'.$data_gender[$a]->gender.'
											</option>
										';
									}
								echo'
							</select>
						</div>						

						<div class="form-group">
							<label>Tempat Lahir </label>
							
							<select name="birth_place" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Tempat Lahir --
								</option>
								';
									$idTL = $data_edit[0]->birth_place;
									$data_tl = $this->master_model->select_in('MST_CITY','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_tl); $a++)
									{
										if($idTL == $data_tl[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_tl[$a]->id.'" '.$select.'>
												'.$data_tl[$a]->city.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Tanggal Lahir </label>
							<input type="date" name="birth_date"  class="form-control datepicker" value="'.$data_edit[0]->birth_date.'" >
						</div>				

						<div class="form-group">
							<label>Pekerjaan</label>
							<input type="text" name="occupation" value="'.$data_edit[0]->occupation.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Golongan Darah</label>
							<input type="text" name="blood_type" value="'.$data_edit[0]->blood_type.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>No. BPJS</label>
							<input type="text" name="bpjs_no" value="'.$data_edit[0]->bpjs_no.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Type Pasien </label>
							
							<select name="patient_type" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Type Pasien --
								</option>
								';
									$idType = $data_edit[0]->patient_type;
									$data_type = $this->master_model->select_in('MST_PATIENT_TYPE','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_type); $a++)
									{
										if($idType == $data_type[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_type[$a]->id.'" '.$select.'>
												'.$data_type[$a]->patient_type.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Nama Perusahaan </label>
							
							<select name="company" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Perusahaan --
								</option>
								';
									$idPT = $data_edit[0]->company;
									$data_pt = $this->master_model->select_in('MST_COMPANY','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_pt); $a++)
									{
										if($idPT == $data_pt[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_pt[$a]->id.'" '.$select.'>
												'.$data_pt[$a]->company.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Alamat</label>
							<textarea name="address"  class="form-control" >'.$data_edit[0]->address.'</textarea>
						</div>

						<div class="form-group">
							<label>Kota </label>
							
							<select name="city" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Kota --
								</option>
								';
									$idCity = $data_edit[0]->city;
									$data_city = $this->master_model->select_in('MST_CITY','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_city); $a++)
									{
										if($idCity == $data_city[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_city[$a]->id.'" '.$select.'>
												'.$data_city[$a]->city.'
											</option>
										';
									}
								echo'
							</select>
						</div>												
						
						<div class="form-group">
							<label>Wilayah </label>
							
							<select name="district" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Wilayah --
								</option>
								';
									$idDis = $data_edit[0]->district;
									$data_dis = $this->master_model->select_in('MST_DISTRICT','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_dis); $a++)
									{
										if($idDis == $data_dis[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_dis[$a]->id.'" '.$select.'>
												'.$data_dis[$a]->district.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Kecamatan </label>
							
							<select name="subdistrict" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Kecamatan --
								</option>
								';
									$idSubDis = $data_edit[0]->subdistrict;
									$data_subdis = $this->master_model->select_in('MST_SUBDISTRICT','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_subdis); $a++)
									{
										if($idSubDis == $data_subdis[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_subdis[$a]->id.'" '.$select.'>
												'.$data_subdis[$a]->subdistrict.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Kode Pos </label>
							
							<select name="zipcode" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Kode Pos --
								</option>
								';
									$idZip = $data_edit[0]->zipcode;
									$data_zip = $this->master_model->select_in('MST_ZIPCODE','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_zip); $a++)
									{
										if($idZip == $data_zip[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_zip[$a]->id.'" '.$select.'>
												'.$data_zip[$a]->zipcode.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Negara </label>
							
							<select name="country" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Negara --
								</option>
								';
									$idCoun = $data_edit[0]->country;
									$data_coun = $this->master_model->select_in('MST_COUNTRY','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_coun); $a++)
									{
										if($idCoun == $data_coun[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_coun[$a]->id.'" '.$select.'>
												'.$data_coun[$a]->country.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Jenis Identitas </label>
							
							<select name="id_card_type" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Jenis Identits --
								</option>
								';
									$idIden = $data_edit[0]->id_card_type;
									$data_iden = $this->master_model->select_in('MST_ID_CARD_TYPE','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_iden); $a++)
									{
										if($idIden == $data_iden[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_iden[$a]->id.'" '.$select.'>
												'.$data_iden[$a]->id_card_type.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>No. Identitas</label>
							<input type="text" name="id_card_no" value="'.$data_edit[0]->id_card_no.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Agama </label>
							
							<select name="religion" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Agama --
								</option>
								';
									$idRelig = $data_edit[0]->religion;
									$data_relig = $this->master_model->select_in('MST_RELIGION','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_relig); $a++)
									{
										if($idRelig == $data_relig[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_relig[$a]->id.'" '.$select.'>
												'.$data_relig[$a]->religion.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>No. Telepon</label>
							<input type="text" name="phone" value="'.$data_edit[0]->phone.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>No. HP (1)</label>
							<input type="text" name="handphone_1" value="'.$data_edit[0]->handphone_1.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>No. HP (2)</label>
							<input type="text" name="handphone_2" value="'.$data_edit[0]->handphone_2.'" class="form-control">
						</div>

						<div class="form-group">
							<label>Email</label>
							<input type="text" name="email" value="'.$data_edit[0]->email.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Emergency Contact </label>
							<input type="text" name="emergency_contact" value="'.$data_edit[0]->emergency_contact.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Emergency Phone </label>
							<input type="text" name="emergency_phone" value="'.$data_edit[0]->emergency_phone.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Emergency Relation</label>
							<input type="text" name="emergency_relationship" value="'.$data_edit[0]->emergency_relationship.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>File Foto Pasien</label>
							<input type="file" name="photo">
							';
							if($data_edit[0]->photograph == '')
							{
								echo '<img class="img-circle" src="'.base_url().'assets/img/default-50x50.gif" alt="User Avatar">';
							}else {
								echo '<img class="img-circle" src="'.base_url().'uploads/foto/'.$data_edit[0]->photograph.'" height="100px" width="100px" alt="User Avatar">';
							}
						echo'
							<input type="hidden" name="photograph" value="'.$data_edit[0]->photograph.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Jenis Pembayaran </label>
							
							<select name="payment_type" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Jenis Pembayaran --
								</option>
								';
									$idPay = $data_edit[0]->payment_type;
									$data_pay = $this->master_model->select_in('MST_PAYMENT_TYPE','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_pay); $a++)
									{
										if($idPay == $data_pay[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_pay[$a]->id.'" '.$select.'>
												'.$data_pay[$a]->payment_type.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Nama Asuransi </label>
							<input type="text" name="insurance_name" value="'.$data_edit[0]->insurance_name.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Cabang Asuransi </label>
							<input type="text" name="insurance_branch" value="'.$data_edit[0]->insurance_branch.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>No. Asuransi</label>
							<input type="text" name="insurance_no" value="'.$data_edit[0]->insurance_no.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Catatan</label>
							<textarea name="notes"  class="form-control" >'.$data_edit[0]->notes.'</textarea>
						</div>

                    </div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';

	}

	public function edit_process_pasien($menuid, $id_pasien)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$this->load->helper(array('form', 'url')); 
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'gif|jpg|png|jpeg|bmp';
		$config['max_size'] = '2048';
		
		$this->upload->initialize($config);
		if(!$this->upload->do_upload('photo')){
			$photo=$this->input->post('photograph');
		}else{
			$photo=$this->upload->file_name;
		}
			
		$data = array(			
			'code' => $this->input->post('code'),
			'name' => $this->input->post('name'),
			'nick_name' => $this->input->post('nick_name'),
			'gender' => $this->input->post('gender'),
			'birth_place' => $this->input->post('birth_place'),
			'birth_date' => $this->input->post('birth_date'),
			'occupation' => $this->input->post('occupation'),
			'blood_type' => $this->input->post('blood_type'),
			'bpjs_no' => $this->input->post('bpjs_no'),
			'alergy' => $this->input->post('alergy'),
			'patient_type' => $this->input->post('patient_type'),
			'company' => $this->input->post('company'),	
			'address' => $this->input->post('address'),
			'city' => $this->input->post('city'),
			'district' => $this->input->post('district'),
			'subdistrict' => $this->input->post('subdistrict'),
			'zipcode' => $this->input->post('zipcode'),
			'country' => $this->input->post('country'),
			'id_card_type' => $this->input->post('id_card_type'),
			'id_card_no' => $this->input->post('id_card_no'),
			'religion' => $this->input->post('religion'),
			'phone' => $this->input->post('phone'),
			'handphone_1' => $this->input->post('handphone_1'),
			'handphone_2' => $this->input->post('handphone_2'),
			'email' => $this->input->post('email'),
			'emergency_contact' => $this->input->post('emergency_contact'),
			'emergency_phone' => $this->input->post('emergency_phone'),
			'emergency_relationship' => $this->input->post('emergency_relationship'),
			'photograph' => $photo,
			'payment_type' => $this->input->post('payment_type'),
			'insurance_name' => $this->input->post('insurance_name'),
			'insurance_branch' => $this->input->post('insurance_branch'),
			'insurance_no' => $this->input->post('insurance_no'),
			'notes' => $this->input->post('notes'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	

		$this->db->where('id', $id_pasien);
		$this->db->update('MST_PATIENT', $data);

		redirect('master_pasien/pasien/'.$menuid);
	}	

	public function delete_pasien($menuid, $id_pasien)
	{
		$this->db->where('id', $id_pasien);
		$this->db->delete('MST_PATIENT');
		redirect('master_pasien/pasien/'.$menuid);
	}

	public function pdf($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['pdf']  = $this->master_model->pdf($id);

			$this->load->view('pasien/pdf',$data);
			
	    }
	}


	public function file_mr($menuid, $ID)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_file_mr']  = $this->master_model->FileMR($ID);

    		$this->load->view('pasien/file_mr', $data);
	    }
	}

	public function histori_mr($menuid, $ID)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_histori_mr']  = $this->master_model->HistoriMR($ID);

    		$this->load->view('pasien/histori_mr', $data);
	    }
	}

	public function insert_file_mr($menuid, $ID)
	{
		$submit = $this->input->post('submit');
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$admin = $this->session->userdata('username');

		$this->load->helper(array('form', 'url')); 
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'pdf';
		$config['max_size'] = '2048';
		// $config['max_width']  = '1288';
		// $config['max_height']  = '768';
		
		$this->upload->initialize($config);
		if(!$this->upload->do_upload('file_mr')){
			$photo="";
		}else{
			$photo=$this->upload->file_name;
		}

		$data = array
		(			
			'id_pasien' => $this->input->post('id_pasien'),
			'description' => $this->input->post('description'),
			'file_name' => $photo,
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1,
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
			
		);
		$this->db->insert('mst_file_mr', $data);
		if($submit==1)
		{
			redirect('master_pasien/file_mr/'.$menuid.'/'.$ID);
		}
	}	

	
	public function delete_file_mr($menuid, $ID, $id_trn)
	{
		$this->db->where('id', $id_trn);
		$this->db->delete('mst_file_mr');
		redirect('master_pasien/file_mr/'.$menuid.'/'.$ID);
	}

	public function edit_file_mr($menuid, $ID)
	{
		$id_trn = $this->input->post('id');
		$edit_file_mr = $this->master_model->mst_edit_dr('MST_FILE_MR',$id_trn);
	
		echo'
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title">Edit Data File Rekam Medis</h4>
		</div>
				<form action="'.base_url().'master_pasien/edit_process_file_mr/'.$menuid.'/'.$ID.'/'.$id_trn.'" method="post" enctype="multipart/form-data">
					<div class="modal-body">
						
						<div class="form-group">
							<input type="hidden" name="id_pasien" value="'.$edit_file_mr[0]->id_pasien.'" class="form-control" placeholder="ID Pasien" required="required">
						</div>
												
						<div class="form-group">
								<label>Keterangan</label>
								<input type="text" name="description" value="'.$edit_file_mr[0]->description.'" class="form-control" placeholder="Keterangan" required="required">
						</div>						

						<div class="form-group">
							<label>File Rekam Medis</label>
							<input type="file" name="file_mr">
							';
							if($edit_file_mr[0]->file_name == '')
							{
								echo '<img class="img-circle" src="'.base_url().'assets/img/default-50x50.gif" alt="User Avatar">';
							}else {
								echo '<img class="img-circle" src="'.base_url().'uploads/foto/'.$edit_file_mr[0]->file_name.'" height="100px" width="100px" alt="User Avatar">';
							}
						echo'
							<input type="hidden" name="file_name" value="'.$edit_file_mr[0]->file_name.'" class="form-control" >
						</div>

						<div class="form-group">
						
						</div>

						<div class="modal-footer">
							<button type="submit" value="1" name="submit" class="btn btn-danger btn-fill pull-right save_phone save_email">Save And Close</button>
								
						</div>
				</form>
		';
	}

	public function edit_process_file_mr($menuid, $ID, $id_trn)
	{
		$submit = $this->input->post('submit');
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$admin = $this->session->userdata('username');

		$this->load->helper(array('form', 'url')); 
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'pdf';
		$config['max_size'] = '2048';
		
		$this->upload->initialize($config);
		if(!$this->upload->do_upload('file_mr')){
			$photo=$this->input->post('file_name');
		}else{
			$photo=$this->upload->file_name;
		}	

		$data = array(			
			'description' => $this->input->post('description'),
			'file_name' => $photo,
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	

		$this->db->where('id', $id_trn);
		$this->db->update('MST_FILE_MR', $data);
		if($submit==1)
		{
			redirect('master_pasien/file_mr/'.$menuid.'/'.$ID);
		}
	}	

	
}
?>
