// On document finished loading
$(window).ready(function(){

	// Datepicker initialization
	$('.date-picker').datepicker({
		format: 'yyyy-mm-dd'
	});

});

// Global AJAX setup
$.ajaxSetup({
	headers:{
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	}
});

// JQuery extension to toggle hiding an element based on another form input
$.fn.formShowToggle = function (listenedElement, values, isCheckbox, invert) {

	// Default parameter set
	isCheckbox = isCheckbox ? isCheckbox : false;
	invert = invert ? invert : false;

	// Self element reference
	let source = this;

	// List of all values to considered 'show' (Except inverted)
	let valueList = [];
	if (values.constructor === Array ) valueList = values;
	else valueList.push(values);

	// Toggles hiding element function
	let toggle = function(value) {

		// Check if the listened object is a checkbox
		if (isCheckbox) {
			if (listenedElement.is(':checked') == true) {
				if (!invert) source.parent('.form-group').parent().show(400);
				else source.parent('.form-group').parent().hide(400);
			}
			else {
				if (!invert) source.parent('.form-group').parent().hide(400);
				else source.parent('.form-group').parent().show(400);
			}
			return;
		}

		// Check if the changed value contained in the values list, then toggle it based on invert settings
		if (contains.call(valueList, value)) {
			if (!invert) source.parent('.form-group').parent().show(400);
			else source.parent('.form-group').parent().hide(400);
		}
		else {
			if (!invert) source.parent('.form-group').parent().hide(400);
			else source.parent('.form-group').parent().show(400);
		}
	}

	// Toggles once to set the initial state
	toggle(listenedElement.val());

	// Create a listener to form value changes
	listenedElement.change(function() {
		toggle($(this).val());
	});
}

// JQuery extension to scroll to an element 
$.fn.scrollView = function (offset, animTime) {
	return this.each(function () {
		if (offset == undefined) offset = 0;
		$('html, body').animate({
			scrollTop: $(this).offset().top - offset
		}, animTime);
	});
}

// JQuery extension to convert DB date format to a human readable format
$.readableDate = function (value) {

	// Month dictionary
	let monthDict = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
	
	// Separates the values
	let year = value.substring(0, 4);
	let month = value.substring(4, 6);
	let date = (value.length > 6) ? parseInt(value.substring(6, 8)) : undefined;

	// Get the textual month 
	let textualMonth = monthDict[parseInt(month) - 1];

	// Combine and return the string
	return (date ? date + ' ' : '') + textualMonth + ' ' + year;
}

// JQuery extension to parse PHP date format into JS format
$.parseDate = function (phpDate) {

	// Separates the date and time 
	phpDate = phpDate.split(' ');

	let date = phpDate[0].split('-');

	// Check if the time is provided 
	if (phpDate[1] !== undefined) {
		let time = phpDate[1].split(':');
		return new Date(date[0], date[1] - 1, date[2], time[0], time[1], time[2]);
	}

	return new Date(date[0], date[1] - 1, date[2]);
}

// JQuery DataTables extension to find a row in the pagination 
$.fn.dataTable.Api.register('row().show()', function() {
	var page_info = this.table().page.info();

	// Get row index
	var new_row_index = this.index();

	// Row position
	var row_position = this.table().rows()[0].indexOf( new_row_index );

	// Already on right page ?
	if(row_position >= page_info.start && row_position < page_info.end) {
		// Return row object
		return this;
	}

	// Find page number
	var page_to_display = Math.floor(row_position / this.table().page.len());

	// Go to that page
	this.table().page(page_to_display);

	// Return row object
	return this;
});

// JQuery DataTables Application function to smoothly navigate to the target data
$.fn.dataTable.Api.register('transition()', function (no, flashClass, scrollAnimTime, flashAnimTime) {

	// Go to the page which the row lives
	this.row(no).show().draw(false);

	// Cache JQuery selector to the target row
	let targetRow = $(this.row(no).node());

	setTimeout(function() {

		// Scrolls smoothly to the target row
		targetRow.scrollView(300, scrollAnimTime);

		// Start the flashing animation
		targetRow.addClass(flashClass);
		setTimeout(function() { 
			targetRow.addClass(flashClass + '-off'); 
			targetRow.removeClass(flashClass);
		}, 1);
		setTimeout(function() { targetRow.removeClass(flashClass + '-off'); }, flashAnimTime);
	}, 100);
});

// JQuery DataTables Application function to get the sum of one column 
jQuery.fn.dataTable.Api.register('sum()', function (condition) {

	condition = condition ? condition : function() { return true; };

	let sum = 0;

	this.flatten().each(function(value, index) {
		if (typeof(value) === 'string') {
			if (condition(index)) sum += value.replace(/[^\d.-]/g, '') * 1;
		}
	});

	return sum;

	/*return this.flatten().reduce(function(a, b) {
		if ( typeof a === 'string' ) {
			a = a.replace(/[^\d.-]/g, '') * 1;
		}
		if ( typeof b === 'string' ) {
			b = b.replace(/[^\d.-]/g, '') * 1;
		}

		return a + b;
	}, 0 );*/
} );

// JavaScript Helper Function to retrieve GET parameters from the URL 
function GetURLParameter(sParam) {
	let sPageURL = decodeURIComponent(window.location.search.substring(1)),
		sURLVariables = sPageURL.split('&'),
		sParameterName,
		i;

	for (i = 0; i < sURLVariables.length; i++) {
		sParameterName = sURLVariables[i].split('=');

		if (sParameterName[0] === sParam) {
			return sParameterName[1] === undefined ? true : sParameterName[1];
		}
	}
};

// Javascript number extension to make a more readable currency
Number.prototype.format = function(n) {
	n = n ? n : 2;
	let regex = '\\d(?=(\\d{' + 3 + '})+' + (n > 0 ? '\\.' : '$') + ')';
	return this.toFixed(Math.max(0, ~~n)).replace(new RegExp(regex, 'g'), '$&,');
};

// Javascript Helper function to find an element in an array 
var contains = function(needle) {
	// Per spec, the way to identify NaN is that it is not equal to itself
	var findNaN = needle !== needle;
	var indexOf;

	if(!findNaN && typeof Array.prototype.indexOf === 'function') {
		indexOf = Array.prototype.indexOf;
	} else {
		indexOf = function(needle) {
			var i = -1, index = -1;

			for(i = 0; i < this.length; i++) {
				var item = this[i];

				if((findNaN && item !== item) || item === needle) {
					index = i;
					break;
				}
			}

			return index;
		};
	}

	return indexOf.call(this, needle) > -1;
};

// Javascript Helper function to send POST request
function post_to_url(path, params, method) {
    method = method || "post"; // Set method to post by default, if not specified.

    var form = $(document.createElement( "form" ))
        .attr( {"method": method, "action": path} );

    $.each( params, function(key,value){
        $.each( value instanceof Array? value : [value], function(i,val){
			console.log(val);
            $(document.createElement("input"))
                .attr({ "type": "hidden", "name": key, "value": val })
                .appendTo( form );
        }); 
    } ); 

    form.appendTo( document.body ).submit(); 
}

// Globally set currency format with the class format-currency
$(window).ready(function(){

	$('.format-currency').each(function(index, element) {
		$(element).html('Rp. ' + parseInt($(element).html()).format(-1));
	});

	// Globally removes all repeater template 
	$('form').find('.mt-repeater-item[style="display:none"]').find('[name]').attr('disabled', true);

});