<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class transaksi_item extends CI_Controller {


    public $table = 'trkeluardetail';
    public $id = 'id_keluar';
    public $order = 'DESC';


	public function __construct()

	{

		parent :: __construct();

		$this->load->model('transaksi_model');
		$this->load->model('master_model');
		$this->load->library('upload');
		

	}
	
	public function index($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_masuk']    = $this->transaksi_model->item_masuk();

    		$this->load->view('item_masuk/main', $data);
	    }
	}

    public function item_in($menuid)
    {
        
        $user_id = $this->session->userdata('user_id');
        $check=$this->master_model->auth_read($user_id, $menuid);
        if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			//$this->load->view('item_masuk/item');
			$this->load->view('item_masuk/item_masuk');
    }
	}
	public function next_1($menuid)
	{
		
		$id_suplier = $this->input->post('id_suplier');

		$this->session->set_userdata('nama_suplier', $this->input->post('nama_suplier'));
		$this->session->set_userdata('no_telp', $this->input->post('no_telp'));
		$this->session->set_userdata('keterangan', $this->input->post('keterangan'));
		$this->session->set_userdata('alamat', $this->input->post('alamat'));
		//$this->session->set_userdata('address_customer', $this->input->post('address'));

		redirect('transaksi_item/item/'.$menuid.'/'.$id_suplier);
	}

	public function get_detail_suplieur($menuid, $fill)
    {
		$menuid=$this->uri->segment(4);
        $input = $this->input->post('input');

        if ($fill == 'nama_suplier') {
            /*$exp=explode(' / ', $input);
            $name=$exp[0];
            $phone=$exp[1];
            $email=$exp[2];*/
            $nama_suplier  = $input;
            $no_telp = '';
            $alamat = '';

            $row = $nama_suplier;
        } elseif ($fill == 'no_telp') {
            $nama_suplier  = '';
            $no_telp = $input;
            $alamat = '';

            $row = $no_telp;
        } elseif ($fill == 'alamat') {
            $nama_suplier  = '';
            $no_telp = '';
            $alamat = $input;

            $row = $alamat;
        }

        $check = $this->transaksi_model->mst_check_supplieur('mssuplier', $fill, $row);

        if ($check == false) {
            $id_suplier      = $this->transaksi_model->mst_check_supplieur('mssuplier');
            $nama_suplier    = $nama_suplier;
            $no_telp   = $no_telp;
            $alamat   = $alamat;
            $keterangan = '';
            $id_suplier      = $id_suplier;
            $alert   = 'error';
        } else {
            $data_supplieur = $this->master_model->select_in('mssuplier', 'id_suplier, nama_suplier, no_telp, alamat, keterangan', "WHERE $fill='$row'");
            $nama_suplier  = $data_supplieur[0]->nama_suplier;
            $no_telp       = $data_supplieur[0]->no_telp;
            $keterangan    = $data_supplieur[0]->keterangan;
            $alamat        = $data_supplieur[0]->alamat;
            $id_suplier    = $data_supplieur[0]->id_suplier;
            $alert         = 'success';
        }

        echo $nama_suplier.'%'.$no_telp.'%'.$keterangan.'%'.$alamat.'%'.$id_suplier.'%'.$alert;
    }


    public function check_phone()
	{
		$no_telp = $this->input->post('no_telp');
		if($no_telp=='')
		{
			echo '2';
		}else
		{
			$cek = $this->transaksi_model->mst_check_supplieur('mssuplier','no_telp',$no_telp);
			if($cek)
			{
				echo '1';
			}else{
				echo '0';
			}
		}
	}


	public function get_supplieur()
    {
		
        $nama_suplier          = $this->input->get('nama_suplier');
        $data_suplieur = $this->master_model->select_in('mssuplier', 'id_suplier, nama_suplier, no_telp, keterangan,  alamat', "WHERE nama_suplier LIKE '%$nama_suplier%'");
        $count         = count($data_suplieur);

        echo '
            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>Nama</th>
                        <th>No Telepon</th>
                        <th>Alamat</th>
                        
                        <th>Buat Service</th>
                    </tr>
                </thead>

                <tbody>
                    ';
        for ($a = 0; $a < count($data_suplieur); $a++) {
			$id_suplier = $data_suplieur[$a]->id_suplier;
			$menuid = $data_suplieur[$a]->id_suplier;
			$nama_suplier = $data_suplieur[$a]->nama_suplier;
			$alamat = $data_suplieur[$a]->alamat;
			$no_telp = $data_suplieur[$a]->no_telp;
			$keterangan = $data_suplieur[$a]->keterangan;

            $b      = $a + 1;

            echo '
                            <tr>
                                <td style="text-align:center">
                                    '.$b.'
                                </td>
                                <td>
                                    
                                        '.$nama_suplier.'
                                    
                                </td>
                                <td>'.$no_telp.'</td>
                                <td>'.$alamat.'</td>
                               
                                <td style="text-align:center">
                                    <a href="'.base_url().'transaksi_item/item/'.$menuid.'/'.$id_suplier.'" class="text-yellow">
                                        Input Item
                                        <i class="fa  fa-external-link-square"></i>
                                    </a>
                                </td>
                            </tr>
                          ';
        }
        echo '
                </tbody>
            </table>
        ';
    }
	public function item($id_suplier = '')
    {
        if ($id_suplier == '') {
            $id_suplier = $this->input->post('submit');
        } else {
            $id_suplier = $id_suplier;
        }

        $data['id_suplier'] = $id_suplier;
       
        $data_msitem['data_msitem'] = $this->master_model->ih();

        $this->load->view('item_masuk/item', $id_suplier, $data_msitem);
	}
	

	public function next_2($menuid, $id_suplier)
    {
            $this->session->set_userdata('tgl_masuk', $this->input->post('tgl_masuk'));
            $this->session->set_userdata('faktur', $this->input->post('faktur'));
            $this->session->set_userdata('ket', $this->input->post('ket'));
       

        redirect('transaksi_item/item_final/'.$menuid.'/'.$id_suplier);
	}
	
	public function item_final($menuid, $id_suplier, $id_header = '')
    {
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

        $this->load->view('item_masuk/item_final');
	}

	public function save_itemin($menuid, $id_customer, $id_header = '')
    {
        //print_array($this->input->post());
        //exit;

        $submit = $this->input->post('submit');

        $jobs             = $this->input->post('jobs');
        $technician       = $this->input->post('technician');
        $durations        = $this->input->post('duration');
        $qty              = $this->input->post('qty');
        $price            = $this->input->post('price');
        $subtotal_service = $this->input->post('subtotal_service');

        $grandtotal = $this->input->post('grandtotal');
        $tax        = $grandtotal * 0.1 / 100;

        $id_admin = $this->session->userdata('id_admin');

        $indent_day = $this->input->post('indent_day');

        $total_service    = $this->input->post('total_service');
        $total_spareparts = $this->input->post('total_spareparts');
        $grandtotal       = $this->input->post('grandtotal');

        if ($submit == 1) {
            $check_customer = $this->master_model->mst_check('ms_customer', 'ID', $id_customer);
            
            if ($check_customer == false) {
                $data_customer = array(
                    'ID'      => $id_customer,
                    'code_customer'    => $this->session->userdata('code_customer'),
                    'name'    => $this->session->userdata('name_customer'),
                    'email'   => $this->session->userdata('email_customer'),
                    'phone'   => $this->session->userdata('phone_customer'),
                    'address' => $this->session->userdata('address_customer'),
                    'status'  => 0,
                    'sort'    => $id_customer,
                );
                $this->db->insert('ms_customer', $data_customer);
            }

            //$tax=$total_service*0.1/100;

            if ($id_header == '') {
                $ID       = $this->master_model->mst_last_id('ts_service');
                $invoice  = $this->master_model->create_invoice($ID);
                $tracking = $this->master_model->tracking();
                $data     = array(
                    'ID'            => $ID,
                    'date_in'       => date('Y-m-d'),
                    'invoice'       => $invoice,
                    'tracking_code' => $tracking,
                    'id_customer'   => $id_customer,
                    'id_admin'      => $id_admin,
                    'category'      => $this->session->userdata('category'),
                    'brand'         => $this->session->userdata('brand'),
                    'model'         => $this->session->userdata('model'),
                    'imei'          => $this->session->userdata('imei'),
                    'damage'        => $this->session->userdata('damage'),

                    'ongkir'        => 15000,
                    'tax'           => $this->input->post('tax'),
                    'discount'      => $this->input->post('discount'),
                    'total_service' => $total_service,
                    'total_parts'   => $total_spareparts,

                    'durations_day' => 0,
                    'total_day'     => $this->input->post('total_day'),
                    'start_date'    => date('Y-m-d H:i:s'),
                    'finish_date'   => 0,
                    'deliver_date'  => 0,
                    'kurir'         => 0,

                    'indent_day'    => $indent_day,

                    'tax'           => $this->input->post('tax'),
                    'discount'      => $this->input->post('discount'),
                    'deliver_date'  => $this->input->post('deliver_date'),
                    'kurir'         => $this->input->post('courir'),
                    'grandtotal'    => $this->input->post('grandtotal'),

                    'note'          => $this->session->userdata('note'),
                    'status'        => 0,
                    'sort'          => $ID,
                );
                $this->db->insert('ts_service', $data);
            } else {
                $this->db->where('id_header', $id_header);
                $this->db->delete('ts_service_detail');

                $update = array(
                    'total_service' => $total_service,
                    'total_parts'   => $total_spareparts,
                    'grandtotal'    => $total_service,
                );
                $this->db->where('ID', $id_header);
                $this->db->update('ts_service', $update);

                $ID = $id_header;
            }

            $control = 'index';
            //$id_service='/'.$ID;
            $id_customer = '';
            $id_service  = '';
        } elseif ($submit == 2) {
            $control    = 'edit';
            $id_service = '/' . $id_header;

            $get_id_service_detail = $this->master_model->select_in('ts_service_detail', 'ID', "WHERE id_header=$id_header");
            $id_service_detail     = $get_id_service_detail[0]->ID;

            $this->db->where('id_service_detail', $id_service_detail);
            $this->db->delete('ts_service_spareparts');

            $this->db->where('id_header', $id_header);
            $this->db->delete('ts_service_detail');

            $update = array(
                'total_service' => $total_service,
                'total_parts'   => $total_spareparts,
                'grandtotal'    => $grandtotal,
            );
            $this->db->where('ID', $id_header);
            $this->db->update('ts_service', $update);

            $ID          = $id_header;
            $id_customer = '/'.$id_customer;
        }

        /*save spareparts start*/

        $pre         = $this->input->post('pre');
        $total_parts = $this->input->post('subtotal_parts');

        $durations_day = 0;
        for ($a = 0; $a < count($jobs); $a++) {
            $no          = $a + 1;
            $spareparts  = $this->input->post('spareparts_'.$no);
            $qty_parts   = $this->input->post('qty_parts_'.$no);
            $price_parts = $this->input->post('price_parts_'.$no);
            $indent      = $this->input->post('indent_'.$no);
            $subtotal    = $this->input->post('subtotal_parts_'.$no);

            if ($jobs[$a] != '') {
                $id_detail = $this->master_model->mst_last_id('ts_service_detail');

                if ($a == 0) {
                    $id_pre = 0;
                } else {
                    $count_pre = $no - $pre[$a];

                    $id_pre = $id_detail - $count_pre;
                }

                $data_detail = array(
                    'ID'         => $id_detail,
                    'id_header'  => $ID,
                    'jobs'       => $jobs[$a],
                    'technician' => $technician[$a],
                    'durations'  => $durations[$a],
                    'pre_jobs'   => $id_pre,
                    'qty'        => $qty[$a],
                    'price'      => $price[$a],
                    'subtotal'   => str_replace('.', '', $subtotal_service[$a]),
                    'status'     => 0,
                    'sort'       => $id_detail,
                );
                $this->db->insert('ts_service_detail', $data_detail);

                //$indents_day=0;
                for ($b = 0; $b < count($spareparts); $b++) {
                    if ($spareparts[$b] != '') {
                        $id_spareparts         = $this->master_model->mst_last_id('ts_service_spareparts');
                        $data_array_spareparts = array(
                            'ID'                => $id_spareparts,
                            //'id_header'=>$ID,
                            'id_service_detail' => $id_detail,
                            'sparepart'         => $spareparts[$b],
                            'qty'               => $qty_parts[$b],
                            'price'             => $price_parts[$b],
                            'indent'            => $indent[$b],
                            'subtotal'          => str_replace('.', '', $subtotal[$b]),
                            'sort'              => $id_spareparts,
                        );
                        $this->db->insert('ts_service_spareparts', $data_array_spareparts);

                        //$indent_day=$indent[$b]+$indents_day;
                    }
                }

                if ($submit == 1) {
                    $id_log   = $this->master_model->mst_last_id('log_jobs');
                    $id_admin = $this->session->userdata('id_admin');
                    $data_log = array(
                        'ID'       => $id_log,
                        'id_jobs'  => $id_detail,
                        'id_admin' => $id_admin,
                        'date_in'  => date('Y-m-d H:i:s'),
                        'status'   => 0,
                        'note'     => 'New Service',
                        'sort'     => $id_log,
                    );
                    $this->db->insert('log_jobs', $data_log);
                }

                $durations_day = $durations[$a] + $durations_day;
            }
        }

        $data_update_service = array(
            'durations_day' => $durations_day,
        );
        $this->db->where('ID', $ID);
        $this->db->update('ts_service', $data_update_service);

        if ($submit == 1) {
            $control = 'index';
        } elseif ($submit == 2) {
            $control = 'edit';
        }

        $today      = date('Y-m-d');
        $estimation = strtotime('+'.$indent_day.' day', strtotime($today));
        $estimation = date('Y-m-d', $estimation);

        $data_update_service = array(
            'finish_date' => $estimation,
            //'grandtotal'=>$total_service+$total_parts-$this->input->post('discount'),
        );
        $this->db->where('ID', $ID);
        $this->db->update('ts_service', $data_update_service);

        /*
        if($submit==1)
        {
        }elseif($submit==2)
        {
        $data_finish=$this->master_model->select_in('ts_service','finish_date',"WHERE ID=$id_header");
        $finish_date=date($data_finish[0]->finish_date);
        $finish_date = strtotime ('+'.$indent_day.' day', strtotime($finish_date));

        $finish_date=date('Y-m-d H:i:s', $finish_date);

        $update_hour=array
        (
        'finish_date'=>$finish_date,
        );
        $this->db->where('ID', $id_header);
        $this->db->update('ts_service', $update_hour);
        }*/

        /*save spareparts end*/

        $this->session->unset_userdata('category');
        $this->session->unset_userdata('brand');
        $this->session->unset_userdata('model');
        $this->session->unset_userdata('imei');
        $this->session->unset_userdata('damage');
        $this->session->unset_userdata('note');
        $this->session->unset_userdata('name_customer');
        $this->session->unset_userdata('phone_customer');
        $this->session->unset_userdata('email_customer');
        $this->session->unset_userdata('address_customer');


        redirect('admin/transaction/'.$control.'/'.$menuid.''.$id_customer.''.$id_service);
	}
	

	function belanja()
    {
        if(isset($_POST['submit']))
        {
            $this->master_model->simpan_barang();
            redirect('transaksi_item/data_item');
        }
        else
        {
            $data['barang']=  $this->master_model->ms_item();
            $data['detail']= $this->master_model->transaksi_item_aja()->result();
			//$this->template->load('template','transaksi/form_transaksi',$data);
			$this->load->view('item_masuk/dt_item', $data);
        }
	}
	
	function selesai_belanja()
    {
        $tanggal=date('Y-m-d');
        $user=  $this->session->userdata('username');
        $id_op=  $this->db->get_where('operator',array('username'=>$user))->row_array();
        $data=array('operator_id'=>$id_op['operator_id'],'tanggal_transaksi'=>$tanggal);
        $this->model_transaksi->selesai_belanja($data);
        redirect('transaksi');
	}
	
	public function item_out($menuid)
    {
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_keluar']    = $this->transaksi_model->item_keluar();

    		$this->load->view('item_keluar/main', $data);
	    }
	}
    public function item_keluar($menuid)
    {
        
        $user_id = $this->session->userdata('user_id');
        $check=$this->master_model->auth_read($user_id, $menuid);
        if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			//$this->load->view('item_masuk/item');
			$this->load->view('item_keluar/item_keluar');
    }
    }
    
    public function selanjutnya($menuid)
	{
		
		$id_suplier = $this->input->post('id_suplier');

		$this->session->set_userdata('nama_suplier', $this->input->post('nama_suplier'));
		$this->session->set_userdata('no_telp', $this->input->post('no_telp'));
		$this->session->set_userdata('keterangan', $this->input->post('keterangan'));
		$this->session->set_userdata('alamat', $this->input->post('alamat'));
		//$this->session->set_userdata('address_customer', $this->input->post('address'));

		redirect('transaksi_item/next/'.$menuid.'/'.$id_suplier);
    }
    
    public function next($id_suplier = '')
    {
        if ($id_suplier == '') {
            $id_suplier = $this->input->post('submit');
        } else {
            $id_suplier = $id_suplier;
        }

        $data['id_suplier'] = $id_suplier;

        $this->load->view('item_keluar/finish_item_masuk', $id_suplier);
    }
    

    public function create() 
    {
        $data = array(
            'button' => 'Create',
            'action' => site_url('transaksi_item/create_action'),
            'id_keluar' => set_value('id_keluar'),
            'id_item' => set_value('id_item'),
            'created_at' => set_value('created_at'),
            'jumlah' => set_value('jumlah'),
            'konten' => 'barang_keluar/barang_keluar_form',
            'judul' => 'Data Barang Keluar',
	);
        $this->load->view('item_keluar/finish_item_masuk', $data);
    }
    
    public function create_action() 
    {
        $this->_rules();

        if ($this->form_validation->run() == FALSE) {
            $this->create();
        } else {
            $data = array(
		'id_keluar' => $this->input->post('id_keluar',TRUE),
		'created_at' => $this->input->post('created_at',TRUE),
		'jumlah' => $this->input->post('jumlah',TRUE),
	    );

            $this->transaksi_model->insert($data);
            $this->session->set_flashdata('message', 'Create Record Success');
            redirect(site_url('transaksi_item/item_out'));
        }
    }


    public function _rules() 
    {
	$this->form_validation->set_rules('id_keluar', 'kode barang', 'trim|required');
	$this->form_validation->set_rules('created_at', 'tgl keluar', 'trim|required');
	$this->form_validation->set_rules('jumlah', 'jumlah', 'trim|required');

	$this->form_validation->set_rules('id_keluar', 'id_keluar', 'trim');
	$this->form_validation->set_error_delimiters('<span class="text-danger">', '</span>');
    }
	
	
}
?>