<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class setting extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
	}
	

	public function kategori_barang($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kat']= $this->master_model->select_in('mst_kategori', '*', "order by id");

			$this->load->view('kategori_barang/list', $data);
	    }
	}

	public function insert_kategori_barang($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'kategori' => $this->input->post('kategori'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);
		$this->db->insert('mst_kategori', $data);
		redirect('setting/kategori_barang/'.$menuid);
	}


	public function update_kategori_barang($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$id = $this->input->post('id');

		$data = array(
			'kategori' => $this->input->post('kategori'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	
	
		$this->db->where('id', $id);
		$this->db->update('mst_kategori', $data);

		redirect('setting/kategori_barang/'.$menuid);
	}


	public function delete_kategori_barang($menuid, $id)
	{
		
		$this->db->where('id',$id);
		$this->db->delete('mst_kategori');
		

		redirect('setting/kategori_barang/'.$menuid);
	}

	public function satuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_sat']= $this->master_model->select_in('mst_satuan', '*', "order by id");

			$this->load->view('satuan/list', $data);
	    }
	}

	public function insert_satuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'satuan' => $this->input->post('satuan'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);
		$this->db->insert('mst_satuan', $data);
		redirect('setting/satuan/'.$menuid);
	}


	public function update_satuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$id = $this->input->post('id');

		$data = array(
			'satuan' => $this->input->post('satuan'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	
	
		$this->db->where('id', $id);
		$this->db->update('mst_satuan', $data);

		redirect('setting/satuan/'.$menuid);
	}

	public function delete_satuan($menuid, $id)
	{
		
		$this->db->where('id',$id);
		$this->db->delete('mst_satuan');
		

		redirect('setting/satuan/'.$menuid);
	}

	public function divisi($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_div']= $this->master_model->select_in('mst_divisi', '*', "order by id");

			$this->load->view('divisi/list', $data);
	    }
	}

	public function insert_divisi($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'divisi' => $this->input->post('divisi'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);
		$this->db->insert('mst_divisi', $data);
		redirect('setting/divisi/'.$menuid);
	}


	public function update_divisi($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$id = $this->input->post('id');

		$data = array(
			'divisi' => $this->input->post('divisi'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	
	
		$this->db->where('id', $id);
		$this->db->update('mst_divisi', $data);

		redirect('setting/divisi/'.$menuid);
	}
	
	public function delete_divisi($menuid, $id)
	{
		
		$this->db->where('id',$id);
		$this->db->delete('mst_divisi');
		

		redirect('setting/divisi/'.$menuid);
	}
	
	public function pengurus($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pgr']= $this->master_model->select_in('mst_pengurus', '*', "order by id");

			$this->load->view('pengurus/list', $data);
	    }
	}

	public function insert_pengurus($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'pengurus' => $this->input->post('pengurus'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);
		$this->db->insert('mst_pengurus', $data);
		redirect('setting/pengurus/'.$menuid);
	}


	public function update_pengurus($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$id = $this->input->post('id');

		$data = array(
			'pengurus' => $this->input->post('pengurus'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	
	
		$this->db->where('id', $id);
		$this->db->update('mst_pengurus', $data);

		redirect('setting/pengurus/'.$menuid);
	}


	public function delete_pengurus($menuid, $id)
	{
		
		$this->db->where('id',$id);
		$this->db->delete('mst_pengurus');
		
		redirect('setting/pengurus/'.$menuid);
	}
	
	public function hari_kerja($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_herikerja']   = $this->master_model->select_in('m_hari_kerja','*',"where 1=0");
			$this->load->view('setting/hari_kerja', $data);
	    }
	}
	
	public function daftar_hari_kerja($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$tahun = $this->input->post('group-b[0][tahun]');
		
		if (empty($tahun)){
			$tahun = $this->session->userdata('tahun');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_harikerja']   = $this->master_model->harikerja($tahun);
			$this->load->view('setting/detail_harikerja', $data);
	    }
	}
	
	public function insert_hari_kerja($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$tahun = $this->input->post('tahun_cuti');
		
		if (empty($tahun)){
			$tahun = $this->session->userdata('tahun');
		}

		$data = array(
		    'tahun' => $tahun,
			'id_bulan' => $this->input->post('id_bulan'),
			'hari_kerja' => $this->input->post('hari_kerja'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);
		$this->db->insert('m_hari_kerja', $data);

		redirect('setting/daftar_hari_kerja/'.$menuid);
	}
	
	public function update_hari_kerja($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$tahun = $this->input->post('tahun_cuti');
		$id = $this->input->post('id');
		
		if (empty($tahun)){
			$tahun = $this->session->userdata('tahun');
		}

		$data = array(
			'hari_kerja' => $this->input->post('hari_kerja'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1			
		);
		
		$this->db->where('id', $id);
		$this->db->update('m_hari_kerja', $data);

		redirect('setting/daftar_hari_kerja/'.$menuid);
	}
}
?>
