<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class master_pelanggan extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
	}

	public function pelanggan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pelanggan']   = $this->master_model->select_in('mspelanggan','*',"ORDER BY id DESC");
			$this->load->view('pelanggan/list', $data);
	    }
	}

	public function input_pelanggan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pelanggan']   = $this->master_model->select_in('mspelanggan','*',"ORDER BY id DESC");
			$this->load->view('pelanggan/input_pelanggan', $data);
	    }
	}

	public function edit_pelanggan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pelanggan']    = $this->master_model->select_in('mspelanggan','*',"WHERE ID = $id");

    		$this->load->view('pelanggan/edit_pelanggan', $data);
	    }
	}

	public function insert_pelanggan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'nama' => $this->input->post('nama'),
			'alamat' => $this->input->post('alamat'),
			'no_hp1' => $this->input->post('no_hp1'),
			'no_hp2' => $this->input->post('no_hp2'),
			'email' => $this->input->post('email'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1			
		);
		$this->db->insert('mspelanggan', $data);
		redirect('master_pelanggan/pelanggan/'.$menuid);
	}

	public function update_pelanggan($menuid, $idEmpl)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'nama' => $this->input->post('nama'),
			'alamat' => $this->input->post('alamat'),
			'no_hp1' => $this->input->post('no_hp1'),
			'no_hp2' => $this->input->post('no_hp2'),
			'email' => $this->input->post('email'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1			
		);
		
		$this->db->where('id', $idEmpl);
		$this->db->update('mspelanggan', $data);
		
		redirect('master_pelanggan/pelanggan/'.$menuid);
	}

	public function kendaraan($menuid, $idPelanggan)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kendaraan']    = $this->master_model->kendaraan($idPelanggan);

    		$this->load->view('pelanggan/kendaraan', $data);
	    }
	}

	public function insert_kendaraan($menuid, $idPelanggan)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'id_pelanggan' => $idPelanggan,
			'no_kendaraan' => $this->input->post('no_kendaraan'),
			'jenis' => $this->input->post('jenis'),
			'merk' => $this->input->post('merk'),
			'type' => $this->input->post('type'),			
			'tahun' => $this->input->post('tahun'),			
			'keterangan' => $this->input->post('keterangan'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1
		);

		$this->db->insert('mskendaraan', $data);
		redirect('master_pelanggan/kendaraan/'.$menuid.'/'.$idPelanggan);
	}

	public function edit_kendaraan($menuid)
	{
		$id_trn = $this->input->post('id');
		$data_edit = $this->master_model->mst_edit_dr('mskendaraan',$id_trn);

		echo'
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title">Edit Kendaraan</h4>
		</div>
				<form action="'.base_url().'master_pelanggan/edit_process_kendaraan/'.$menuid.'/'.$data_edit[0]->id_pelanggan.'/'.$id_trn.'" method="post" enctype="multipart/form-data">
					<div class="modal-body">

						<div class="form-group">
							<label>No. Kendaraan</label>
							<input type="text" name="no_kendaraan" value="'.$data_edit[0]->no_kendaraan.'" class="form-control" placeholder="No. Kendaraan" required="required">
						</div>						

						<div class="form-group">
							<label>Jenis Kendaraan </label>
							
							<select name="jenis" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Jenis Kendaraan --
								</option>
								';
									$idJns = $data_edit[0]->jenis;
									$data_jns = $this->master_model->select_in('mst_jenis','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_jns); $a++)
									{
										if($idJns == $data_jns[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_jns[$a]->id.'" '.$select.'>
												'.$data_jns[$a]->jenis.'
											</option>
										';
									}
								echo'
							</select>
						</div>

						<div class="form-group">
							<label>Merk Kendaraan </label>
							
							<select name="merk" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Merk Kendaraan --
								</option>
								';
									$idMrk = $data_edit[0]->merk;
									$data_mrk = $this->master_model->select_in('mst_merk','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_mrk); $a++)
									{
										if($idMrk == $data_mrk[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_mrk[$a]->id.'" '.$select.'>
												'.$data_mrk[$a]->merk.'
											</option>
										';
									}
								echo'
							</select>
						</div>

						<div class="form-group">
							<label>Type Kendaraan </label>
							
							<select name="type" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Type Kendaraan --
								</option>
								';
									$idTyp = $data_edit[0]->type;
									$data_typ = $this->master_model->select_in('mst_type','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_typ); $a++)
									{
										if($idTyp == $data_typ[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_typ[$a]->id.'" '.$select.'>
												'.$data_typ[$a]->type.'
											</option>
										';
									}
								echo'
							</select>
						</div>

						<div class="form-group">
							<label>Tahun Keluaran</label>
							<input type="text" name="tahun" value="'.$data_edit[0]->tahun.'" class="form-control" placeholder="Tahun" >
						</div>						

						<div class="form-group">
							<label>Keterangan</label>
							<textarea name="keterangan" class="form-control" placeholder="Keterangan">'.$data_edit[0]->keterangan.'</textarea>
						</div>

						<div class="modal-footer">
							<button type="submit" value="1" name="submit" class="btn btn-danger btn-fill pull-right save_phone save_email">Save And Close</button>
						</div>
				</form>
		';
	}

	public function edit_process_kendaraan($menuid, $idPelanggan, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$data = array(
			'id_pelanggan' => $idPelanggan,
			'no_kendaraan' => $this->input->post('no_kendaraan'),
			'jenis' => $this->input->post('jenis'),
			'merk' => $this->input->post('merk'),
			'type' => $this->input->post('type'),			
			'tahun' => $this->input->post('tahun'),			
			'keterangan' => $this->input->post('keterangan'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('mskendaraan', $data);
		redirect('master_pelanggan/kendaraan/'.$menuid.'/'.$idPelanggan);
	}	
}
?>
