<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class master_kantor extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
	}

	public function kantor($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kantor']   = $this->master_model->select_in('mst_kantor','*',"ORDER BY id DESC");
			$this->load->view('daftar_kantor/list', $data);
	    }
	}

	public function input_kantor($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kantor']   = $this->master_model->select_in('mst_kantor','*',"ORDER BY id DESC");
			$this->load->view('daftar_kantor/input_kantor', $data);
	    }
	}


	public function insert_kantor($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'nama_kantor' => $this->input->post('nama_kantor'),
			'alamat' => $this->input->post('alamat'),
			'no_telepon' => $this->input->post('no_telepon'),
			'is_kp' => $this->input->post('is_kp')
		);
		$this->db->insert('mst_kantor', $data);
		redirect('master_kantor/kantor/'.$menuid);
	}

	public function edit_kantor($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kantor']    = $this->master_model->select_in('mst_kantor','*',"WHERE ID = $id");

    		$this->load->view('daftar_kantor/edit_kantor', $data);
	    }
	}

	public function update_kantor($menuid)
	{
		$id = $this->input->post('id');

		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			// 'nama_kantor' => $this->input->post('nama_kantor'),
			'alamat' => $this->input->post('alamat'),
			'no_telepon' => $this->input->post('no_telepon'),
			'is_kp' => $this->input->post('is_kp')
		);
		
		$this->db->where('id', $id);
		$this->db->update('mst_kantor', $data);
		
		redirect('master_kantor/kantor/'.$menuid);
	}

	public function user_list($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_us']   =  $this->master_model->userKantor($id);
			$this->load->view('daftar_kantor/user_list', $data);
	    }
	}

	public function insert_user_kantor($menuid, $idKantor)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'id_kantor' => $idKantor,
			'id_user' => $this->input->post('id_user')
		);
		$this->db->insert('mst_user_kantor', $data);
		redirect('master_kantor/user_list/'.$menuid.'/'.$idKantor);
	}

	function delete_user_kantor($menuid,$idKantor, $id)
	{

		$this->db->where('id',$id);
		$this->db->delete('mst_user_kantor');
		
		redirect('master_kantor/user_list/'.$menuid.'/'.$idKantor);
	}
}
?>
