<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class master_dokter extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
	}

	public function dokter($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_dokter']= $this->master_model->ms_dokter('MST_DOCTOR');

			$this->load->view('dokter/list', $data);
	    }
	}

	public function input_dokter($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_dokter']    = $this->master_model->select_in('MST_DOCTOR','*',"ORDER BY id DESC");

    		$this->load->view('dokter/input_dokter', $data);
	    }
	}

	public function ubah_dokter($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_dokter']    = $this->master_model->select_in('MST_DOCTOR','*',"WHERE ID = $id");

    		$this->load->view('dokter/edit_dokter', $data);
	    }
	}

	public function insert_dokter($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$this->load->helper(array('form', 'url')); 
		$ktp="";
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'gif|jpg|png|jpeg|bmp';
		$config['max_size'] = '2048';
		// $config['max_width']  = '1288';
		// $config['max_height']  = '768';
		

		$this->upload->initialize($config);
			if(!$this->upload->do_upload('ktp')){
				$ktp="";
			}else{
				$ktp=$this->upload->file_name;
		}

		$this->upload->initialize($config);
			if(!$this->upload->do_upload('photo')){
				$photo="";
			}else{
				$photo=$this->upload->file_name;
		}

		// print_r ($photo);
		// die;

	 	$data_code = $this->master_model->genDokter();
		
		$data = array(
			'code' => $data_code[0]->code,
			'name' => $this->input->post('name'),
			'initial_name' => $this->input->post('initial_name'),
			'specialist' => $this->input->post('specialist'),
			'gender' => $this->input->post('gender'),
			'birth_place' => $this->input->post('birth_place'),
			'birth_date' => $this->input->post('birth_date'),
			'address' => $this->input->post('address'),
			'city' => $this->input->post('city'),
			'district' => $this->input->post('district'),
			'subdistrict' => $this->input->post('subdistrict'),
			'zipcode' => $this->input->post('zipcode'),
			'country' => $this->input->post('country'),
			'id_card_no' => $this->input->post('id_card_no'),
			'id_card_image' => $ktp,
			'npwp_no' => $this->input->post('npwp_no'),
			'religion' => $this->input->post('religion'),
			'phone' => $this->input->post('phone'),
			'handphone_1' => $this->input->post('handphone_1'),
			'handphone_2' => $this->input->post('handphone_2'),
			'email' => $this->input->post('email'),
			'bank_name' => $this->input->post('bank_name'),
			'bank_branch' => $this->input->post('bank_branch'),
			'bank_account_name' => $this->input->post('bank_account_name'),
			'bank_account_no' => $this->input->post('bank_account_no'),
			'bpjs_no' => $this->input->post('bpjs_no'),
			'emergency_contact' => $this->input->post('emergency_contact'),
			'emergency_phone' => $this->input->post('emergency_phone'),
			'emergency_relationship' => $this->input->post('emergency_relationship'),
			'photograph' => $photo,
			'status' => $this->input->post('status'),
			'notes' => $this->input->post('notes'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1
			
			
		);
		$this->db->insert('MST_DOCTOR', $data);
		redirect('master_dokter/dokter/'.$menuid);
	}


	public function delete_dokter($menuid, $ID)
	{
		$this->db->where('id', $ID);
		$this->db->delete('MST_DOCTOR');
		redirect('master_dokter/dokter/'.$menuid);
	}

	public function edit_dokter($menuid)
	{
		$ID = $this->input->post('id');		
		$data_edit=$this->master_model->mst_edit_dr('MST_DOCTOR',$ID);
		
		echo'
			<form method="post" action="'.base_url().'master_dokter/update_dokter/'.$menuid.'/'.$ID.'" enctype="multipart/form-data">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Dokter</h4>
				</div>
				<div class="modal-body">				

						<div class="form-group">
							<label>Kode Dokter</label>
							<input type="text" name="label_code" value="'.$data_edit[0]->code.'" class="form-control" required="required" disabled>
							<input type="hidden" name="code" value="'.$data_edit[0]->code.'" >
						</div>

						<div class="form-group">
							<label>Nama Dokter</label>
							<input type="text" name="name" value="'.$data_edit[0]->name.'" class="form-control" required="required" >
						</div>

						<div class="form-group">
							<label>Inisial Dokter</label>
							<input type="text" name="initial_name" value="'.$data_edit[0]->initial_name.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Spesialis </label>
							
							<select name="specialist" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Spesialis --
								</option>
								';
									$idSpesialis = $data_edit[0]->specialist;
									$data_spesialis = $this->master_model->select_in('MST_SPECIALIST','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_spesialis); $a++)
									{
										if($idSpesialis == $data_spesialis[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_spesialis[$a]->id.'" '.$select.'>
												'.$data_spesialis[$a]->specialist.'
											</option>
										';
									}
								echo'
							</select>
						</div>

						<div class="form-group">
							<label>Jenis Kelamin </label>
							
							<select name="gender" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Jenis Kelamin --
								</option>
								';
									$idGender = $data_edit[0]->gender;
									$data_gender = $this->master_model->select_in('MST_GENDER','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_gender); $a++)
									{
										if($idGender == $data_gender[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_gender[$a]->id.'" '.$select.'>
												'.$data_gender[$a]->gender.'
											</option>
										';
									}
								echo'
							</select>
						</div>						

						<div class="form-group">
							<label>Tempat Lahir </label>
							
							<select name="birth_place" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Tempat Lahir --
								</option>
								';
									$idTL = $data_edit[0]->birth_place;
									$data_tl = $this->master_model->select_in('MST_CITY','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_tl); $a++)
									{
										if($idTL == $data_tl[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_tl[$a]->id.'" '.$select.'>
												'.$data_tl[$a]->city.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Tanggal Lahir </label>
							<input type="date" name="birth_date"  class="form-control datepicker" value="'.$data_edit[0]->birth_date.'" >
						</div>				

						<div class="form-group">
							<label>Alamat</label>
							<textarea name="address"  class="form-control" >'.$data_edit[0]->address.'</textarea>
						</div>

						<div class="form-group">
							<label>Kota </label>
							
							<select name="city" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Kota --
								</option>
								';
									$idCity = $data_edit[0]->city;
									$data_city = $this->master_model->select_in('MST_CITY','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_city); $a++)
									{
										if($idCity == $data_city[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_city[$a]->id.'" '.$select.'>
												'.$data_city[$a]->city.'
											</option>
										';
									}
								echo'
							</select>
						</div>												
						
						<div class="form-group">
							<label>Wilayah </label>
							
							<select name="district" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Wilayah --
								</option>
								';
									$idDis = $data_edit[0]->district;
									$data_dis = $this->master_model->select_in('MST_DISTRICT','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_dis); $a++)
									{
										if($idDis == $data_dis[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_dis[$a]->id.'" '.$select.'>
												'.$data_dis[$a]->district.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Kecamatan </label>
							
							<select name="subdistrict" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Kecamatan --
								</option>
								';
									$idSubDis = $data_edit[0]->subdistrict;
									$data_subdis = $this->master_model->select_in('MST_SUBDISTRICT','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_subdis); $a++)
									{
										if($idSubDis == $data_subdis[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_subdis[$a]->id.'" '.$select.'>
												'.$data_subdis[$a]->subdistrict.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Kode Pos </label>
							
							<select name="zipcode" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Kode Pos --
								</option>
								';
									$idZip = $data_edit[0]->zipcode;
									$data_zip = $this->master_model->select_in('MST_ZIPCODE','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_zip); $a++)
									{
										if($idZip == $data_zip[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_zip[$a]->id.'" '.$select.'>
												'.$data_zip[$a]->zipcode.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>Negara </label>
							
							<select name="country" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Negara --
								</option>
								';
									$idCoun = $data_edit[0]->country;
									$data_coun = $this->master_model->select_in('MST_COUNTRY','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_coun); $a++)
									{
										if($idCoun == $data_coun[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_coun[$a]->id.'" '.$select.'>
												'.$data_coun[$a]->country.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>No. KTP</label>
							<input type="text" name="id_card_no" value="'.$data_edit[0]->id_card_no.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>File KTP</label>
							<input type="file" name="ktp">
							';
							if($data_edit[0]->id_card_image == '')
							{
								echo '<img class="img-circle" src="'.base_url().'assets/img/default-50x50.gif" alt="User Avatar">';
							}else {
								echo '<img class="img-circle" src="'.base_url().'uploads/foto/'.$data_edit[0]->id_card_image.'" height="100px" width="100px" alt="User Avatar">';
							}
						echo'
							<input type="hidden" name="id_card_image" value="'.$data_edit[0]->id_card_image.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>No. NPWP</label>
							<input type="text" name="npwp_no" value="'.$data_edit[0]->npwp_no.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Agama </label>
							
							<select name="religion" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Agama --
								</option>
								';
									$idRelig = $data_edit[0]->religion;
									$data_relig = $this->master_model->select_in('MST_RELIGION','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_relig); $a++)
									{
										if($idRelig == $data_relig[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_relig[$a]->id.'" '.$select.'>
												'.$data_relig[$a]->religion.'
											</option>
										';
									}
								echo'
							</select>
						</div>												

						<div class="form-group">
							<label>No. Telepon</label>
							<input type="text" name="phone" value="'.$data_edit[0]->phone.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>No. HP (1)</label>
							<input type="text" name="handphone_1" value="'.$data_edit[0]->handphone_1.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>No. HP (2)</label>
							<input type="text" name="handphone_2" value="'.$data_edit[0]->handphone_2.'" class="form-control">
						</div>

						<div class="form-group">
							<label>Email</label>
							<input type="text" name="email" value="'.$data_edit[0]->email.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Nama Bank</label>
							<input type="text" name="bank_name" value="'.$data_edit[0]->bank_name.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Cabang Bank</label>
							<input type="text" name="bank_branch" value="'.$data_edit[0]->bank_branch.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Nama Rekening</label>
							<input type="text" name="bank_account_name" value="'.$data_edit[0]->bank_account_name.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>No. Rekening</label>
							<input type="text" name="bank_account_no" value="'.$data_edit[0]->bank_account_no.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>No. BPJS</label>
							<input type="text" name="bpjs_no" value="'.$data_edit[0]->bpjs_no.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Emergency Contact </label>
							<input type="text" name="emergency_contact" value="'.$data_edit[0]->emergency_contact.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Emergency Phone </label>
							<input type="text" name="emergency_phone" value="'.$data_edit[0]->emergency_phone.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Emergency Relation</label>
							<input type="text" name="emergency_relationship" value="'.$data_edit[0]->emergency_relationship.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>File KTP</label>
							<input type="file" name="photo">
							';
							if($data_edit[0]->photograph == '')
							{
								echo '<img class="img-circle" src="'.base_url().'assets/img/default-50x50.gif" alt="User Avatar">';
							}else {
								echo '<img class="img-circle" src="'.base_url().'uploads/foto/'.$data_edit[0]->photograph.'" height="100px" width="100px" alt="User Avatar">';
							}
						echo'
							<input type="hidden" name="photograph" value="'.$data_edit[0]->photograph.'" class="form-control" >
						</div>

						<div class="form-group">
							<label>Status </label>
							
							<select name="status" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Status --
								</option>
								';
									$idStat = $data_edit[0]->status;
									$data_stat = $this->master_model->select_in('MST_STATUS','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_stat); $a++)
									{
										if($idStat == $data_stat[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_stat[$a]->id.'" '.$select.'>
												'.$data_stat[$a]->status.'
											</option>
										';
									}
								echo'
							</select>
						</div>												


						<div class="form-group">
							<label>Catatan</label>
							<textarea name="notes"  class="form-control" >'.$data_edit[0]->notes.'</textarea>
						</div>

                    </div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function update_dokter($menuid, $ID)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$this->load->helper(array('form', 'url')); 
		$ktp = "";
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'gif|jpg|png|jpeg|bmp';
		$config['max_size'] = '2048';
//		log_message('INFO', 'Isi photo ' . $_FILES['photo']);
		$this->upload->initialize($config);
			if(!$this->upload->do_upload('ktp')){
				$ktp=$this->input->post('id_card_image');
			}else{
				$ktp=$this->upload->file_name;
		}
		
		$this->upload->initialize($config);
			if(!$this->upload->do_upload('photo')){
				$photo=$this->input->post('photograph');
			}else{
				$photo=$this->upload->file_name;
		}


		$data = array(			
			'code' => $this->input->post('code'),
			'name' => $this->input->post('name'),
			'initial_name' => $this->input->post('initial_name'),
			'specialist' => $this->input->post('specialist'),
			'gender' => $this->input->post('gender'),
			'birth_place' => $this->input->post('birth_place'),
			'birth_date' => $this->input->post('birth_date'),
			'address' => $this->input->post('address'),
			'city' => $this->input->post('city'),
			'district' => $this->input->post('district'),
			'subdistrict' => $this->input->post('subdistrict'),
			'zipcode' => $this->input->post('zipcode'),
			'country' => $this->input->post('country'),
			'id_card_no' => $this->input->post('id_card_no'),
			'id_card_image' => $ktp,
			'npwp_no' => $this->input->post('npwp_no'),
			'religion' => $this->input->post('religion'),
			'phone' => $this->input->post('phone'),
			'handphone_1' => $this->input->post('handphone_1'),
			'handphone_2' => $this->input->post('handphone_2'),
			'email' => $this->input->post('email'),
			'bank_name' => $this->input->post('bank_name'),
			'bank_branch' => $this->input->post('bank_branch'),
			'bank_account_name' => $this->input->post('bank_account_name'),
			'bank_account_no' => $this->input->post('bank_account_no'),
			'bpjs_no' => $this->input->post('bpjs_no'),
			'emergency_contact' => $this->input->post('emergency_contact'),
			'emergency_phone' => $this->input->post('emergency_phone'),
			'emergency_relationship' => $this->input->post('emergency_relationship'),
			'photograph' => $photo,
			'status' => $this->input->post('status'),
			'notes' => $this->input->post('notes'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	
	
		$this->db->where('id', $ID);
		$this->db->update('MST_DOCTOR', $data);

		redirect('master_dokter/dokter/'.$menuid);
	}

	public function jadwal($menuid, $ID)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jadwal']  = $this->master_model->jadwal($ID);

    		$this->load->view('dokter/jadwal', $data);
	    }
	}

	public function insert_jadwal($menuid, $ID)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$data = array(
			'id_dokter' => $this->input->post('id_dokter'),
			'id_klinik' => $this->input->post('id_klinik'),
			'hari' => $this->input->post('hari'),
			'time_start' => $this->input->post('time_start'),
			'time_end' => $this->input->post('time_end'),
			'id_room' => $this->input->post('id_room'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1	
			
		);
		$this->db->insert('MST_DOCTOR_SCHEDULE', $data);
		redirect('master_dokter/jadwal/'.$menuid.'/'.$ID);
	}

	public function edit_jadwal($menuid, $ID)
	{
		$id_trn = $this->input->post('id');
		$data_edit = $this->master_model->mst_edit_dr('MST_DOCTOR_SCHEDULE',$id_trn);
	
		echo'
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title">Edit Jadwal Praktek Dokter</h4>
		</div>
				<form action="'.base_url().'master_dokter/edit_process_jadwal/'.$menuid.'/'.$ID.'/'.$id_trn.'" method="post" enctype="multipart/form-data">
					<div class="modal-body">
						
						<div class="form-group">
							<input type="hidden" name="id_dokter" value="'.$data_edit[0]->id_dokter.'" class="form-control" placeholder="ID Dokter" required="required">
						</div>

						<div class="form-group">
							<label>Klinik </label>
							
							<select name="id_klinik" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Klinik --
								</option>
								';
									$idKlinik = $data_edit[0]->id_klinik;
									$data_klinik = $this->master_model->select_in('MST_CLINIC_BRANCH','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_klinik); $a++)
									{
										if($idKlinik == $data_klinik[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_klinik[$a]->id.'" '.$select.'>
												'.$data_klinik[$a]->name.'
											</option>
										';
									}
								echo'
							</select>
						</div>

						<div class="form-group">
							<label>Hari </label>
							
							<select name="hari" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Hari --
								</option>
								';
									$idHari = $data_edit[0]->hari;
									$data_hari = $this->master_model->select_in('MST_HARI','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_hari); $a++)
									{
										if($idHari == $data_hari[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_hari[$a]->id.'" '.$select.'>
												'.$data_hari[$a]->hari.'
											</option>
										';
									}
								echo'
							</select>
						</div>

						<div class="form-group">
							<label>Jam Mulai </label>
							
							<select name="time_start" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Jam Mulai --
								</option>
								';
									$idMulai = $data_edit[0]->time_start;
									$data_jam = $this->master_model->select_in('MST_TIME','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_jam); $a++)
									{
										if($idMulai == $data_jam[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_jam[$a]->id.'" '.$select.'>
												'.$data_jam[$a]->time.'
											</option>
										';
									}
								echo'
							</select>
						</div>

						<div class="form-group">
							<label>Jam Akhir </label>
							
							<select name="time_end" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Jam Akhir --
								</option>
								';
									$idAkhir = $data_edit[0]->time_end;
									$data_jam = $this->master_model->select_in('MST_TIME','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_jam); $a++)
									{
										if($idAkhir == $data_jam[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_jam[$a]->id.'" '.$select.'>
												'.$data_jam[$a]->time.'
											</option>
										';
									}
								echo'
							</select>
						</div>


						<div class="form-group">
							<label>Room No </label>
							
							<select name="id_room" class="form-control" >
								<option selected="selected" value="">
									-- Pilih Room No --
								</option>
								';
									$idRoom = $data_edit[0]->id_room;
									$data_room = $this->master_model->select_in('MST_CLINIC_ROOM','*',"ORDER BY id ASC");
									for($a=0; $a < count($data_room); $a++)
									{
										if($idRoom == $data_room[$a]->id)
										{
											$select = 'selected="selected"';
										}else {
											$select = '';
										}
										echo'
											<option value="'.$data_room[$a]->id.'" '.$select.'>
												'.$data_room[$a]->room.'
											</option>
										';
									}
								echo'
							</select>
						</div>

						<div class="form-group">
						
						</div>

						<div class="modal-footer">
							<button type="submit" value="1" name="submit" class="btn btn-danger btn-fill pull-right save_phone save_email">Save And Close</button>
								
						</div>
				</form>
		';
	}

	public function edit_process_jadwal($menuid, $ID, $id_trn)
	{
		$submit = $this->input->post('submit');
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$admin = $this->session->userdata('username');

		$data = array(			
			'id_dokter' => $this->input->post('id_dokter'),
			'id_klinik' => $this->input->post('id_klinik'),
			'hari' => $this->input->post('hari'),
			'time_start' => $this->input->post('time_start'),
			'time_end' => $this->input->post('time_end'),
			'id_room' => $this->input->post('id_room'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	

		$this->db->where('id', $id_trn);
		$this->db->update('MST_DOCTOR_SCHEDULE', $data);
		if($submit==1)
		{
			redirect('master_dokter/jadwal/'.$menuid.'/'.$ID);
		}
	}	
}
?>
