<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class absensi extends CI_Controller {

	public function __construct()

	{

		parent :: __construct();

		$this->load->model('master_model');
		$this->load->model('absensi_model');
		$this->load->model('kunjungan_model');
		date_default_timezone_set('Asia/Jakarta');

    }


	public function mesin_presensi()
	{
		$dataView = [
			'insertedId' => '',
			'jenis' => 1
		];
		$this->load->view('absensi/menu',$dataView);
	}

	public function absen($menuid, $jenis, $idkunjungan)
	{
		$dataView = [
			'insertedId' => '',
			'jenis' => $jenis,
			'idKunjungan' => $idkunjungan
		];

		$this->load->view('absensi/absen',$dataView);
	}

	public function handleScanResult($menuid)
    {
		date_default_timezone_set('Asia/Jakarta');

		$result = $this->input->post('result');
		
		// Retrieve photo data
        $photoData = $this->input->post('photoData');
		
		// Convert base64 encoded image data to binary
		$imageData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $photoData));

		// Generate a unique filename for the photo
		$filename = 'photo_' . time() . '.png';

		// Specify the path to the uploads/absen folder
		$path = FCPATH . 'uploads' . DIRECTORY_SEPARATOR . 'absen' . DIRECTORY_SEPARATOR . $filename;

        // Check if decoding was successful
		if ($imageData !== false) {

			// Save the decoded image data to the file
			$fileSaved = file_put_contents($path, $imageData);

			if ($fileSaved !== false) {
				echo 'Image saved successfully.';
			} else {
				echo 'Failed to save the image.';
			}
		} else {
			echo 'Failed to decode the base64 data.';
		}	

		$jenis = $this->input->post('selectedOptionValue');
		$idKunjungan = $this->input->post('kunjunganValue');
		$now = date("Y-m-d");
		// Process the scanned result as needed
		// For example, you can save it to a database, perform some business logic, etc.
		$cek = $this->master_model->select_in('tr_absen','*',"where id_pengelola='$result' and tanggal = '$now'");
		$count = count($cek, COUNT_RECURSIVE);	
		if($idKunjungan > 0){ 
			if($jenis == 5){
				$data = array(
					'kunjungan_keluar' => date('Y-m-d H:i:s'),
					'foto_kunjungan_keluar' => $filename,
				);									
			}
	
			if($jenis == 6){
				$data = array(
					'kunjungan_masuk' => date('Y-m-d H:i:s'),
					'foto_kunjungan_masuk' => $filename,
				);					
			}

			$this->db->where('id', $idKunjungan);
			$this->db->update('tr_permohonan_kunjungan', $data);				

		} else {
			if($count == 0){
				if (file_put_contents($path, $imageData)) {
					if($jenis == 1){
						$data = array(
							'tanggal' => date('Y-m-d'),
							'id_pengelola' => $result,						
							'absen_masuk' => date('Y-m-d H:i:s'),
							'foto_masuk' => $filename,						
						);					
					}
					if($jenis == 2){
						$data = array(
							'tanggal' => date('Y-m-d'),
							'id_pengelola' => $result,						
							'absen_pulang' => date('Y-m-d H:i:s'),
							'foto_pulang' => $filename,						
						);					
					}
					if($jenis == 3){
						$data = array(
							'tanggal' => date('Y-m-d'),
							'id_pengelola' => $result,						
							'istirahat_keluar' => date('Y-m-d H:i:s'),
							'foto_istirahat_keluar' => $filename,						
						);					
					}
					if($jenis == 4){
						$data = array(
							'tanggal' => date('Y-m-d'),
							'id_pengelola' => $result,
							'istirahat_masuk' => date('Y-m-d H:i:s'),
							'foto_istirahat_masuk' => $filename,						
						);					
					}
					$this->db->insert('tr_absen', $data);
				}
			} else {
				if (file_put_contents($path, $imageData)) {
					if($jenis == 1){
						$data = array(					
							'absen_masuk' => date('Y-m-d H:i:s'),
							'foto_masuk' => $filename,						
						);					
					}
					if($jenis == 2){
						$data = array(					
							'absen_pulang' => date('Y-m-d H:i:s'),
							'foto_pulang' => $filename,
						);					
					}
					if($jenis == 3){
						$data = array(					
							'istirahat_keluar' => date('Y-m-d H:i:s'),
							'foto_istirahat_keluar' => $filename,
						);					
					}
					if($jenis == 4){
						$data = array(
							'istirahat_masuk' => date('Y-m-d H:i:s'),
							'foto_istirahat_masuk' => $filename,
						);					
					}

					echo("<script>console.log('Jenis: " . $jenis . "');</script>");
					echo("<script>console.log('Jam: " . date('Y-m-d H:i:s') . "');</script>");

					$this->db->where('id_pengelola', $result);
					$this->db->where('tanggal', $now);
					$this->db->update('tr_absen', $data);				
					
				}
			}
		}
		
		$data = array(
			'tanggal' => date('Y-m-d'),
			'id_pengelola' => $result,						
			'hadir' => date('Y-m-d H:i:s'),
		);					
		$this->db->insert('tr_absen_raw', $data);
		
		$sql="update tr_absen set telat_masuk = case when TIMESTAMPDIFF(MINUTE, concat(tanggal,' ',(select jam_masuk from m_jadwal where hari = DAYNAME(tanggal))), absen_masuk) > 0 then
			TIMESTAMPDIFF(MINUTE, concat(tanggal,' ',(select jam_masuk from m_jadwal where hari = DAYNAME(tanggal))), absen_masuk) else 0 end
			where id_pengelola = '$result' and tanggal = '$now';";
		$qry = $this->db->query($sql);
	
    	$ijin = $this->master_model->select_in('tr_permohonan_ijin','*',"where id_pengelola='$result' and tgl_ijin = '$now' and jam_ijin_mulai = '8:00' and tindakan_kadiv = 1 and tindakan_hrd = 1 ");
		$count = count($ijin, COUNT_RECURSIVE);	
		if($count == 1){
    		$sql="update tr_absen set telat_masuk = 0 where id_pengelola = '$result' and tanggal = '$now';";
    		$qry = $this->db->query($sql);
		}
	
	    $kunjungan = $this->master_model->select_in('tr_permohonan_kunjungan','*',"where id_pengelola='$result' and tgl_dinas = '$now' and jam_pergi = '8:00' and tindakan_kadiv = 1 and tindakan_hrd = 1 ");
		$count = count($ijin, COUNT_RECURSIVE);	
		if($count == 1){
    		$sql="update tr_absen set telat_masuk = 0 where id_pengelola = '$result' and tanggal = '$now';";
    		$qry = $this->db->query($sql);
		}	
		
		$siswa = $this->master_model->select_in('m_pengelola','*',"where id_pengelola='$result'");

		$insertedId = $siswa[0]->nama_lengkap;
		
		$response = array('message' => 'Data Berhasil Disimpan', 'Nama Pengelola :' => $insertedId);
        // echo json_encode($response);

		echo("<script>console.log('idKunjungan: " . $idKunjungan . "');</script>");

		if($jenis==1 or $jenis==2 or $jenis==3 or $jenis==4 ){
			$dataView = [
				'insertedId' => $insertedId,
				'jenis' => $jenis,
				'idKunjungan' => 0
			];

			$this->load->view('absensi/absen', $dataView);
		}

		if($jenis==5 or $jenis==6){
// 			redirect('kunjungan/riwayat_kunjungan/'.$menuid);	
            $user_id = $this->session->userdata('user_id');
    	    $check = $this->master_model->auth_read($user_id, $menuid);
    		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
    		$pengelola = $msuser[0]->id_pengelola;
    		if(empty($pengelola)){
    			$pengelola = 0;
    		}
    		
    	    if($check==false)
    	    {
    	        redirect('NotAuthorized');
    	    }else
    	    {
    			$data['data_pengajuan']   = $this->kunjungan_model->riwayat_pengajuan($pengelola);
    			$this->load->view('kunjungan/riwayat_pengajuan', $data);
    	    }
		}

		// $this->load->view('absensi/absen', ['insertedId' => $insertedId]);
		// redirect('absensi/absen/'.$menuid.'/'.$jenis, ['insertedId' => $insertedId]);	
	}
	
	public function daftar_presensi($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_presensi']   = $this->master_model->select_in('tr_absen','*',"where 1=0");
			$this->load->view('absensi/daftar_presensi', $data);
	    }
	}

	public function data_presensi($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal]'));
		$tanggal = $date->format('Y-m-d');
		
		if (empty($tanggal)){
			$tanggal = $this->session->userdata('tanggal');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_presensi']   = $this->absensi_model->presensi($tanggal);
			$this->load->view('absensi/data_presensi', $data);
	    }
	}
	
	public function laporan_kehadiran($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kehadiran']   = $this->master_model->select_in('tr_absen','*',"where 1=0");
			$this->load->view('absensi/laporan_kehadiran', $data);
	    }
	}

	public function detail_lap_kehadiran($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal1]'));
		$tanggal1 = $date->format('Y-m-d');
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal2]'));
		$tanggal2 = $date->format('Y-m-d');

		if (empty($tanggal1)){
			$tanggal1 = $this->session->userdata('tanggal1');
			$tanggal2 = $this->session->userdata('tanggal2');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kehadiran']   = $this->absensi_model->kehadiran($tanggal1, $tanggal2);
			$this->load->view('absensi/detail_kehadiran', $data);
	    }
	}

	public function excel_kehadiran($menuid, $tanggal1, $tanggal2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kehadiran']   = $this->absensi_model->kehadiran($tanggal1, $tanggal2);
			$this->load->view('absensi/excel_kehadiran', $data);
	    }
	}

	public function update_presensi($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_presensi']   = $this->absensi_model->koreksi_presensi($id);
			$this->load->view('absensi/koreksi_presensi', $data);
	    }
	}

	public function edit_presensi($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$result = $this->input->post('id_pengelola');
		$now = $this->input->post('tanggal');
		
		$absen_masuk = $this->input->post('tanggal').' '.$this->input->post('absen_masuk').':00';
		$absen_pulang = $this->input->post('tanggal').' '.$this->input->post('absen_pulang').':00';
		$istirahat_keluar = $this->input->post('tanggal').' '.$this->input->post('istirahat_keluar').':00';
		$istirahat_masuk = $this->input->post('tanggal').' '.$this->input->post('istirahat_masuk').':00';
		
		$data = array(			
			'absen_masuk' => $absen_masuk,
			'absen_pulang' => $absen_pulang,			
			'istirahat_keluar' => $istirahat_keluar,
			'istirahat_masuk' => $istirahat_masuk,	
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1			
		);

		$this->db->where('id', $id);
		$this->db->update('tr_absen', $data);

		$sql="update tr_absen set telat_masuk = case when TIMESTAMPDIFF(MINUTE, concat(tanggal,' ',(select jam_masuk from m_jadwal where hari = DAYNAME(tanggal))), absen_masuk) > 0 then
			TIMESTAMPDIFF(MINUTE, concat(tanggal,' ',(select jam_masuk from m_jadwal where hari = DAYNAME(tanggal))), absen_masuk) else 0 end
			where id_pengelola = '$result' and tanggal = '$now';";

		$qry = $this->db->query($sql);
		
		redirect('absensi/daftar_presensi/'.$menuid);
	}
	
	public function laporan_tidak_absen_pulang($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kehadiran']   = $this->master_model->select_in('tr_absen','*',"where 1=0");
			$this->load->view('absensi/laporan_tidak_absen_pulang', $data);
	    }
	}
	
	public function detail_lap_tidak_absen_pulang($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal1]'));
		$tanggal1 = $date->format('Y-m-d');
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal2]'));
		$tanggal2 = $date->format('Y-m-d');

        $pengelola = $this->input->post('group-b[0][pengelola]');
        

        $data_pengelola = $this->master_model->select_in('m_pengelola','*',"where id = $pengelola");

        $idpengelola = $data_pengelola[0]->id_pengelola;

		if (empty($tanggal1)){
			$tanggal1 = $this->session->userdata('tanggal1');
			$tanggal2 = $this->session->userdata('tanggal2');
			$pengelola = $this->session->userdata('pengelola');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kehadiran']   = $this->absensi_model->tidak_absen_pulang($tanggal1, $tanggal2, $idpengelola);
			$this->load->view('absensi/detail_tidak_absen_pulang', $data);
	    }
	}
}

?>
