<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class transaction extends CI_Controller {

	function __construct()
	{
        parent::__construct();
		$this->load->model('master_model');
		$this->load->library('upload');
        $this->load->model('transaksi_model');
		$this->load->library('PHPExcel');
		$this->load->library('PHPExcel/IOFactory');
    }


	public function index($menuid, $ID='')
	{
			$status = $this->input->get('status');

			$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
				if($status == '')
				{
					$data['data_service']=$this->master_model->mst_data('ts_service');
				}else {
					$data['data_service']=$this->master_model->select_in('ts_service','*', "WHERE status = $status");
				}

				$this->load->view('service/main', $data);
    	}
	}

	public function selected_service($menuid)
	{
		$ID = $this->input->post('ID');

		$data_service = $this->master_model->select_in('ts_service', '*', "WHERE ID=$ID");

		$id_customer = $data_service[0]->id_customer;
		$data_customer = $this->master_model->select_in('ms_customer','name',"WHERE ID = $id_customer");

		$product = explode(', ', $data_service[0]->product);

		$status = $data_service[0]->status;

		if($status == 0)
		{
			$status = '<span class="label label-primary">Analysis</span>';
		}elseif($status == 1)
		{
			$status = '<span class="label label-info">Process</span>';
		}elseif($status == 2)
		{
			$status = '<span class="label label-warning">Pending</span>';
		}elseif($status == 3)
		{
			$status = '<span class="label label-success">Done</span>';
		}elseif($status == 4)
		{
			$status = '<span class="label label-danger">Failed</span>';
		}
		echo'
			<table class="table no-margin">
				<thead>
					<tr>
						<th>No</th>
						<th>Invoice</th>
						<th>Customer</th>
						<th>Service Date</th>
						<th>Product</th>
						<th>Policy Number</th>

						<th>Admin</th>
						<th>Status</th>
						<th>Edit</th>
						<th>Delete</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>1</td>
						<td>
							<a alt="'.$data_service[0]->ID.'" class="close_invoice" data-dismiss="modal" style="cursor:pointer">
									'.$data_service[0]->invoice.'
							</a>
							<script>
								$(document).ready(function()
								{
									$(".close_invoice").click(function()
						      {
							        $(".invoice_pop").trigger("click");
							    });
								});
							</script>
						</td>
						<td>
							<a href="'.base_url().'master/customer_detail/9/'.$data_service[0]->id_customer.'" class="text-aqua">
								'.$data_customer[0]->name.'
							</a>
						</td>
						<td>
							'.date('d M Y', strtotime($data_service[0]->date_in)).'
						</td>
						<td>'.$product[0].', '.$product[1].', '.$product[2].'</td>
						<td>'.$product[3].'</td>

						<td>
							';
								$id_admin=$data_service[0]->id_admin;
								$data_admin=$this->master_model->select_in('user','name',"WHERE ID=$id_admin");
								echo $data_admin[0]->name;
							echo'
						</td>
						<td>'.$status.'</td>
						<td style="text-align:center">
							 <a href="'.base_url().'transaction/edit/'.$menuid.'/'.$id_customer.'/'.$ID.'" class="text-green" style="cursor:pointer">
										<i class="fa fa-edit"></i>
								</a>
						</td>
						<td style="text-align:center">
							<a href="'.base_url().'>transaction/delete/'.$menuid.'/'.$ID.'" onclick="return confirm(\'Are you sure want to delete this service?\')"  class="text-red">
										<i class="fa fa-trash-o"></i>
								</a>
						</td>
					</tr>
				</tbody>
			</table>
		';
	}


	public function rent($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_rent']=$this->master_model->mst_data('ts_analysis');

			$this->load->view('rent/main', $data);
    	}
	}

	public function start($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$this->load->view('service/start');
    	}
	}


	public function customer_to_list($menuid)
	{
		$name=$this->input->get('name');
		$data_customer=$this->master_model->select_in('ms_customer','name, phone, email',"WHERE name LIKE '%$name%'");
		for($c=0; $c < count($data_customer); $c++)
		{
			$name=$data_customer[$c]->name;
			$phone=$data_customer[$c]->phone;
			$email=$data_customer[$c]->email;
			echo'
				<option value="'.$name.'">
			';
		}
	}

	public function get_detail_customer($menuid, $fill)
	{
		$input=$this->input->post('input');

		if($fill=='name')
		{
			/*$exp=explode(' / ', $input);
			$name=$exp[0];
			$phone=$exp[1];
			$email=$exp[2];*/
			$name=$input;
			$phone='';
			$email='';

			$row=$name;
		}elseif($fill=='phone')
		{
			$name='';
			$phone=$input;
			$email='';

			$row=$phone;
		}elseif($fill=='email')
		{
			$name='';
			$phone='';
			$email=$input;

			$row=$email;
		}

		$check=$this->master_model->mst_check('ms_customer', $fill, $row);

		if($check==false)
		{
			$ID=$this->master_model->mst_last_id('ms_customer');
			$name=$name;
			$phone=$phone;
			$email=$email;
			$company='';
			$company_phone='';
			$address='';
			$ID=$ID;
			$alert='error';
		}else
		{
			$data_customer=$this->master_model->select_in('ms_customer','ID, name, phone, email, address, company, company_phone',"WHERE $fill='$row'");
			$name=$data_customer[0]->name;
			$phone=$data_customer[0]->phone;
			$email=$data_customer[0]->email;
			$address=$data_customer[0]->address;
			$company=$data_customer[0]->company;
			$company_phone=$data_customer[0]->company_phone;
			$ID=$data_customer[0]->ID;
			$alert='success';
		}

		echo $name.'%'.$phone.'%'.$email.'%'.$address.'%'.$ID.'%'.$alert.'%'.$company.'%'.$company_phone;
	}

	public function get_detail_services($menuid)
	{
		$jobs=$this->input->post('jobs');

		$check=$this->master_model->mst_check('ms_service', 'name', $jobs);

		if($check==false)
		{
			$duration=0;
			$qty=0;
			$price=0;
			$mechanic='';
			$subtotal=0;
		}else
		{
			$data_service=$this->master_model->select_in('ms_service','name, durations, price, mechanic',"WHERE name='$jobs'");
			$duration=$data_service[0]->durations;
			$qty=1;
			$price=$data_service[0]->price;
			$mechanic=$data_service[0]->mechanic;

			$subtotal=$qty*$price;
		}

		echo $duration.'%'.$qty.'%'.$price.'%'.$mechanic.'%'.$subtotal;
	}


	public function next_1($menuid)
	{
		$id_customer=$this->input->post('id_customer');

		$this->session->set_userdata('name_customer', $this->input->post('name'));
		$this->session->set_userdata('phone_customer', $this->input->post('phone'));
		$this->session->set_userdata('email_customer', $this->input->post('email'));
		$this->session->set_userdata('address_customer', $this->input->post('address'));

		redirect('transaction/product/'.$menuid.'/'.$id_customer);
	}

	public function product($menuid, $id_customer='')
	{
		if($id_customer=='')
		{
			$id_customer=$this->input->post('submit');
		}else
		{
			$id_customer=$id_customer;
		}

		$data['id_customer']=$id_customer;

		$this->load->view('service/product', $id_customer);
	}

	public function category_to_list($menuid)
	{
		$name=$this->input->get('name');
		$data_category=$this->master_model->select_in('ms_product','name',"WHERE name LIKE '%$name%'");
		for($c=0; $c < count($data_category); $c++)
		{
			$name=$data_category[$c]->name;
			echo'
				<option value="'.$name.'">
			';
		}
	}

	public function category_to_model($menuid)
	{
		$name=$this->input->POST('name');
		$get_id_product = $this->master_model->select_in('ms_product', 'ID', "WHERE name = '$name'");
		$id_product = $get_id_product[0]->ID;

		$data_category=$this->master_model->select_in('ms_product_category','ID, name',"WHERE id_product = '$id_product' ORDER BY name ASC");
		echo'
				<option selected="selected">Choose Model</option>
		';
				for($a=0; $a < count($data_category); $a++)
				{
					echo'
						<option value="'.$data_category[$a]->name.'">'.$data_category[$a]->name.'</option>
					';
				}
	}

	public function brand_to_list($menuid, $merk)
	{
		$name=$this->input->get('name');

		if($merk == 0)
		{
			$and = "";
		}else
		{
			$and = "AND id_product = $merk";
		}
		$data_brand=$this->master_model->select_in('ms_product_category','name',"WHERE name LIKE '%$name%' $and");
		for($c=0; $c < count($data_brand); $c++)
		{
			$name=$data_brand[$c]->name;
			echo'
				<option value="'.$name.'">
			';
		}
	}

	public function model_to_type($menuid)
	{
		$name=$this->input->POST('name');
		$get_id_product_category = $this->master_model->select_in('ms_product_category', 'ID', "WHERE name = '$name'");
		$id_product = $get_id_product_category[0]->ID;

		$data_category=$this->master_model->select_in('ms_product_subcategory','ID, name',"WHERE id_product_category = '$id_product'");
		echo'
				<option selected="selected">Choose Type</option>
			';
				for($a=0; $a < count($data_category); $a++)
				{
					echo'
						<option value="'.$data_category[$a]->name.'">'.$data_category[$a]->name.'</option>
					';
				}
	}

	public function type_to_unit($menuid)
	{
		$name=$this->input->POST('name');
		$get_id_product = $this->master_model->select_in('ms_product_subcategory', 'ID', "WHERE name = '$name'");
		$id_product = $get_id_product[0]->ID;

		$data_category=$this->master_model->select_in('ms_product_unit','ID, policy_number',"WHERE id_product_subcategory = '$id_product'");
		echo'
				<option selected="selected">Choose Unit</option>
				';
					for($a=0; $a < count($data_category); $a++)
					{
						echo'
							<option value="'.$data_category[$a]->policy_number.'">'.$data_category[$a]->policy_number.'</option>
						';
					}
	}

	public function model_to_list($menuid, $model)
	{
		$name=$this->input->get('name');

		if($model == 0)
		{
			$and = "";
		}else
		{
			$and = "AND id_product_category = $model";
		}

		$data_model=$this->master_model->select_in('ms_product_subcategory','name',"WHERE name LIKE '%$name%' $and");
		for($c=0; $c < count($data_model); $c++)
		{
			$name=$data_model[$c]->name;
			echo'
				<option value="'.$name.'">
			';
		}
	}

	public function type_to_detail($menuid)
	{
		$name=$this->input->POST('name');

		$data_subcategory=$this->master_model->select_in('ms_product_subcategory','ID, price',"WHERE name = '$name'");

		echo $data_subcategory[0]->ID.'--'.$data_subcategory[0]->price;
	}

	public function damage_to_list($menuid)
	{
		$name=$this->input->get('name');
		$data_damage=$this->master_model->select_in('ms_service','name',"WHERE name LIKE '%$name%'");
		for($c=0; $c < count($data_damage); $c++)
		{
			$name=$data_damage[$c]->name;
			echo'
				<option value="'.$name.'">
			';
		}
	}

	public function spareparts_to_list($menuid, $type)
	{
		$type = str_replace('%20', ' ', $type);
		$name=$this->input->get('name');
		$data_subcategory = $this->master_model->select_in('ms_product_subcategory','ID',"WHERE name = '$type'");
		$id_product_subcategory= $data_subcategory[0]->ID;

		$data_spareparts=$this->master_model->select_in('ms_product_spareparts','name',"WHERE name LIKE '%$name%' AND id_product_subcategory = $id_product_subcategory");
		for($c=0; $c < count($data_spareparts); $c++)
		{
			$name=$data_spareparts[$c]->name;
			echo'
				<option value="'.$name.'">
			';
		}
	}

	public function get_data_list($menuid, $fill)
	{
		$name=$this->input->get('name');
		$data_technician=$this->master_model->select_in('ms_'.$fill,'name',"WHERE name LIKE '%$name%'");
		for($c=0; $c < count($data_technician); $c++)
		{
			$name=$data_technician[$c]->name;
			echo'
				<option value="'.$name.'">
			';
		}
	}


	public function get_price($menuid)
	{
		$name=$this->input->post('name');

		$check=$this->master_model->mst_check('ms_product_spareparts', 'name', $name);

		if($check==false)
		{
			echo '0--<span class="text-red">No sparepart in database, do you want request this sparepart?</span>';
		}else
		{
			$data_spareparts=$this->master_model->select_in('ms_product_spareparts','price, stock, request',"WHERE name='$name'");

			$price=$data_spareparts[0]->price;
			$stock = $data_spareparts[0]->stock;
			$request = $data_spareparts[0]->request;

			$real_stock = $stock - $request;

			if($stock < 1)
			{
				echo $price.'--<span class="text-orange">Indent</span> [Stock: 0]';
			}else {
				echo $price.'--<span class="text-green" style="top: 15px">Ready</span> [Stock: '.$stock.', Request: '.$request.']';
			}
		}
	}


	public function create_analysis($menuid)
	{
		$this->session->set_userdata($this->input->post());

		redirect('transaction/jobs/'.$menuid);
	}

	public function jobs($menuid, $id_customer='', $id_header='')
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$this->load->view('service/jobs');
    	}

	}

	public function save_service_dummy($menuid)
	{
		$id_admin=$this->session->userdata('user_id');

		$count_message_service = $this->master_model->mst_count('log_activity', "activity = 'Service' AND status_read=0");
		$count_message_spareparts = $this->master_model->mst_count('log_activity', "activity = 'Spareparts' AND status_read=0");

		$id_service = $this->master_model->mst_last_id('ts_service');
		$data_admin = $this->master_model->select_in('user','name',"WHERE ID = $id_admin");

		$jobs = $this->input->post('jobs');

		$id_service = $this->master_model->mst_last_id('ts_service');
		$technician = $this->input->post('technician');
		$durations  = $this->input->post('duration');
		$qty        = $this->input->post('qty');
		$price      = $this->input->post('price');
		$subtotal   = $this->input->post('subtotal');
		$pre        = $this->input->post('pre');

		for($a=0; $a < count($jobs); $a++)
		{
			if($jobs[$a] <> '')
			{
				$id_service_detail = $this->master_model->mst_last_id('ts_service_detail');
				$insert_service_detail = array
				(
					'ID' => $id_service_detail,
					'id_service' => $id_service,
					'jobs' => $jobs[$a],
					'technician' => $technician[$a],
					'durations' => $durations[$a],
					'qty' => $qty[$a],
					'price' => $price[$a],
					'subtotal' => $subtotal[$a],
					'pre_jobs' => $pre[$a],
					'status' => 1,
					'sort' => $id_service_detail
				);
				$this->db->insert('ts_service_detail', $insert_service_detail);
			}
		}

		//New Notification
		$arr['id_detail'] = $id_service;
		$arr['activity'] = 'Service';
		$arr['date_in'] = date('Y-m-d H:i:s');
		$arr['admin_name'] = $data_admin[0]->name;
		$arr['note'] = 'Create New Service';
		//New Notification End

		$arr['status'] = true;
		$arr['count_message_service'] = $count_message_service+1;
		echo json_encode($arr);
	}


	public function save_service($menuid, $id_customer='', $id_header='')
	{
		$id_admin=$this->session->userdata('user_id');
		$count_message_service = $this->master_model->mst_count('log_activity', "activity = 'Service' AND status_read=0");
		$count_message_spareparts = $this->master_model->mst_count('log_activity', "activity = 'Spareparts' AND status_read=0");
		$data_admin = $this->master_model->select_in('user','name',"WHERE ID = $id_admin");

		$submit=$this->input->post('submit');

		$jobs=$this->input->post('jobs');

		$technician=$this->input->post('technician');
		$durations=$this->input->post('duration');
		$qty=$this->input->post('qty');
		$price=$this->input->post('price');
		$subtotal_service=$this->input->post('subtotal_service');

		$grandtotal=$this->input->post('grandtotal');
		$tax=$this->input->post('tax');
		$id_admin=$this->session->userdata('user_id');
		$indent_day=$this->input->post('indent_day');
		$total_service=$this->input->post('total_service');
		$total_spareparts=$this->input->post('total_spareparts');

		if($submit==1)
		{
			$email = $this->session->userdata('email');
			$check_customer=$this->master_model->mst_check('ms_customer', 'email', $email);

			if($check_customer==false)
			{
				$id_customer = $this->master_model->mst_last_id('ms_customer');
				$data_customer=array
				(
					'ID'=>$id_customer,
					'name'=>$this->session->userdata('name'),
					'email'=>$this->session->userdata('email'),
					'phone'=>$this->session->userdata('phone'),
					'address'=>$this->session->userdata('address'),
					'company'=>$this->session->userdata('company'),
					'company_phone'=>$this->session->userdata('company_phone'),
					'last_activity'=> date('Y-m-d'),
					'status'=>0,
					'sort'=>$id_customer,
				);
				$this->db->insert('ms_customer', $data_customer);
			}else {
				$data_customer = $this->master_model->select_in('ms_customer', 'ID', "WHERE email = '$email'");
				$id_customer = $data_customer[0]->ID;

				$update_customer=array
				(
					'name'=>$this->session->userdata('name'),
					'company'=>$this->session->userdata('company'),
					'company_phone' => $this->session->userdata('company_phone'),
					'address'=>$this->session->userdata('address'),
					'last_activity'=> date('Y-m-d'),
				);
				$this->db->where('ID', $id_customer);
				$this->db->update('ms_customer', $update_customer);
			}

			if($id_header=='')
			{
				$ID=$this->master_model->mst_last_id('ts_service');
				$invoice=$this->master_model->create_invoice($ID);
				$tracking=$this->master_model->tracking();
				$data=array
				(
					'ID'           => $ID,
					'date_in'      => date('Y-m-d'),
					'invoice'      => $invoice,
					'id_admin'     => $id_admin,
					'id_customer'  => $id_customer,
					'product'      => $this->session->userdata('product').', '.$this->session->userdata('model').', '.$this->session->userdata('type').', '.$this->session->userdata('unit'),
					'damage'       => $this->session->userdata('damage'),
					'total_service'=> $total_service,
					'total_parts'  => $total_spareparts,
					'durations_day'=> $this->input->post('total_day'),
					'start_date'   => date('Y-m-d H:i:s'),
					'finish_date'  => date('Y-m-d H:i:s', strtotime('+ '.$this->input->post('total_day').' Day', strtotime(date('Y-m-d H:i:s')))),
					'tax'          => $this->input->post('tax'),
					'discount'     => $this->input->post('discount'),
					'grandtotal'   => $this->input->post('grandtotal'),
					'note'         => $this->input->post('note'),
					'status'=>0,
					'sort'=>$ID,
				);
				$this->db->insert('ts_service', $data);


			}else
			{
				$this->db->where('id_service', $id_header);
				$this->db->delete('ts_service_detail');

				$update=array
				(
					'total_service' => $total_service,
					'total_parts'   => $total_spareparts,
					'grandtotal'    => $total_service,
				);
				$this->db->where('ID', $id_header);
				$this->db->update('ts_service', $update);

				$ID=$id_header;
			}

			$control='index';
			//$id_service='/'.$ID;
			$id_customer='';
			$id_service='';

		}elseif($submit==2)
		{
			$control='edit';
			$id_service='/'.$id_header;

			$get_id_service_detail = $this->master_model->select_in('ts_service_detail','ID',"WHERE id_service=$id_header");
			$id_service_detail = $get_id_service_detail[0]->ID;

			$this->db->where('id_service_detail', $id_service_detail);
			$this->db->delete('ts_service_spareparts');

			$this->db->where('id_service', $id_header);
			$this->db->delete('ts_service_detail');

			$update=array
			(
				'total_service'=>$total_service,
				'total_parts'=>$total_spareparts,
				'grandtotal'=>$grandtotal,
			);
			$this->db->where('ID', $id_header);
			$this->db->update('ts_service', $update);

			$ID=$id_header;
			$id_customer='/'.$id_customer;
		}

		/*save service detail start*/
		$pre=$this->input->post('pre');
		//$total_parts=$this->input->post('subtotal_parts');

		$durations_day=0;
		for($a=0; $a < count($jobs); $a++)
		{
			$no = $a + 1;
			$spareparts = $this->input->post('spareparts_'.$no);
			$qty_parts  = $this->input->post('qty_parts_'.$no);
			$price_parts= $this->input->post('price_parts_'.$no);
			$indent     = $this->input->post('indent_'.$no);
			$subtotal   = $this->input->post('subtotal_parts_'.$no);

			if($jobs[$a] <> '')
			{
				$id_detail=$this->master_model->mst_last_id('ts_service_detail');

				if($a == 0)
				{
					$id_pre = 0;
				}else
				{
					$count_pre = $no - $pre[$a];

					$id_pre = $id_detail - $count_pre;
				}

				$data_detail=array
				(
					'ID'=>$id_detail,
					'id_service'=>$ID,
					'jobs'=>$jobs[$a],
					'technician'=>$technician[$a],
					'durations'=>$durations[$a],
					'pre_jobs'=>$id_pre,
					'qty'=>$qty[$a],
					'price'=>$price[$a],
					'subtotal'=>str_replace('.','',$subtotal_service[$a]),
					'status'=>0,
					'sort'=>$id_detail,
				);
				$this->db->insert('ts_service_detail', $data_detail);

				$id_log_jobs = $this->master_model->mst_last_id('log_activity');
				$log_jobs = array
				(
					'ID' => $id_log_jobs,
					'activity' => 'Jobs',
					'id_detail' => $id_detail,
					'id_admin' => $id_admin,
					'date_in' => date('Y-m-d H:i:s'),
					'status' => 0,
					'note' => 'Unprocess Jobs',
					'sort' => $id_log_jobs
				);
				$this->db->insert('log_activity', $log_jobs);

				$check_service = $this->master_model->mst_check('ms_service', 'name', $jobs[$a]);
				if($check_service == false)
				{
					$id_jobs = $this->master_model->mst_last_id('ms_service');
					$data_ms_service= array
					(
						'ID' => $id_jobs,
						'mechanic' => $technician[$a],
						'name' => $jobs[$a],
						'durations' => $durations[$a],
						'price' => $price[$a],
						'sort' => $id_jobs,
						'publish' => 1
					);
					$this->db->insert('ms_service', $data_ms_service);
				}

				$count_spareparts=0;
				for($b=0; $b < count($spareparts); $b++)
				{
					if($spareparts[$b] <> '')
					{
						$c = $b+1;

						$count_spareparts = $c+1;

						$id_spareparts=$this->master_model->mst_last_id('ts_service_spareparts');
						$data_array_spareparts=array
						(
							'ID'=>$id_spareparts,
							'id_service_detail'=>$id_detail,
							'sparepart'=>$spareparts[$b],
							'qty'=>$qty_parts[$b],
							'price'=>$price_parts[$b],
							'indent'=>$indent[$b],
							'order_date'=>date('Y-m-d'),
							'subtotal'=>str_replace('.','',$subtotal[$b]),
							'sort'=>$id_spareparts,
						);
						$this->db->insert('ts_service_spareparts', $data_array_spareparts);

						//$indent_day=$indent[$b]+$indents_day;

						$type = $this->session->userdata('type');
						$get_id_subcategory = $this->master_model->select_in('ms_product_subcategory', 'ID, id_product, id_product_category', "WHERE name = '$type'");

						$check_spareparts = $this->master_model->mst_check('ms_product_spareparts', 'name', $spareparts[$b]);
						if($check_spareparts == false)
						{
							$id_ms_spareparts = $this->master_model->mst_last_id('ms_product_spareparts');
							$data_ms_spareparts= array
							(
								'ID' => $id_ms_spareparts,
								'id_product_subcategory' => $get_id_subcategory[0]->ID,
								'name' => $spareparts[$b],
								'request' => $qty_parts[$b],
								'price' => $price_parts[$b],
								'barcode' => $get_id_subcategory[0]->id_product.'-'.$get_id_subcategory[0]->id_product_category.'-'.$get_id_subcategory[0]->ID.'-'.$id_ms_spareparts,
								'note'   => 'New Product Request!',
								'sort' => $id_ms_spareparts,
								'publish' => 1,
								'status' => 1,
							);
							$this->db->insert('ms_product_spareparts', $data_ms_spareparts);
						}else {
							$get_id_ms_spareparts = $this->master_model->select_in('ms_product_spareparts', 'ID, stock, request', "WHERE name = '$spareparts[$b]'");
							$id_ms_spareparts = $get_id_ms_spareparts[0]->ID;
							$request = $get_id_ms_spareparts[0]->request;

							$data_ms_spareparts= array
							(
								'request' => $request+$qty_parts[$b],
							);
							$this->db->where('ID', $id_ms_spareparts);
							$this->db->update('ms_product_spareparts', $data_ms_spareparts);
						}

						$id_log_spareparts = $this->master_model->mst_last_id('log_activity');
						$log_product = array
						(
							'ID' => $id_log_spareparts,
							'activity' => 'Spareparts',
							'id_detail' => $id_spareparts,
							'id_spareparts' => $id_ms_spareparts,
							'qty' => $qty_parts[$b],
							'id_admin' => $id_admin,
							'date_in' => date('Y-m-d H:i:s'),
							'note' => 'Request New Spareparts',
							'sort' => $id_log_spareparts
					  );
						$this->db->insert('log_activity', $log_product);

						$arr['url_spareparts'] = $get_id_subcategory[0]->id_product.'/'.$get_id_subcategory[0]->id_product_category.'/'.$get_id_subcategory[0]->ID.'/'.$id_ms_spareparts;
						$arr['name_spareparts'] = $spareparts[$b];
						$arr['date_in_spareparts'] = date('Y-m-d H:i:s');
						$arr['admin_name_spareparts'] = $data_admin[0]->name;
						$arr['note_spareparts'] = 'Request New Spareparts';
					}
				}

				if($submit==1)
				{
					$id_log=$this->master_model->mst_last_id('log_activity');
					$id_admin=$this->session->userdata('user_id');
					$data_log=array
					(
						'ID'=>$id_log,
						'activity' => 'Service',
						'id_detail'=>$ID,
						'id_admin'=>$id_admin,
						'date_in'=>date('Y-m-d H:i:s'),
						'status'=>0,
						'note'=>'Create New Service',
						'sort'=>$id_log,
					);
					$this->db->insert('log_activity', $data_log);
				}

				$durations_day=$durations[$a]+$durations_day;
			}
		}

		if($submit==1)
		{
			$control='index';

		}elseif($submit==2)
		{
			$control='edit';
		}

		$this->session->unset_userdata('product');
		$this->session->unset_userdata('model');
		$this->session->unset_userdata('type');
		$this->session->unset_userdata('unit');
		$this->session->unset_userdata('damage');
		$this->session->unset_userdata('note');
		$this->session->unset_userdata('name');
		$this->session->unset_userdata('phone');
		$this->session->unset_userdata('email');
		$this->session->unset_userdata('address');


		//New Notification End

		$arr['id_detail'] = $ID;
		$arr['activity'] = 'Service';
		$arr['date_in'] = date('d M Y H:i', strtotime(date('Y-m-d H:i:s')));
		$arr['admin_name'] = $data_admin[0]->name;
		$arr['note'] = 'Create New Service';

		$arr['status'] = true;
		$arr['count_message_service'] = $count_message_service+1;
		$arr['count_message_spareparts'] = $count_message_spareparts+$count_spareparts;
		echo json_encode($arr);

		//redirect('transaction/'.$control.'/'.$menuid.''.$id_service);
	}

	public function update_service($menuid, $id_customer, $id_service)
	{
		if($this->input->post('submit')==1)
		{
			$control='jobs';
		}else
		{
			$control='edit';
		}
		$data=array
		(
			'tax'=>$this->input->post('tax'),
			'discount'=>$this->input->post('discount'),
			'deliver_date'=>$this->input->post('deliver_date'),
			'kurir'=>$this->input->post('courir'),
			'grandtotal'=>$this->input->post('grandtotal'),
		);
		$this->db->where('ID', $id_service);
		$this->db->update('ts_service', $data);

		redirect('transaction/'.$control.'/'.$menuid.'/'.$id_customer.'/'.$id_service);
	}

	public function save_spareparts($menuid, $id_customer, $id_header='')
	{
		$submit=$this->input->post('submit');

		$spareparts=$this->input->post('spareparts');
		$qty=$this->input->post('qty');
		$price=$this->input->post('price');
		$indent=$this->input->post('indent');
		$subtotal=$this->input->post('subtotal');
		$total_parts=$this->input->post('grandtotal');

		if($submit==1)
		{
			$control='jobs';

			$ID=$this->master_model->mst_last_id('ts_service');

			$update=array
			(
				'total_parts'=>$total_parts,
			);
			$this->db->where('ID', $ID);
			$this->db->update('ts_service', $update);

			if($id_header=='')
			{
				$id_service='';
			}else
			{
				$id_service='/'.$id_header;

				$this->db->where('id_header', $id_header);
				$this->db->delete('ts_service_spareparts');
			}
		}elseif($submit==2)
		{
			$control='edit';
			$id_service='/'.$id_header;
			$id_header=$id_header;

			$this->db->where('id_header', $id_header);
			$this->db->delete('ts_service_spareparts');

			$update=array
			(
				'total_parts'=>$total_parts,
			);
			$this->db->where('ID', $id_header);
			$this->db->update('ts_service', $update);

		}

		$indent_day=0;
		for($a=0; $a < count($spareparts); $a++)
		{
			if($spareparts[$a]=='')
			{
			}else
			{
				$ID=$this->master_model->mst_last_id('ts_service_spareparts');
				$data_detail=array
				(
					'ID'=>$ID,
					'id_header'=>$id_header,
					'sparepart'=>$spareparts[$a],
					'qty'=>$qty[$a],
					'price'=>$price[$a],
					'indent'=>$indent[$a],
					'subtotal'=>str_replace('.','',$subtotal[$a]),
					'sort'=>$ID,
				);
				$this->db->insert('ts_service_spareparts', $data_detail);
				$indent_day=$indent[$a]+$indent_day;
			}
		}

		$data_update_service=array
		(
			'indent_day'=>$indent_day,
		);
		$this->db->where('ID', $id_header);
		$this->db->update('ts_service', $data_update_service);

		if($submit==1)
		{
		}elseif($submit==2)
		{
			$data_finish=$this->master_model->select_in('ts_service','finish_date',"WHERE ID=$id_header");
			$finish_date=date($data_finish[0]->finish_date);
			$finish_date = strtotime ('+'.$indent_day.' day', strtotime($finish_date));

			$finish_date=date('Y-m-d H:i:s', $finish_date);

			$update_hour=array
			(
				'finish_date'=>$finish_date,
			);
			$this->db->where('ID', $id_header);
			$this->db->update('ts_service', $update_hour);
		}

		redirect('transaction/'.$control.'/'.$menuid.'/'.$id_customer.''.$id_service);
	}

	public function delete($menuid)
	{
		$ID = $this->input->post('ID');

		$data_detail=$this->master_model->select_in('ts_service_detail','ID',"WHERE id_service=$ID");
		for($a=0; $a < count($data_detail); $a++)
		{
			$id_detail=$data_detail[$a]->ID;

			$data_spareparts=$this->master_model->select_in('ts_service_spareparts','ID, sparepart, qty',"WHERE id_service_detail=$id_detail");
			$id_spareparts=$data_spareparts[0]->ID;
			$name_spareparts=$data_spareparts[0]->sparepart;
			$qty_spareparts=$data_spareparts[0]->qty;

			$data_ms_spareparts = $this->master_model->select_in('ms_product_spareparts','ID, request',"WHERE name = '$name_spareparts'");
			$request_ms_spareparts = $data_ms_spareparts[0]->request;

			$update_ms_spareparts=array
			(
				'request' => $request_ms_spareparts-$qty_spareparts,
			);
			$this->db->where('name', $name_spareparts);
			$this->db->update('ms_product_spareparts', $update_ms_spareparts);

			$this->db->where('id_detail', $id_spareparts);
			$this->db->delete('log_activity');

			$this->db->where('id_service_detail', $id_detail);
			$this->db->delete('ts_service_spareparts');

			$this->db->where('id_detail', $id_detail);
			$this->db->delete('log_activity');
		}

		$this->db->where('id_service', $ID);
		$this->db->delete('ts_service_detail');

		$this->db->where('id_detail', $ID);
		$this->db->delete('log_activity');

		$this->db->where('ID', $ID);
		$this->db->delete('ts_service');

		return true;
	}


	public function delete_rent($menuid, $ID)
	{
		$this->db->where('ID', $ID);
		$this->db->delete('ts_rent');

		$this->db->where('id_rent', $ID);
		$this->db->delete('ts_service');

		$this->db->where('id_header', $ID);
		$this->db->delete('ts_service_detail');

		$this->db->where('id_header', $ID);
		$this->db->delete('ts_service_spareparts');

		$data_detail=$this->master_model->select_in('ts_service_detail','ID',"WHERE id_header=$ID");
		for($a=0; $a < count($data_detail); $a++)
		{
			$id_detail=$data_detail[$a]->ID;
			$this->db->where('id_jobs', $id_detail);
			$this->db->delete('log_service');
		}

		redirect('transaction/index/'.$menuid);
	}

	public function edit($menuid, $id_customer, $ID)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$this->load->view('service/edit');
    	}
	}


	public function get_customer($menuid)
	{
		$name=$this->input->get('name');
		$data_customer=$this->master_model->select_in('ms_customer','*',"WHERE name LIKE '%$name%' OR phone LIKE '%$name%'");
		$count=count($data_customer);

		echo'
			<br/>
			<table id="example1" class="table table-bordered table-striped">
				<thead>
					<tr>
						<th>No.</th>
						<th>Name</th>
						<th>Phone Number</th>
						<th>Email</th>
						<th>Company</th>
						<th>Address</th>
						<th>Last Activity</th>
						<th>Status</th>
						<th>Create Service</th>
					</tr>
				</thead>

				<tbody>
					';

						  for($a=0; $a < count($data_customer); $a++)
						  {
							  $id_customer = $data_customer[$a]->ID;
							  $status = $data_customer[$a]->status;
							  if($status==0)
							  {
								  $flag = '<span class="text-red">Unverified</span>';
							  }else{
								  $flag = '<span class="text-blue">Verified</span>';
							  }
							  $alamat = $data_customer[$a]->address;
							  $b=$a+1;

							  echo'
								<tr>
									<td style="text-align:center">
										'.$b.'
									</td>
									<td>
										<a href="'.base_url().'master/customer_detail/'.$menuid.'/'.$id_customer.'">
											'.$data_customer[$a]->name.'
										</a>
									</td>
									<td>'.$data_customer[$a]->phone.'</td>
									<td>'.$data_customer[$a]->email.'</td>
									<td>'.$data_customer[$a]->company.'</td>
									<td>'.$alamat.'</td>
									<td style="text-align:right">
										'.date('d M Y', strtotime($data_customer[$a]->last_activity)).'
									</td>
									<td align="center">
										'.$flag.'
									</td>
									<td style="text-align:center">
										<a href="'.base_url().'transaction/start/'.$menuid.'/'.$id_customer.'" class="text-blue">
											<i class="fa fa-wrench"></i>
										</a>
									</td>
								</tr>
							  ';
						  }
					echo'
				</tbody>
			</table>

			<script>
			  $(function ()
			  {
				    $("#example1").DataTable(
					{
						"paging": true,
						"lengthMenu": [ 10, 20, 30, 40, 50 ],
						"pageLength": 10,
						"searching": true,
						//"ajax": "data/arrays.txt",
						"deferRender": true,
					});
			  });
			</script>
		';
	}


	public function get_customer_2($menuid)
	{
		$name=$this->input->get('name');
		$data_customer=$this->master_model->select_in('ms_customer','ID, name, phone, email, status, address',"WHERE name LIKE '%$name%'");

		for($a=0; $a < count($data_customer); $a++)
		{
			echo $data_customer[$a]->name;
		}
	}


	public function job($menuid, $ID = '')
	{
		$status = $this->input->get('status');
		$user_id = $this->session->userdata('user_id');
    $check=$this->master_model->auth_read($user_id, $menuid);

    if($check==false)
    {
        redirect('NotAuthorized');
    }else
    {
				if($status == '')
				{
					$data['data_jobs']=$this->master_model->mst_data('ts_service_detail');
				}else {
					$data['data_jobs']=$this->master_model->select_in('ts_service_detail', '*', "WHERE status = $status");
				}


		  	$this->load->view('jobs/main', $data);
  	}
	}

	public function status_jobs($menuid)
	{
		$ID=$this->input->post('ID');

		$data_edit=$this->master_model->select_in('ts_service_detail','status, jobs',"WHERE ID=$ID");
		$data_status=array
		(
			'0'=>'<span class="label label-primary">Unprocess</span>',
			'1'=>'<span class="label label-info">Process</span>',
			'2'=>'<span class="label label-warning">Pending</span>',
			'3'=>'<span class="label label-success">Done</span>',
			'4'=>'<span class="label label-danger">Failed</span>',
		);

		$alt=array
		(
			'0'=>'',
			'1'=>'Update Status Jobs to Process',
			'2'=>'Update Status Jobs to Pending',
			'3'=>'Update Status Jobs to Done',
			'4'=>'Update Status Jobs to Failed',
		);
		echo'
			<div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Status Jobs ['.$data_edit[0]->jobs.']</h4>
      </div>
			<!--<form action="'.base_url().'transaction/edit_status_jobs/'.$menuid.'/'.$ID.'" method="post">-->
				<div class="modal-body">
					';
						for($a=0; $a < count($data_status); $a++)
						{
							if($data_edit[0]->status==$a)
							{
								$check='checked="checked"';
							}else
							{
								$check='';
							}

							if($data_edit[0]->status>$a)
							{
								$display='style="display:none; cursor:pointer"';
							}else
							{
								$display='';
							}
							echo'
								<script>
									$(".status_jobs'.$a.'").click(function(){
										var alt = $(this).attr("alt");
										var status = $(this).attr("title");

										$(".status").val(status);
										$(".note").val(alt);
									});
								</script>
								<div class="form-group" '.$display.'>
									<input alt="'.$alt[$a].'" title="'.$a.'" class="status_jobs'.$a.'" type="radio" name="status" value="'.$a.'" '.$check.' id="'.$a.'">
									<label for="'.$a.'" style="cursor:pointer">'.$data_status[$a].'</label>

									<input type="hidden" class="status" value="'.$data_edit[0]->status.'">
								</div>
							';
						}
					echo'
					<div class="form-group">
						<label>
							Note
						</label>
						<textarea name="note" class="form-control note"></textarea>
					</div>
				</div>
				<div class="modal-footer">
					<script src="'.base_url().'node_modules/socket.io/node_modules/socket.io-client/socket.io.js"></script>
					<script>
						$(document).ready(function(){
							$("#update_status_jobs").click(function()
							{
								document.querySelector(".loader-default").className += " is-active";

								var dataString =
								{
									status : $(".status").val(),
									note 	 : $(".note").val(),
								};

								$.ajax({
									type: "POST",
									url: "'.base_url().'transaction/update_status_jobs/'.$menuid.'/'.$ID.'",
									data: dataString,
									dataType: "json",
									cache : false,
									success: function(data)
									{
										//alert(data.status);
										//return false;
										document.querySelector(".loader-default").className -= " is-active";

										if(data.status == true)
										{
											var socket = io.connect("http://"+window.location.hostname+":3000");

											socket.emit("count_message_service", {
												count_message_service: data.count_message_service
											});

											socket.emit("new_notification_service",
											{
												id_detail: data.id_detail,
												activity: data.activity,
												date_in: data.date_in,
												admin_name: data.admin_name,
												note: data.note,
											});

											setTimeout(function() {
												window.location.href = "'.base_url().'transaction/job/'.$menuid.'";
											}, 1000);

										} else if(data.status == false)
										{
											alerty.toasts("Status is same!", {place: "top"})
										}
									} ,error: function(xhr, status, error) {
										alert(error);
									},
								});
						});
						});
					</script>
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="update_status_jobs">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			<!--</form>-->
		';
	}

	public function update_status_jobs($menuid, $ID)
	{
		$status=$this->input->post('status');
		$id_admin=$this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $id_admin");

		$check_status_jobs = $this->master_model->select_in('ts_service_detail', 'ID', "WHERE ID = $ID AND status = $status");
		$count_check = count($check_status_jobs);

		if($count_check == 0)
		{
			$data_update=array
			(
				'status'=>$status,
			);
			$this->db->where('ID', $ID);
			$this->db->update('ts_service_detail', $data_update);

			$id_log=$this->master_model->mst_last_id('log_activity');

			$data_log=array
			(
				'ID'=>$id_log,
				'activity' => 'Jobs',
				'id_detail'=>$ID,
				'id_admin'=>$id_admin,
				'date_in'=>date('Y-m-d H:i:s'),
				'status'=> $this->input->post('status'),
				'note'=> $this->input->post('note'),
				'sort'=>$id_log,
			);
			$this->db->insert('log_activity', $data_log);

			if($status==1)
			{
				$get_id_header=$this->master_model->select_in('ts_service_detail','id_service',"WHERE ID=$ID");
				$id_service=$get_id_header[0]->id_service;
				$update_service=array
				(
					'status'=>1,
				);
				$this->db->where('ID', $id_service);
				$this->db->update('ts_service', $update_service);

				$id_log_service=$this->master_model->mst_last_id('log_activity');
				$data_log_service=array
				(
					'ID'=>$id_log_service,
					'activity' => 'Service',
					'id_detail'=>$id_service,
					'id_admin'=>$id_admin,
					'date_in'=>date('Y-m-d H:i:s'),
					'status'=> $this->input->post('status'),
					'note'=> 'Update Status Service to Process',
					'sort'=>$id_log_service,
				);
				$this->db->insert('log_activity', $data_log_service);
			}
			$arr['status'] = true;
		}else {
			$arr['status'] = false;
		}

		$arr['id_detail'] = $ID;
		$arr['activity'] = 'Service';
		$arr['date_in'] = date('Y-m-d H:i:s');
		$arr['admin_name'] = $data_admin[0]->name;
		$arr['note'] = $this->input->post('note');

		$count_message_service = $this->master_model->mst_count('log_activity', "activity = 'Service' AND status_read=0");
		$arr['count_message_service'] = $count_message_service+1;
		//redirect('transaction/job/'.$menuid);

		echo json_encode($arr);
	}

	public function history_jobs($menuid)
	{
		$ID=$this->input->post('ID');
		$history=$this->master_model->select_in('log_activity','*',"WHERE id_detail=$ID AND activity = 'Jobs' ORDER BY ID DESC");

		echo'
			<div class="modal-header">
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              <h4 class="modal-title">History Jobs</h4>
            </div>
			<div class="modal-body">
				<table id="example1" class="table table-bordered table-striped">
					<thead>
						<tr>
							<th>
								No
							</th>
							<th>
								Status
							</th>
							<th>
								Date
							</th>
							<th>
								Admin
							</th>
							<th>
								Note
							</th>
						</tr>
					</thead>
					<tbody>
						';
							for($a=0; $a < count($history); $a++)
							{
								$status = $history[$a]->status;
								$id_admin=$history[$a]->id_admin;

								$data_admin=$this->master_model->select_in('user','name',"WHERE ID=$id_admin");
								if($status==0)
							  {
								 $status='<span class="label label-primary">Unprocess</span>';
							  }elseif($status==1)
							  {
								 $status='<span class="label label-info">Process</span>';
							  }elseif($status==2)
							  {
								 $status='<span class="label label-warning">Pending</span>';
							  }elseif($status==3)
							  {
								 $status='<span class="label label-success">Done</span>';
							  }elseif($status==4)
							  {
								 $status='<span class="label label-danger">Failed</span>';
							  }

								$b=$a+1;
								echo'
									<tr>
										<td>
											'.$b.'
										</td>
										<td>
											'.$status.'
										</td>
										<td>
											'.$history[$a]->date_in.'
										</td>
										<td>
											'.$data_admin[0]->name.'
										</td>
										<td>
											'.$history[$a]->note.'
										</td>
									</tr>
								';
							}
						echo'
					</tbody>
				</table>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
			</div>
		';
	}


	public function history_spareparts($menuid)
	{
		$ID=$this->input->post('ID');
		$history=$this->master_model->select_in('log_activity','*',"WHERE id_detail=$ID AND activity = 'Spareparts' ORDER BY ID DESC");

		echo'
			<div class="modal-header">
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              <h4 class="modal-title">History Sparepart</h4>
            </div>
			<div class="modal-body">
				<table id="example1" class="table table-bordered table-striped">
					<thead>
						<tr>
							<th>
								No
							</th>
							<th>
								Status
							</th>
							<th>
								Date
							</th>
							<th>
								Action By
							</th>
							<th>
								Note
							</th>
						</tr>
					</thead>
					<tbody>
						';
							for($a=0; $a < count($history); $a++)
							{
								$status = $history[$a]->status;
								$id_admin=$history[$a]->id_admin;

								$data_admin=$this->master_model->select_in('user','name',"WHERE ID=$id_admin");
								if($status==0)
							  {
								 $status='<span class="label label-primary">Request</span>';
							  }elseif($status==1)
							  {
								 $status='<span class="label label-info">Ordered</span>';
							  }elseif($status==2)
							  {
								 $status='<span class="label label-warning">Indent</span>';
							  }elseif($status==3)
							  {
								 $status='<span class="label label-success">Ready</span>';
							  }elseif($status==4)
							  {
								 $status='<span class="label label-danger">Canceled</span>';
							  }

								$b=$a+1;
								echo'
									<tr>
										<td>
											'.$b.'
										</td>
										<td>
											'.$status.'
										</td>
										<td>
											'.date('d M Y H:i', strtotime($history[$a]->date_in)).'
										</td>
										<td>
											'.$data_admin[0]->name.'
										</td>
										<td>
											'.$history[$a]->note.'
										</td>
									</tr>
								';
							}
						echo'
					</tbody>
				</table>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
			</div>
		';
	}

	public function spareparts($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_spareparts']=$this->master_model->mst_data_spareparts();

			$this->load->view('spareparts/main', $data);
    	}
	}

	public function invoice($menuid)
	{
		$this->load->view('service/invoice');
	}

	public function invoice_print($menuid, $ID)
	{
		$this->load->view('service/invoice_print');
	}

	public function invoice_rent_print($menuid, $ID)
	{
		$this->load->view('service/invoice_rent_print');
	}

	public function update_technician($menuid, $ID)
	{
		$name=$this->input->post('name');

		$update=array
		(
			'technician'=>$this->input->post('name'),
		);
		$this->db->where('ID', $ID);
		$this->db->update('ts_service_detail', $update);
	}



	public function status_spareparts($menuid, $id_service)
	{
		$ID=$this->input->post('ID');

		$data_edit=$this->master_model->select_in('ts_service_spareparts','status, supplier, sparepart, order_date, cost, indent, order_in_date, note, qty',"WHERE ID=$ID");
		$id_supplier = $data_edit[0]->supplier;
		$order_date = $data_edit[0]->order_date;
		$indent = $data_edit[0]->indent;
		$order_in_date=$data_edit[0]->order_in_date;
		$sparepart=$data_edit[0]->sparepart;
		$status=$data_edit[0]->status;
		$cost=$data_edit[0]->cost;
		$note_spareparts=$data_edit[0]->note;
		$qty=$data_edit[0]->qty;

		$get_id_ms_spareparts = $this->master_model->select_in('ms_product_spareparts', 'ID', "WHERE name = '$sparepart'");
		$id_spareparts=$get_id_ms_spareparts[0]->ID;


		$data_service=$this->master_model->select_in('ts_service','*',"WHERE ID=$id_service");
		$nomor_invoice=$data_service[0]->invoice;


		$product = explode(', ', $data_service[0]->product);
		$category=$product[0];
		$brand=$product[1];
		$model=$product[2];
		$imei=$product[3];

		$damage=$data_service[0]->damage;
		$note=$data_service[0]->note;
		$total_service=$data_service[0]->total_service;
		$total_parts=$data_service[0]->total_parts;
		$grandtotal=$data_service[0]->grandtotal;
		$durations_day=$data_service[0]->durations_day;
		$start_date=$data_service[0]->start_date;
		$finish_date=$data_service[0]->finish_date;
		$deliver_date=$data_service[0]->deliver_date;
		$discount=$data_service[0]->discount;
		$tax=$data_service[0]->tax;
		$id_customer=$data_service[0]->id_customer;

		$data_service_detail=$this->master_model->select_in('ts_service_detail','*',"WHERE id_service=$id_service ORDER BY ID ASC");
		$count_edit=count($data_service_detail);

		$data_customer=$this->master_model->select_in('ms_customer','name, email, phone, address',"WHERE ID=$id_customer");
		$name_customer=$data_customer[0]->name;
		$phone_customer=$data_customer[0]->phone;
		$email_customer=$data_customer[0]->email;
		$address_customer=$data_customer[0]->address;


		if($order_date=='0000-00-00')
		{
			$order_date=date('Y-m-d');
		}else
		{
			$order_date=$order_date;
		}

		if($order_in_date=='0000-00-00')
		{
			$order_in_date=date('Y-m-d');
		}else
		{
			$order_in_date=$order_in_date;
		}

		echo'
			<div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Status Spareparts ['.$sparepart.']</h4>
      </div>
			<!--<form action="'.base_url().'transaction/edit_status_spareparts/'.$menuid.'/'.$ID.'" method="post">-->
			<div class="modal-body">

			<script type="text/javascript">

				$(".check").click(function() {
			    var cek = $(this).val();
			    //alert(cek);

			    if(cek==0)
			    {
			      $(".box-status1").show();
			      $(".box-status2").hide();
			      $(".box-status3").hide();
			      $(".box-status4").hide();
						$(".box-status5").hide();
			    }else if(cek==1)
			    {
			      $(".box-status1").hide();
			      $(".box-status2").show();
			      $(".box-status3").hide();
			      $(".box-status4").hide();
						$(".box-status5").hide();
			    }else if(cek==2)
			    {
			      $(".box-status1").hide();
			      $(".box-status2").hide();
			      $(".box-status3").show();
			      $(".box-status4").hide();
						$(".box-status5").hide();
			    }else if(cek==3)
			    {
			      $(".box-status1").hide();
			      $(".box-status2").hide();
			      $(".box-status3").hide();
			      $(".box-status4").show();
						$(".box-status5").hide();
			    }else if(cek==4)
			    {
			      $(".box-status1").hide();
			      $(".box-status2").hide();
			      $(".box-status3").hide();
			      $(".box-status4").hide();
						$(".box-status5").show();
			    }

			    });
			</script>

			';
				$data_status=array
				(
					'0'=>'<span class="label label-primary">Request</span>',
					'1'=>'<span class="label label-info">Ordered</span>',
					'2'=>'<span class="label label-warning">Indent</span>',
					'3'=>'<span class="label label-success">Ready</span>',
					'4'=>'<span class="label label-danger">Canceled</span>',
				);

				$alt=array
				(
					'0'=>'Request',
					'1'=>'Update Status to Ordered',
					'2'=>'Update Status to Indent',
					'3'=>'Update Status to Ready',
					'4'=>'Update Status to Canceled',
				);

				$isi=array
				(
					'0'=>'',
					'1'=>'
							<div class="col-md-3">
								<div class="row">
									<script type="text/javascript">
											$(document).ready(function()
											{
													$(".supplier1").bind("input", function(e)
													{
															var name = $(this).val();

															$.ajax({
																	 type: "GET",
																	 dataType: "html",
																	 url: "'.base_url().'transaction/supplier_to_list/'.$menuid.'",
																	 data:"name="+name,
																	 success: function(msg)
																	 {
																			$("#supplier1_to_list").html(msg);
																	 }
															});
													});
												});
											</script>
								<label>Supplier</label>
								<input type="text" name="supplier1" class="supplier1 form-control" list="supplier1_to_list" placeholder="Supplier Name" value="'.$id_supplier.'">
								<datalist id="supplier1_to_list"></datalist>
								</div>
							</div>

							<div class="col-md-3">
								<label>Order Date</label>
								<input type="text" name="date1" class="date1 form-control" id="datepicker" placeholder="Order Date" value="'.date('m/d/Y', strtotime($order_date)).'">
									<script>
									$("#datepicker").datepicker({
										autoclose: true
									});

									$("#datepicker2").datepicker({
										autoclose: true
									});
								</script>
							</div>

							<div class="col-md-3">
								<label>Indent</label>
								<input type="text" name="indent1" class="indent1 form-control" placeholder="Indent" value="'.$indent.'">
							</div>

							<div class="col-md-3">
								<div class="row">
								<label>Cost</label>
								<input type="text" name="cost1" class="cost1 form-control" placeholder="Cost" value="'.$cost.'">
								</div>
							</div>
						',
					'2'=>'<div class="col-md-12">
						<div class="row">
							<label>Indent Day</label>
							<input type="text" name="indent2" class="indent2 form-control" placeholder="Day" value="'.$indent.'">
						</div>
					</div>',
					'3'=>'
							<div class="col-md-4">
								<div class="row">
								<script type="text/javascript">
										$(document).ready(function()
										{
												$(".supplier2").bind("input", function(e)
												{
														var name = $(this).val();

														$.ajax({
																 type: "GET",
																 dataType: "html",
																 url: "'.base_url().'transaction/supplier_to_list/'.$menuid.'",
																 data:"name="+name,
																 success: function(msg)
																 {
																		$("#supplier2_to_list").html(msg);
																 }
														});
												});
											});
										</script>
									<label>Supplier</label>
									<input type="text" name="supplier2" class="supplier2 form-control" list="supplier2_to_list" placeholder="Supplier Name" value="'.$id_supplier.'">
									<datalist id="supplier2_to_list"></datalist>
								</div>
							</div>

							<div class="col-md-4">
								<label>Order In Date</label>
								<input type="text" name="date2" class="form-control" placeholder="Order Date" value="'.date('m/d/Y', strtotime($order_in_date)).'" id="datepicker2">
							</div>

							<div class="col-md-4">
								<div class="row">
									<label>Cost</label>
									<input type="text" name="cost2" class="cost2 form-control" placeholder="Cost" value="'.$cost.'">
								</div>
							</div>
							<div style="clear: both"></div>
							',

					'4'=>'',
				);

				echo'
				</ul>
					';
						for($a=0; $a < count($data_status); $a++)
						{
							if($data_edit[0]->status==$a)
							{
								$check='checked="checked"';
								$show = '';
							}else
							{
								$check='';
								$show = 'style="display:none"';
							}

							if($data_edit[0]->status>$a)
							{
								$display='style="display:none; cursor:pointer"';
							}else
							{
								$display='';
							}

							if($a == 0)
							{
								$collapse = 'collapseOne';
							}elseif($a==1)
							{
								$collapse = 'collapseOne';
							}elseif($a==2)
							{
								$collapse = 'collapseThree';
							}elseif($a==3)
							{
								$collapse = 'collapseFour';
							}elseif($a==4)
							{
								$collapse = 'collapseFive';
							}

							 echo'
							 <script>
							 	$(".status_spareparts").click(function(){
									var values = $(this).attr("alt");
									var val    = $(this).val();

									$(".status_value").val(val);
									$(".note").val(values)
								});
							 </script>
							 			<div '.$display.'>
	                       <label style="cursor: pointer">
	                          <input alt="'.$alt[$a].'" type="radio" name="status" class="check status_spareparts status" '.$check.' value="'.$a.'" >

	                          &nbsp;
	                          <span class="'.$a.'">'.$data_status[$a].'</span>
	                       </label>
	                       <div class="box-status'.($a+1).'" '.$show.'>
					          	 			'.$isi[$a].'
			               		 </div>

			               </div>
	                    ';

		                }
					echo'
					</ul>
					<input type="hidden" name="id_spareparts" value="'.$id_spareparts.'">
					<input type="hidden" name="qty" value="'.$qty.'">

					<input type="hidden" class="status_value" value="'.$status.'">
					<textarea name="note" class="form-control note" placeholder="Note">'.$note_spareparts.'</textarea>
				</div>
				<div class="modal-footer">
					<script src="'.base_url().'node_modules/socket.io/node_modules/socket.io-client/socket.io.js"></script>
					<script>
						$(document).ready(function(){
							$("#update_status_spareparts").click(function()
							{
								//alert("'.$ID.'");
								//return false;

								document.querySelector(".loader-default").className += " is-active";

								var dataString =
								{
									supplier1 : $(".supplier1").val(),
									supplier2 : $(".supplier2").val(),
									indent1   : $(".indent1").val(),
									indent2   : $(".indent2").val(),
									date1     : $(".date1").val(),
									date2     : $(".date2").val(),
									cost1     : $(".cost1").val(),
									cost2     : $(".cost2").val(),
									status    : $(".status_value").val(),
									note 	    : $(".note").val(),
								};

								$.ajax({
									type: "POST",
									url: "'.base_url().'transaction/edit_status_spareparts/'.$menuid.'/'.$ID.'",
									data: dataString,
									dataType: "json",
									cache : false,
									success: function(data)
									{
										//alert(data);
										//return false;
										document.querySelector(".loader-default").className -= " is-active";

										if(data.status == true)
										{
											var socket = io.connect("http://"+window.location.hostname+":3000");

											socket.emit("count_message_spareparts", {
					              count_message_spareparts: data.count_message_spareparts
					            });

											socket.emit("new_notification_spareparts",
					            {
												url_spareparts: data.url_spareparts,
										    name_spareparts: data.name_spareparts,
										    date_in_spareparts: data.date_in_spareparts,
										    admin_name_spareparts: data.admin_name_spareparts,
										    note_spareparts: data.note_spareparts,
					            });

											setTimeout(function() {
												window.location.href = "'.base_url().'transaction/spareparts/'.$menuid.'";
											}, 1000);

										} else if(data.status == false)
										{
											alerty.toasts("Status is same!", {place: "top"})
										}
									} ,error: function(xhr, status, error) {
										alert(error);
									},
								});
						});
						});
					</script>
					<input type="submit" class="btn btn-primary btn-fill pull-right" value="Update" id="update_status_spareparts">

					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
		<!--</form>-->

		';
	}

	public function edit_status_spareparts($menuid, $ID)
	{
		//print_array($this->input->post());
		//exit;
		$date=$this->input->post('date1');
		$in_date=$this->input->post('date2');
		$note=$this->input->post('note');
		$status=$this->input->post('status');

		$id_admin = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user','name',"WHERE ID = $id_admin");

		$get_detail_spareparts  = $this->master_model->select_in('ts_service_spareparts', 'indent, sparepart, qty', "WHERE ID = $ID");
		$sparepart_name         = $get_detail_spareparts[0]->sparepart;
		$qty                    = $get_detail_spareparts[0]->qty;
		$get_id_ms_spareparts   = $this->master_model->select_in('ms_product_spareparts', 'ID, id_product_subcategory, request, status, stock', "WHERE name = '$sparepart_name'");
		$id_ms_spareparts       = $get_id_ms_spareparts[0]->ID;
		$id_product_subcategory = $get_id_ms_spareparts[0]->id_product_subcategory;
		$request_ms_spareparts  = $get_id_ms_spareparts[0]->request;
		$status_ms_spareparts   = $get_id_ms_spareparts[0]->status;
		$stock_ms_spareparts    = $get_id_ms_spareparts[0]->stock;

		//echo $sparepart_name;
		//exit;

		$get_id_category = $this->master_model->select_in('ms_product_subcategory', 'id_product, id_product_category', "WHERE ID = $id_product_subcategory");

		if ($status==1)
		{
			$supplier  = $this->input->post('supplier1');
			$cost      = $this->input->post('cost1');
			$indent    = $this->input->post('indent1');
			$qty_in    = 0;
			$qty_out   = 0;

			$data_update=array
			(
			 	'status'       => $status,
			 	'supplier'     => $supplier,
				'indent'       => $indent,
			 	'order_date'   => date('Y-m-d', strtotime($date)),
			 	'cost'         => $cost,
			 	'note'         => $note
			);
			$this->db->where('ID', $ID);
			$this->db->update('ts_service_spareparts', $data_update);

			$check_supplier = $this->master_model->mst_check('ms_supplier', 'name', $supplier);
			if($check_supplier ==  false)
			{
				$id_supplier = $this->master_model->mst_last_id('ms_supplier');
				$data_supplier=array
				(
					'ID'            => $id_supplier,
					'name'          => $supplier,
					'status'        => 0,
					'last_activity' => date('Y-m-d'),
					'sort'          => $id_supplier
				);
				$this->db->insert('ms_supplier', $data_supplier);
			}
		}elseif ($status==2)
		{
			$qty_in   = 0;
			$qty_out  = 0;

			$data_update=array
			(
			 	'status'       => $status,
			 	'indent'       => $this->input->post('indent2'),
			 	'note'         => $note
			);
			$this->db->where('ID', $ID);
			$this->db->update('ts_service_spareparts', $data_update);
		}elseif ($status==3)
		{
			$update_spareparts= array
			(
				'request' => $request_ms_spareparts-$qty,
				'stock'   => $stock_ms_spareparts-$qty,
			);
			$this->db->where('ID', $id_ms_spareparts);
			$this->db->update('ms_product_spareparts', $update_spareparts);

			$supplier = $this->input->post('supplier2');
			$qty_in   = $qty;
			$qty_out  = 0;

			$data_update=array
			(
			 	'status'       => $status,
			 	'supplier'     => $supplier,
			 	'order_in_date'=> date('Y-m-d', strtotime($in_date)),
			 	'cost'         => $this->input->post('cost2'),
			 	'note'         => $note
			);
			$this->db->where('ID', $ID);
			$this->db->update('ts_service_spareparts', $data_update);

			$check_supplier = $this->master_model->mst_check('ms_supplier', 'name', $supplier);
			if($check_supplier ==  false)
			{
				$id_supplier = $this->master_model->mst_last_id('ms_supplier');
				$data_supplier=array
				(
					'ID'            => $id_supplier,
					'name'          => $supplier,
					'status'        => 0,
					'last_activity' => date('Y-m-d'),
					'sort'          => $id_supplier
				);
				$this->db->insert('ms_supplier', $data_supplier);
			}
		}elseif ($status==4)
		{
			if($status_ms_spareparts == 1)
			{
				$update_spareparts= array
				(
					'request' => $request_ms_spareparts-$qty,
					'status' => 2,
				);
				$this->db->where('ID', $id_ms_spareparts);
				$this->db->update('ms_product_spareparts', $update_spareparts);
			}else {
				$update_spareparts= array
				(
					'request' => $request_ms_spareparts-$qty,
				);
				$this->db->where('ID', $id_ms_spareparts);
				$this->db->update('ms_product_spareparts', $update_spareparts);
			}

			$data_update=array
			(
			 	'status'       => $status,
			 	'note'         => $note
			);
			$this->db->where('ID', $ID);
			$this->db->update('ts_service_spareparts', $data_update);

			$qty_in = 0;
			$qty_out = 0;
		}

		$id_log_spareparts = $this->master_model->mst_last_id('log_activity');
		$data_log_spareparts=array
		(
			'ID'        => $id_log_spareparts,
			'activity'  => 'Spareparts',
			'id_detail' => $ID,
			'qty'       => $qty,
			'qty_in'    => $qty_in,
			'qty_out'   => $qty_out,
			'status'    => $status,
			'id_admin'  => $id_admin,
			'date_in'   => date('Y-m-d H:i:s'),
			'id_spareparts' => $id_ms_spareparts,
			'note'      => $note,
			'sort'      => $id_log_spareparts
		);
		$this->db->insert('log_activity', $data_log_spareparts);

		$arr['url_spareparts']        = $get_id_category[0]->id_product.'/'.$get_id_category[0]->id_product_category.'/'.$id_product_subcategory.'/'.$id_ms_spareparts;
		$arr['name_spareparts']       = $sparepart_name;
		$arr['date_in_spareparts']    = date('Y-m-d H:i:s');
		$arr['admin_name_spareparts'] = $data_admin[0]->name;
		$arr['note_spareparts']       = $note;

		$arr['status'] = true;
		$count_message_spareparts = $this->master_model->mst_count('log_activity', "activity = 'Spareparts' AND status_read=0");

		$arr['count_message_spareparts'] = $count_message_spareparts+1;
		echo json_encode($arr);

		//redirect('transaction/spareparts/'.$menuid);
	}

	public function supplier_to_list($menuid)
	{
		$name=$this->input->get('name');
		$data_supplier = $this->master_model->select_in('ms_supplier','name',"WHERE name LIKE '%$name%'");

		for($c=0; $c < count($data_supplier); $c++)
		{
			$name=$data_supplier[$c]->name;
			echo'
				<option value="'.$name.'">
			';
		}
	}



	public function invoice_rent_to_list($menuid)
	{
		$invoice = $this->input->get('name');

		$data_invoice_rent = $this->master_model->select_in('ts_rent', 'invoice', "WHERE invoice LIKE '%$invoice%'");

		for($a=0; $a < count($data_invoice_rent); $a++)
		{
			echo'
				<option value="'.$data_invoice_rent[$a]->invoice.'">
			';
		}
	}


	public function invoice_rent($menuid)
	{
		$this->load->view('service/invoice_rent');
	}

	public function status_service($menuid)
	{
		$ID = $this->input->post('ID');

		$explode = explode('--', $ID);
		$ID = $explode[0];
		$status = $explode[1];

		$data_edit = $this->master_model->select_in('ts_service', 'note, invoice', "WHERE ID=$ID");
		$data_status=array
		(
				'0' => '<span class="label label-primary">Analysis</span>',
				'1' => '<span class="label label-info">Process</span>',
				'2' => '<span class="label label-warning">Pending</span>',
				'3' => '<span class="label label-success">Done</span>',
				'4' => '<span class="label label-danger">Failed</span>'
		);

		$value_status=array
		(
				'0' => 'Analys',
				'1' => 'Update Status Service to Process',
				'2' => 'Update Status Service to Pending',
				'3' => 'Update Status Service to Done',
				'4' => 'Update Status Service to Failed'
		);

		echo'
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">Status Service '.$data_edit[0]->invoice.'</h4>
			</div>
			<div class="overlay" id="overlay" style="display: none">
        <i class="fa fa-refresh fa-spin"></i>
      </div>
			<div class="modal-body">
				';
					for($a=0; $a < count($data_status); $a++)
					{
						if($status == $a)
						{
							$check ='checked="checked"';
							$checked = 'checked';
							$aria_check ='aria-checked="true"';
						}else {
							$check = '';
							$checked = '';
							$aria_check ='aria-checked="false"';
						}

						if($a < $status)
						{
							$display = 'style="display: none"';
							$break = '';
						}else {
							$display = 'style="cursor: pointer"';
							$break = '<br/><br/>';
						}
						echo'
						<script>
							$(function()
							{
								$(".radio_click").click(function()
								{
									 var value = $(this).attr("alt");
									 var title = $(this).attr("title");

									 $(".note").val(value);
									 $(".status").val(title);
								});
							});
						</script>
							<label '.$display.'>
									<input alt="'.$value_status[$a].'" title="'.$a.'" name="status" class="minimal radio_click" '.$check.' type="radio" value="'.$a.'">
									<input type="hidden" class="status" value="'.$status.'">
								'.$data_status[$a].'
							</label>
							'.$break.'
						';
					}
				echo'
				<label>Latest Note</label>
				<textarea class="form-control note" name="note" placeholder="Note">'.$data_edit[0]->note.'</textarea>
			</div>
			<div class="modal-footer">
				<script src="'.base_url().'node_modules/socket.io/node_modules/socket.io-client/socket.io.js"></script>
				<script>
					$(document).ready(function(){
						$("#update_status_service").click(function()
						{
							document.querySelector(".loader-default").className += " is-active";

							var dataString =
							{
								status : $(".status").val(),
								note 	 : $(".note").val(),
							};

							$.ajax({
								type: "POST",
								url: "'.base_url().'transaction/update_status_service/'.$menuid.'/'.$ID.'",
								data: dataString,
								dataType: "json",
								cache : false,
								success: function(data)
								{
									document.querySelector(".loader-default").className -= " is-active";

									if(data.status == true)
									{
										var socket = io.connect("http://"+window.location.hostname+":3000");

										socket.emit("count_message_service", {
											count_message_service: data.count_message_service
										});

										socket.emit("new_notification_service",
										{
											id_detail: data.id_detail,
											activity: data.activity,
											date_in: data.date_in,
											admin_name: data.admin_name,
											note: data.note,
										});

										setTimeout(function() {
										  window.location.href = "'.base_url().'transaction/index/'.$menuid.'";
										}, 1000);

									} else if(data.status == false)
									{
										alerty.toasts("Error", {place: "top"})
									}
								} ,error: function(xhr, status, error) {
									alert(error);
								},
							});
					});
					});
				</script>
					<input type="submit" class="btn btn-primary btn-fill pull-right" value="Update" id="update_status_service">
				<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
		  </div>
		';
	}

	public function update_status_service($menuid, $ID)
	{
		$status = $this->input->post('status');
		$data_service=array
		(
			'status' => $this->input->post('status'),
			'note'   => $this->input->post('note'),
		);
		$this->db->where('ID', $ID);
		$this->db->update('ts_service', $data_service);

		if($status == 1)
		{
			$start = date('Y-m-d H:i:s');
		}else {
			$start = '0000-00-00 00:00:00';
		}

		$data_jobs=array
		(
			'status' => $this->input->post('status'),
			'start'  => $start,
		);
		$this->db->where('id_service', $ID);
		$this->db->update('ts_service_detail', $data_jobs);

		$id_admin = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user','name',"WHERE ID = $id_admin");
		$id_log = $this->master_model->mst_last_id('log_activity');
		$data_log=array
		(
			'ID' => $id_log,
			'activity' => 'Service',
			'id_detail' => $ID,
			'id_admin' => $id_admin,
			'date_in' => date('Y-m-d H:i:s'),
			'note' => $this->input->post('note'),
			'sort' => $id_log
		);
		$this->db->insert('log_activity', $data_log);

		$data_service_detail = $this->master_model->select_in('ts_service_detail','ID',"WHERE id_service = $ID");
		for($a=0; $a < count($data_service_detail); $a++)
		{
			$id_service_detail = $data_service_detail[$a]->ID;
			$id_log_jobs = $this->master_model->mst_last_id('log_activity');
			$data_log_jobs=array
			(
				'ID' => $id_log_jobs,
				'activity' => 'Jobs',
				'id_detail' => $id_service_detail,
				'id_admin' => $id_admin,
				'date_in' => date('Y-m-d H:i:s'),
				'status' => $this->input->post('status'),
				'note' => $this->input->post('note'),
				'sort' => $id_log_jobs
			);
			$this->db->insert('log_activity', $data_log_jobs);

			$update_spareparts=array
			(
				'status' => $this->input->post('status'),
				'supplier' => 'Warehouse',
			);
			$this->db->where('id_service_detail', $id_service_detail);
			$this->db->update('ts_service_spareparts', $update_spareparts);

			$data_spareparts = $this->master_model->select_in('ts_service_spareparts','ID, qty, sparepart',"WHERE id_service_detail = $id_service_detail");
			for($c=0; $c < count($data_spareparts); $c++)
			{
				$id_spareparts = $data_spareparts[$c]->ID;
				$qty_parts = $data_spareparts[$c]->qty;
				$spareparts = $data_spareparts[$c]->sparepart;

				$get_id_ms_spareparts = $this->master_model->select_in('ms_product_spareparts', 'ID, stock, request, status', "WHERE name = '$spareparts'");
				$id_ms_spareparts = $get_id_ms_spareparts[0]->ID;
				$stock = $get_id_ms_spareparts[0]->stock;
				$request = $get_id_ms_spareparts[0]->request;
				$status_ms_spareparts = $get_id_ms_spareparts[0]->status;

				$id_log_spareparts = $this->master_model->mst_last_id('log_activity');
				$data_log_spareparts=array
				(
					'ID' => $id_log_spareparts,
					'activity' => 'Spareparts',
					'id_detail' => $id_spareparts,
					'id_admin' => $id_admin,
					'id_spareparts' => $id_ms_spareparts,
					'qty'      => $qty_parts,
					'date_in' => date('Y-m-d H:i:s'),
					'status' => $this->input->post('status'),
					'note' => $this->input->post('note'),
					'sort' => $id_log_spareparts
				);
				$this->db->insert('log_activity', $data_log_spareparts);

				if($this->input->post('status') == 3) //if product ready
				{
					$update_product = array
					(
						'stock' => $stock-$qty_parts,
						'request' => $request-$qty_parts,
					);
					$this->db->where('name', $spareparts);
					$this->db->update('ms_product_spareparts', $update_product);

					$id_log_spareparts = $this->master_model->mst_last_id('log_activity');
					$data_log_spareparts=array
					(
						'ID'            => $id_log_spareparts,
						'activity'      => 'Spareparts',
						'id_detail'     => 0,
						'id_admin'      => $id_admin,
						'id_spareparts' => $id_ms_spareparts,
						'qty'           => $stock-$qty_parts,
						'qty_out'       => $qty_parts,
						'date_in'       => date('Y-m-d H:i:s'),
						'status'        => 0,
						'note'          => $this->input->post('note'),
						'sort'          => $id_log_spareparts
					);
					$this->db->insert('log_activity', $data_log_spareparts);
				}elseif($this->input->post('status') == 4) //else product canceled
				{
					if($status_ms_spareparts == 0)//if product is available
					{
						$update_product = array
						(
							'request' => $request-$qty_parts,
						);
						$this->db->where('name', $spareparts);
						$this->db->update('ms_product_spareparts', $update_product);
					}else {
						$update_product = array
						(
							'request' => $request-$qty_parts,
							'status'  => 2
						);
						$this->db->where('name', $spareparts);
						$this->db->update('ms_product_spareparts', $update_product);

						//$this->db->where('name', $spareparts);
						//$this->db->delete('ms_product_spareparts');
					}

				}

			}
		}

		$arr['id_detail'] = $ID;
		$arr['activity'] = 'Service';
		$arr['date_in'] = date('Y-m-d H:i:s');
		$arr['admin_name'] = $data_admin[0]->name;
		$arr['note'] = $this->input->post('note');

		$arr['status'] = true;
		$count_message_service = $this->master_model->mst_count('log_activity', "activity = 'Service' AND status_read=0");
		$arr['count_message_service'] = $count_message_service;
		//redirect('transaction/index/'.$menuid);

		echo json_encode($arr);
	}


	public function invoice_rent_detail($menuid)
	{
		$invoice = $this->input->post('ID');

		$data_rent = $this->master_model->select_in('ts_rent', '*', "WHERE invoice = '$invoice'");


		$count = count($data_rent);

		if($count == 0)
		{
			echo'empty';
		}else
		{

			$id_customer = $data_rent[0]->id_customer;
			$status = $data_rent[0]->status;

			if($status == 0)
			{
				$status = '<span class="label label-warning">Invoice</span>';
			}elseif($status == 1)
			{
				$status = '<span class="label label-info">Rent</span>';
			}elseif($status == 2)
			{
				$status = '<span class="label label-warning">Serviced</span>';
			}elseif($status == 3)
			{
				$status = '<span class="label label-success">Done</span>';
			}elseif($status == 4)
			{
				$status = '<span class="label label-danger">Canceled</span>';
			}

			$start = new DateTime($data_rent[0]->start_date);
			$end = new DateTime($data_rent[0]->end_date);
			$today = new DateTime('now');

			$total = $start->diff($end);
			$current = $start->diff($today);

			$percent_completed = round($current->days / $total->days * 100, 1);


			$startTimeStamp = strtotime($data_rent[0]->start_date);
			$endTimeStamp = strtotime($data_rent[0]->end_date);

			$timeDiff = abs($endTimeStamp - $startTimeStamp);

			$numberDays = $timeDiff/86400;

			$numberDays = intval($numberDays);

			$data_customer = $this->master_model->select_in('ms_customer', '*', "WHERE ID = $id_customer");

			echo'
				<div class="col-md-3">
                	<div class="form-group">
                			<script>
							  $(function()
							  {
							    $(".invoice_rent").click(function()
							    {
							       var ID = $(this).attr("alt");

							       $.ajax({
							          type: "POST",
							        dataType: "html",
							        url: "'.base_url().'transaction/invoice_rent/'.$menuid.'",
							        data: "ID="+ID,
							        success: function(data)
							        {
							          $(".invoice-rent-modal").html(data);
							        }
							      });
							    });
							  });
							 </script>

                            <label>Invoice Number</label>
                            <br />
                            <a alt="'.$data_rent[0]->ID.'" class="invoice_rent" data-toggle="modal" data-target="#invoice-rent" style="cursor:pointer">
                            '.$data_rent[0]->invoice.'
                            </a>

                            <div class="modal fade" id="invoice-rent" role="dialog">
						        <div class="modal-dialog" style="width: 80%">
						          <div class="modal-content invoice-rent-modal" style="z-index:9999">

						          </div>
						        </div>
						    </div>

						    <input type="hidden" value="'.$data_rent[0]->ID.'" name="id_rent">
                      </div>
                      <div class="form-group">
                            <label>Nama Customer</label>
                            <br />
                            '.$data_customer[0]->name.'
                      </div>
                      <div class="form-group">
	                        <label>Phone Number</label>
	                        <br />
	                        '.$data_customer[0]->phone.'
	                  </div>
             	</div>
                <div class="col-md-3">

                    <div class="form-group">
                        <label>Company</label>
                        <br />
                        '.$data_customer[0]->company.'
                    </div>
                    <div class="form-group">
                        <label>Company Phone Number</label>
                        <br />
                        '.$data_customer[0]->company_phone.'
                    </div>
                    <div class="form-group">
                        <label>Rent Date</label>
                        <br />
                        '.date('d M Y', strtotime($data_rent[0]->start_date)).' - '.date('d M Y', strtotime($data_rent[0]->start_date)).'
                    </div>
              	</div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Brand / Merk</label>
                        <br />
                        '.$data_rent[0]->product.'
                    </div>
                    <div class="form-group">
                        <label>Model</label>
                        <br />
                        '.$data_rent[0]->model.'
                    </div>
                    <div class="form-group">
                        <label>Type</label>
                        <br />
                        '.$data_rent[0]->type.'
                    </div>
               	</div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Policy Number</label>
                        <br />
                        '.$data_rent[0]->policy_number.'
                    </div>

                    <div class="form-group">
                        <label>Status</label>
                        <br />
                        '.$status.'
                    </div>

                    <div class="form-group">
                        <label>Note</label>
                        <br />
                        '.$data_rent[0]->note.'
                    </div>
                </div>

                <div class="col-md-12">
                	<div class="clearfix">
						<span class="pull-left">Start Date : <b>'.date('d M Y', strtotime($data_rent[0]->start_date)).'</b></span>
						<!-- <center><small><?php echo $percent_completed;?>%</small></center> -->
						<span class="pull-right">End Date : <b>'.date('d M Y', strtotime($data_rent[0]->end_date)).'</b></span>
					</div>
					<div class="progress xs">
						<div class="progress-bar progress-bar-blue" style="width: '.$percent_completed.'%;"></div>
					</div>
                </div>

                <div class="col-md-6">
                	<div class="form-group">
                    	<script>
                    		$(".damage").click(function(e)
							{
								var damage = $(this).val();

								if(damage == 1)
								{
									$("#damage").val("Regular Service");
								}else
								{
									$("#damage").val("");
								}
							});
                    	</script>
                        <label><input type="radio" name="damage" class="damage" value="0" checked="checked"> Type of Damage</label>
		                <label><input type="radio" name="damage" class="damage" value="1"> Regular Service</label>
		                <input type="text" name="damage" class="form-control damage_to_list" placeholder="Damage / Regular Service" list="damage_to_list" id="damage">
		                <datalist id="damage_to_list"></datalist>
                    </div>
                </div>

                <div class="col-md-6">
                	<div class="form-group">
                        <script>
                    		$(".workshop").click(function(e)
							{
								var workshop = $(this).val();

								if(workshop == 1)
								{
									$("#workshop").val("");
								}else
								{
									$("#workshop").val("Own Workshop");
								}
							});
                    	</script>
                        <label><input type="radio" name="workshop" class="workshop" value="0" checked="checked"> Own Workshop</label>
		                <label><input type="radio" name="workshop" class="workshop" value="1"> Partner Workshop</label>
		                <input type="text" name="workshop" class="form-control damage_to_list" placeholder="Workshop" list="damage_to_list" id="workshop" value="Own Workshop">
		                <datalist id="damage_to_list"></datalist>
                    </div>
                </div>
			';
		}
	}

	public function get_service($menuid, $before, $today, $param)
	{
		$status = $this->input->post('status');

		if($status == 'All')
		{
			$status = "";
		}else {
			$status = "AND status = '$status'";
		}

		$data_service = $this->master_model->select_in('ts_service', '*', "WHERE date_in BETWEEN '$before' AND '$today' $status ORDER BY ID DESC");

		echo'
		<table id="'.$param.'" class="table table-bordered table-striped">
					<thead>
							<tr>
									<th>No.</th>
									<th>Invoice</th>
									<th>Customer</th>
									<th>Service Date</th>
									<th>Product</th>
									<th>Policy Number</th>

									<th>Grand Total</th>
									<th>Status</th>
									<th>Admin</th>
									<th>Edit</th>
									<th>Delete</th>
							</tr>
					</thead>
					<tbody>
					';
								for($a=0; $a < count($data_service); $a++)
								{
										$ID = $data_service[$a]->ID;
										$status = $data_service[$a]->status;

										if($status == 0)
										{
											$status = '<span class="label label-primary">Analysis</span>';
										}elseif($status == 1)
										{
											$status = '<span class="label label-info">Process</span>';
										}elseif($status == 2)
										{
											$status = '<span class="label label-warning">Pending</span>';
										}elseif($status == 3)
										{
											$status = '<span class="label label-success">Done</span>';
										}elseif($status == 4)
										{
											$status = '<span class="label label-danger">Failed</span>';
										}

									 $b=$a+1;
							echo'
							<tr>
									<td>
										'.$b.'
									</td>
									<td>
										<script>
											$(function()
											{
												$(".invoice_pop'.$a.'").click(function()
												{
													 var ID = $(this).attr("alt");
													 $.ajax({
															type: "POST",
														dataType: "html",
														url: "'.base_url().'transaction/invoice/'.$menuid.'",
														data: "ID="+ID,
														success: function(data)
														{
															$(".invoice-modal").html(data);
														}
													});
												});
											});
										</script>
										<a alt="'.$data_service[$a]->ID.'" class="invoice_pop'.$a.'" data-toggle="modal" data-target="#invoice-modal" style="cursor:pointer">
												'.$data_service[$a]->invoice.'
										</a>
									</td>
									<td>
										<script>
											$(document).ready(function(e)
											{
												$(".customer'.$a.'").click(function()
												{
													 var ID = $(this).attr("alt");

														$.ajax({
														 type: "POST",
														 dataType: "html",
														 url: "'.base_url().'master/detail_customer/9",
														 data:"ID="+ID,
														 success: function(msg){
																$(".customer-modal").html(msg);
														 }
														});
												});
											});
										</script>
										<a alt="'.$data_service[$a]->id_customer.'" class="text-aqua customer'.$a.'" data-toggle="modal" data-target="#customer-modal" style="cursor:pointer">
											';
												$id_customer=$data_service[$a]->id_customer;
												$data_customer=$this->master_model->select_in('ms_customer','name',"WHERE ID=$id_customer");
												echo $data_customer[0]->name;
											echo'
										</a>
									</td>
									<td>
										'.date('d M Y', strtotime($data_service[$a]->date_in)).'
									</td>
									<td>
											';
												$product = explode(', ', $data_service[$a]->product);
												echo $product[0].', '.$product[1].', '.$product[2];
											echo'
									</td>
									<td>
										'.$product[3].'
									</td>

									<td>
										<strong>'.str_replace(',','.',number_format($data_service[$a]->grandtotal)).'</strong>
									</td>
									<td>
									<script>
										$(function()
										{
											$(".status_service'.$a.'").click(function()
											{
												 var ID = $(this).attr("alt");
												 $.ajax({
														type: "POST",
													dataType: "html",
													url: "'.base_url().'transaction/status_service/'.$menuid.'",
													data: "ID="+ID,
													success: function(data)
													{
														$(".status-modal").html(data);
													}
												});
											});
										});
									</script>
										<a alt="'.$data_service[$a]->ID.'--'.$data_service[$a]->status.'" class="status_service'.$a.'" data-toggle="modal" data-target="#status-modal" style="cursor:pointer">
											'.$status.'
										</a>
									</td>
									<td>
										';
											$id_admin=$data_service[$a]->id_admin;
											$data_admin=$this->master_model->select_in('user','name',"WHERE ID=$id_admin");
											echo $data_admin[0]->name;
										echo'
									</td>
									<td style="text-align:center">
										 <a href="'.base_url().'transaction/edit/'.$menuid.'/'.$id_customer.'/'.$ID.'" class="text-green" style="cursor:pointer">
													<i class="fa fa-edit"></i>
											</a>
									</td>
									<td style="text-align:center">
									<script>
										$(document).ready(function(e)
										{
											$(".delete'.$a.'").click(function()
											{
												var ID = $(this).attr("alt");
												alerty.confirm(
													"Are you sure want to delete this service?",
													{title: "Notes", cancelLabel: "Cancel", okLabel: "Confirm"},
													function()
													{
														$.ajax({
														 type: "POST",
														 dataType: "html",
														 url: "'.base_url().'transaction/delete/'.$menuid.'",
														 data:"ID="+ID,
														 success: function(msg)
														 {
															 if(msg == "error")
															 {
																 alerty.toasts("Can not be deleted, because there is a transaction in progress", {place: "top"})
															 }else {
																alerty.toasts("Delete succesfully", {place: "top"})
															 }
														 }
														});
													},

													function() {
														alerty.toasts("Canceled")
													}
												)
											});
										});
									</script>
									<a alt="'.$data_service[$a]->ID.'" class="delete'.$a.' text-red" style="cursor: pointer">
												<i class="fa fa-trash-o"></i>
										</a>
									</td>
							</tr>
							';
						} echo'
					</tbody>

			</table>

			<script>
	    $(function()
	    {
	      $(".invoice_pop").click(function()
	      {
	         var ID = $(this).attr("alt");
	         $.ajax({
	            type: "POST",
	          dataType: "html",
	          url: "'.base_url().'transaction/invoice/'.$menuid.'",
	          data: "ID="+ID,
	          success: function(data)
	          {
	            $(".invoice-modal").html(data);
	          }
	        });
	      });
	    });
	    </script>

	    <script>
		    $(function()
		    {
		      $(".status_service").click(function()
		      {
		         var ID = $(this).attr("alt");
		         $.ajax({
		            type: "POST",
		          dataType: "html",
		          url: "'.base_url().'transaction/status_rent/'.$menuid.'",
		          data: "ID="+ID,
		          success: function(data)
		          {
								//alert(data);
								//return false;
		            $(".status-modal").html(data);
		          }
		        });
		      });
		    });
	    </script>

			<script>

			  $(function ()
			  {
			    $("#'.$param.'").DataTable(
			  	{
			  		"paging": true,
			  		"lengthMenu": [ 10, 20, 30, 40, 50 ],
			  		"pageLength": 10,
			  		"searching": true,
			  		//"ajax": "data/arrays.txt",
			  		"deferRender": true,
			  	});
			  });
			</script>
		';
	}


	public function get_jobs($menuid, $before, $today, $param)
	{
		$status = $this->input->post('status');

		if($status == 'All')
		{
			$status = "";
		}else {
			$status = "AND a.status = '$status'";
		}

		$data_jobs = $this->master_model->select_in('ts_service_detail a LEFT JOIN ts_service b ON a.id_service = b.ID', 'a.*, b.invoice', "WHERE b.date_in BETWEEN '$before' AND '$today' $status ORDER BY a.ID DESC");

		echo'
		<table id="example1" class="table table-bordered table-striped">
					<thead>
							<tr>
									<th>No.</th>
									<th>Invoice</th>
									<th>Jobs</th>
									<th>Mechanic</th>
									<th>Durations</th>
									<th>Target Finish</th>
									<th>Status</th>
									<!--<th>Latest Note</th>
									<th>Edit</th>
									<th>Delete</th>-->
							</tr>
					</thead>
					<tbody class="get_customer">
					';
								for($a=0; $a < count($data_jobs); $a++)
								{
										$ID = $data_jobs[$a]->ID;
										$status = $data_jobs[$a]->status;

			$id_service=$data_jobs[$a]->id_service;

			$data_service=$this->master_model->select_in('ts_service','id_customer, finish_date, invoice',"WHERE ID=$id_service");
			$id_customer=$data_service[0]->id_customer;

			if($status==0)
			{
			 $status='<span class="label label-primary">Unprocess</span>';
			}elseif($status==1)
			{
			 $status='<span class="label label-info">Process</span>';
			}elseif($status==2)
			{
			 $status='<span class="label label-warning">Pending</span>';
			}elseif($status==3)
			{
			 $status='<span class="label label-success">Done</span>';
			}elseif($status==4)
			{
			 $status='<span class="label label-danger">Failed</span>';
			}

			if($status==4)
			{
				$status=$status;
			}else
			{
				$status='
					<a alt="'.$data_jobs[$a]->ID.'" class="status_jobs" data-toggle="modal" data-target="#status-modal" style="cursor:pointer">
					'.$status.'
				</a>
				';
			}
			$b=$a+1;
							echo'
							<tr>
									<td>
										'.$b.'
									</td>
									<td>
										<a alt="'.$id_service.'" class="text-blue invoice_pop" data-toggle="modal" data-target="#invoice-modal" style="cursor:pointer">
											'.$data_service[0]->invoice.'
										</a>
									</td>
									<td>
			<a alt="'.$ID.'" class="text-aqua history" data-toggle="modal" data-target="#history-modal" style="cursor:pointer">
												'.$data_jobs[$a]->jobs.'
			</a>
									</td>
									<td>

										<span class="show-first'.$a.'">
				'.$data_jobs[$a]->technician.'
											</span>

									</td>

									<td>
										'.$data_jobs[$a]->durations.' Hours
									</td>

									<td>
										';
											$explode=explode(' ', $data_service[0]->finish_date);
											$date=$explode[0];
											$hour=$explode[1];

											echo date('d M Y', strtotime($date));
										echo'
									</td>

									<td>
										'.$status.'
									</td>
							</tr>
							';
						}
					echo'
					</tbody>

			</table>

			<script>
	    $(function()
	    {
	      $(".invoice_pop").click(function()
	      {
	         var ID = $(this).attr("alt");
	         $.ajax({
	            type: "POST",
	          dataType: "html",
	          url: "'.base_url().'transaction/invoice/'.$menuid.'",
	          data: "ID="+ID,
	          success: function(data)
	          {
	            $(".invoice-modal").html(data);
	          }
	        });
	      });
	    });
	    </script>

	    <script>
		    $(function()
		    {
		      $(".status_service").click(function()
		      {
		         var ID = $(this).attr("alt");
		         $.ajax({
		            type: "POST",
		          dataType: "html",
		          url: "'.base_url().'transaction/status_rent/'.$menuid.'",
		          data: "ID="+ID,
		          success: function(data)
		          {
								//alert(data);
								//return false;
		            $(".status-modal").html(data);
		          }
		        });
		      });
		    });
	    </script>

			<script>

			  $(function ()
			  {
			    $("#'.$param.'").DataTable(
			  	{
			  		"paging": true,
			  		"lengthMenu": [ 10, 20, 30, 40, 50 ],
			  		"pageLength": 10,
			  		"searching": true,
			  		//"ajax": "data/arrays.txt",
			  		"deferRender": true,
			  	});
			  });
			</script>
		';
	}

	public function get_spareparts($menuid, $before, $today, $param)
	{
		$status = $this->input->post('status');

		if($status == 'All')
		{
			$status = "";
		}else {
			$status = "AND a.status = '$status'";
		}

		$data_spareparts = $this->master_model->select_in('ts_service_spareparts a LEFT JOIN ts_service_detail b ON a.id_service_detail = b.ID LEFT JOIN ts_service c ON b.id_service = c.ID LEFT JOIN ms_supplier d ON a.order_supplier = d.ID
		', 'a.*, b.id_service, c.invoice, c.date_in, d.name', "WHERE c.date_in BETWEEN '$before' AND '$today' $status ORDER BY a.ID DESC");

		echo'
		<table id="'.$param.'" class="table table-bordered table-striped">
				<thead>
						<tr>
								<th>No.</th>
								<th>Invoice</th>
								<th>Sparepart</th>
								<th>Service Date</th>
								<th>Indent</th>
								<th>Order Date</th>
								<th>Supplier</th>
								<th>Qty</th>
								<th>Price</th>
								<th>Subtotal</th>
								<th>Status</th>
						</tr>
				</thead>

				<tbody>
						';
							for($a=0; $a < count($data_spareparts); $a++)
							{
									$status=$data_spareparts[$a]->status;

									if($status==0)
									{
											$status='<span class="label label-primary">Request</span>';
									}elseif($status==1)
									{
											$status='<span class="label label-info">Ordered</span>';
									}elseif($status==2)
									{
											$status='<span class="label label-warning">Indent</span>';
									}elseif($status==3)
									{
											$status='<span class="tlabel label-success">Ready</span>';
									}elseif($status==4)
									{
											$status='<span class="label label-danger">Canceled</span>';
									}

									if($status==4)
									{
											$status=$status;
									}else
									{
											$status='
													<script>
															$(function()
															{
																	$(".status'.$a.'").click(function()
																	{
																		 var ID = $(this).attr("alt");

																		 $.ajax({
																					type: "POST",
																					dataType: "html",
																					url: "'.base_url().'transaction/status_spareparts/'.$menuid.'/'.$data_spareparts[$a]->id_service.'",
																					data: "ID="+ID,
																					success: function(data)
																					{
																							$(".status-modal").html(data);
																					}
																			});
																	});
															});
													</script>
													<a alt="'.$data_spareparts[$a]->ID.'" class="status'.$a.'" data-toggle="modal" data-target="#status-modal" style="cursor:pointer">
															'.$status.'
													</a>
											';
									}


									$b=$a+1;

									echo'
											<tr>
													<td>
															'.$b.'
												 </td>
												 <td>
															<a alt="'.$data_spareparts[$a]->id_service.'" class="invoice-pop" data-toggle="modal" data-target="#invoice-modal" style="cursor:pointer">
																	'.$data_spareparts[$a]->invoice.'
															</a>
												 </td>
													<td>
															<a alt="'.$data_spareparts[$a]->ID.'" class="history text-aqua" data-toggle="modal" data-target="#history-modal" style="cursor:pointer">
															'.$data_spareparts[$a]->sparepart.'
															</a>
													</td>
													<td>'.date('d M Y', strtotime($data_spareparts[$a]->date_in)).'
													</td>
													<td>
															'.$data_spareparts[$a]->indent.' Days
													</td>
													<td>
															'.date('d M Y', strtotime($data_spareparts[$a]->order_date)).'
													</td>
													<td>
															'.$data_spareparts[$a]->name.'
													</td>
													<td>
															'.$data_spareparts[$a]->qty.'
													</td>
													<td>
															'.str_replace(',','.',number_format($data_spareparts[$a]->price)).'

													</td>
													<td>
															'.str_replace(',','.',number_format($data_spareparts[$a]->subtotal)).'
													</td>
													<td>
															'.$status.'
													</td>


											</tr>
									';
							}
					echo'
				</tbody>

		</table>



			<script>

			  $(function ()
			  {
			    $("#'.$param.'").DataTable(
			  	{
			  		"paging": true,
			  		"lengthMenu": [ 10, 20, 30, 40, 50 ],
			  		"pageLength": 10,
			  		"searching": true,
			  		//"ajax": "data/arrays.txt",
			  		"deferRender": true,
			  	});
			  });
			</script>
		';
	}

	public function export_data_service($menuid, $before, $today, $status)
	{
		if($status == 'All')
		{
			$status = "";
		}else {
			$status = "AND status = '$status'";
		}

		$data_service = $this->master_model->select_in('ts_service', '*', "WHERE date_in BETWEEN '$before' AND '$today' $status ORDER BY ID DESC");
		if(count($data_service) == 0)
    {
        echo'
            <script language="javascript">
                window.alert("No collection data to export on that date!!")
                window.location.href="'.base_url().'transaction/index/'.$menuid.'";
            </script>
        ';
    }else
    {
        $styleArray =
            array(
                'borders' =>
            array(
            'allborders' =>
             array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' =>
            array(
                'argb' => '00000000'
                ),
            ),
            ),
        );

        $fontHeader = array(
            'font' => array(
                'bold' => true
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                'rotation'   => 0,

            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'F7F7F8')
            )
        );

        $objPHPExcel = new phpexcel();

        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->getActiveSheet()->setTitle('REPORT ACTIVITY SERVICE');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


        $objPHPExcel->getActiveSheet()->setCellValue('A4', 'No.');
        $objPHPExcel->getActiveSheet()->setCellValue('B4', 'Invoice');
        $objPHPExcel->getActiveSheet()->setCellValue('C4', 'Customer');
        $objPHPExcel->getActiveSheet()->setCellValue('D4', 'Service Date');
        $objPHPExcel->getActiveSheet()->setCellValue('E4', 'Product');
        $objPHPExcel->getActiveSheet()->setCellValue('F4', 'Policy Number');
        $objPHPExcel->getActiveSheet()->setCellValue('G4', 'Grand Total');
        $objPHPExcel->getActiveSheet()->setCellValue('H4', 'Status');
        $objPHPExcel->getActiveSheet()->setCellValue('I4', 'Admin');

        //print_array($data_call);
        //exit;

        for($a=0; $a < count($data_service); $a++)
        {
					$ID = $data_service[$a]->ID;
					$status = $data_service[$a]->status;

					$id_customer=$data_service[$a]->id_customer;
					$data_customer=$this->master_model->select_in('ms_customer','name',"WHERE ID=$id_customer");

					if($status == 0)
					{
						$status = 'Analysis';
					}elseif($status == 1)
					{
						$status = 'Process';
					}elseif($status == 2)
					{
						$status = 'Pending';
					}elseif($status == 3)
					{
						$status = 'Done';
					}elseif($status == 4)
					{
						$status = 'Failed';
					}

					$product = explode(', ', $data_service[$a]->product);

					$id_admin=$data_service[$a]->id_admin;
					$data_admin=$this->master_model->select_in('user','name',"WHERE ID=$id_admin");

            $isi[]= array('A' => $a+1, 'B' => $data_service[$a]->invoice, 'C' => $data_customer[0]->name, 'D' => date('d M Y', strtotime($data_service[$a]->date_in)), 'E' => $product[0].', '.$product[1].', '.$product[2], 'F' => $product[3], 'G' => $data_service[$a]->grandtotal, 'H' => $status, 'I' => $data_admin[0]->name);
        }

        //print_array($isi);
        //exit;

        $objPHPExcel->getActiveSheet()->getStyle('A4:I5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle('A4:I5')->getFont()->setBold(true);
        //$objPHPExcel->getActiveSheet()->getStyle('M')->getAlignment()->setWrapText(true);

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(45);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);

        //set merge kolom
        $objPHPExcel->getActiveSheet()->mergeCells('A1:I1');
        $objPHPExcel->getActiveSheet()->mergeCells('A2:I2');
        $objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
        $objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
        $objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
        $objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
        $objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
        $objPHPExcel->getActiveSheet()->mergeCells('F4:F5');
        $objPHPExcel->getActiveSheet()->mergeCells('G4:G5');
        $objPHPExcel->getActiveSheet()->mergeCells('H4:H5');
        $objPHPExcel->getActiveSheet()->mergeCells('I4:I5');

        //set papersize
        $objPHPExcel->getActiveSheet()
            ->getPageSetup()
            ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
        $objPHPExcel->getActiveSheet()
            ->getPageSetup()
            ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

        $objPHPExcel->getActiveSheet()
            ->getPageMargins()->setTop(0.25);
        $objPHPExcel->getActiveSheet()
            ->getPageMargins()->setRight(0);
        $objPHPExcel->getActiveSheet()
            ->getPageMargins()->setLeft(0);
        $objPHPExcel->getActiveSheet()
            ->getPageMargins()->setBottom(0.25);
        $objPHPExcel->getActiveSheet()
            ->setShowGridlines(true);

        //set header kolom
        $objPHPExcel->getActiveSheet()->setCellValue('A1', 'REPORT ACTIVITY SERVICE');
        $objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : '.date('d M Y', strtotime($before)).' - '.date('d M Y', strtotime($today)));


        // melakukan pengisian data
        foreach($isi as $k => $v)
        {
            $col = $k + 6;

            foreach($v as $k1 => $v1)
            {
                $column = $k1.$col;
                $objPHPExcel->getActiveSheet()->setCellValue($column, $v1);
                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);


                $subtotal='=SUM(G6:G'.$col.')';

                //$objPHPExcel->getActiveSheet()->setCellValue('G'.$col, $subtotal);
            }
        }
        $tco=$col+1;

        $objPHPExcel->getActiveSheet()->setCellValue('G'.$tco, $subtotal);

        $objWorksheet = $objPHPExcel->getActiveSheet(0);
        $objWorksheet->getStyle('A4:'.$column)->applyFromArray($styleArray);

        $objWorksheet->getStyle('D6:D'.$col)->getNumberFormat()->setFormatCode('#,##0');
        $objWorksheet->getStyle('D'.$tco)->getNumberFormat()->setFormatCode('#,##0');
        $objPHPExcel->getActiveSheet()->getStyle('A6:A'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->getStyle('C6:C'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);;

        $objPHPExcel->getActiveSheet()->getStyle('D6:D'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->getStyle('E6:E'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

				$objPHPExcel->getActiveSheet()->getStyle('F6:F'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

				$objPHPExcel->getActiveSheet()->getStyle('G6:G'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

				$objPHPExcel->getActiveSheet()->getStyle('H6:H'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->getStyle('I6:I'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle('C'.$tco)->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle('D'.$tco)->getFont()->setBold(true);

        $objPHPExcel->getActiveSheet()
        ->getStyle('A6:A'.$col)
        ->getAlignment()
        ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
        ->setTextRotation(0);

        $tanggal = date('d M Y');
        $filename = 'REPORT ACTIVITY SERVICE '.$tanggal.'.xlsx';

        //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache

        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .XLSX Excel 2007 format
        $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');

				$objWriter->setPreCalculateFormulas(true);

        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
        exit;
    }
}


		public function export_data_jobs($menuid, $before, $today, $status)
		{
			if($status == 'All')
			{
				$status = "";
			}else {
				$status = "AND a.status = '$status'";
			}

			$data_jobs = $this->master_model->select_in('ts_service_detail a LEFT JOIN ts_service b ON a.id_service = b.ID', 'a.*, b.invoice, b.id_admin', "WHERE b.date_in BETWEEN '$before' AND '$today' $status ORDER BY a.ID DESC");
			if(count($data_jobs) == 0)
	    {
	        echo'
	            <script language="javascript">
	                window.alert("No collection data to export on that date!!")
	                window.location.href="'.base_url().'transaction/job/'.$menuid.'";
	            </script>
	        ';
	    }else
	    {
	        $styleArray =
	            array(
	                'borders' =>
	            array(
	            'allborders' =>
	             array(
	                'style' => PHPExcel_Style_Border::BORDER_THIN,
	                'color' =>
	            array(
	                'argb' => '00000000'
	                ),
	            ),
	            ),
	        );

	        $fontHeader = array(
	            'font' => array(
	                'bold' => true
	            ),
	            'alignment' => array(
	                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
	                'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
	                'rotation'   => 0,

	            ),
	            'fill' => array(
	                'type' => PHPExcel_Style_Fill::FILL_SOLID,
	                'color' => array('rgb' => 'F7F7F8')
	            )
	        );

	        $objPHPExcel = new phpexcel();

	        $objPHPExcel->setActiveSheetIndex(0);

	        $objPHPExcel->getActiveSheet()->setTitle('REPORT ACTIVITY JOBS');
	        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	        $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


	        $objPHPExcel->getActiveSheet()->setCellValue('A4', 'No.');
	        $objPHPExcel->getActiveSheet()->setCellValue('B4', 'Invoice');
	        $objPHPExcel->getActiveSheet()->setCellValue('C4', 'Jobs');
	        $objPHPExcel->getActiveSheet()->setCellValue('D4', 'Mechanic');
	        $objPHPExcel->getActiveSheet()->setCellValue('E4', 'Durations');
	        $objPHPExcel->getActiveSheet()->setCellValue('F4', 'Start Date');
	        $objPHPExcel->getActiveSheet()->setCellValue('G4', 'Finish Date');
	        $objPHPExcel->getActiveSheet()->setCellValue('H4', 'Status');
	        $objPHPExcel->getActiveSheet()->setCellValue('I4', 'Admin');

	        //print_array($data_call);
	        //exit;

	        for($a=0; $a < count($data_jobs); $a++)
	        {
						$ID = $data_jobs[$a]->ID;
						$status = $data_jobs[$a]->status;

						$id_service=$data_jobs[$a]->id_service;

						$data_service=$this->master_model->select_in('ts_service','id_customer, finish_date, invoice',"WHERE ID=$id_service");
						$id_customer=$data_service[0]->id_customer;

						if($status==0)
						{
						$status='Unprocess';
						}elseif($status==1)
						{
						$status='Process';
						}elseif($status==2)
						{
						$status='Pending';
						}elseif($status==3)
						{
						$status='Done';
						}elseif($status==4)
						{
						$status='Failed';
						}

						$explode=explode(' ', $data_service[0]->finish_date);
						$date=$explode[0];
						$hour=$explode[1];

						$id_admin=$data_jobs[$a]->id_admin;
						$data_admin=$this->master_model->select_in('user','name',"WHERE ID=$id_admin");

						if($data_jobs[$a]->start == '0000-00-00 00:00:00')
						{
							$start = 'Unprocess';
						}else {
							$start = date('d M Y', strtotime($data_jobs[$a]->start));
						}

	            $isi[]= array('A' => $a+1, 'B' => $data_jobs[$a]->invoice, 'C' => $data_jobs[$a]->jobs, 'D' => $data_jobs[$a]->technician, 'E' => $data_jobs[$a]->durations.' Hours', 'F' => $start, 'G' => date('d M Y', strtotime($date)), 'H' => $status, 'I' => $data_admin[0]->name);
	        }

	        //print_array($isi);
	        //exit;

	        $objPHPExcel->getActiveSheet()->getStyle('A4:I5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
	        $objPHPExcel->getActiveSheet()->getStyle('A4:I5')->getFont()->setBold(true);
	        //$objPHPExcel->getActiveSheet()->getStyle('M')->getAlignment()->setWrapText(true);

	        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);

	        //set merge kolom
	        $objPHPExcel->getActiveSheet()->mergeCells('A1:I1');
	        $objPHPExcel->getActiveSheet()->mergeCells('A2:I2');
	        $objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
	        $objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
	        $objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
	        $objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
	        $objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
	        $objPHPExcel->getActiveSheet()->mergeCells('F4:F5');
	        $objPHPExcel->getActiveSheet()->mergeCells('G4:G5');
	        $objPHPExcel->getActiveSheet()->mergeCells('H4:H5');
	        $objPHPExcel->getActiveSheet()->mergeCells('I4:I5');

	        //set papersize
	        $objPHPExcel->getActiveSheet()
	            ->getPageSetup()
	            ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
	        $objPHPExcel->getActiveSheet()
	            ->getPageSetup()
	            ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setTop(0.25);
	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setRight(0);
	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setLeft(0);
	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setBottom(0.25);
	        $objPHPExcel->getActiveSheet()
	            ->setShowGridlines(true);

	        //set header kolom
	        $objPHPExcel->getActiveSheet()->setCellValue('A1', 'REPORT ACTIVITY JOBS');
	        $objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : '.date('d M Y', strtotime($before)).' - '.date('d M Y', strtotime($today)));


	        // melakukan pengisian data
	        foreach($isi as $k => $v)
	        {
	            $col = $k + 6;

	            foreach($v as $k1 => $v1)
	            {
	                $column = $k1.$col;
	                $objPHPExcel->getActiveSheet()->setCellValue($column, $v1);
	                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);


	                $subtotal='=SUM(G6:G'.$col.')';

	                //$objPHPExcel->getActiveSheet()->setCellValue('G'.$col, $subtotal);
	            }
	        }
	        $tco=$col+1;

	        //$objPHPExcel->getActiveSheet()->setCellValue('G'.$tco, $subtotal);

	        $objWorksheet = $objPHPExcel->getActiveSheet(0);
	        $objWorksheet->getStyle('A4:'.$column)->applyFromArray($styleArray);

	        $objWorksheet->getStyle('D6:D'.$col)->getNumberFormat()->setFormatCode('#,##0');
	        $objWorksheet->getStyle('D'.$tco)->getNumberFormat()->setFormatCode('#,##0');
	        $objPHPExcel->getActiveSheet()->getStyle('A6:A'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('C6:C'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);;

	        $objPHPExcel->getActiveSheet()->getStyle('D6:D'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('E6:E'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

					$objPHPExcel->getActiveSheet()->getStyle('F6:F'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

					$objPHPExcel->getActiveSheet()->getStyle('G6:G'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

					$objPHPExcel->getActiveSheet()->getStyle('H6:H'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('I6:I'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getFont()->setBold(true);
	        $objPHPExcel->getActiveSheet()->getStyle('C'.$tco)->getFont()->setBold(true);
	        $objPHPExcel->getActiveSheet()->getStyle('D'.$tco)->getFont()->setBold(true);

	        $objPHPExcel->getActiveSheet()
	        ->getStyle('A6:A'.$col)
	        ->getAlignment()
	        ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
	        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
	        ->setTextRotation(0);

	        $tanggal = date('d M Y');
	        $filename = 'REPORT ACTIVITY JOBS '.$tanggal.'.xlsx';

	        //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
	        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache

	        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .XLSX Excel 2007 format
	        $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');

					$objWriter->setPreCalculateFormulas(true);

	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');
	        exit;
	    }
		}


		public function export_data_spareparts($menuid, $before, $today, $status)
		{
			if($status == 'All')
			{
				$status = "";
			}else {
				$status = "AND a.status = '$status'";
			}

			$data_spareparts = $this->master_model->select_in('ts_service_spareparts a LEFT JOIN ts_service_detail b ON a.id_service_detail = b.ID LEFT JOIN ts_service c ON b.id_service = c.ID LEFT JOIN ms_supplier d ON a.supplier = d.ID', 'a.*, c.invoice, c.date_in, c.id_admin, d.name', "WHERE c.date_in BETWEEN '$before' AND '$today' $status ORDER BY a.ID DESC");
			if(count($data_spareparts) == 0)
	    {
	        echo'
	            <script language="javascript">
	                window.alert("No collection data to export on that date!!")
	                window.location.href="'.base_url().'transaction/job/'.$menuid.'";
	            </script>
	        ';
	    }else
	    {
	        $styleArray =
	            array(
	                'borders' =>
	            array(
	            'allborders' =>
	             array(
	                'style' => PHPExcel_Style_Border::BORDER_THIN,
	                'color' =>
	            array(
	                'argb' => '00000000'
	                ),
	            ),
	            ),
	        );

	        $fontHeader = array(
	            'font' => array(
	                'bold' => true
	            ),
	            'alignment' => array(
	                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
	                'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
	                'rotation'   => 0,

	            ),
	            'fill' => array(
	                'type' => PHPExcel_Style_Fill::FILL_SOLID,
	                'color' => array('rgb' => 'F7F7F8')
	            )
	        );

	        $objPHPExcel = new phpexcel();

	        $objPHPExcel->setActiveSheetIndex(0);

	        $objPHPExcel->getActiveSheet()->setTitle('REPORT ACTIVITY SPAREPARTS');
	        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	        $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


	        $objPHPExcel->getActiveSheet()->setCellValue('A4', 'No.');
	        $objPHPExcel->getActiveSheet()->setCellValue('B4', 'Invoice');
	        $objPHPExcel->getActiveSheet()->setCellValue('C4', 'Sparepart');
	        $objPHPExcel->getActiveSheet()->setCellValue('D4', 'Service Date');
	        $objPHPExcel->getActiveSheet()->setCellValue('E4', 'Indent');
	        $objPHPExcel->getActiveSheet()->setCellValue('F4', 'Order Date');
	        $objPHPExcel->getActiveSheet()->setCellValue('G4', 'Supplier');
	        $objPHPExcel->getActiveSheet()->setCellValue('H4', 'Qty');
	        $objPHPExcel->getActiveSheet()->setCellValue('I4', 'Price');
					$objPHPExcel->getActiveSheet()->setCellValue('J4', 'Subtotal');
					$objPHPExcel->getActiveSheet()->setCellValue('K4', 'Status');

	        //print_array($data_call);
	        //exit;

	        for($a=0; $a < count($data_spareparts); $a++)
	        {
						$status=$data_spareparts[$a]->status;

						if($status==0)
						{
								$status='Request';
						}elseif($status==1)
						{
								$status='Ordered';
						}elseif($status==2)
						{
								$status='Indent';
						}elseif($status==3)
						{
								$status='Ready';
						}elseif($status==4)
						{
								$status='Canceled';
						}

	            $isi[]= array
							(
								'A' => $a+1,
								'B' => $data_spareparts[$a]->invoice,
								'C' => $data_spareparts[$a]->sparepart,
								'D' => date('d M Y', strtotime($data_spareparts[$a]->date_in)),
								'E' => $data_spareparts[$a]->indent.' Days',
								'F' => date('d M Y', strtotime($data_spareparts[$a]->order_date)),
								'G' => $data_spareparts[$a]->name,
								'H' => $data_spareparts[$a]->qty,
								'I' => $data_spareparts[$a]->price,
								'J' => $data_spareparts[$a]->subtotal,
								'K' => $status
						);
	        }

	        //print_array($isi);
	        //exit;

	        $objPHPExcel->getActiveSheet()->getStyle('A4:I5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
	        $objPHPExcel->getActiveSheet()->getStyle('A4:I5')->getFont()->setBold(true);
	        //$objPHPExcel->getActiveSheet()->getStyle('M')->getAlignment()->setWrapText(true);

	        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
					$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
					$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);

	        //set merge kolom
	        $objPHPExcel->getActiveSheet()->mergeCells('A1:K1');
	        $objPHPExcel->getActiveSheet()->mergeCells('A2:K2');
	        $objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
	        $objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
	        $objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
	        $objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
	        $objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
	        $objPHPExcel->getActiveSheet()->mergeCells('F4:F5');
	        $objPHPExcel->getActiveSheet()->mergeCells('G4:G5');
	        $objPHPExcel->getActiveSheet()->mergeCells('H4:H5');
	        $objPHPExcel->getActiveSheet()->mergeCells('I4:I5');
					$objPHPExcel->getActiveSheet()->mergeCells('J4:J5');
					$objPHPExcel->getActiveSheet()->mergeCells('K4:K5');

	        //set papersize
	        $objPHPExcel->getActiveSheet()
	            ->getPageSetup()
	            ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
	        $objPHPExcel->getActiveSheet()
	            ->getPageSetup()
	            ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setTop(0.25);
	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setRight(0);
	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setLeft(0);
	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setBottom(0.25);
	        $objPHPExcel->getActiveSheet()
	            ->setShowGridlines(true);

	        //set header kolom
	        $objPHPExcel->getActiveSheet()->setCellValue('A1', 'REPORT ACTIVITY SPAREPARTS');
	        $objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : '.date('d M Y', strtotime($before)).' - '.date('d M Y', strtotime($today)));


	        // melakukan pengisian data
	        foreach($isi as $k => $v)
	        {
	            $col = $k + 6;

	            foreach($v as $k1 => $v1)
	            {
	                $column = $k1.$col;
	                $objPHPExcel->getActiveSheet()->setCellValue($column, $v1);
	                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);


	                $subtotal='=SUM(G6:G'.$col.')';

	                //$objPHPExcel->getActiveSheet()->setCellValue('G'.$col, $subtotal);
	            }
	        }
	        $tco=$col+1;

	        //$objPHPExcel->getActiveSheet()->setCellValue('G'.$tco, $subtotal);

	        $objWorksheet = $objPHPExcel->getActiveSheet(0);
	        $objWorksheet->getStyle('A4:'.$column)->applyFromArray($styleArray);

	        $objWorksheet->getStyle('D6:D'.$col)->getNumberFormat()->setFormatCode('#,##0');
	        $objWorksheet->getStyle('D'.$tco)->getNumberFormat()->setFormatCode('#,##0');
	        $objPHPExcel->getActiveSheet()->getStyle('A6:A'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('C6:C'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);;

	        $objPHPExcel->getActiveSheet()->getStyle('D6:D'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('E6:E'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

					$objPHPExcel->getActiveSheet()->getStyle('F6:F'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

					$objPHPExcel->getActiveSheet()->getStyle('G6:G'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

					$objPHPExcel->getActiveSheet()->getStyle('H6:H'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('I6:I'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getFont()->setBold(true);
	        $objPHPExcel->getActiveSheet()->getStyle('C'.$tco)->getFont()->setBold(true);
	        $objPHPExcel->getActiveSheet()->getStyle('D'.$tco)->getFont()->setBold(true);

	        $objPHPExcel->getActiveSheet()
	        ->getStyle('A6:A'.$col)
	        ->getAlignment()
	        ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
	        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
	        ->setTextRotation(0);

	        $tanggal = date('d M Y');
	        $filename = 'REPORT ACTIVITY SPAREPARTS '.$tanggal.'.xlsx';

	        //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
	        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache

	        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .XLSX Excel 2007 format
	        $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');

					$objWriter->setPreCalculateFormulas(true);

	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');
	        exit;
	    }
		}


		public function export_invoice($menuid, $ID)
		{
			$data_service = $this->master_model->select_in('ts_service', '*', "WHERE ID = $ID");

			$invoice=$data_service[0]->invoice;

	    $damage=$data_service[0]->damage;
	    $note=$data_service[0]->note;
	    $total_service=$data_service[0]->total_service;
	    $total_parts=$data_service[0]->total_parts;
	    $grandtotal=$data_service[0]->grandtotal;
	    $durations_day=$data_service[0]->durations_day;
	    $start_date=$data_service[0]->start_date;
	    $finish_date=$data_service[0]->finish_date;
	    $deliver_date=$data_service[0]->deliver_date;
	    $discount=$data_service[0]->discount;
	    $tax=$data_service[0]->tax;
			$date_in=$data_service[0]->date_in;

	    $status = $data_service[0]->status;

	    if($status == 0)
	    {
	      $status = 'Analysis';
	    }elseif($status == 1)
	    {
	      $status = 'Process';
	    }elseif($status == 2)
	    {
	      $status = 'Pending';
	    }elseif($status == 3)
	    {
	      $status = 'Done';
	    }elseif($status == 4)
	    {
	      $status = 'Failed';
	    }

	    $id_customer=$data_service[0]->id_customer;

	    $data_service_detail=$this->master_model->select_in('ts_service_detail','*',"WHERE id_service=$ID ORDER BY ID ASC");
	    $count_edit=count($data_service_detail);

	    $data_customer=$this->master_model->select_in('ms_customer','name, email, phone, address',"WHERE ID=$id_customer");
			if(count($data_service) == 0)
	    {
	        echo'
	            <script language="javascript">
	                window.alert("No collection data to export on that date!!")
	                window.location.href="'.base_url().'transaction/index/'.$menuid.'";
	            </script>
	        ';
	    }else
	    {
	        $styleArray =
	            array(
	                'borders' =>
	            array(
	            'allborders' =>
	             array(
	                'style' => PHPExcel_Style_Border::BORDER_THIN,
	                'color' =>
	            array(
	                'argb' => '00000000'
	                ),
	            ),
	            ),
	        );

	        $fontHeader = array(
	            'font' => array(
	                'bold' => true
	            ),
	            'alignment' => array(
	                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
	                'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
	                'rotation'   => 0,

	            ),
	            'fill' => array(
	                'type' => PHPExcel_Style_Fill::FILL_SOLID,
	                'color' => array('rgb' => 'F7F7F8')
	            )
	        );

	        $objPHPExcel = new phpexcel();

	        $objPHPExcel->setActiveSheetIndex(0);

	        $objPHPExcel->getActiveSheet()->setTitle('INVOICE');
	        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
	        $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);


	        $objPHPExcel->getActiveSheet()->setCellValue('A13', 'No.');
	        $objPHPExcel->getActiveSheet()->setCellValue('B13', 'Jobs');
	        $objPHPExcel->getActiveSheet()->setCellValue('C13', 'Durations');
	        $objPHPExcel->getActiveSheet()->setCellValue('D13', 'Qty');
	        $objPHPExcel->getActiveSheet()->setCellValue('E13', 'Price');
	        $objPHPExcel->getActiveSheet()->setCellValue('F13', 'Mechanic');
	        $objPHPExcel->getActiveSheet()->setCellValue('G13', 'Pre/Indent');
	        $objPHPExcel->getActiveSheet()->setCellValue('H13', 'Status');
	        $objPHPExcel->getActiveSheet()->setCellValue('I13', 'Subtotal');

	        //print_array($data_service_detail);
	        //exit;

	        for($a=0; $a < count($data_service_detail); $a++)
	        {
							$b=$a+1;
							$id_service_detail=$data_service_detail[$a]->ID;
							$jobs=$data_service_detail[$a]->jobs;
							$durations=$data_service_detail[$a]->durations;
							$qty=$data_service_detail[$a]->qty;
							$price=$data_service_detail[$a]->price;
							$technician=$data_service_detail[$a]->technician;
							$subtotal=$data_service_detail[$a]->subtotal;
							if($data_service_detail[$a]->status==0)
              {
               $status='Unprocess';
              }elseif($data_service_detail[$a]->status==1)
              {
               $status='Process';
              }elseif($data_service_detail[$a]->status==2)
              {
               $status='Pending';
              }elseif($data_service_detail[$a]->status==3)
              {
               $status='Done';
              }elseif($data_service_detail[$a]->status==4)
              {
               $status='Failed';
              }

							if($a == 0)
							{
								$id_pre = 0;
							}else
							{
								$count_pre = $id_service_detail - $pre;

								$id_pre = $b - $count_pre;
							}

	            $isi[]= array('A' => $a+1, 'B' => $jobs, 'C' => $durations.' Hours', 'D' => $qty, 'E' => str_replace(',','.',number_format($price)), 'F' => $technician, 'G' => $id_pre, 'H' => $status, 'I' => str_replace(',','.',number_format($subtotal)));
	        }

	        //print_array($isi);
	        //exit;

	        $objPHPExcel->getActiveSheet()->getStyle('A13:I14')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
	        $objPHPExcel->getActiveSheet()->getStyle('A13:I14')->getFont()->setBold(true);
	        //$objPHPExcel->getActiveSheet()->getStyle('M')->getAlignment()->setWrapText(true);

	        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
	        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);

	        //set merge kolom
	        $objPHPExcel->getActiveSheet()->mergeCells('A1:D2');
					$objPHPExcel->getActiveSheet()->mergeCells('A3:D3');
					$objPHPExcel->getActiveSheet()->mergeCells('A4:D4');
	        $objPHPExcel->getActiveSheet()->mergeCells('E1:I5');
	        $objPHPExcel->getActiveSheet()->mergeCells('A13:A14');
	        $objPHPExcel->getActiveSheet()->mergeCells('B13:B14');
	        $objPHPExcel->getActiveSheet()->mergeCells('C13:C14');
	        $objPHPExcel->getActiveSheet()->mergeCells('D13:D14');
	        $objPHPExcel->getActiveSheet()->mergeCells('E13:E14');
	        $objPHPExcel->getActiveSheet()->mergeCells('F13:F14');
	        $objPHPExcel->getActiveSheet()->mergeCells('G13:G14');
	        $objPHPExcel->getActiveSheet()->mergeCells('H13:H14');
	        $objPHPExcel->getActiveSheet()->mergeCells('I13:I14');

	        //set papersize
	        $objPHPExcel->getActiveSheet()
	            ->getPageSetup()
	            ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
	        $objPHPExcel->getActiveSheet()
	            ->getPageSetup()
	            ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setTop(0.25);
	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setRight(0);
	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setLeft(0);
	        $objPHPExcel->getActiveSheet()
	            ->getPageMargins()->setBottom(0.25);
	        $objPHPExcel->getActiveSheet()
	            ->setShowGridlines(true);

	        //set header kolom
	        $objPHPExcel->getActiveSheet()->setCellValue('A1', 'INVOICE');
	        $objPHPExcel->getActiveSheet()->setCellValue('A3', '#'.$invoice);
					$objPHPExcel->getActiveSheet()->setCellValue('A4', 'Date : '.date('d M Y', strtotime($date_in)));


	        // melakukan pengisian data
	        foreach($isi as $k => $v)
	        {
	            $col = $k + 15;

	            foreach($v as $k1 => $v1)
	            {
	                $column = $k1.$col;
	                $objPHPExcel->getActiveSheet()->setCellValue($column, $v1);
	                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);


	                $subtotal='=SUM(G6:G'.$col.')';

	                //$objPHPExcel->getActiveSheet()->setCellValue('G'.$col, $subtotal);
	            }
	        }
	        $tco=$col+1;

	        //$objPHPExcel->getActiveSheet()->setCellValue('G'.$tco, $subtotal);

	        $objWorksheet = $objPHPExcel->getActiveSheet(0);
	        $objWorksheet->getStyle('A13:'.$column)->applyFromArray($styleArray);

	        $objWorksheet->getStyle('D15:D'.$col)->getNumberFormat()->setFormatCode('#,##0');
	        $objWorksheet->getStyle('E'.$tco)->getNumberFormat()->setFormatCode('#,##0');
	        $objPHPExcel->getActiveSheet()->getStyle('A15:A'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('B15:B'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('C15:C'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);;

	        $objPHPExcel->getActiveSheet()->getStyle('D15:D'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('E15:E'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

					$objPHPExcel->getActiveSheet()->getStyle('F15:F'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

					$objPHPExcel->getActiveSheet()->getStyle('G15:G'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

					$objPHPExcel->getActiveSheet()->getStyle('H15:H'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('I15:I'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

	        $objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getFont()->setBold(true);
	        $objPHPExcel->getActiveSheet()->getStyle('C'.$tco)->getFont()->setBold(true);
	        $objPHPExcel->getActiveSheet()->getStyle('D'.$tco)->getFont()->setBold(true);

	        $objPHPExcel->getActiveSheet()
	        ->getStyle('A6:A'.$col)
	        ->getAlignment()
	        ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
	        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
	        ->setTextRotation(0);





	        $tanggal = date('d M Y');
	        $filename = 'INVOICE #'.$invoice.'.xlsx';

	        //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
	        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache

	        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .XLSX Excel 2007 format
	        $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');

					$objWriter->setPreCalculateFormulas(true);

	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');
	        exit;
	    }
		}

		public function generate_pdf($menuid, $ID)
		{
			ob_start();
			$data['ID']=$ID;
			$this->load->view('service/invoice_pdf', $data);

			$html = ob_get_contents();
	        ob_end_clean();

	    require_once('./assets/html2pdf/html2pdf.class.php');
			$pdf = new HTML2PDF('P','LETTER','en', false, 'ISO-8859-15',array(5, 2, 0, 0));
			$pdf->WriteHTML($html);
			$pdf->Output($ID.'.pdf', 'D');
		}

		public function input_stok($menuid)
		{
			$user_id = $this->session->userdata('user_id');
			$check=$this->master_model->auth_read($user_id, $menuid);
		
			if($check==false)
			{
				redirect('NotAuthorized');
			}else
			{
				$data['data_header']   = $this->master_model->select_in('input_stok','*',"WHERE 1 = 0");
	
				$this->load->view('input_stok/header', $data);
			}
		}

		public function insert_stok1($menuid)
		{
			$user_id = $this->session->userdata('user_id');
			$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
			$user_id1 = $data_admin[0]->name;
	
			$data = array(
				'tanggal' => $this->input->get('tanggal'),
				'id_barang' => $this->input->get('barang'),
				'jumlah' => $this->input->get('jumlah'),
				'created_at' => date('Y-m-d H:i:s'),
				'created_by' => $user_id1
			);	
			$this->db->insert('input_stok', $data);
			
		}
		
		public function insert_stok($menuid)
		{
			//$id_barang= $this->uri->segment(3);
			
			$user_id = $this->session->userdata('user_id');
			$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
			$user_id1 = $data_admin[0]->name;
			
			$id_barang = $this->input->get('barang');
			$check_stok=$this->master_model->mst_check_stock('input_stok', 'id_barang', $id_barang);

			if($check_stok==false)
			{

				$data = array(
					'tanggal' => $this->input->get('tanggal'),
					'tanggal' => $this->input->get('tanggal'),
					'id_barang' => $this->input->get('barang'),
					'jumlah' => $this->input->get('jumlah'),
					'created_at' => date('Y-m-d H:i:s'),
					'created_by' => $user_id1
				);	

				$this->db->insert('input_stok', $data);
			}else{

				$data_stock = $this->master_model->select_in('input_stok', 'id, jumlah', "WHERE id_barang = '$id_barang'");
				for($a=0; $a < count($data_stock); $a++)
				{ 
				$id_stock = $data_stock[0]->id;
				$jumlah = $data_stock[0]->jumlah;
				
				}
			
				$jum = $this->input->get('jumlah');
				$jumlah2 = $jumlah + $jum;
				$data_update = array(
					
					'jumlah' => $jumlah2,
					'created_at' => date('Y-m-d H:i:s'),
					'created_by' => $user_id1
					
				);	

	

				$this->db->where('id', $id_stock);
				$this->db->update('input_stok', $data_update);
			}


		}

		public function insert_pengiriman($menuid)
		{
			$user_id = $this->session->userdata('user_id');
			$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
			$user_id1 = $data_admin[0]->name;
	
			$data = array(
				'no_pengiriman' => $this->input->get('no'),
				'tanggal' => $this->input->get('tanggal'),
				'id_pelanggan' => $this->input->get('cust'),
				'id_barang' => $this->input->get('barang'),
				'jumlah' => $this->input->get('jumlah'),
				'kurir' => '',
				'no_resi' => '',
				'created_at' => date('Y-m-d H:i:s'),
				'created_by' => $user_id1
			);	
			$this->db->insert('input_pengiriman', $data);
			
		}

		function hapus_transaksi(){
			$id = $_GET['id'];
			$this->db->where('id',$id);
			$this->db->delete('input_stok');
		}

		function hapus_transaksi_kirim(){
			$id = $_GET['id'];
			$this->db->where('id',$id);
			$this->db->delete('input_pengiriman');
		}

	
		public function getCust()
		{	
			$id = $_GET['id'];
					
			$cust = $this->master_model->select_in('ms_customer','*',"where id = $id");
	
			$data_cust = array('nama'   =>  $cust[0]->nama,
			'tlp'  	=>  $cust[0]->tlp, 
			'alamat'  	=>  $cust[0]->alamat	);
			echo json_encode($data_cust);
			
		}
	

		function list_transaksi(){
			$tanggal = $_GET['tanggal'];
			echo "<table id='example1' class='table table-bordered table-striped'>
					<thead><tr><th>No</th><th>Model</th><th>Kategori</th><th>Merek</th><th>Warna</th><th>Ukuran</th><th>Jumlah</th><th>Aksi</th></tr></thead>";
			$sql = "SELECT a.jumlah, b.model, c.kategori as kategori_desc, d.merek as merek_desc,
					e.warna as warna_desc, f.ukuran as ukuran_desc, a.id
					FROM input_stok a left join mspersediaan b on a.id_barang=b.id
					left join mst_kategori c on b.kategori=c.id
					left join mst_merek d on b.merek=d.id
					left join mst_warna e on b.warna=e.id
					left join mst_ukuran f on b.ukuran=f.id
					WHERE a.tanggal='$tanggal'";
			
			$list = $this->db->query($sql)->result();
			$no=1;
			foreach ($list as $row){
				echo "<tr>
					<td width='10'>$no</td>
					<td>$row->model</td>
					<td>$row->kategori_desc</td>
					<td>$row->merek_desc</td>
					<td>$row->warna_desc</td>
					<td>$row->ukuran_desc</td>
					<td>$row->jumlah</td>
					<td onClick='hapus($row->id)'><button class='btn btn-danger btn-sm'>Hapus</button></td>
					</tr>";
				$no++;
			}
			echo" </table>";
		}

		
		function list_transaksi_kirim(){
			$no = $_GET['no'];
			echo "<table id='example1' class='table table-bordered table-striped'>
					<thead><tr><th>No</th><th>Model</th><th>Kategori</th><th>Merek</th><th>Warna</th><th>Ukuran</th><th>Jumlah</th><th>Aksi</th></tr></thead>";
			$sql = "SELECT a.jumlah, b.model, c.kategori as kategori_desc, d.merek as merek_desc,
					e.warna as warna_desc, f.ukuran as ukuran_desc, a.id
					FROM input_pengiriman a left join mspersediaan b on a.id_barang=b.id
					left join mst_kategori c on b.kategori=c.id
					left join mst_merek d on b.merek=d.id
					left join mst_warna e on b.warna=e.id
					left join mst_ukuran f on b.ukuran=f.id
					WHERE a.no_pengiriman='$no'";
			
			$list = $this->db->query($sql)->result();
			$no=1;
			foreach ($list as $row){
				echo "<tr>
					<td width='10'>$no</td>
					<td>$row->model</td>
					<td>$row->kategori_desc</td>
					<td>$row->merek_desc</td>
					<td>$row->warna_desc</td>
					<td>$row->ukuran_desc</td>
					<td>$row->jumlah</td>
					<td onClick='hapus($row->id)'><button class='btn btn-danger btn-sm'>Hapus</button></td>
					</tr>";
				$no++;
			}
			echo" </table>";
		}

		public function input_pengiriman($menuid)
		{
			$user_id = $this->session->userdata('user_id');
			$check=$this->master_model->auth_read($user_id, $menuid);
		
			if($check==false)
			{
				redirect('NotAuthorized');
			}else
			{
				$data['data_header']   = $this->master_model->select_in('input_pengiriman','*',"WHERE 1 = 0");
	
				$this->load->view('input_pengiriman/header', $data);
			}
		}
		
			public function input_pengiriman2($menuid)
		{
			$user_id = $this->session->userdata('user_id');
			$check=$this->master_model->auth_read($user_id, $menuid);

			$tgl = $this->input->post('tanggal_beli');
			$cust = $this->input->post('id_cust');
	
			if (empty($tgl)){
				$tgl = $this->session->userdata('tanggal_beli');
				$cust = $this->session->userdata('id_cust');
			}	

			if($check==false)
			{
				redirect('NotAuthorized');
			}else
			{
				$data['data_header']   = $this->master_model->select_in('input_pengiriman','*',"WHERE 1 = 0");
	
				$this->load->view('input_pengiriman/header2', $data);
			}
		}

		public function input_resi($menuid)
		{
			$user_id = $this->session->userdata('user_id');
			$check=$this->master_model->auth_read($user_id, $menuid);
		
			if($check==false)
			{
				redirect('NotAuthorized');
			}else
			{
				$data['data_header']   = $this->master_model->select_in('input_pengiriman','*',"WHERE 1 = 0");
	
				$this->load->view('input_resi/header', $data);
			}
		}
		
		public function input_resi2($menuid)
		{
			$user_id = $this->session->userdata('user_id');
			$check=$this->master_model->auth_read($user_id, $menuid);

			$date1 = $this->input->post('from_date');
			$date2 = $this->input->post('to_date');
	
			if (empty($date1)){
				$date1 = $this->session->userdata('date1');
				$date2 = $this->session->userdata('date2');
			}	

			if($check==false)
			{
				redirect('NotAuthorized');
			}else
			{
				$data['data_header']   = $this->transaksi_model->listResi($date1, $date2);
				$this->load->view('input_resi/header2', $data);
			}
		}

		function list_pengiriman(){
			$menuid=$this->uri->segment(3);
			$tanggal = $_GET['tanggal'];
			echo "<table id='example1' class='table table-bordered table-striped'>
					<thead>
					<tr><th>No</th>
					<th>No. Pengiriman</th>
					<th>Nama Pelanggan</th>
					<th>Telepon</th>
					<th>Alamat</th>
					<th>Kurir</th>
					<th>Tambah Resi</th>
					<th>No. Resi</th>
					<th>Aksi</th>
					<th>Aksi</th>
					</tr>
					</thead>";
			$sql = "SELECT distinct a.id, a.no_pengiriman, a.id_pelanggan, b.nama, b.tlp, b.alamat, a.kurir, a.no_resi, ifnull(c.kurir,'') as kurir_d 
					FROM input_pengiriman a left join ms_customer b on a.id_pelanggan=b.id 
					left join mst_kurir c on a.kurir = c.id
					WHERE a.tanggal='$tanggal'";
			
			$list = $this->db->query($sql)->result();
			$no=1;
			foreach ($list as $row){
				$id = $row->id;
				echo "
				<h2>Hasil: <span id='hasil'></span></h2>
					<!--<form action=''.base_url().'transaction/update_resi/' method='post' enctype='multipart/form-data'>	-->
					<tr>
					<td width='10'>$id</td>
					<td>$row->no_pengiriman</td>
					<td>$row->nama</td>
					<td>$row->tlp</td>
					<td>$row->alamat</td>
					<td>$row->kurir_d</td>
					<td style='text-align:center'>
					<a class='edit text-green'  alt='$id'  id='add_button' data-toggle='modal' data-target='#edit-modal' style='cursor:pointer'>
					
						<i class='fa fa-plus-square'></i>
					</a>

				
				</a>
				 </td>

				 <td>
				 <a data-toggle='modal'  alt='$id' data-target='#myModal' class='btn btn-info btn-fill pull-right'>Tambah Agency</a>
				 </td>

					<td><input type='text' name='no_resi' id='no_resi' class='form-control' required='required' value='$row->no_resi'></td>
					
					<td onClick='simpan($row->id)'><button type='submit' value='1' name='submit' id ='tombol_form' class='btn btn-danger btn-fill pull-right save_phone save_email'>Simpan </button></td>
					</tr>

					<script>
						document.getElementById('tombol_form').
						addEventListener('click', tampilkan_nilai_form);



						function tampilkan_nilai_form(){
							
							var nilai_form=document.getElementById('no_resi').value;
							
							$.ajax({
								url: ''.base_url().'transaction/update_resi,
								type: 'POST',
								dataType: 'html',
								data:'no_resi='+nilai_form,
								cache: false,
								success: function(response) {
									$('#pesan').html(response);
								}
							})
						}
					</script>
					</form>";
				$no++;
			}
			echo" </table>";

			echo"<div class='modal fade' id='edit-modal' role='dialog'>
			<div class='modal-dialog'>
				<div class='modal-content edit-modal' style='z-index:9999'>
				</div>
		  </div>
	 </div>
	 <script>
	 $(document).ready(function(e)
	 {
		 $('.edit').click(function()
		 {
			  var id = $(this).attr('alt');

				 $.ajax({
				  type: 'POST',
				  dataType: 'html',
				
				  url: ''.base_url().'transaction/edit_agency/'.$menuid.'' 
				  data:'id='+id,
				  success: function(msg)
				  {
						 $('.edit-modal').html(msg);
				  }
				 });
		 });
	 });
 </script>
	 ";
		}

		public function update_resi()
		{
			$user_id = $this->session->userdata('user_id');
			$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
			$user_id1 = $data_admin[0]->name;

	
			$id = $_GET['id'];
			$no_resi = $_GET['no_resi'];
			
			$data = array(
				'no_resi' => $no_resi,
				'updated_at' => date('Y-m-d H:i:s'),
				'updated_by' => $user_id1
			);	
		
			$this->db->where('id', $id);
			$this->db->update('input_pengiriman', $data);
	

			// redirect('master_persediaan/daftar_persediaan/'.$menuid);
		}

			public function update_resi2($menuid)
		{
			$user_id = $this->session->userdata('user_id');
			$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
			$user_id1 = $data_admin[0]->name;

	
			
			
			$no_resi = $this->input->post('no_resi');
			$id = $this->input->post('id');

		

			
			$data = array(
				'no_resi' => $no_resi,
				'updated_at' => date('Y-m-d H:i:s'),
				'updated_by' => $user_id1
			
			);	
		
			$this->db->where('id', $id);
			$this->db->update('input_pengiriman', $data);
	

			redirect('transaction/input_resi/'.$menuid);
		}

		public function insert_kategori_resi($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$no_resi = $this->input->post('no_resi');

	
		$data = array(
		
			'no_resi' => $no_resi,
		);

		$this->db->insert('resi', $data);
		
		$this->load->view('input_resi/header');
	}


	public function edit_agency($menuid)
	{
		$id = $this->input->post('id');
		print_r($id);
		die;
		$edit_agency = $this->master_model->mst_data_edit_agency('msAgency', $id_agen);
		
		
		echo'
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title">Edit Data Agency</h4>
		</div>
				<form action="'.base_url().'master/edit_process_agency/'.$menuid.'/'.$id_agen.'" method="post" enctype="multipart/form-data">
						<div class="modal-body">

								<div class="form-group">
										<label>Nama Agen *</label>
										<input type="text" name="nama_agen" value="" class="form-control" placeholder="Nama Agen" required="required">
								</div>
								
							

								<div class="form-group">
								
								</div>

								<div class="modal-footer">
									<button type="submit" value="1" name="submit" class="btn btn-danger btn-fill pull-right save_phone save_email">Save And Close</button>
										
								</div>
				</form>
		';
	}
	

}
?>
