<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class pengajuan_pinjaman extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('pinjaman_model');
  	}

	public function list($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_pengajuan'] = $this->pinjaman_model->pengajuanPinjaman();

    		$this->load->view('pengajuan/list', $data);
	    }
	}

	public function input_pengajuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengajuan']    = $this->master_model->select_in('pengajuan_pinjaman','*',"order by id");

    		$this->load->view('pengajuan/input_pengajuan', $data);
	    }
	}

	public function insert_pengajuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$data = array(			
			'no_rkp' => $this->input->post('no_rkp'),
			'tgl_rkp' => $this->input->post('tgl_rkp'),
			'no_rkp_sebelum' => $this->input->post('no_rkp_sebelum'),
			'ms_external' => $this->input->post('ms_external'),
			'id_anggota' => $this->input->post('id_anggota'),
			'tujuan_pinjaman' => $this->input->post('tujuan_pinjaman'),
			'pekerjaan' => $this->input->post('pekerjaan'),
			'id_kategori_usaha' => $this->input->post('id_kategori_usaha'),
			'sektor_ekonomi' => $this->input->post('sektor_ekonomi'),
			'id_jenis_pinjaman' => $this->input->post('id_jenis_pinjaman'),
			'penyusun1' => $this->input->post('penyusun1'),
			'penyusun2' => $this->input->post('penyusun2'),
			'penyusun3' => $this->input->post('penyusun3'),
			'penyusun4' => $this->input->post('penyusun4'),
			'komite' => $this->input->post('komite'),
			'ada_penjamin' => $this->input->post('ada_penjamin'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('pengajuan_pinjaman', $data);

		$data_edit=$this->pinjaman_model->getLastID();
		$lastID = $data_edit[0]->last_id;
		
		$data = array(			
			'id_pengajuan' => $lastID,
			'analisa' => '',
			'catatan_pendapatan' => '',
			'kesimpulan' => '',
			'catatan_biaya_ops' => '',
			'catatan_biaya_hdp' => '',
			'catatan_kemampuan' => '',
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('analisa_personal', $data);

		$data = array(			
			'id_pengajuan' => $lastID,
			'analisa_agunan' => '',
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('analisa_agunan', $data);

		$data = array(			
			'id_pengajuan' => $lastID,
			'catatan' => '',
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('catatan_rekap_rekening', $data);

		$data = array(			
			'id_pengajuan' => $lastID,
			'catatan_agunan_rkp' => '',
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('catatan_agunan_rkp', $data);

		redirect('pengajuan_pinjaman/list/'.$menuid);
	}	

	public function edit_pengajuan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengajuan']    = $this->master_model->select_in('pengajuan_pinjaman','*',"WHERE id = $id");

    		$this->load->view('pengajuan/edit_pengajuan', $data);
	    }
	}

	public function update_pengajuan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$data = array(			
			'no_rkp' => $this->input->post('no_rkp'),			
			'tgl_rkp' => $this->input->post('tgl_rkp'),
			'no_rkp_sebelum' => $this->input->post('no_rkp_sebelum'),
			'ms_external' => $this->input->post('ms_external'),
			'id_anggota' => $this->input->post('id_anggota'),
			'tujuan_pinjaman' => $this->input->post('tujuan_pinjaman'),
			'pekerjaan' => $this->input->post('pekerjaan'),
			'id_kategori_usaha' => $this->input->post('id_kategori_usaha'),
			'sektor_ekonomi' => $this->input->post('sektor_ekonomi'),
			'id_jenis_pinjaman' => $this->input->post('id_jenis_pinjaman'),
			'penyusun1' => $this->input->post('penyusun1'),
			'penyusun2' => $this->input->post('penyusun2'),
			'penyusun3' => $this->input->post('penyusun3'),
			'penyusun4' => $this->input->post('penyusun4'),
			'komite' => $this->input->post('komite'),
			'ada_penjamin' => $this->input->post('ada_penjamin'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('pengajuan_pinjaman', $data);

		redirect('pengajuan_pinjaman/list/'.$menuid);
	}	

	public function fasilitas($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_fasilitas']    = $this->pinjaman_model->fasilitas($id);

    		$this->load->view('pengajuan/fasilitas', $data);
	    }
	}

	public function input_fasilitas($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_fasilitas']    = $this->master_model->select_in('fasilitas_pinjaman', '*', "WHERE 1=0");

    		$this->load->view('pengajuan/input_fasilitas', $data);
	    }
	}
	
	public function insert_fasilitas($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$pinj = $this->input->post('baki_debet')+$this->input->post('usulan_pinjaman');
		$waktu = $this->input->post('jangka_waktu');
		$bunga = $this->input->post('bunga_tahun');
		$jenis = $this->input->post('id_perhitungan_bunga');
		if($jenis == 1) { //Flat
			$ang_pokok = $pinj / $waktu;
			$ang_bunga = $pinj * (($bunga / 12)/100);
			$angsuran = $ang_pokok + $ang_bunga;
		}
		if($jenis == 2) { //Sliding
			$ang_pokok = 0;
			$ang_bunga = $pinj * (($bunga / 12)/100);
			$angsuran = $ang_pokok + $ang_bunga;
		}
		
		$idRKP = $this->input->post('id_pengajuan');
		$data = array(			
			'id_pengajuan' => $idRKP,
			'id_jenis_pinjaman' => $this->input->post('id_jenis_pinjaman'),
			'id_perhitungan_bunga' => $this->input->post('id_perhitungan_bunga'),
			'plafond_awal' => $this->input->post('plafond_awal'),
			'baki_debet' => $this->input->post('baki_debet'),
			'usulan_pinjaman' => $this->input->post('usulan_pinjaman'),
			'plafond_akhir' => $pinj,
			'jangka_waktu' => $this->input->post('jangka_waktu'),
			'bunga_tahun' => $this->input->post('bunga_tahun'),
			'provisi' => $this->input->post('provisi'),
			'komisi' => $this->input->post('komisi'),
			'tujuan_pengajuan' => $this->input->post('tujuan_pengajuan'),
			'is_map' => $this->input->post('is_map'),
			'no_rek_pinjaman' => $this->input->post('no_rek_pinjaman'),
			'periode_awal' => $this->input->post('periode_awal'),
			'periode_akhir' => $this->input->post('periode_akhir'),
			'keterangan' => $this->input->post('keterangan'),
			'angsuran_bulan' => $angsuran,
			'angsuran_pokok' => $ang_pokok,
			'angsuran_bunga' => $ang_bunga,
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('fasilitas_pinjaman', $data);


		redirect('pengajuan_pinjaman/fasilitas/'.$menuid.'/'.$idRKP);
	}	

	public function edit_fasilitas($menuid, $idRKP, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_fasilitas']    = $this->master_model->select_in('fasilitas_pinjaman', '*', "WHERE id_pengajuan = $idRKP and id = $id");

    		$this->load->view('pengajuan/edit_fasilitas', $data);
	    }
	}
	
	public function update_fasilitas($menuid, $idRKP, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
				
		$pinj = $this->input->post('baki_debet')+$this->input->post('usulan_pinjaman');
		$waktu = $this->input->post('jangka_waktu');
		$bunga = $this->input->post('bunga_tahun');
		$jenis = $this->input->post('id_perhitungan_bunga');
		if($jenis == 1) { //Flat
			$ang_pokok = $pinj / $waktu;
			$ang_bunga = $pinj * (($bunga / 12)/100);
			$angsuran = $ang_pokok + $ang_bunga;
		}
		if($jenis == 2) { //Sliding
			$ang_pokok = 0;
			$ang_bunga = $pinj * (($bunga / 12)/100);
			$angsuran = $ang_pokok + $ang_bunga;
		}
		$data = array(						
			'id_jenis_pinjaman' => $this->input->post('id_jenis_pinjaman'),
			'id_perhitungan_bunga' => $this->input->post('id_perhitungan_bunga'),
			'plafond_awal' => str_replace('.', '', $this->input->post('plafond_awal')),			
			'baki_debet' => $this->input->post('baki_debet'),
			'usulan_pinjaman' => $this->input->post('usulan_pinjaman'),
			'plafond_akhir' => $pinj,
			'jangka_waktu' => $this->input->post('jangka_waktu'),
			'bunga_tahun' => $this->input->post('bunga_tahun'),
			'provisi' => $this->input->post('provisi'),
			'komisi' => $this->input->post('komisi'),
			'tujuan_pengajuan' => $this->input->post('tujuan_pengajuan'),
			'is_map' => $this->input->post('is_map'),
			'no_rek_pinjaman' => $this->input->post('no_rek_pinjaman'),
			'periode_awal' => $this->input->post('periode_awal'),
			'periode_akhir' => $this->input->post('periode_akhir'),
			'keterangan' => $this->input->post('keterangan'),
			'angsuran_bulan' => $angsuran,
			'angsuran_pokok' => $ang_pokok,
			'angsuran_bunga' => $ang_bunga,
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('fasilitas_pinjaman', $data);

		redirect('pengajuan_pinjaman/fasilitas/'.$menuid.'/'.$idRKP);
	}	

	public function delete_fasilitas($menuid, $idRKP, $id)
	{
		$this->db->where('id', $id);
		$this->db->delete('fasilitas_pinjaman');

		redirect('pengajuan_pinjaman/fasilitas/'.$menuid.'/'.$idRKP);
	}

	public function jaminan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jaminan']    = $this->pinjaman_model->jaminan($id);
			$data['data_analisa'] 	 = $this->master_model->select_in('analisa_agunan', '*', "WHERE id_pengajuan = $id");
			$data['data_agunan'] 	 = $this->master_model->select_in('catatan_agunan_rkp', '*', "WHERE id_pengajuan = $id");

    		$this->load->view('pengajuan/jaminan', $data);
	    }
	}

	public function insert_jaminan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$jns= $this->input->post('id_jenis_jaminan');
		$jenis = $this->master_model->select_in('jenis_jaminan', 'kode_jenis', "WHERE id = $jns");
		$kode = $jenis[0]->kode_jenis;

		$data = array(			
			'id_jenis_jaminan' => $this->input->post('id_jenis_jaminan'),
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			// 'prosen_taksasi' => $this->input->post('prosen_taksasi'),
			'nilai_ht_fidusia' => $this->input->post('nilai_ht_fidusia'),
			'catatan_rkp' => $this->input->post('catatan_rkp'),
			// 'analisa_agunan_map' => $this->input->post('analisa_agunan_map'),
// 			'informasi_nilai_pasar' => $this->input->post('informasi_nilai_pasar'),
			'catatan_agunan' => $this->input->post('catatan_agunan'),			
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('jaminan_pinjaman_header', $data);

		$last=$this->pinjaman_model->getLastIDJaminan();
		$jID = $last[0]->last_id;	

		$sql="insert into jaminan_pinjaman_detail (id_header, id_jenis_jaminan, ket_jaminan, create_at, create_by, update_at, update_by)
			select $jID, id, '', now(), $user_id, now(), $user_id from jenis_jaminan where jaminan_path like '%$kode%' order by jaminan_path;";
		$qry = $this->db->query($sql);
		
		$data = array(
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'id_header' => $jID,
			'catatan_nilai_pasar' => '',
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('catatan_nilai_pasar', $data);

		redirect('pengajuan_pinjaman/jaminan/'.$menuid.'/'.$id);
	}
	
	public function update_jaminan_detail($menuid, $idRKP, $idHeader)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$datajaminan = $this->master_model->select_in('jaminan_pinjaman_detail', '*', "WHERE id_header = $idHeader order by id");
		$i = 1; 
		foreach($datajaminan as $by){
			$id = $this->input->post('id'.$i);
			$data = array(			
				'ket_jaminan' => $this->input->post('ket_jaminan'.$i),
				'update_at' => date('Y-m-d H:i:s'),
				'update_by' => $user_id1
			);	
			$this->db->where('id', $id);
			$this->db->update('jaminan_pinjaman_detail', $data);
	
			$i++; 		
		}

		redirect('pengajuan_pinjaman/jaminan/'.$menuid.'/'.$idRKP);
	}	


	public function delete_jaminan($menuid, $idRKP, $ID)
	{
		$this->db->where('id_header', $ID);
		$this->db->delete('jaminan_pinjaman_detail');

		$this->db->where('id_header', $ID);
		$this->db->delete('jaminan_pinjaman_foto');

		$this->db->where('id', $ID);
		$this->db->delete('jaminan_pinjaman_header');

		$this->db->where('id_header', $ID);
		$this->db->delete('jaminan_nilai_pasar');

		$sql="delete from survey_nilai_pasar_detail where id_survey in (select id from survey_nilai_pasar_header where id_header = $ID);";
		$qry = $this->db->query($sql);

		$this->db->where('id_header', $ID);
		$this->db->delete('survey_nilai_pasar_header');

		redirect('pengajuan_pinjaman/jaminan/'.$menuid.'/'.$idRKP);
	}

	public function jaminan_detail($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jaminan_detail']    = $this->pinjaman_model->jaminanDetail($id);

    		$this->load->view('pengajuan/jaminan_detail', $data);
	    }
	}

	public function insert_jaminan_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id_header');
		$data = array(			
			'id_header' => $this->input->post('id_header'),
			'id_jenis_jaminan' => $this->input->post('id_jenis_jaminan'),
			'ket_jaminan' => $this->input->post('ket_jaminan'),			
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('jaminan_pinjaman_detail', $data);
		redirect('pengajuan_pinjaman/jaminan_detail/'.$menuid.'/'.$id);
	}

	public function delete_jaminan_detail($menuid, $idHeader, $ID)
	{
		$this->db->where('id', $ID);
		$this->db->delete('jaminan_pinjaman_detail');
		redirect('pengajuan_pinjaman/jaminan_detail/'.$menuid.'/'.$idHeader);
	}


	public function foto_jaminan($menuid, $id, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_foto'] = $this->master_model->select_in('jaminan_pinjaman_foto','*',"WHERE id_header = $id");

    		$this->load->view('pengajuan/foto_detail', $data);
	    }
	}

	public function insert_foto($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$this->load->helper(array('form', 'url')); 
		$photokiri = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'gif|jpg|png|jpeg|bmp|pdf';
		$config['max_size'] = '2048';
		// $config['max_width']  = '1288';
		// $config['max_height']  = '768';
		
		$this->upload->initialize($config);
		  if(!$this->upload->do_upload('foto_kiri')){
			  $photokiri="";
		  }else{
			  $photokiri=$this->upload->file_name;
		}

		$this->load->helper(array('form', 'url')); 
		$photokanan = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'gif|jpg|png|jpeg|bmp|pdf';
		$config['max_size'] = '2048';
		// $config['max_width']  = '1288';
		// $config['max_height']  = '768';
		
		$this->upload->initialize($config);
		  if(!$this->upload->do_upload('foto_kanan')){
			  $photokanan="";
		  }else{
			  $photokanan=$this->upload->file_name;
		}
		$id = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');
		$data = array(
			'id_header' => $this->input->post('id_header'),
			'keterangan_kiri' => $this->input->post('keterangan_kiri'),			
			'foto_kiri' => $photokiri,
			'keterangan_kanan' => $this->input->post('keterangan_kanan'),			
			'foto_kanan' => $photokanan,
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);
		$this->db->insert('jaminan_pinjaman_foto', $data);
		redirect('pengajuan_pinjaman/foto_jaminan/'.$menuid.'/'.$id.'/'.$idRKP);
	}

	public function delete_foto_jaminan($menuid, $id, $idHdr, $idRKP)
	{
		$this->db->where('id', $id);
		$this->db->delete('jaminan_pinjaman_foto');

		redirect('pengajuan_pinjaman/foto_jaminan/'.$menuid.'/'.$idHdr.'/'.$idRKP);
	}

	public function analisa($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_analisa'] = $this->master_model->select_in('analisa_personal','*',"WHERE id_pengajuan = $id");

    		$this->load->view('pengajuan/analisa_pinjaman', $data);
	    }
	}

	public function update_analisa_personal($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(			
			'analisa' => $this->input->post('analisa'),
			'catatan_pendapatan' => $this->input->post('catatan'),
			'kesimpulan' => $this->input->post('kesimpulan'),
			'catatan_biaya_ops' => $this->input->post('catatan_biaya_ops'),
			'catatan_biaya_hdp' => $this->input->post('catatan_biaya_hdp'),
			'catatan_kemampuan' => $this->input->post('catatan_kemampuan'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id_pengajuan', $id);
		$this->db->update('analisa_personal', $data);

		redirect('pengajuan_pinjaman/analisa/'.$menuid.'/'.$id);
	}	

	public function analisa_biaya_hidup($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_bhidup'] = $this->master_model->select_in('analisa_biaya_hidup','*',"WHERE id_pengajuan = $id order by id");

    		$this->load->view('pengajuan/biaya_hidup', $data);
	    }
	}

	public function insert_analisa_biaya_hidup($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id_pengajuan');
		$data = array(			
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),			
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('analisa_biaya_hidup', $data);
		redirect('pengajuan_pinjaman/analisa_biaya_hidup/'.$menuid.'/'.$id);
	}

	public function update_analisa_biaya_hidup($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$idRKP = $this->input->post('id_pengajuan');
		$id = $this->input->post('id');
		$data = array(						
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),		
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('analisa_biaya_hidup', $data);

		redirect('pengajuan_pinjaman/analisa_biaya_hidup/'.$menuid.'/'.$idRKP);
	}	

	public function delete_analisa_biaya_hidup($menuid, $id, $idRKP)
	{
		$this->db->where('id', $id);
		$this->db->delete('analisa_biaya_hidup');

		redirect('pengajuan_pinjaman/analisa_biaya_hidup/'.$menuid.'/'.$idRKP);
	}


	public function analisa_biaya_operasional($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_bopr'] = $this->master_model->select_in('analisa_biaya_operasional','*',"WHERE id_pengajuan = $id order by id");

    		$this->load->view('pengajuan/biaya_operasional', $data);
	    }
	}

	public function insert_analisa_biaya_operasional($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id_pengajuan');
		$data = array(			
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),			
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('analisa_biaya_operasional', $data);
		redirect('pengajuan_pinjaman/analisa_biaya_operasional/'.$menuid.'/'.$id);
	}

	public function update_analisa_biaya_operasional($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$idRKP = $this->input->post('id_pengajuan');
		$id = $this->input->post('id');
		$data = array(						
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),		
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('analisa_biaya_operasional', $data);

		redirect('pengajuan_pinjaman/analisa_biaya_operasional/'.$menuid.'/'.$idRKP);
	}

	public function delete_analisa_biaya_operasional($menuid, $id, $idRKP)
	{
		$this->db->where('id', $id);
		$this->db->delete('analisa_biaya_operasional');

		redirect('pengajuan_pinjaman/analisa_biaya_operasional/'.$menuid.'/'.$idRKP);
	}


	public function analisa_kemampuan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pend'] = $this->master_model->select_in('viewpendapatan','*',"WHERE id_pengajuan = $id order by create_at");
			$data['data_biaya'] = $this->pinjaman_model->spViewBiaya($id);

    		$this->load->view('pengajuan/kemampuan', $data);
	    }
	}

	public function insert_analisa_kemampuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id_pengajuan');
		$data = array(			
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),			
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('analisa_kemampuan', $data);
		redirect('pengajuan_pinjaman/analisa_kemampuan/'.$menuid.'/'.$id);
	}

	public function analisa_pendapatan_usaha($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pend'] = $this->master_model->select_in('pendapatan_usaha_header','*',"WHERE id_pengajuan = $id order by id");

    		$this->load->view('pengajuan/pendapatan_usaha', $data);
	    }
	}

	public function insert_pendapatan_usaha_header($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id_pengajuan');
		$data = array(			
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'hpp' => $this->input->post('hpp'),			
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('pendapatan_usaha_header', $data);
		redirect('pengajuan_pinjaman/analisa_pendapatan_usaha/'.$menuid.'/'.$id);
	}

	public function update_pendapatan_usaha_header($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$idRKP = $this->input->post('id_pengajuan');
		$id = $this->input->post('id');
		$data = array(			
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'hpp' => $this->input->post('hpp'),			
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('pendapatan_usaha_header', $data);

		redirect('pengajuan_pinjaman/analisa_pendapatan_usaha/'.$menuid.'/'.$idRKP);
	}

	public function delete_pendapatan_usaha_header($menuid, $id, $idRKP)
	{
		$this->db->where('id', $id);
		$this->db->delete('pendapatan_usaha_header');

		$this->db->where('id_header', $id);
		$this->db->delete('pendapatan_usaha_detail');

		redirect('pengajuan_pinjaman/analisa_pendapatan_usaha/'.$menuid.'/'.$idRKP);
	}

	public function analisa_pendapatan_usaha_detail($menuid, $id, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$check=$this->master_model->auth_read($user_id, $menuid);
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$qry = $this->master_model->select_in('pendapatan_usaha_detail', 'count(id) as rec', "WHERE id_header = $id");
		$rec = $qry[0]->rec;

		$qry = $this->master_model->select_in('pendapatan_usaha_detail', 'sum(nominal) as tot', "WHERE id_header = $id");
		$tot = $qry[0]->tot;

		if($rec==0){
			$rata=0;
		}else{
			$rata = $tot / $rec;
		}

		$data = array(			
			'rata_rata_omset' => $rata,
			'total' => $tot,
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('pendapatan_usaha_header', $data);

		$sql="update pendapatan_usaha_header set nett = case when hpp > 0 then rata_rata_omset - (rata_rata_omset * (hpp/100)) else total end where id = $id;";
		$qry = $this->db->query($sql);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pend'] = $this->master_model->select_in('pendapatan_usaha_detail','*',"WHERE id_header = $id order by id");

    		$this->load->view('pengajuan/pendapatan_usaha_detail', $data);
	    }
	}

	public function insert_pendapatan_usaha_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');
		$data = array(			
			'id_header' => $this->input->post('id_header'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),	
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('pendapatan_usaha_detail', $data);		
		redirect('pengajuan_pinjaman/analisa_pendapatan_usaha_detail/'.$menuid.'/'.$id.'/'.$idRKP);
	}

	public function update_pendapatan_usaha_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$idHdr = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');
		$id = $this->input->post('id');
		$data = array(						
			'id_header' => $this->input->post('id_header'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),		
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('pendapatan_usaha_detail', $data);

		redirect('pengajuan_pinjaman/analisa_pendapatan_usaha_detail/'.$menuid.'/'.$idHdr.'/'.$idRKP);
	}	

	public function delete_pendapatan_usaha_detail($menuid, $idHdr, $idRKP, $id)
	{
		$this->db->where('id', $id);
		$this->db->delete('pendapatan_usaha_detail');

		redirect('pengajuan_pinjaman/analisa_pendapatan_usaha_detail/'.$menuid.'/'.$idHdr.'/'.$idRKP);
	}

	public function analisa_pendapatan_lain($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_plain'] = $this->master_model->select_in('pendapatan_lain','*',"WHERE id_pengajuan = $id order by id");

    		$this->load->view('pengajuan/pendapatan_lain', $data);
	    }
	}

	public function insert_pendapatan_lain($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id_pengajuan');
		$data = array(			
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('pendapatan_lain', $data);
		redirect('pengajuan_pinjaman/analisa_pendapatan_lain/'.$menuid.'/'.$id);
	}

	public function update_pendapatan_lain($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$idRKP = $this->input->post('id_pengajuan');
		$id = $this->input->post('id');
		$data = array(						
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),		
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('pendapatan_lain', $data);

		redirect('pengajuan_pinjaman/analisa_pendapatan_lain/'.$menuid.'/'.$idRKP);
	}	

	public function delete_pendapatan_lain($menuid, $id, $idRKP)
	{
		$this->db->where('id', $id);
		$this->db->delete('pendapatan_lain');

		redirect('pengajuan_pinjaman/analisa_pendapatan_lain/'.$menuid.'/'.$idRKP);
	}

	public function analisa_biaya_lain($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_blain'] = $this->master_model->select_in('biaya_lain','*',"WHERE id_pengajuan = $id order by id");

    		$this->load->view('pengajuan/biaya_lain', $data);
	    }
	}

	public function insert_biaya_lain($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id_pengajuan');
		$data = array(			
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),
			'is_sw' => $this->input->post('sw'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('biaya_lain', $data);
		redirect('pengajuan_pinjaman/analisa_biaya_lain/'.$menuid.'/'.$id);
	}

	public function update_biaya_lain($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$idRKP = $this->input->post('id_pengajuan');
		$id = $this->input->post('id');
		$data = array(						
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),	
			'is_sw' => $this->input->post('sw'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('biaya_lain', $data);

		redirect('pengajuan_pinjaman/analisa_biaya_lain/'.$menuid.'/'.$idRKP);
	}	

	public function delete_analisa_biaya_lain($menuid, $id, $idRKP)
	{
		$this->db->where('id', $id);
		$this->db->delete('biaya_lain');

		redirect('pengajuan_pinjaman/analisa_biaya_lain/'.$menuid.'/'.$idRKP);
	}

	public function mutasi_rekening($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_rek'] = $this->master_model->select_in('rekening_header','*',"WHERE id_pengajuan = $id order by id");
			$data['data_rekaprek'] = $this->master_model->select_in('catatan_rekap_rekening','*',"WHERE id_pengajuan = $id");

    		$this->load->view('pengajuan/mutasi_rekening', $data);
	    }
	}

	public function insert_mutasi_rekening_header($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id_pengajuan');
		$data = array(			
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'nama_bank' => $this->input->post('nama_bank'),
			'jenis_rekening' => $this->input->post('jenis_rekening'),
			'no_rekening' => $this->input->post('no_rekening'),			
			'atas_nama' => $this->input->post('atas_nama'),			
			'catatan' => $this->input->post('catatan'),	
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('rekening_header', $data);
		redirect('pengajuan_pinjaman/mutasi_rekening/'.$menuid.'/'.$id);
	}

	public function update_mutasi_rekening_header($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$idRKP = $this->input->post('id_pengajuan');
		$id = $this->input->post('id');
		$data = array(			
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'nama_bank' => $this->input->post('nama_bank'),
			'jenis_rekening' => $this->input->post('jenis_rekening'),
			'no_rekening' => $this->input->post('no_rekening'),			
			'atas_nama' => $this->input->post('atas_nama'),			
			'catatan' => $this->input->post('catatan'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('rekening_header', $data);

		redirect('pengajuan_pinjaman/mutasi_rekening/'.$menuid.'/'.$idRKP);
	}

	public function delete_mutasi_rekening_header($menuid, $id, $idRKP)
	{
		$this->db->where('id', $id);
		$this->db->delete('rekening_header');

		$this->db->where('id_header', $id);
		$this->db->delete('rekening_detail');

		redirect('pengajuan_pinjaman/mutasi_rekening/'.$menuid.'/'.$idRKP);
	}

	public function update_catatan_rekap_rekening($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$idRKP = $this->input->post('id_pengajuan');
		$id = $this->input->post('id');
		$data = array(			
			'catatan' => $this->input->post('catatan'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('catatan_rekap_rekening', $data);

		redirect('pengajuan_pinjaman/mutasi_rekening/'.$menuid.'/'.$idRKP);
	}

	public function mutasi_rekening_detail($menuid, $id, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$check=$this->master_model->auth_read($user_id, $menuid);
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		// $qry = $this->master_model->select_in('pendapatan_usaha_detail', 'count(id) as rec', "WHERE id_header = $id");
		// $rec = $qry[0]->rec;

		// $qry = $this->master_model->select_in('pendapatan_usaha_detail', 'sum(nominal) as tot', "WHERE id_header = $id");
		// $tot = $qry[0]->tot;

		// if($rec==0){
		// 	$rata=0;
		// }else{
		// 	$rata = $tot / $rec;
		// }

		// $data = array(			
		// 	'rata_rata_omset' => $rata,
		// 	'update_at' => date('Y-m-d H:i:s'),
		// 	'update_by' => $user_id1
		// );	

		// $this->db->where('id', $id);
		// $this->db->update('pendapatan_usaha_header', $data);

		// $sql="update pendapatan_usaha_header set nett = rata_rata_omset - (rata_rata_omset * (hpp/100)) where id = $id;";
		// $qry = $this->db->query($sql);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_detl'] = $this->master_model->select_in('rekening_detail','*',"WHERE id_header = $id order by id");

    		$this->load->view('pengajuan/mutasi_rekening_detail', $data);
	    }
	}

	public function insert_mutasi_rekening_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');
		$data = array(			
			'id_header' => $this->input->post('id_header'),
			'periode' => $this->input->post('periode'),
			'debet' => $this->input->post('debet'),	
			'debet_frek' => $this->input->post('debet_frek'),	
			'kredit' => $this->input->post('kredit'),	
			'kredit_frek' => $this->input->post('kredit_frek'),	
			'saldo_tertinggi' => $this->input->post('saldo_tertinggi'),	
			'saldo_terendah' => $this->input->post('saldo_terendah'),	
			'saldo_rata' => $this->input->post('saldo_rata'),	
			'saldo_akhir_bulan' => $this->input->post('saldo_akhir_bulan'),	
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('rekening_detail', $data);

		redirect('pengajuan_pinjaman/mutasi_rekening_detail/'.$menuid.'/'.$id.'/'.$idRKP);
	}

	public function update_mutasi_rekening_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$id = $this->input->post('id');
		$idHdr = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');
		$data = array(			
			'id_header' => $this->input->post('id_header'),
			'periode' => $this->input->post('periode'),
			'debet' => $this->input->post('debet'),	
			'debet_frek' => $this->input->post('debet_frek'),	
			'kredit' => $this->input->post('kredit'),	
			'kredit_frek' => $this->input->post('kredit_frek'),	
			'saldo_tertinggi' => $this->input->post('saldo_tertinggi'),	
			'saldo_terendah' => $this->input->post('saldo_terendah'),	
			'saldo_rata' => $this->input->post('saldo_rata'),	
			'saldo_akhir_bulan' => $this->input->post('saldo_akhir_bulan'),	
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('rekening_detail', $data);

		redirect('pengajuan_pinjaman/mutasi_rekening_detail/'.$menuid.'/'.$idHdr.'/'.$idRKP);
	}

	public function delete_mutasi_rekening_detail($menuid, $id, $idHdr, $idRKP)
	{
		$this->db->where('id', $id);
		$this->db->delete('rekening_detail');

		redirect('pengajuan_pinjaman/mutasi_rekening_detail/'.$menuid.'/'.$idHdr.'/'.$idRKP);
	}

	public function foto_usaha($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_foto'] = $this->master_model->select_in('pendapatan_usaha_foto','*',"WHERE id_header = $id");

    		$this->load->view('pengajuan/foto_usaha', $data);
	    }
	}

	public function insert_foto_usaha($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$this->load->helper(array('form', 'url')); 
		$photokiri = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'gif|jpg|png|jpeg|bmp|pdf';
		$config['max_size'] = '2048';
		// $config['max_width']  = '1288';
		// $config['max_height']  = '768';
		
		$this->upload->initialize($config);
		  if(!$this->upload->do_upload('foto_kiri')){
			  $photokiri="";
		  }else{
			  $photokiri=$this->upload->file_name;
		}

		$this->load->helper(array('form', 'url')); 
		$photokanan = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'gif|jpg|png|jpeg|bmp|pdf';
		$config['max_size'] = '2048';
		// $config['max_width']  = '1288';
		// $config['max_height']  = '768';
		
		$this->upload->initialize($config);
		  if(!$this->upload->do_upload('foto_kanan')){
			  $photokanan="";
		  }else{
			  $photokanan=$this->upload->file_name;
		}

		$id = $this->input->post('id_header');
		$idRKP = $this->input->post('id_pengajuan');
		$data = array(
			'id_header' => $this->input->post('id_header'),
			'keterangan_kiri' => $this->input->post('keterangan_kiri'),			
			'foto_kiri' => $photokiri,
			'keterangan_kanan' => $this->input->post('keterangan_kanan'),			
			'foto_kanan' => $photokanan,
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);
		$this->db->insert('pendapatan_usaha_foto', $data);
		redirect('pengajuan_pinjaman/foto_usaha/'.$menuid.'/'.$id.'/'.$idRKP);
	}

	public function delete_foto_usaha($menuid, $id, $idHdr, $idRKP)
	{
		$this->db->where('id', $id);
		$this->db->delete('pendapatan_usaha_foto');

		redirect('pengajuan_pinjaman/foto_usaha/'.$menuid.'/'.$idHdr.'/'.$idRKP);
	}

    function trim_desimal($nilai) {
        
        $hasil = str_replace('0',' ',$nilai);
        $hasil = rtrim($hasil);
        $hasil = str_replace(' ','0',$hasil);
        
        if(substr($hasil,-1)=='.'){
        	$hasil = str_replace('.','',$hasil);
        } 
        
		return $hasil;
	}

	function print_rkp(){
		$id = $this->uri->segment('3');
		
		$sql = "select a.*, b.no_anggota, b.nama_anggota, b.tgl_lahir, b.no_referentor, b.nama_referentor, b.hubungan_referentor, b.nama_ibu_kandung, 
			b.alamat_ktp, b.alamat_domisili, b.no_hp, b.nama_usaha, b.alamat_usaha, b.no_telp_usaha, x.kategori_usaha,
			b.bidang_usaha, b.lama_bekerja, TIMESTAMPDIFF(YEAR, b.tgl_lahir, NOW() ) AS usia, c.jenis_pinjaman,
			d.nama_pengurus as penyusun1, d.jabatan as jabatan1,
			e.nama_pengurus as penyusun2, e.jabatan as jabatan2,
			f.nama_pengurus as penyusun3, f.jabatan as jabatan3,
			g.nama_pengurus as penyusun4, g.jabatan as jabatan4
			from pengajuan_pinjaman a left join anggota b on a.id_anggota=b.id
			left join jenis_pinjaman c on a.id_jenis_pinjaman=c.id
			left join kategori_usaha x on a.id_kategori_usaha=x.id
			left join pengurus_koperasi d on a.penyusun1=d.id
			left join pengurus_koperasi e on a.penyusun2=e.id
			left join pengurus_koperasi f on a.penyusun3=f.id
			left join pengurus_koperasi g on a.penyusun4=g.id
			where a.id = $id";

		$rpt = $this->db->query($sql)->row_array();

		$this->load->library('pdf');
		$pdf = new FPDF('p', 'mm', 'A4');
		
		// membuat halaman baru
		$pdf->AliasNbPages();
		$pdf->AddPage();
		// setting jenis font yang akan digunakan
		
		$sql = "select a.* from config_global a ";
		$fot = $this->db->query($sql)->result();
		foreach ($fot as $f)
		{				
			$y_awal = $pdf->GetY(); 
			
			$pdf->Image('uploads/foto/'.$f->image,135,$y_awal,50,15,'JPG','');

			$pdf->SetXY(10,$y_awal+15);

			$pdf->Cell(190, 3, '', '', 1, 'C');			
		}

		$pdf->SetFont('Times', 'BU', 13);
		// $pdf->SetXY(10,4);
		$pdf->Cell(190, 6, '" REKOMENDASI & KEPUTUSAN PINJAMAN " ( RKP )', 'LTR', 1, 'L');		
		$pdf->SetFont('Times', '', 10);			
		$pdf->Cell(45, 4, 'Nomor RKP', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_rkp'], 'R', 1, 'L');

		$GLOBALS['rkp'] = 'No. RKP : '.$rpt['no_rkp'];

        $bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

        $tglRKP = date('d', strtotime($rpt['tgl_rkp'])).' '.$bulan[date('m', strtotime($rpt['tgl_rkp']))]. ' '. date('Y', strtotime($rpt['tgl_rkp']));
		$pdf->Cell(45, 4, 'Tanggal RKP', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $tglRKP, 'R', 1, 'L');

		$pdf->Cell(45, 4, 'Nomor RKP Sebelumnya', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_rkp_sebelum'], 'R', 1, 'L');
		
		$pdf->SetFont('Times', 'I', 10);
		$pdf->Cell(45, 4, 'Member Service External', 'L', 0, 'L');		
		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['ms_external'], 'R', 1, 'L');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'DATA NASABAH', 'LRTB', 1, 'C');		

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(45, 4, 'Nama Calon Peminjam', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['nama_anggota'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'No. Keanggotaan', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_anggota'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'Usia Anggota', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['usia'].' tahun', 'R', 1, 'L');

		$pdf->Cell(45, 4, 'Referentor', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['nama_referentor'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'No. Anggota Referentor', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_referentor'], 'R', 1, 'L');
		
		$pdf->Cell(45, 4, 'Hubungan Referentor', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['hubungan_referentor'], 'R', 1, 'L');
		
		$pdf->Cell(45, 4, 'Nama Ibu Kandung', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['nama_ibu_kandung'], 'R', 1, 'L');

		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(60,$y_awal);
		$pdf->MultiCell(140, 4, $rpt['alamat_ktp'], 'R', 'J', false);
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain		
		$tinggi=$y_akhir-$y_awal;
		$pdf->SetXY(10,$y_awal);
		$pdf->Cell(45, $tinggi, 'Alamat Rumah (KTP)', 'L', 0, 'L');
		$pdf->Cell(5, $tinggi, ':', '', 1, 'L');

		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(60,$y_awal);
		$pdf->MultiCell(140, 4, $rpt['alamat_domisili'], 'R', 'J', false);
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain		
		$tinggi=$y_akhir-$y_awal;
		$pdf->SetXY(10,$y_awal);
		$pdf->Cell(45, $tinggi, 'Domisili Tempat Tinggal', 'L', 0, 'L');
		$pdf->Cell(5, $tinggi, ':', '', 1, 'L');

		$pdf->Cell(45, 4, 'Nomor HP Pribadi', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_hp'], 'R', 1, 'L');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'DATA USAHA / PEKERJAAN', 'LRTB', 1, 'C');		

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(45, 4, 'Nama Usaha', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['nama_usaha'], 'R', 1, 'L');

		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(60,$y_awal);
		$pdf->MultiCell(140, 4, $rpt['alamat_usaha'], 'R', 'J', false);
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain		
		$tinggi=$y_akhir-$y_awal;
		$pdf->SetXY(10,$y_awal);
		$pdf->Cell(45, $tinggi, 'Alamat Usaha', 'L', 0, 'L');
		$pdf->Cell(5, $tinggi, ':', '', 1, 'L');
		
		$pdf->Cell(45, 4, 'No. Telp Usaha', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_telp_usaha'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'Bidang Usaha', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['bidang_usaha'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'Lama Bekerja', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['lama_bekerja'], 'R', 1, 'L');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TUJUAN DAN SEKTOR', 'LRTB', 1, 'C');		

		$pdf->SetFont('Times', '', 10);
// 		$pdf->Cell(45, 4, 'Tujuan Pengajuan Pinjaman', 'L', 0, 'L');
// 		$pdf->Cell(5, 4, ':', 0, 0, 'L');
// 		$pdf->Cell(140, 4, $rpt['tujuan_pinjaman'], 'R', 1, 'L');
		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(60,$y_awal);
// 		$pdf->SetFont('Times', 'I', 10);
		$pdf->MultiCell(140, 4, $rpt['tujuan_pinjaman'], 'R', 'L', false);
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain
		$tinggi=$y_akhir-$y_awal;

		$pdf->SetXY(10,$y_awal);
// 		$pdf->Cell(8, 4, '', '', 1, 'L');
        $pdf->Cell(45, $tinggi, 'Tujuan Pengajuan Pinjaman', 'L', 0, 'L');

		$pdf->SetXY(55,$y_awal);
		$pdf->Cell(5, $tinggi, ':', '', 1, 'L');
		
		$pdf->Cell(45, 4, 'Pekerjaan', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['pekerjaan'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'Kategori Usaha', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['kategori_usaha'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'Sektor Ekonomi', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['sektor_ekonomi'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'Jenis Permohonan', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['jenis_pinjaman'], 'R', 1, 'L');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'STRUKTUR FASILITAS PINJAMAN', 1, 1, 'C');		

		$pdf->SetFont('Times', '', 10);
		
		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(90,$y_awal);
		$pdf->multicell(27, 4, 'Plafond Awal (Rupiah)', 'RB', 'C');
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain
		
        $tinggi=$y_akhir-$y_awal;

		$pdf->SetXY(10,$y_awal);
		$pdf->multicell(8, $tinggi, 'No.', 'LRB', 'C');

		$pdf->SetXY(18,$y_awal);
		$pdf->multicell(72, $tinggi, 'Jenis Fasilitas', 'RB', 'C');
		
		$pdf->SetXY(117,$y_awal);
		$pdf->multicell(27, 4, 'Baki Debet (Rupiah)', 'RB', 'C');
		
		$pdf->SetXY(144,$y_awal);
		$pdf->multicell(27, 4, 'Usulan Pinjaman (Rupiah)', 'RB', 'C');
		
		$pdf->SetXY(171,$y_awal);
		$pdf->multicell(29, 4, 'Plafond Akhir (Rupiah)', 'RB', 'C');
		
		$sql = "select a.*, b.tipe_pinjaman, b.keterangan as ket_tipe, c.perhitungan_bunga 
		From fasilitas_pinjaman a left join tipe_pinjaman b on a.id_jenis_pinjaman=b.id
		left join perhitungan_bunga c on a.id_perhitungan_bunga = c.id
		where a.id_pengajuan = $id order by a.id";
		$fas = $this->db->query($sql)->result();

    	$a=1; $pawal=0; $baki=0; $pinj=0; $pakhir=0;
		foreach ($fas as $p)
		{
		    $pdf->Cell(8, 4, $a, 'LR', 0, 'C');
		    $pdf->Cell(37, 4, 'Jenis Pinjaman', '', 0, 'L');
		    $pdf->Cell(5, 4, ':', '', 0, 'L');
		    $pdf->Cell(57, 4, $p->tipe_pinjaman.' '.$p->ket_tipe, 'R', 0, 'L');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(29, 4, '', 'R', 1, 'C');

		    $pdf->Cell(8, 4, '', 'LR', 0, 'C');
		    $pdf->Cell(37, 4, 'No. Rek. Pinjaman', '', 0, 'L');
		    $pdf->Cell(5, 4, ':', '', 0, 'L');
		    $pdf->Cell(30, 4, $p->no_rek_pinjaman, 'R', 0, 'L');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(29, 4, '', 'R', 1, 'C');

		    $pdf->Cell(8, 4, '', 'LR', 0, 'C');
		    $pdf->Cell(37, 4, 'Fasilitas Pinjaman', '', 0, 'L');
		    $pdf->Cell(5, 4, ':', '', 0, 'L');
		    $pdf->Cell(30, 4, $p->perhitungan_bunga, 'R', 0, 'L');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(29, 4, '', 'R', 1, 'C');
		    
		    $pdf->Cell(8, 4, '', 'LR', 0, 'C');
		    $pdf->Cell(37, 4, 'Bunga / Tahun', '', 0, 'L');
		    $pdf->Cell(5, 4, ':', '', 0, 'L');
		    $pdf->Cell(30, 4, $this->trim_desimal(strval(number_format($p->bunga_tahun,3))).'%', 'R', 0, 'L');
		    $pdf->Cell(27, 4, number_format($p->plafond_awal,0), 'R', 0, 'C');
		    $pdf->Cell(27, 4, number_format($p->baki_debet,0), 'R', 0, 'C');
		    $pdf->Cell(27, 4, number_format($p->usulan_pinjaman,0), 'R', 0, 'C');
		    $pdf->Cell(29, 4, number_format($p->plafond_akhir,0), 'R', 1, 'C');
		    
		    $pdf->Cell(8, 4, '', 'LR', 0, 'C');
		    $pdf->Cell(37, 4, 'Bunga / Bulan', '', 0, 'L');
		    $pdf->Cell(5, 4, ':', '', 0, 'L');
		    $pdf->Cell(30, 4, $this->trim_desimal(strval(number_format(($p->bunga_tahun / 12),3))).'%', 'R', 0, 'L');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(29, 4, '', 'R', 1, 'C');
		    
            $pdf->Cell(8, 4, '', 'LR', 0, 'C');
		    $pdf->Cell(37, 4, 'Biaya Provisi', '', 0, 'L');
		    $pdf->Cell(5, 4, ':', '', 0, 'L');
		    $pdf->Cell(30, 4, $this->trim_desimal(strval(number_format(($p->provisi),3))).'%', 'R', 0, 'L');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(29, 4, '', 'R', 1, 'C');
		    
		    $pdf->Cell(8, 4, '', 'LR', 0, 'C');
		    $pdf->Cell(37, 4, 'Biaya Komisi', '', 0, 'L');
		    $pdf->Cell(5, 4, ':', '', 0, 'L');
		    $pdf->Cell(30, 4, $this->trim_desimal(strval(number_format(($p->komisi),3))).'%', 'R', 0, 'L');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(29, 4, '', 'R', 1, 'C');
		    
		    $pdf->Cell(8, 4, '', 'LR', 0, 'C');
		    $pdf->Cell(37, 4, 'Jangka Waktu', '', 0, 'L');
		    $pdf->Cell(5, 4, ':', '', 0, 'L');
		    $pdf->Cell(30, 4, number_format(($p->jangka_waktu),0).' Bulan', 'R', 0, 'L');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(29, 4, '', 'R', 1, 'C');
		    
		    $pdf->Cell(8, 4, '', 'LR', 0, 'C');
		    $pdf->Cell(37, 4, 'Tgl. Pencairan', '', 0, 'L');
		    $pdf->Cell(5, 4, ':', '', 0, 'L');
		    $prdAwal = date('d', strtotime($p->periode_awal)).' '.$bulan[date('m', strtotime($p->periode_awal))]. ' '. date('Y', strtotime($p->periode_awal));
		    $pdf->Cell(30, 4, $prdAwal, 'R', 0, 'L');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(29, 4, '', 'R', 1, 'C');
		    
		    $pdf->Cell(8, 4, '', 'LR', 0, 'C');
		    $pdf->Cell(37, 4, 'Tgl. Jatuh Tempo', '', 0, 'L');
		    $pdf->Cell(5, 4, ':', '', 0, 'L');
		    $prdAkhir = date('d', strtotime($p->periode_akhir)).' '.$bulan[date('m', strtotime($p->periode_akhir))]. ' '. date('Y', strtotime($p->periode_akhir));
		    $pdf->Cell(30, 4, $prdAkhir, 'R', 0, 'L');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(27, 4, '', 'R', 0, 'C');
		    $pdf->Cell(29, 4, '', 'R', 1, 'C');
		    
		    $pdf->Cell(8, 4, '', 'LRB', 0, 'C');
		    $pdf->Cell(37, 4, 'Angsuran / Bulan', 'B', 0, 'L');
		    $pdf->Cell(5, 4, ':', 'B', 0, 'L');
		    $pdf->Cell(30, 4, 'Rp. '.number_format(($p->angsuran_bulan),0), 'RB', 0, 'L');
		    $pdf->Cell(27, 4, '', 'RB', 0, 'C');
		    $pdf->Cell(27, 4, '', 'RB', 0, 'C');
		    $pdf->Cell(27, 4, '', 'RB', 0, 'C');
		    $pdf->Cell(29, 4, '', 'RB', 1, 'C');
		    
			$pdf->MultiCell(190, 4, $p->keterangan, 'LRB', 'L', false);

            $a=$a+1;
			$pawal = $pawal + $p->plafond_awal;
			$baki = $baki + $p->baki_debet;
			$pinj = $pinj + $p->usulan_pinjaman;
			$pakhir = $pakhir + $p->plafond_akhir;
		}

		$pdf->Cell(80, 4, 'TOTAL : ', 1, 0, 'C');
		$pdf->Cell(27, 4, number_format($pawal,0), 1, 0, 'C');
		$pdf->Cell(27, 4, number_format($baki,0), 1, 0, 'C');
		$pdf->Cell(27, 4, number_format($pinj,0), 1, 0, 'C');
		$pdf->Cell(29, 4, number_format($pakhir,0), 1, 1, 'C');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'JAMINAN YANG DISERAHKAN', 1, 1, 'C');	

		$pdf->SetFont('Times', '', 10);
		
		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(117,$y_awal);
		$pdf->multicell(27, 4, 'Nilai Pasar (Rupiah)', 'RB', 'C');
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain
		
        $tinggi=$y_akhir-$y_awal;

		$pdf->SetXY(10,$y_awal);
		$pdf->multicell(8, $tinggi, 'No.', 'LRB', 'C');

		$pdf->SetXY(18,$y_awal);
		$pdf->multicell(99, $tinggi, 'Jenis Jaminan', 'RB', 'C');
		
		$pdf->SetXY(144,$y_awal);
		$pdf->multicell(27, 4, 'Nilai Taksasi (Rupiah)', 'RB', 'C');
		
		$pdf->SetXY(171,$y_awal);
		$pdf->multicell(29, 4, 'Nilai HT/Fidusia (Rupiah)', 'RB', 'C');
		
		$sql = "select a.*, b.jenis_jaminan, (select sum(total) from jaminan_nilai_pasar 
		where id_header = a.id) as nilai_pasar from jaminan_pinjaman_header a left join 
		jenis_jaminan b on a.id_jenis_jaminan = b.id
		where a.id_pengajuan = $id order by a.id";
		$jam = $this->db->query($sql)->result();

		// for($a=0; $a < count($fas); $a++)
		$a=1; $pasar=0; $taksasi=0; $ht=0;
		foreach ($jam as $p)
		{
			// if($a>1){
			// 	$pdf->Cell(8, 4, '', 'TLR', 0, 'C');	
			// }else{
				$pdf->Cell(8, 4, $a, 'TLR', 0, 'C');
			// }
			$pdf->SetFont('Times', 'BU', 10);
			$pdf->Cell(99, 4, $p->jenis_jaminan. ' Dengan Rincian : ' , 'T', 0, 'L');
			$pdf->SetFont('Times', '', 10);
			$pdf->Cell(27, 4, number_format($p->nilai_pasar,0), 'LT', 0, 'C');
			$nilai_taksasi = $p->nilai_pasar * ($p->prosen_taksasi/100);
			$pdf->Cell(27, 4, number_format($nilai_taksasi,0), 'LT', 0, 'C');
			$pdf->Cell(29, 4, number_format($p->nilai_ht_fidusia,0), 'LRT', 1, 'C');
			
			$sql = "select a.*, b.jenis_jaminan from jaminan_pinjaman_detail a left join 
			jenis_jaminan b on a.id_jenis_jaminan = b.id
			where a.id_header = $p->id and b.is_rkp='Ya' order by a.id";
			$dtl = $this->db->query($sql)->result();
			// $pdf->SetFont('Times', '', 10);
			foreach ($dtl as $d)
			{
				$y_awal=$pdf->GetY(); // ini ...
				$pdf->SetXY(60,$y_awal);
				$pdf->MultiCell(57, 4, trim($d->ket_jaminan), 'R', 'L', false);
				$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain
				
				// if($d->ket_jaminan=='Jenis & Model'){
				    // $pdf->Cell(37, 4, $y_awal.''.$y_akhir, 'L', 1, 'L');
				// }
				
				$tinggi=$y_akhir-$y_awal;

				$pdf->SetXY(18,$y_awal);
				$pdf->Cell(37, $tinggi, trim($d->jenis_jaminan), 'L', 0, 'L');

				$pdf->SetXY(55,$y_awal);
				$pdf->Cell(5, $tinggi, ':', 0, 0, 'L');

				$pdf->SetXY(10,$y_awal);
				$pdf->Cell(8, $tinggi, '', 'L', 0, 'L');

				$pdf->SetXY(117,$y_awal);
				$pdf->Cell(27, $tinggi, '', 'R', 0, 'L');

				$pdf->SetXY(144,$y_awal);
				$pdf->Cell(27, $tinggi, '', 'R', 0, 'L');

				$pdf->SetXY(171,$y_awal);
				$pdf->Cell(29, $tinggi, '', 'R', 1, 'L');
				// $pdf->Cell(27, 4, '', 'R', 0, 'C');
				// $pdf->Cell(27, 4, '', 'L', 0, 'C');
				// $pdf->Cell(29, $tinggi, '', 'LRTB', 1, 'C');		
				
				
				if(floor($y_awal) > 250){ $pdf->AddPage(); }
			}

			$pdf->Cell(8, 4, '', 'LRB', 0, 'L');
			$pdf->SetFont('Times', 'I', 10);
			$pdf->Cell(99, 4, 'Cover Ratio' , 'TRB', 0, 'R');			
			$pdf->SetFont('Times', '', 10);
			$pdf->Cell(27, 4, number_format($p->nilai_pasar/$pakhir*100,2).'%', 'TRB', 0, 'C');			
			$pdf->Cell(27, 4, number_format($nilai_taksasi/$pakhir*100,2).'%', 'TRB', 0, 'C');
			$pdf->Cell(29, 4, number_format($p->nilai_ht_fidusia/$pakhir*100,2).'%', 'RTB', 1, 'C');

// 			$pdf->SetXY(10,$y_awal);
// 			$pdf->Cell(8, 8, '', 'LRB', 0, 'L');
// 			$pdf->Cell(99, 8, '', 'RB', 0, 'L');
// 			$pdf->Cell(27, 8, '', 'RB', 0, 'L');
// 			$pdf->Cell(27, 8, '', 'RB', 0, 'L');
// 			$pdf->Cell(29, 8, '', 'RB', 1, 'L');

			// $pdf->Cell(190, 4, 'Catatan:', 'LR', 1, 'L');

			$y_awal=$pdf->GetY(); // ini ...
			$pdf->SetXY(10,$y_awal);
			$pdf->SetFont('Times', 'I', 10);
			$pdf->MultiCell(190, 4, $p->catatan_rkp, 'LRB', 'L', false);
			$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain
			
			// $tinggi=$y_akhir-$y_awal;

			// $pdf->SetXY(10,$y_awal);
			// $pdf->Cell(8, 4, '', '', 1, 'L');

			// $pdf->SetXY(117,$y_awal);
			// $pdf->Cell(27, $tinggi, '', 'R', 1, 'L');

			// $pdf->SetXY(144,$y_awal);
			// $pdf->Cell(27, $tinggi, '', 'R', 1, 'L');

			// $pdf->SetXY(171,$y_awal);
			// $pdf->Cell(29, $tinggi, '', 'R', 1, 'L');
			
			
			$a++; $pasar=$pasar+$p->nilai_pasar;
			$taksasi=$taksasi+$nilai_taksasi;
			$ht=$ht+$p->nilai_ht_fidusia;
		}

		$pdf->Cell(8, 4, '', 'LR', 0, 'L');
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(99, 4, 'Total Jaminan', 'R', 0, 'R');
		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(27, 4, number_format($pasar,0), 'RB', 0, 'C');
		$pdf->Cell(27, 4, number_format($taksasi,0), 'RB', 0, 'C');
		$pdf->Cell(29, 4, number_format($ht,0), 'RB', 1, 'C');

		$pdf->Cell(8, 4, '', 'LR', 0, 'L');
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(99, 4, 'Total Pinjaman', 'R', 0, 'R');		
		$pdf->SetFont('Times', '', 10);		
		$pdf->Cell(27, 4, number_format($pakhir,0), 'RB', 0, 'C');
		$pdf->Cell(27, 4, number_format($pakhir,0), 'RB', 0, 'C');
		$pdf->Cell(29, 4, number_format($pakhir,0), 'RB', 1, 'C');

		$pdf->Cell(8, 4, '', 'LRB', 0, 'L');
		$pdf->SetFont('Times', 'BI', 10);
		$pdf->Cell(99, 4, 'Total Cover Ratio', 'RB', 0, 'R');		
		$pdf->SetFont('Times', '', 10);		
		$pdf->Cell(27, 4, number_format($pasar/$pakhir*100,2).'%', 'RB', 0, 'C');
		$pdf->Cell(27, 4, number_format($taksasi/$pakhir*100,2).'%', 'RB', 0, 'C');
		$pdf->Cell(29, 4, number_format($ht/$pakhir*100,2).'%', 'RB', 1, 'C');

		$sql = "select a.* from catatan_agunan_rkp a where a.id_pengajuan = $id";
		$agrkp = $this->db->query($sql)->row_array();

		$pdf->Cell(190, 4, 'Catatan RKP : ', 'LRT', 1, 'L');
		$pdf->MultiCell(190, 4, $agrkp['catatan_agunan_rkp'], 'LRB', 'L', false);

		$pdf->AddPage();

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TIM PENYUSUN', 1, 1, 'C');	

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(49, 4, $rpt['jabatan1'], 'L', 0, 'C');
		$pdf->Cell(47, 4, $rpt['jabatan2'], '', 0, 'C');
		$pdf->Cell(47, 4, $rpt['jabatan3'], '', 0, 'C');
		$pdf->Cell(47, 4, $rpt['jabatan4'], 'R', 1, 'C');

		$pdf->Cell(49, 14, '', 'L', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', 'R', 1, 'C');

		$pdf->Cell(49, 4, $rpt['penyusun1'], 'LB', 0, 'C');
		$pdf->Cell(47, 4, $rpt['penyusun2'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $rpt['penyusun3'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $rpt['penyusun4'], 'RB', 1, 'C');

		$sql = "select * from pengurus_koperasi where grup = 'REKOMENDASI';";
		$grp = $this->db->query($sql)->row_array();

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TIM REKOMENDASI', 1, 1, 'C');	

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(49, 4, $grp['jabatan'], 'L', 0, 'C');
		$pdf->Cell(47, 4, '', '', 0, 'C');
		$pdf->Cell(47, 4, '', '', 0, 'C');
		$pdf->Cell(47, 4, '', 'R', 1, 'C');

		$pdf->Cell(49, 14, '', 'L', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', 'R', 1, 'C');

		$pdf->Cell(49, 4, $grp['nama_pengurus'], 'LB', 0, 'C');
		$pdf->Cell(47, 4, '', 'B', 0, 'C');
		$pdf->Cell(47, 4, '', 'B', 0, 'C');
		$pdf->Cell(47, 4, '', 'RB', 1, 'C');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TIM KOMITE KEPUTUSAN', 1, 1, 'C');	
		
		if($rpt['komite']==1){
			$sql = "select a.*,
			ifnull(d.nama_pengurus,'') as kom1, ifnull(d.jabatan,'') as jabatan1,
			ifnull(e.nama_pengurus,'') as kom2, ifnull(e.jabatan,'') as jabatan2,
			ifnull(f.nama_pengurus,'') as kom3, ifnull(f.jabatan,'') as jabatan3,
			ifnull(g.nama_pengurus,'') as kom4, ifnull(g.jabatan,'') as jabatan4 
			from komite_pum a left join pengurus_koperasi d on a.komite1=d.id
			left join pengurus_koperasi e on a.komite2=e.id
			left join pengurus_koperasi f on a.komite3=f.id
			left join pengurus_koperasi g on a.komite4=g.id
			where $pakhir between a.baki_debet_from and a.baki_debet_to";	
		}else{
			$sql = "select a.*,
			ifnull(d.nama_pengurus,'') as kom1, ifnull(d.jabatan,'') as jabatan1,
			ifnull(e.nama_pengurus,'') as kom2, ifnull(e.jabatan,'') as jabatan2,
			ifnull(f.nama_pengurus,'') as kom3, ifnull(f.jabatan,'') as jabatan3,
			ifnull(g.nama_pengurus,'') as kom4, ifnull(g.jabatan,'') as jabatan4 
			from komite a left join pengurus_koperasi d on a.komite1=d.id
			left join pengurus_koperasi e on a.komite2=e.id
			left join pengurus_koperasi f on a.komite3=f.id
			left join pengurus_koperasi g on a.komite4=g.id
			where $pakhir between a.baki_debet_from and a.baki_debet_to";	
		};
		$komite = $this->db->query($sql)->row_array();

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(49, 4, $komite['jabatan1'], 'L', 0, 'C');
		$pdf->Cell(47, 4, $komite['jabatan2'], '', 0, 'C');
		$pdf->Cell(47, 4, $komite['jabatan3'], '', 0, 'C');
		$pdf->Cell(47, 4, $komite['jabatan4'], 'R', 1, 'C');

		$pdf->Cell(49, 14, '', 'L', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', 'R', 1, 'C');

		$pdf->Cell(49, 4, $komite['kom1'], 'LB', 0, 'C');
		$pdf->Cell(47, 4, $komite['kom2'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $komite['kom3'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $komite['kom4'], 'RB', 1, 'C');

		$pdf->Output();
	}

	function print_map(){
		$id = $this->uri->segment('3');
		
		$sql = "select a.*, b.no_anggota, b.nama_anggota, b.tgl_lahir, b.no_referentor, b.nama_referentor, b.nama_ibu_kandung, 
			b.alamat_ktp, b.alamat_domisili, b.no_hp, b.nama_usaha, b.alamat_usaha, b.no_telp_usaha,
			b.bidang_usaha, b.lama_bekerja, TIMESTAMPDIFF(YEAR, b.tgl_lahir, NOW() ) AS usia, c.jenis_pinjaman,
			d.nama_pengurus as penyusun1, d.jabatan as jabatan1,
			e.nama_pengurus as penyusun2, e.jabatan as jabatan2,
			f.nama_pengurus as penyusun3, f.jabatan as jabatan3,
			g.nama_pengurus as penyusun4, g.jabatan as jabatan4
			from pengajuan_pinjaman a left join anggota b on a.id_anggota=b.id
			left join jenis_pinjaman c on a.id_jenis_pinjaman=c.id
			left join pengurus_koperasi d on a.penyusun1=d.id
			left join pengurus_koperasi e on a.penyusun2=e.id
			left join pengurus_koperasi f on a.penyusun3=f.id
			left join pengurus_koperasi g on a.penyusun4=g.id
			where a.id = $id";

		$rpt = $this->db->query($sql)->row_array();

		$this->load->library('pdf');
		$pdf = new FPDF('p', 'mm', 'A4');
		// membuat halaman baru
		$pdf->AliasNbPages();
		$pdf->AddPage();
		// setting jenis font yang akan digunakan
		
		$sql = "select a.* from config_global a ";
		$fot = $this->db->query($sql)->result();
		foreach ($fot as $f)
		{				
			$y_awal = $pdf->GetY(); 
			
			$pdf->Image('uploads/foto/'.$f->image,135,$y_awal,50,15,'JPG','');

			$pdf->SetXY(10,$y_awal+15);

			$pdf->Cell(190, 3, '', '', 1, 'C');			
		}

		$pdf->SetFont('Times', 'BU', 13);
		// $pdf->SetXY(10,4);
		$pdf->Cell(90, 6, 'MEMORANDUM ANALISA PINJAMAN', '', 0, 'C');		
		$pdf->Cell(100, 6, '', '', 1, 'C');		
		$pdf->SetFont('Times', '', 11);
		$pdf->Cell(90, 4, $rpt['nama_usaha'], '', 0, 'C');
		$pdf->Cell(100, 4, '', '', 1, 'C');
		$pdf->Cell(45, 4, 'Nama Calon Peminjam', '', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['nama_anggota'], '', 1, 'L');
		
		$pdf->Cell(45, 4, 'Nomor RKP', '', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_rkp'], '', 1, 'L');
		$pdf->Cell(190, 4, '', 'T', 1, 'L');
		
		$GLOBALS['rkp'] = 'No. MAP : MAP - '.$rpt['no_rkp'];
		
		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);
		
		$pdf->SetFont('Times', 'BU', 10);
		$pdf->Cell(45, 4, '1. PERMOHONAN PINJAMAN', '', 1, 'L');

		$pdf->SetFont('Times', '', 10);
		$sql = "select a.*, b.tipe_pinjaman, b.keterangan as ket_tipe, c.perhitungan_bunga
		from fasilitas_pinjaman a left join tipe_pinjaman b on a.id_jenis_pinjaman=b.id
		left join perhitungan_bunga c on a.id_perhitungan_bunga=c.id
		where a.id_pengajuan = $id and a.is_map = 1 order by a.id";
		$pinjaman = $this->db->query($sql)->row_array();
		$fas = $this->db->query($sql)->result();
		
		$total_plafond = 0; $no = 1;
		foreach ($fas as $fs)
		{
			$pdf->Cell(8, 4, $no, '', 0, 'R');	
			$pdf->Cell(40, 4, 'No. Rek. Pinjaman', '', 0, 'L');	
			$pdf->Cell(5, 4, ':', '', 0, 'C');	
			$pdf->Cell(27, 4, $fs->no_rek_pinjaman, '', 1, 'L');
			
			$pdf->Cell(8, 4, '', '', 0, 'R');	
			$pdf->Cell(40, 4, 'Pengajuan Pinjaman', '', 0, 'L');	
			$pdf->Cell(5, 4, ':', '', 0, 'C');	
			$pdf->Cell(27, 4, 'Rp. '.number_format($fs->plafond_akhir,0).',-', '', 1, 'L');

			$pdf->Cell(8, 4, '', '', 0, 'R');	
			$pdf->Cell(40, 4, 'Jenis Pinjaman', '', 0, 'L');	
			$pdf->Cell(5, 4, ':', '', 0, 'C');	
			$pdf->Cell(27, 4, $fs->tipe_pinjaman.' - '.$fs->ket_tipe, '', 1, 'L');

			$pdf->Cell(8, 4, '', '', 0, 'R');	
			$pdf->Cell(40, 4, 'Fasilitas', '', 0, 'L');	
			$pdf->Cell(5, 4, ':', '', 0, 'C');	
			$pdf->Cell(27, 4, $fs->perhitungan_bunga, '', 1, 'L');

			$pdf->Cell(8, 4, '', '', 0, 'R');	
			$pdf->Cell(40, 4, 'Jangka Waktu', '', 0, 'L');	
			$pdf->Cell(5, 4, ':', '', 0, 'C');	
			$pdf->Cell(27, 4, $fs->jangka_waktu.' Bulan', '', 1, 'L');
			
			
			$prdAwal = date('d', strtotime($fs->periode_awal)).' '.$bulan[date('m', strtotime($fs->periode_awal))]. ' '. date('Y', strtotime($fs->periode_awal));
			$pdf->Cell(8, 4, '', '', 0, 'R');	
			$pdf->Cell(40, 4, 'Tgl. Pencairan', '', 0, 'L');	
			$pdf->Cell(5, 4, ':', '', 0, 'C');	
			$pdf->Cell(27, 4, $prdAwal, '', 1, 'L');
			
			$prdAkhir = date('d', strtotime($fs->periode_akhir)).' '.$bulan[date('m', strtotime($fs->periode_akhir))]. ' '. date('Y', strtotime($fs->periode_akhir));
			$pdf->Cell(8, 4, '', '', 0, 'R');	
			$pdf->Cell(40, 4, 'Tgl. Jatuh Tempo', '', 0, 'L');	
			$pdf->Cell(5, 4, ':', '', 0, 'C');	
			$pdf->Cell(27, 4, $prdAkhir, '', 1, 'L');

			$pdf->Cell(8, 4, '', '', 0, 'R');	
			$pdf->Cell(40, 4, 'Suku Bunga', '', 0, 'L');	
			$pdf->Cell(5, 4, ':', '', 0, 'C');	
			$pdf->Cell(27, 4, $this->trim_desimal(strval(number_format(($fs->bunga_tahun/12),3))).' % per bulan', '', 1, 'L');

			$pdf->Cell(8, 4, '', '', 0, 'R');	
			$pdf->Cell(40, 4, 'Tujuan Pengajuan Pinjaman', '', 0, 'L');
			$pdf->Cell(5, 4, ':', '', 0, 'C');
			$pdf->Cell(27, 4, $fs->tujuan_pengajuan, '', 1, 'L');

			$pdf->Cell(8, 4, '', '', 0, 'R');	
			$pdf->Cell(40, 4, 'Angsuran / Bulan', '', 0, 'L');
			$pdf->Cell(5, 4, ':', '', 0, 'C');
			$pdf->Cell(27, 4, 'Rp. '.number_format($fs->angsuran_bulan,0).',-', '', 1, 'L');

			// // for($a=0; $a < count($fas); $a++)
			// $a=3; $pawal=0; $baki=0; $pinj=0; $pakhir=0;
			// foreach ($fas as $p)
			// {
			// 	$pdf->Cell(8, 4, $a.'.', '', 0, 'R');	
			// 	$pdf->Cell(40, 4, $p->jenis_fasilitas, '', 0, 'L');	
			// 	$pdf->Cell(5, 4, ':', '', 0, 'C');	
			// 	$pdf->Cell(27, 4, $p->ket_fasilitas.' '.$p->keterangan, '', 1, 'L');
			// 	$a++;
			// }
// 			$total_plafond = $total_plafond + $fs->plafond_akhir;
			$no=$no+1;	
			$pdf->Cell(190, 4, '', 0, 1, 'C');
		}

        $sql = "select a.*, b.tipe_pinjaman, b.keterangan as ket_tipe, c.perhitungan_bunga
		from fasilitas_pinjaman a left join tipe_pinjaman b on a.id_jenis_pinjaman=b.id
		left join perhitungan_bunga c on a.id_perhitungan_bunga=c.id
		where a.id_pengajuan = $id order by a.id";
		$fasTotal = $this->db->query($sql)->result();
		//hitung total plafon
		foreach ($fasTotal as $fs)
		{
			$total_plafond = $total_plafond + $fs->plafond_akhir;
		}

		$pdf->SetFont('Times', 'BU', 10);
		$pdf->Cell(45, 4, '2. ANALISA CALON PEMINJAM DAN USAHA', '', 1, 'L');	

		$pdf->SetFont('Times', '', 10);
		$sql = "select a.* from analisa_personal a 
		where a.id_pengajuan = $id order by a.id";
		$ans = $this->db->query($sql)->row_array();

        // $analisa = $ans['analisa'];
        $analisa = str_replace('&quot;','"',$ans['analisa']);
        $analisa = str_replace('&nbsp;',' ',$analisa);
		$analisa = str_replace('&ndash;','-',$analisa);
		$analisa = str_replace('&#39;',"'",$analisa);
        
		$pdf->MultiCell(190, 4, strip_tags($analisa), '', 'J', false);

		$pdf->Cell(190, 4, '', 0, 1, 'C');
		
		$pdf->SetFont('Times', 'BU', 10);
		$pdf->Cell(45, 4, '3. ANALISA KEUANGAN', '', 1, 'L');	
		
		$pdf->SetFont('Times', 'IU', 10);
		$pdf->Cell(45, 4, 'a. Analisa Mutasi Rekening', '', 1, 'L');	

		$sql = "select a.* from rekening_header a 
		where a.id_pengajuan = $id order by a.id";
		$rek = $this->db->query($sql)->result();

        $rekHdr = 0;
		foreach ($rek as $r){
		    $pdf->Cell(190, 4, '', 0, 1, 'C');
			$pdf->SetFont('Times', '', 10);
			$pdf->Cell(25, 4, 'Nama Bank', 0, 0, 'L');
			$pdf->Cell(5, 4, ':', '', 0, 'C');
			$pdf->Cell(90, 4, $r->nama_bank, '', 1, 'L');
	
			$pdf->Cell(25, 4, 'Jenis Rekening', 0, 0, 'L');
			$pdf->Cell(5, 4, ':', '', 0, 'C');
			$pdf->Cell(90, 4, $r->jenis_rekening, '', 1, 'L');
	
			$pdf->Cell(25, 4, 'No. Rekening', 0, 0, 'L');
			$pdf->Cell(5, 4, ':', '', 0, 'C');
			$pdf->Cell(90, 4, $r->no_rekening, '', 1, 'L');
	
			$pdf->Cell(25, 4, 'Atas Nama', 0, 0, 'L');
			$pdf->Cell(5, 4, ':', '', 0, 'C');
			$pdf->Cell(90, 4, $r->atas_nama, '', 1, 'L');
	
			$sql = "select a.* from rekening_detail a 
			where a.id_header = $r->id order by a.id";
			$rekd = $this->db->query($sql)->result();

			$pdf->SetFont('Times', 'B', 9);

			$y_awal=$pdf->GetY(); // ini ...
			$pdf->SetXY(10,$y_awal);
			$pdf->multicell(27, 5, 'Aktivitas Rekening', 1, 'C');
			$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain
			
			$tinggi=$y_akhir-$y_awal;

			$pdf->SetXY(37,$y_awal);
			$pdf->multicell(23, 5, 'Mutasi Debet (Rupiah)', 1, 'C');

			$pdf->SetXY(60,$y_awal);
			$pdf->multicell(10, $tinggi, 'Frek', 1, 'C');

			$pdf->SetXY(70,$y_awal);
			$pdf->multicell(23, 5, 'Mutasi Kredit (Rupiah)', 1, 'C');

			$pdf->SetXY(93,$y_awal);
			$pdf->multicell(10, $tinggi, 'Frek', 1, 'C');

			$pdf->SetXY(103,$y_awal);
			$pdf->multicell(24, 5, 'Saldo Tertinggi (Rupiah)', 1, 'C');

			$pdf->SetXY(127,$y_awal);
			$pdf->multicell(24, 5, 'Saldo Terendah (Rupiah)', 1, 'C');

			$pdf->SetXY(151,$y_awal);
			$pdf->multicell(24, 5, 'Saldo Rata Rata (Rupiah)', 1, 'C');

			$pdf->SetXY(175,$y_awal);
			$pdf->multicell(25, 5, 'Saldo Akhir Bulan (Rupiah)', 1, 'C');

			$x=0; $dbt=0; $fd=0; $krd=0; $fk=0; $sti=0; $str=0; $sta=0; $sab=0;
			foreach ($rekd as $rd){
				$month_num = substr($rd->periode,0,2);
				// $month_name = date("F", mktime(0, 0, 0, $month_num, 10));
				$month_name = $bulan[$month_num];
				
				$year_name = substr($rd->periode,3,4);

				$pdf->SetFont('Times', '', 9);
				$pdf->Cell(27, 4, $month_name.' '.$year_name, 1, 0, 'L');
				$pdf->Cell(23, 4, number_format($rd->debet,0), 1, 0, 'R');
				$pdf->Cell(10, 4, number_format($rd->debet_frek,0), 1, 0, 'R');
				$pdf->Cell(23, 4, number_format($rd->kredit,0), 1, 0, 'R');
				$pdf->Cell(10, 4, number_format($rd->kredit_frek,0), 1, 0, 'R');
				$pdf->Cell(24, 4, number_format($rd->saldo_tertinggi,0), 1, 0, 'R');
				$pdf->Cell(24, 4, number_format($rd->saldo_terendah,0), 1, 0, 'R');
				$pdf->Cell(24, 4, number_format($rd->saldo_rata,0), 1, 0, 'R');
				$pdf->Cell(25, 4, number_format($rd->saldo_akhir_bulan,0), 1, 1, 'R');
				
				$x++;
				$dbt=$dbt+$rd->debet; 
				$fd=$fd+$rd->debet_frek; 
				$krd=$krd+$rd->kredit; 
				$fk=$fk+$rd->kredit_frek; 
				$sti=$sti+$rd->saldo_tertinggi; 
				$str=$str+$rd->saldo_terendah; 
				$sta=$sta+$rd->saldo_rata; 
				$sab=$sab+$rd->saldo_akhir_bulan;
			}
			$pdf->SetFont('Times', 'B', 9);
			$pdf->Cell(27, 4, 'Total ', 1, 0, 'L');
			$pdf->Cell(23, 4, number_format($dbt,0), 1, 0, 'R');
			$pdf->Cell(10, 4, number_format($fd,0), 1, 0, 'R');
			$pdf->Cell(23, 4, number_format($krd,0), 1, 0, 'R');
			$pdf->Cell(10, 4, number_format($fk,0), 1, 0, 'R');
			$pdf->Cell(24, 4, number_format($sti,0), 1, 0, 'R');
			$pdf->Cell(24, 4, number_format($str,0), 1, 0, 'R');
			$pdf->Cell(24, 4, number_format($sta,0), 1, 0, 'R');
			$pdf->Cell(25, 4, number_format($sab,0), 1, 1, 'R');
		
			$pdf->Cell(27, 4, 'Rata Rata ', 1, 0, 'L');
			$pdf->Cell(23, 4, number_format($dbt/$x,0), 1, 0, 'R');
			$pdf->Cell(10, 4, number_format($fd/$x,0), 1, 0, 'R');
			$pdf->Cell(23, 4, number_format($krd/$x,0), 1, 0, 'R');
			$pdf->Cell(10, 4, number_format($fk/$x,0), 1, 0, 'R');
			$pdf->Cell(24, 4, number_format($sti/$x,0), 1, 0, 'R');
			$pdf->Cell(24, 4, number_format($str/$x,0), 1, 0, 'R');
			$pdf->Cell(24, 4, number_format($sta/$x,0), 1, 0, 'R');
			$pdf->Cell(25, 4, number_format($sab/$x,0), 1, 1, 'R');

			$pdf->SetFont('Times', '', 10);
			$pdf->MultiCell(190, 4, $r->catatan, '', 'L', false);
			
			$rekHdr++;
		}		

		
        if ($rekHdr > 1){
            $pdf->Cell(190, 4, '', 0, 1, 'C');
    		$sql = "select concat(MONTHNAME(concat(substr(a.periode,4,4),'-',substr(a.periode,1,2), '-01')),' ',substr(a.periode,4,4)) as periode, 
    		    substr(a.periode,1,2) as bulan, substr(a.periode,4,4) as tahun,
    			sum(debet) as debet, sum(debet_frek) as debet_frek, sum(kredit) as kredit, sum(kredit_frek) as kredit_frek,
    			sum(saldo_tertinggi) as saldo_tertinggi, sum(saldo_terendah) as saldo_terendah, sum(saldo_rata) as saldo_rata,
    			sum(saldo_akhir_bulan) as saldo_akhir_bulan
    			From rekening_detail a left join rekening_header b on a.id_header = b.id where b.id_pengajuan = $id
    			group by concat(MONTHNAME(concat(substr(a.periode,4,4),'-',substr(a.periode,1,2), '-01')),' ',substr(a.periode,4,4)) order by 
    			concat(substr(a.periode,4,4),'-',substr(a.periode,1,2), '-01');";
    		$rekaprek = $this->db->query($sql)->result();
    		
    		$pdf->Cell(190, 4, 'Rekap Rekening', 0, 1, 'L');
    		$pdf->SetFont('Times', 'B', 10);
    
    		$y_awal=$pdf->GetY(); // ini ...
    		$pdf->SetXY(10,$y_awal);
    		$pdf->multicell(27, 5, 'Aktivitas Rekening (Rupiah)', 1, 'C');
    		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain
    		
    		$tinggi=$y_akhir-$y_awal;
    
    		$pdf->SetXY(37,$y_awal);
    		$pdf->multicell(23, 5, 'Mutasi Debet (Rupiah)', 1, 'C');
    
    		$pdf->SetXY(60,$y_awal);
    		$pdf->multicell(10, $tinggi, 'Frek', 1, 'C');
    
    		$pdf->SetXY(70,$y_awal);
    		$pdf->multicell(23, 5, 'Mutasi Kredit (Rupiah)', 1, 'C');
    
    		$pdf->SetXY(93,$y_awal);
    		$pdf->multicell(10, $tinggi, 'Frek', 1, 'C');
    
    		$pdf->SetXY(103,$y_awal);
    		$pdf->multicell(24, 5, 'Saldo Tertinggi (Rupiah)', 1, 'C');
    
    		$pdf->SetXY(127,$y_awal);
    		$pdf->multicell(24, 5, 'Saldo Terendah (Rupiah)', 1, 'C');
    
    		$pdf->SetXY(151,$y_awal);
    		$pdf->multicell(24, 5, 'Saldo Rata Rata (Rupiah)', 1, 'C');
    
    		$pdf->SetXY(175,$y_awal);
    		$pdf->multicell(25, 5, 'Saldo Akhir Bulan (Rupiah)', 1, 'C');
    
    		$x=0; $dbt=0; $fd=0; $krd=0; $fk=0; $sti=0; $str=0; $sta=0; $sab=0;
    		foreach ($rekaprek as $rd){
    // 			$month_num = intval(substr($rd->periode,0,2));
    // 			$month_name = date("F", mktime(0, 0, 0, $month_num, 10));
    // 			$year_name = substr($rd->periode,3,4);
    
    			$pdf->SetFont('Times', '', 9);
    			$pdf->Cell(27, 4, $bulan[$rd->bulan].' '.$rd->tahun, 1, 0, 'L');
    			$pdf->Cell(23, 4, number_format($rd->debet,0), 1, 0, 'R');
    			$pdf->Cell(10, 4, number_format($rd->debet_frek,0), 1, 0, 'R');
    			$pdf->Cell(23, 4, number_format($rd->kredit,0), 1, 0, 'R');
    			$pdf->Cell(10, 4, number_format($rd->kredit_frek,0), 1, 0, 'R');
    			$pdf->Cell(24, 4, number_format($rd->saldo_tertinggi,0), 1, 0, 'R');
    			$pdf->Cell(24, 4, number_format($rd->saldo_terendah,0), 1, 0, 'R');
    			$pdf->Cell(24, 4, number_format($rd->saldo_rata,0), 1, 0, 'R');
    			$pdf->Cell(25, 4, number_format($rd->saldo_akhir_bulan,0), 1, 1, 'R');
    			
    			$x++;
    			$dbt=$dbt+$rd->debet; 
    			$fd=$fd+$rd->debet_frek; 
    			$krd=$krd+$rd->kredit; 
    			$fk=$fk+$rd->kredit_frek; 
    			$sti=$sti+$rd->saldo_tertinggi; 
    			$str=$str+$rd->saldo_terendah; 
    			$sta=$sta+$rd->saldo_rata; 
    			$sab=$sab+$rd->saldo_akhir_bulan;
    		}
    		$pdf->SetFont('Times', 'B', 9);
    		$pdf->Cell(27, 4, 'Total ', 1, 0, 'L');
    		$pdf->Cell(23, 4, number_format($dbt,0), 1, 0, 'R');
    		$pdf->Cell(10, 4, number_format($fd,0), 1, 0, 'R');
    		$pdf->Cell(23, 4, number_format($krd,0), 1, 0, 'R');
    		$pdf->Cell(10, 4, number_format($fk,0), 1, 0, 'R');
    		$pdf->Cell(24, 4, number_format($sti,0), 1, 0, 'R');
    		$pdf->Cell(24, 4, number_format($str,0), 1, 0, 'R');
    		$pdf->Cell(24, 4, number_format($sta,0), 1, 0, 'R');
    		$pdf->Cell(25, 4, number_format($sab,0), 1, 1, 'R');
    	    if($x==0){$x=1; }
    		$pdf->Cell(27, 4, 'Rata Rata ', 1, 0, 'L');
    		$pdf->Cell(23, 4, number_format($dbt/$x,0), 1, 0, 'R');
    		$pdf->Cell(10, 4, number_format($fd/$x,0), 1, 0, 'R');
    		$pdf->Cell(23, 4, number_format($krd/$x,0), 1, 0, 'R');
    		$pdf->Cell(10, 4, number_format($fk/$x,0), 1, 0, 'R');
    		$pdf->Cell(24, 4, number_format($sti/$x,0), 1, 0, 'R');
    		$pdf->Cell(24, 4, number_format($str/$x,0), 1, 0, 'R');
    		$pdf->Cell(24, 4, number_format($sta/$x,0), 1, 0, 'R');
			$pdf->Cell(25, 4, number_format($sab/$x,0), 1, 1, 'R');
			
			$sql = "select a.* from catatan_rekap_rekening a 
			where a.id_pengajuan = $id order by a.id";
			$rekap_rekening = $this->db->query($sql)->row_array();
	
	        $pdf->SetFont('Times', '', 10);
			$pdf->MultiCell(190, 4, $rekap_rekening['catatan'], '', 'L', false);
        } else{
            $sql = "select a.* from catatan_rekap_rekening a 
			where a.id_pengajuan = $id order by a.id";
			$rekap_rekening = $this->db->query($sql)->row_array();
	
	        $pdf->SetFont('Times', '', 10);
			$pdf->MultiCell(190, 4, $rekap_rekening['catatan'], '', 'L', false);
        }
		$pdf->Cell(190, 4, '', 0, 1, 'C');

		$pdf->SetFont('Times', 'IU', 10);
		$pdf->Cell(45, 4, 'b. Analisa Pendapatan Usaha', '', 1, 'L');	

		$sql = "select a.* from pendapatan_usaha_header a 
		where a.id_pengajuan = $id order by a.id";
		$pusaha = $this->db->query($sql)->result();

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(10, 5, 'No.', 1, 0, 'C');
		$pdf->Cell(110, 5, 'Keterangan', 1, 0, 'C');
		$pdf->Cell(70, 5, 'Jumlah (Rupiah)', 1, 1, 'C');

		$no= 1; $perkiraan=0;
		foreach ($pusaha as $pu){
			$pdf->SetFont('Times', '', 10);
			$pdf->Cell(10, 4, $no, 1, 0, 'C');
			$pdf->Cell(110, 4, $pu->keterangan, 1, 0, 'L');
			$pdf->Cell(35, 4, '', 1, 0, 'C');
			$pdf->Cell(35, 4, '', 1, 1, 'C');
					
			$sql = "select a.* from pendapatan_usaha_detail a 
			where a.id_header = $pu->id order by a.id";
			$usahadtl = $this->db->query($sql)->result();
			
			$pu_ttl=0; $t=0;
			foreach ($usahadtl as $udt){
				$pdf->Cell(10, 4, '', 1, 0, 'C');
				$pdf->Cell(110, 4, $udt->keterangan, 1, 0, 'L');
				$pdf->Cell(35, 4, number_format($udt->nominal,0), 1, 0, 'R');
				$pdf->Cell(35, 4, '', 1, 1, 'C');				
				$pu_ttl=$pu_ttl+$udt->nominal;
				$t++;
			}
			$pdf->SetFont('Times', 'B', 10);
			$pdf->Cell(10, 4, '', 'TLRB', 0, 'C');
			$pdf->Cell(110, 4, 'Total '.$pu->keterangan, 'TRB', 0, 'L');
			$pdf->Cell(35, 4, number_format($pu_ttl,0), 1, 0, 'R');
			$pdf->Cell(35, 4, '', 1, 1, 'R');	
			
			$pdf->SetFont('Times', '', 10);
			if($pu->hpp>0){
				$pdf->Cell(10, 4, '', 'LRB', 0, 'C');
				$pdf->Cell(110, 4, 'Rata-rata '.$pu->keterangan, 'RB', 0, 'L');
				$pdf->Cell(35, 4, '', 1, 0, 'R');
				$pdf->Cell(35, 4, number_format($pu->rata_rata_omset,0), 1, 1, 'R');	
	
				$pdf->Cell(10, 4, '', 'LRB', 0, 'C');
				$pdf->Cell(110, 4, 'HPP ('.$pu->hpp.'%)', 'RB', 0, 'L');
				$pdf->Cell(35, 4, '', 1, 0, 'R');
				$pdf->Cell(35, 4, '('.number_format($pu->rata_rata_omset*($pu->hpp/100),0).')', 1, 1, 'R');		
			}
			
			$no++;
			if($pu->hpp>0){
				$perkiraan = $perkiraan+ ($pu->rata_rata_omset - ($pu->rata_rata_omset*($pu->hpp/100)));
			} else {
				$perkiraan = $perkiraan+ $pu_ttl;
			}
		}
		
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(10, 4, '', 'LB', 0, 'C');
		$pdf->Cell(110, 4, 'Perkiraan Pendapatan Usaha Per Bulan', 'RB', 0, 'L');
		$pdf->Cell(35, 4, '', 1, 0, 'R');
		$pdf->Cell(35, 4, number_format($perkiraan,0), 1, 1, 'R');	

		$pdf->SetFont('Times', '', 10);		
		// $pdf->Cell(190, 4, 'Catatan : ', 0, 1, 'L');

        $analisa = str_replace('&quot;','"',$ans['catatan_pendapatan']);
        $analisa = str_replace('&nbsp;',' ',$analisa);
		$analisa = str_replace('&ndash;','-',$analisa);
		$analisa = str_replace('&#39;',"'",$analisa);

		$pdf->MultiCell(190, 4, strip_tags($analisa), '', 'J', false);

		$pdf->Cell(190, 4, '', 0, 1, 'C');
		$pdf->SetFont('Times', 'IU', 10);
		$pdf->Cell(45, 4, 'c. Biaya Operasional Usaha', '', 1, 'L');

		$sql = "select a.* from analisa_biaya_operasional a 
		where a.id_pengajuan = $id order by a.id";
		$opr = $this->db->query($sql)->result();
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(10, 5, 'No.', 1, 0, 'C');
		$pdf->Cell(80, 5, 'Keterangan', 1, 0, 'C');
		$pdf->Cell(35, 5, 'Nominal (Rupiah)', 1, 1, 'C');
		$pdf->SetFont('Times', '', 10);
		$i=1; $ttl=0;
		foreach ($opr as $op)
		{
			$pdf->Cell(10, 4, $i, 1, 0, 'C');
			$pdf->Cell(80, 4, $op->keterangan, 1, 0, 'L');
			$pdf->Cell(8, 4, 'Rp. ', 'LB', 0, 'C');
			$pdf->Cell(27, 4, number_format($op->nominal,0), 'RB', 1, 'R');
	
			$i++; $ttl=$ttl+$op->nominal;
		}
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(90, 5, 'Total Biaya Operasional', 1, 0, 'C');
		$pdf->Cell(8, 5, 'Rp. ', 'LB', 0, 'C');
		$pdf->Cell(27, 5, number_format($ttl,0), 'RB', 1, 'R');
		
		$pdf->SetFont('Times', '', 10);	
		// $pdf->Cell(190, 4, 'Catatan : ', 0, 1, 'L');
		$analisa = str_replace('&quot;','"',$ans['catatan_biaya_ops']);
        $analisa = str_replace('&nbsp;',' ',$analisa);
		$analisa = str_replace('&ndash;','-',$analisa);
		$analisa = str_replace('&#39;',"'",$analisa);

		$pdf->MultiCell(190, 4, strip_tags($analisa), '', 'J', false);		

		$pdf->Cell(190, 4, '', 0, 1, 'C');
		$pdf->SetFont('Times', 'IU', 10);
		$pdf->Cell(45, 4, 'd. Data Biaya Hidup', '', 1, 'L');	
		
		$sql = "select a.* from analisa_biaya_hidup a 
		where a.id_pengajuan = $id order by a.id";
		$byhidup = $this->db->query($sql)->result();
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(10, 5, 'No.', 1, 0, 'C');
		$pdf->Cell(80, 5, 'Keterangan', 1, 0, 'C');
		$pdf->Cell(35, 5, 'Nominal (Rupiah)', 1, 1, 'C');
		$pdf->SetFont('Times', '', 10);
		$i=1; $ttl=0;
		foreach ($byhidup as $bh)
		{
			$pdf->Cell(10, 4, $i, 1, 0, 'C');
			$pdf->Cell(80, 4, $bh->keterangan, 1, 0, 'L');
			$pdf->Cell(8, 4, 'Rp. ', 'LB', 0, 'C');
			$pdf->Cell(27, 4, number_format($bh->nominal,0), 'RB', 1, 'R');
	
			$i++; $ttl=$ttl+$bh->nominal;
		}
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(90, 5, 'Total Biaya Hidup', 1, 0, 'C');
		$pdf->Cell(8, 5, 'Rp. ', 'LB', 0, 'C');
		$pdf->Cell(27, 5, number_format($ttl,0), 'RB', 1, 'R');

		$pdf->SetFont('Times', '', 10);	
		// $pdf->Cell(190, 4, 'Catatan : ', 0, 1, 'L');
        $analisa = str_replace('&quot;','"',$ans['catatan_biaya_hdp']);
        $analisa = str_replace('&nbsp;',' ',$analisa);
		$analisa = str_replace('&ndash;','-',$analisa);
		$analisa = str_replace('&#39;',"'",$analisa);

		$pdf->MultiCell(190, 4, strip_tags($analisa), '', 'J', false);		

		$pdf->Cell(190, 4, '', 0, 1, 'C');
		$pdf->SetFont('Times', 'IU', 10);
		$pdf->Cell(45, 4, 'e. Analisa Kemampuan', '', 1, 'L');

		$sql = "select a.* from viewpendapatan a 
		where a.id_pengajuan = $id ";
		$rekap_pend = $this->db->query($sql)->result();
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(10, 5, 'No.', 1, 0, 'C');
		$pdf->Cell(80, 5, 'Keterangan', 1, 0, 'C');
		$pdf->Cell(70, 5, 'Nominal (Rupiah)', 1, 1, 'C');
		$pdf->SetFont('Times', '', 10);
		$i=1; $ttl=0;
		foreach ($rekap_pend as $pd)
		{
			$pdf->Cell(10, 4, $i, 1, 0, 'C');
			$pdf->Cell(80, 4, $pd->keterangan, 1, 0, 'L');
			$pdf->Cell(35, 4, number_format($pd->nett,0), '1', 0, 'R');
			$pdf->Cell(35, 4, '', '1', 1, 'R');
	
			$i++; $ttl=$ttl+$pd->nett;
		}
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(90, 5, 'Total Pendapatan', 'LB', 0, 'C');
		$pdf->Cell(35, 5, '', 'BR', 0, 'C');
		$pdf->Cell(35, 5, number_format($ttl,0), 'RB', 1, 'R');

		$pdf->SetFont('Times', '', 10);

		$rekap_biaya = $this->pinjaman_model->spViewBiaya($id);

		$i=$i; $ttlby=0;
		foreach ($rekap_biaya as $by)
		{
			$pdf->Cell(10, 4, $i, 1, 0, 'C');
			$pdf->Cell(80, 4, $by->keterangan, 1, 0, 'L');
			$pdf->Cell(35, 4, number_format($by->nominal,0), '1', 0, 'R');
			$pdf->Cell(35, 4, '', '1', 1, 'R');
	
			$i++; $ttlby=$ttlby+$by->nominal;
		}
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(90, 5, 'Total Biaya dan Angsuran', 'LB', 0, 'C');
		$pdf->Cell(35, 5, '', 'BR', 0, 'C');
		$pdf->Cell(35, 5, '('.number_format($ttlby,0).')', 'RB', 1, 'R');

		$pdf->Cell(90, 5, 'Sisa Pendapatan Bersih', 'LB', 0, 'C');
		$pdf->Cell(35, 5, '', 'BR', 0, 'C');
		
		if($ttl-$ttlby < 0){
    		$pdf->Cell(35, 5, '('.number_format($ttl-$ttlby,0).')', 'RB', 1, 'R');    
		} else {
		    $pdf->Cell(35, 5, number_format($ttl-$ttlby,0), 'RB', 1, 'R');    
		}
		

		$pdf->SetFont('Times', '', 10);		
		// $pdf->Cell(190, 4, 'Catatan : ', 0, 1, 'L');
        $analisa = str_replace('&quot;','"',$ans['catatan_kemampuan']);
        $analisa = str_replace('&nbsp;',' ',$analisa);
		$analisa = str_replace('&ndash;','-',$analisa);
		$analisa = str_replace('&#39;',"'",$analisa);
        
		$pdf->MultiCell(190, 4, strip_tags($analisa), '', 'J', false);

		$pdf->Cell(190, 4, '', 0, 1, 'C');
		$pdf->SetFont('Times', 'BU', 10);
		$pdf->Cell(45, 4, '4. ANALISA AGUNAN', '', 1, 'L');	

		$sql = "select * From analisa_agunan where id_pengajuan=$id ;";
		$aag = $this->db->query($sql)->row_array();

		$pdf->SetFont('Times', '', 10);		
		$pdf->Cell(190, 4, '', 0, 1, 'L');
		
		$sql = "select sum(a.nilai_ht_fidusia) as nilai_ht_fidusia, 
		sum((select (a.prosen_taksasi/100) * sum(total) from jaminan_nilai_pasar where id_header = a.id)) as nilai_taksasi,
		sum((select sum(total) from jaminan_nilai_pasar where id_header = a.id)) as nilai_pasar from jaminan_pinjaman_header a 
		where a.id_pengajuan=$id ;";
		$jam = $this->db->query($sql)->result();

		foreach ($jam as $jm){
			$pdf->SetFont('Times', '', 10);		

			// $pdf->Cell(190, 4, '', 0, 1, 'C');
			
			$pdf->SetFont('Times', 'B', 10);
			$pdf->Cell(10, 5, 'No.', 1, 0, 'C');
			$pdf->Cell(60, 5, 'Keterangan', 1, 0, 'C');
			$pdf->Cell(35, 5, 'Nominal (Rupiah)', 1, 0, 'C');
			$pdf->Cell(35, 5, 'Cover Ratio', 1, 1, 'C');
			$pdf->SetFont('Times', '', 10);

			$pdf->Cell(10, 5, '1', 1, 0, 'C');
			$pdf->Cell(60, 5, 'Nilai Pasar', 1, 0, 'L');
			$pdf->Cell(35, 5, number_format($jm->nilai_pasar,0), 1, 0, 'R');
			$pdf->Cell(35, 5, number_format($jm->nilai_pasar / $total_plafond*100,2).'%', 1, 1, 'R');
			
			$pdf->Cell(10, 5, '2', 1, 0, 'C');
			$pdf->Cell(60, 5, 'Nilai Taksasi', 1, 0, 'L');
			$pdf->Cell(35, 5, number_format($jm->nilai_taksasi,0), 1, 0, 'R');
			$pdf->Cell(35, 5, number_format($jm->nilai_taksasi / $total_plafond*100,2).'%', 1, 1, 'R');
			
			$pdf->Cell(10, 5, '3', 1, 0, 'C');
			$pdf->Cell(60, 5, 'Nilai HT/Fidusia', 1, 0, 'L');
			$pdf->Cell(35, 5, number_format($jm->nilai_ht_fidusia,0), 1, 0, 'R');
			$pdf->Cell(35, 5, number_format($jm->nilai_ht_fidusia / $total_plafond*100,2).'%', 1, 1, 'R');
			
			$pdf->SetFont('Times', 'B', 10);
			$pdf->Cell(70, 5, 'Total Pinjaman', 1, 0, 'L');
			$pdf->Cell(70, 5, number_format($total_plafond,0), 1, 1, 'R');

			// $pdf->SetFont('Times', '', 10);		
			// $pdf->MultiCell(190, 4, strip_tags($jm->analisa_agunan_map), '', 'J', false);
		}
		
		$pdf->SetFont('Times', '', 10);
		$pdf->MultiCell(190, 4, $aag['analisa_agunan'], '', 'J', false);

		$pdf->Cell(190, 4, '', 0, 1, 'C');
		$pdf->SetFont('Times', 'BU', 10);
		$pdf->Cell(45, 4, '5. KESIMPULAN', '', 1, 'L');	

		$pdf->SetFont('Times', '', 10);
        $analisa = str_replace('&quot;','"',$ans['kesimpulan']);
        $analisa = str_replace('&nbsp;',' ',$analisa);
		$analisa = str_replace('&ndash;','-',$analisa);
		$analisa = str_replace('&#39;',"'",$analisa);

		$pdf->MultiCell(190, 4, strip_tags($analisa), '', 'J', false);
		$pdf->Cell(190, 4, '', 0, 1, 'C');

		//foto usaha
		
		$sql = "select count(id) as recc From pendapatan_usaha_foto where id_header in ( select id From pendapatan_usaha_header where id_pengajuan = $id);";
		$cekFoto = $this->db->query($sql)->row_array();
		if($cekFoto['recc']>0){
		   		$pdf->AddPage(); //gambar jaminan di halaman baru
		
        		$pdf->SetFont('Times', 'B', 10);
        		$pdf->Cell(190, 8, 'FOTO USAHA', 'T', 1, 'C');	
        
        		$pdf->SetFont('Times', '', 10);
        		$sql = "select * From pendapatan_usaha_foto where id_header in (
        			select id From pendapatan_usaha_header where id_pengajuan = $id) order by id;";
        		$fot = $this->db->query($sql)->result();
        		foreach ($fot as $f)
        		{	
        			
        			$y_awal = $pdf->GetY(); 
        			
        			$pdf->Image('uploads/foto/'.$f->foto_kiri,10,$y_awal,90,50,'JPG','');
        
        			$pdf->SetXY(10,$y_awal+50);
        
        			$pdf->Cell(90, 7, $f->keterangan_kiri, 'B', 01, 'C');
        			$pdf->Cell(90, 3, '', '', 0, 'C');
        					
        			$pdf->Image('uploads/foto/'.$f->foto_kanan,110,$y_awal,90,50,'JPG','');
        
        			$pdf->SetXY(110,$y_awal+50);
        
        			$pdf->Cell(90, 7, $f->keterangan_kanan, 'B', 1, 'C');
        			$pdf->Cell(90, 3, '', '', 1, 'C');
        			// $y_akhir=$y_awal+75; // dan ini dipake buat perhitungan tinggi baris yg lain									
        			
        		} 
		}
		


		$pdf->AddPage();

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TIM PENYUSUN', 1, 1, 'C');	

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(49, 4, $rpt['jabatan1'], 'L', 0, 'C');
		$pdf->Cell(47, 4, $rpt['jabatan2'], '', 0, 'C');
		$pdf->Cell(47, 4, $rpt['jabatan3'], '', 0, 'C');
		$pdf->Cell(47, 4, $rpt['jabatan4'], 'R', 1, 'C');

		$pdf->Cell(49, 14, '', 'L', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', 'R', 1, 'C');

		$pdf->Cell(49, 4, $rpt['penyusun1'], 'LB', 0, 'C');
		$pdf->Cell(47, 4, $rpt['penyusun2'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $rpt['penyusun3'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $rpt['penyusun4'], 'RB', 1, 'C');

		$sql = "select * from pengurus_koperasi where grup = 'REKOMENDASI';";
		$grp = $this->db->query($sql)->row_array();

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TIM REKOMENDASI', 1, 1, 'C');	

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(49, 4, $grp['jabatan'], 'L', 0, 'C');
		$pdf->Cell(47, 4, '', '', 0, 'C');
		$pdf->Cell(47, 4, '', '', 0, 'C');
		$pdf->Cell(47, 4, '', 'R', 1, 'C');

		$pdf->Cell(49, 14, '', 'L', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', 'R', 1, 'C');

		$pdf->Cell(49, 4, $grp['nama_pengurus'], 'LB', 0, 'C');
		$pdf->Cell(47, 4, '', 'B', 0, 'C');
		$pdf->Cell(47, 4, '', 'B', 0, 'C');
		$pdf->Cell(47, 4, '', 'RB', 1, 'C');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TIM KOMITE KEPUTUSAN', 1, 1, 'C');	
		
		$sql = "select sum(plafond_akhir) as baki_debet from fasilitas_pinjaman
		where id_pengajuan = $id";
		$baki = $this->db->query($sql)->row_array();
		$bk = $baki['baki_debet'];
		if($rpt['komite']==1){
			$sql = "select a.*,
			ifnull(d.nama_pengurus,'') as kom1, ifnull(d.jabatan,'') as jabatan1,
			ifnull(e.nama_pengurus,'') as kom2, ifnull(e.jabatan,'') as jabatan2,
			ifnull(f.nama_pengurus,'') as kom3, ifnull(f.jabatan,'') as jabatan3,
			ifnull(g.nama_pengurus,'') as kom4, ifnull(g.jabatan,'') as jabatan4 
			from komite_pum a left join pengurus_koperasi d on a.komite1=d.id
			left join pengurus_koperasi e on a.komite2=e.id
			left join pengurus_koperasi f on a.komite3=f.id
			left join pengurus_koperasi g on a.komite4=g.id
			where $bk between a.baki_debet_from and a.baki_debet_to";
		}else{
			$sql = "select a.*,
			ifnull(d.nama_pengurus,'') as kom1, ifnull(d.jabatan,'') as jabatan1,
			ifnull(e.nama_pengurus,'') as kom2, ifnull(e.jabatan,'') as jabatan2,
			ifnull(f.nama_pengurus,'') as kom3, ifnull(f.jabatan,'') as jabatan3,
			ifnull(g.nama_pengurus,'') as kom4, ifnull(g.jabatan,'') as jabatan4 
			from komite a left join pengurus_koperasi d on a.komite1=d.id
			left join pengurus_koperasi e on a.komite2=e.id
			left join pengurus_koperasi f on a.komite3=f.id
			left join pengurus_koperasi g on a.komite4=g.id
			where $bk between a.baki_debet_from and a.baki_debet_to";	
		};
		$komite = $this->db->query($sql)->row_array();

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(49, 4, $komite['jabatan1'], 'L', 0, 'C');
		$pdf->Cell(47, 4, $komite['jabatan2'], '', 0, 'C');
		$pdf->Cell(47, 4, $komite['jabatan3'], '', 0, 'C');
		$pdf->Cell(47, 4, $komite['jabatan4'], 'R', 1, 'C');

		$pdf->Cell(49, 14, '', 'L', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', 'R', 1, 'C');

		$pdf->Cell(49, 4, $komite['kom1'], 'LB', 0, 'C');
		$pdf->Cell(47, 4, $komite['kom2'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $komite['kom3'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $komite['kom4'], 'RB', 1, 'C');

		$pdf->Output();
	}

	function print_lpa(){
		$id = $this->uri->segment('3');

		$sql = "select a.*, b.no_rkp, b.id_anggota, c.nama_anggota, c.alamat_ktp, c.no_hp 
			from jaminan_pinjaman_header a left join pengajuan_pinjaman b 
			on a.id_pengajuan=b.id left join anggota c on b.id_anggota=c.id where a.id_pengajuan=$id";
		$rpt = $this->db->query($sql)->row_array();

		$this->load->library('pdf');
		$pdf = new FPDF('p', 'mm', 'A4');
		// membuat halaman baru
		$pdf->AliasNbPages();
		$pdf->AddPage();
		// setting jenis font yang akan digunakan
		
		$GLOBALS['rkp'] = 'No. LPA : LPA - '.$rpt['no_rkp'];
		
		$sql = "select a.* from config_global a ";
		$fot = $this->db->query($sql)->result();
		foreach ($fot as $f)
		{				
			$y_awal = $pdf->GetY(); 
			
			$pdf->Image('uploads/foto/'.$f->image,135,$y_awal,50,15,'JPG','');

			$pdf->SetXY(10,$y_awal+15);

			$pdf->Cell(190, 3, '', '', 1, 'C');			
		}

		$pdf->SetFont('Times', 'BU', 13);
		// $pdf->SetXY(10,4);
		$pdf->Cell(190, 12, 'LAPORAN PENILAIAN AGUNAN', 'LTR', 1, 'L');		

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'DATA NASABAH', 'LRTB', 1, 'C');		

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(50, 4, 'Nama Lengkap', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(135, 4, $rpt['nama_anggota'], 'R', 1, 'L');
	
		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(65,$y_awal);
		$pdf->MultiCell(135, 4, $rpt['alamat_ktp'], 'R', 'J', false);
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain		
		$tinggi=$y_akhir-$y_awal;
		$pdf->SetXY(10,$y_awal);
		$pdf->Cell(50, $tinggi, 'Alamat KTP', 'L', 0, 'L');
		$pdf->Cell(5, $tinggi, ':', '', 1, 'L');

		$pdf->Cell(50, 4, 'Nomor Telp', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(135, 4, $rpt['no_hp'], 'R', 1, 'L');

		$sql = "select a.*, b.jenis_jaminan from jaminan_pinjaman_header a left join 
		jenis_jaminan b on a.id_jenis_jaminan = b.id
		where a.id_pengajuan = $id order by a.id";
		$jam = $this->db->query($sql)->result();

		// for($a=0; $a < count($fas); $a++)
		$a=1; $pasar=0; $taksasi=0; $ht=0;
		foreach ($jam as $p)
		{			
			$pdf->SetFont('Times', 'B', 10);
			$pdf->Cell(190, 5, 'DATA JAMINAN', 'LRTB', 1, 'C');		
		
			$pdf->SetFont('Times', '', 10);
			$sql = "select a.*, b.jenis_jaminan, b.is_header, b.jaminan_level from jaminan_pinjaman_detail a left join 
			jenis_jaminan b on a.id_jenis_jaminan = b.id
			where a.id_header = $p->id order by a.id";
			$dtl = $this->db->query($sql)->result();
			// $pdf->SetFont('Times', '', 10);
			foreach ($dtl as $d)
			{
				$y_awal=$pdf->GetY(); // ini ...
				$pdf->SetXY(65,$y_awal);
				$pdf->MultiCell(135, 4, $d->ket_jaminan, 'R', 'J', false);
				$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain		
				$tinggi=$y_akhir-$y_awal;
				$pdf->SetXY(10,$y_awal);

				if ($d->is_header==1){
					$pdf->SetFont('Times', 'B', 10);
					$pdf->Cell(50, $tinggi, str_repeat(' ',$d->jaminan_level*2).$d->jenis_jaminan, 'L', 0, 'L');
				}else{
					$pdf->SetFont('Times', '', 10);
					$pdf->Cell(50, $tinggi, str_repeat(' ',$d->jaminan_level*2).$d->jenis_jaminan, 'L', 0, 'L');
				}
				$pdf->SetFont('Times', '', 10);
				if ($d->is_header==1){
					$pdf->Cell(5, $tinggi, '', 0, 1, 'L');
				}else{
					$pdf->Cell(5, $tinggi, ':', 0, 1, 'L');
				}
			}
				// $pdf->cell(135, 4, $d->ket_jaminan, 'R', 1, 'L');
			

			$pdf->Cell(190, 4, '', 'LR', 1, 'L');

			$pdf->SetFont('Times', 'B', 10);
			$pdf->Cell(190, 5, 'PERBANDINGAN NILAI PASAR', 'LRTB', 1, 'C');	

			$sql = "select a.*, b.nama_situs, b.alamat, b.taksasi, d.satuan, e.jaminan,
			(select sum(total) from survey_nilai_pasar_detail where id_survey=a.id_survey) as grand_total
			From survey_nilai_pasar_detail a left join survey_nilai_pasar_header b
			on a.id_survey=b.id left join jaminan_pinjaman_header c on b.id_header=c.id
			left join mst_satuan d on a.id_satuan=d.id left join mst_jaminan e on a.id_jaminan=e.id			
			where c.id_pengajuan = $id and b.id_header = $p->id and b.footer = 'Tidak' order by a.id_survey, a.id";

			$rpt = $this->db->query($sql)->row_array();
			$psr = $this->db->query($sql)->result();
	
	
        	$y_awal=$pdf->GetY(); // ini ...
    		$pdf->SetXY(150,$y_awal);
    		$pdf->multicell(25, 4, 'Harga Asumsi (Rupiah)', 'RB', 'C');
    		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain
    		
            $tinggi=$y_akhir-$y_awal;
    
    		$pdf->SetXY(175,$y_awal);
    		$pdf->multicell(25, 4, 'Harga Jual (Rupiah)', 'RB', 'C');
    
    		$pdf->SetXY(10,$y_awal);
    		$pdf->multicell(8, $tinggi, 'No', 'LRB', 'C');
	
    		$pdf->SetXY(18,$y_awal);
    		$pdf->multicell(30, $tinggi, 'Nama Situs', 'RB', 'C');
		
    		$pdf->SetXY(48,$y_awal);
    		$pdf->multicell(65, $tinggi, 'Alamat', 'RB', 'C');

    		$pdf->SetXY(113,$y_awal);
    		$pdf->multicell(22, $tinggi, 'Jaminan', 'RB', 'C');
    		
    		$pdf->SetXY(135,$y_awal);
    		$pdf->multicell(15, $tinggi, 'Jumlah', 'RB', 'C');

		
// 			$pdf->Cell(8, 5, 'No', 'LTRB', 0, 'C');
// 			$pdf->Cell(30, 5, 'Nama Situs', 'RBT', 0, 'L');
// 			$pdf->Cell(65, 5, 'Alamat', 'RBT', 0, 'L');
// 			$pdf->Cell(22, 5, 'Jaminan', 'RBT', 0, 'L');
// 			$pdf->Cell(15, 5, 'Jumlah', 'RBT', 0, 'L');
// 			$pdf->Cell(25, 5, 'Harga Asumsi', 'RBT', 0, 'L');
// 			$pdf->Cell(25, 5, 'Harag Jual', 'RBT', 1, 'R');	

			$pdf->SetFont('Times', '', 9);
			$no = 1; $sr = 0;
			foreach ($psr as $ps)
			{
				$sql = "select a.id_survey, count(a.id_jaminan) as jml
				From survey_nilai_pasar_detail a left join survey_nilai_pasar_header b
				on a.id_survey=b.id left join jaminan_pinjaman_header c on b.id_header=c.id
				left join mst_satuan d on a.id_satuan=d.id left join mst_jaminan e on a.id_jaminan=e.id			
				where c.id_pengajuan = $id and b.id_header = $p->id and a.id_survey = $ps->id_survey and b.footer = 'Tidak' group by a.id_survey";
	
				$nCount = $this->db->query($sql)->row_array();

				if($nCount['jml']==1){
					$pdf->Cell(8, 4, $no, 'LRB', 0, 'C');
					$pdf->Cell(30, 4, $ps->nama_situs, 'RB', 0, 'L');
					$pdf->Cell(65, 4, $ps->alamat, 'RB', 0, 'L');
					$pdf->Cell(22, 4, $ps->jaminan, 'RB', 0, 'L');
					$pdf->Cell(15, 4, number_format($ps->jumlah,0). ' '. $ps->satuan, 'RB', 0, 'L');
					$pdf->Cell(25, 4, number_format($ps->harga), 'RB', 0, 'R');
					$pdf->Cell(25, 4, number_format($ps->grand_total), 'RB', 1, 'R');	
				} else {
					if($sr==$ps->id_survey) {
						$pdf->Cell(8, 4, '', 'LRB', 0, 'C');
						$pdf->Cell(30, 4, '', 'RB', 0, 'L');
						$pdf->Cell(65, 4, '', 'RB', 0, 'L');
						$pdf->Cell(22, 4, $ps->jaminan, 'RB', 0, 'L');
						$pdf->Cell(15, 4, number_format($ps->jumlah,0). ' '. $ps->satuan, 'RB', 0, 'L');
						$pdf->Cell(25, 4, number_format($ps->harga), 'RB', 0, 'R');
						$pdf->Cell(25, 4, '', 'RB', 1, 'R');	
						$no = $no-1;					
					} else {
						$pdf->Cell(8, 4, $no, 'LR', 0, 'C');
						$pdf->Cell(30, 4, $ps->nama_situs, 'R', 0, 'L');
						$pdf->Cell(65, 4, $ps->alamat, 'R', 0, 'L');
						$pdf->Cell(22, 4, $ps->jaminan, 'RB', 0, 'L');
						$pdf->Cell(15, 4, number_format($ps->jumlah,0). ' '. $ps->satuan, 'RB', 0, 'L');
						$pdf->Cell(25, 4, number_format($ps->harga), 'RB', 0, 'R');
						$pdf->Cell(25, 4, number_format($ps->grand_total), 'R', 1, 'R');	
					}
				}

				$sr = $ps->id_survey;	
				$no = $no + 1;
			}

			$sql = "select 'Harga Rata Rata' as ket, a.id_jaminan, e.jaminan, sum(a.harga) / count(a.id_jaminan) as rata2
			From survey_nilai_pasar_detail a left join survey_nilai_pasar_header b
			on a.id_survey=b.id left join jaminan_pinjaman_header c on b.id_header=c.id
			left join mst_satuan d on a.id_satuan=d.id left join mst_jaminan e on a.id_jaminan=e.id
			where c.id_pengajuan = $id and b.id_header = $p->id and b.footer = 'Tidak' group by a.id_jaminan, e.jaminan";

			$rpt = $this->db->query($sql)->row_array();
			$psr = $this->db->query($sql)->result();
	
			$pdf->SetFont('Times', '', 9);
			$no = 1; $sr = '';
			foreach ($psr as $ps)
			{
				$sql = "select count(a.id_survey) as jml
				From survey_nilai_pasar_detail a left join survey_nilai_pasar_header b
				on a.id_survey=b.id left join jaminan_pinjaman_header c on b.id_header=c.id
				left join mst_satuan d on a.id_satuan=d.id left join mst_jaminan e on a.id_jaminan=e.id
				where c.id_pengajuan = $id and b.id_header = $p->id and b.footer = 'Tidak' group by a.id_survey limit 1";
	
				$nCount = $this->db->query($sql)->row_array();

				if($nCount['jml']==1){
					$pdf->Cell(8, 4, $ps->ket, 'LB', 0, 'L');
					$pdf->Cell(30, 4, '', 'B', 0, 'L');
					$pdf->Cell(65, 4, '', 'RB', 0, 'L');
					$pdf->Cell(22, 4, $ps->jaminan, 'B', 0, 'L');
					$pdf->Cell(15, 4, '', 'RB', 0, 'L');
					$pdf->Cell(25, 4, number_format($ps->rata2), 'RB', 0, 'R');
					$pdf->Cell(25, 4, '', 'RB', 1, 'R');	
				} else {
					if($sr==$ps->ket) {
						$pdf->Cell(8, 4, '', 'LB', 0, 'C');
						$pdf->Cell(30, 4, '', 'B', 0, 'L');
						$pdf->Cell(65, 4, '', 'RB', 0, 'L');
						$pdf->Cell(22, 4, $ps->jaminan, 'B', 0, 'L');
						$pdf->Cell(15, 4, '', 'RB', 0, 'L');
						$pdf->Cell(25, 4, number_format($ps->rata2), 'RB', 0, 'R');
						$pdf->Cell(25, 4, '', 'RB', 1, 'R');	
						$no = $no-1;					
					} else {
						$pdf->Cell(8, 4, $ps->ket, 'L', 0, 'L');
						$pdf->Cell(30, 4, '', '', 0, 'L');
						$pdf->Cell(65, 4, '', 'R', 0, 'L');
						$pdf->Cell(22, 4, $ps->jaminan, 'B', 0, 'L');
						$pdf->Cell(15, 4, '', 'RB', 0, 'L');
						$pdf->Cell(25, 4, number_format($ps->rata2), 'RB', 0, 'R');
						$pdf->Cell(25, 4, '', 'R', 1, 'R');	
					}
				}
				$sr = $ps->ket;	
				$no = $no + 1;
			}


			$sql = "select a.*, b.nama_situs, b.alamat, b.taksasi, d.satuan, e.jaminan,
			(select sum(total) from survey_nilai_pasar_detail where id_survey=a.id_survey) as grand_total
			From survey_nilai_pasar_detail a left join survey_nilai_pasar_header b
			on a.id_survey=b.id left join jaminan_pinjaman_header c on b.id_header=c.id
			left join mst_satuan d on a.id_satuan=d.id left join mst_jaminan e on a.id_jaminan=e.id			
			where c.id_pengajuan = $id and b.id_header = $p->id and b.footer = 'Ya' and b.harga_sekarang = 'Tidak' order by a.id_survey, a.id";

			$rpt = $this->db->query($sql)->row_array();
			$psr = $this->db->query($sql)->result();

			$pdf->SetFont('Times', '', 9);
			$no = 1; $sr = 0;
			foreach ($psr as $ps)
			{
				$sql = "select count(a.id_survey) as jml
				From survey_nilai_pasar_detail a left join survey_nilai_pasar_header b
				on a.id_survey=b.id left join jaminan_pinjaman_header c on b.id_header=c.id
				left join mst_satuan d on a.id_satuan=d.id left join mst_jaminan e on a.id_jaminan=e.id
				where c.id_pengajuan = $id and b.id_header = $p->id and b.footer = 'Tidak' group by a.id_survey limit 1";
	
				$nCount = $this->db->query($sql)->row_array();

				if($nCount['jml']==1){
					$pdf->Cell(8, 4, $ps->nama_situs, 'LB', 0, 'L');
					$pdf->Cell(30, 4, '', 'B', 0, 'L');
					$pdf->Cell(65, 4, $ps->alamat, 'RB', 0, 'L');
					$pdf->Cell(22, 4, $ps->jaminan, 'RB', 0, 'L');
					$pdf->Cell(15, 4, number_format($ps->jumlah,0). ' '. $ps->satuan, 'RB', 0, 'L');
					$pdf->Cell(25, 4, number_format($ps->harga), 'RB', 0, 'R');
					$pdf->Cell(25, 4, number_format($ps->grand_total), 'RB', 1, 'R');	
				} else {

					if($sr==$ps->id_survey) {
						$pdf->Cell(8, 4, '', 'LB', 0, 'C');
						$pdf->Cell(30, 4, '', 'B', 0, 'L');
						$pdf->Cell(65, 4, '', 'RB', 0, 'L');
						$pdf->Cell(22, 4, $ps->jaminan, 'RB', 0, 'L');
						$pdf->Cell(15, 4, number_format($ps->jumlah,0). ' '. $ps->satuan, 'RB', 0, 'L');
						$pdf->Cell(25, 4, number_format($ps->harga), 'RB', 0, 'R');
						$pdf->Cell(25, 4, '', 'RB', 1, 'R');	
						$no = $no-1;					
					} else {
						$pdf->Cell(8, 4, $ps->nama_situs, 'L', 0, 'L');
						$pdf->Cell(30, 4, '', '', 0, 'L');
						$pdf->Cell(65, 4, $ps->alamat, 'R', 0, 'L');
						$pdf->Cell(22, 4, $ps->jaminan, 'RB', 0, 'L');
						$pdf->Cell(15, 4, number_format($ps->jumlah,0). ' '. $ps->satuan, 'RB', 0, 'L');
						$pdf->Cell(25, 4, number_format($ps->harga), 'RB', 0, 'R');
						$pdf->Cell(25, 4, number_format($ps->grand_total), 'R', 1, 'R');	
					}
				}
				$sr = $ps->id_survey;	
				$no = $no + 1;
			}

			$sql = "select a.*, b.nama_situs, b.alamat, b.taksasi, d.satuan, e.jaminan,
			(select sum(total) from survey_nilai_pasar_detail where id_survey=a.id_survey) as grand_total
			From survey_nilai_pasar_detail a left join survey_nilai_pasar_header b
			on a.id_survey=b.id left join jaminan_pinjaman_header c on b.id_header=c.id
			left join mst_satuan d on a.id_satuan=d.id left join mst_jaminan e on a.id_jaminan=e.id			
			where c.id_pengajuan = $id and b.id_header = $p->id and b.footer = 'Ya' and b.harga_sekarang = 'Ya' order by a.id_survey, a.id";

			$rpt = $this->db->query($sql)->row_array();
			$psr = $this->db->query($sql)->result();

			$pdf->SetFont('Times', '', 9);
			$no = 1; $sr = 0;
			foreach ($psr as $ps)
			{
				$sql = "select count(a.id_survey) as jml
				From survey_nilai_pasar_detail a left join survey_nilai_pasar_header b
				on a.id_survey=b.id left join jaminan_pinjaman_header c on b.id_header=c.id
				left join mst_satuan d on a.id_satuan=d.id left join mst_jaminan e on a.id_jaminan=e.id
				where c.id_pengajuan = $id and b.id_header = $p->id and b.footer = 'Tidak' group by a.id_survey limit 1";
	
				$nCount = $this->db->query($sql)->row_array();
				if($nCount['jml']==1){
					$pdf->Cell(8, 4, $ps->nama_situs, 'LB', 0, 'L');
					$pdf->Cell(30, 4, '', 'B', 0, 'L');
					$pdf->Cell(65, 4, $ps->alamat, 'RB', 0, 'L');
					$pdf->Cell(22, 4, $ps->jaminan, 'RB', 0, 'L');
					$pdf->Cell(15, 4, number_format($ps->jumlah,0). ' '. $ps->satuan, 'RB', 0, 'L');
					$pdf->Cell(25, 4, number_format($ps->harga), 'RB', 0, 'R');
					$pdf->Cell(25, 4, number_format($ps->grand_total), 'RB', 1, 'R');	
				} else {

					if($sr==$ps->id_survey) {
						$pdf->Cell(8, 4, '', 'LB', 0, 'C');
						$pdf->Cell(30, 4, '', 'B', 0, 'L');
						$pdf->Cell(65, 4, '', 'RB', 0, 'L');
						$pdf->Cell(22, 4, $ps->jaminan, 'RB', 0, 'L');
						$pdf->Cell(15, 4, number_format($ps->jumlah,0). ' '. $ps->satuan, 'RB', 0, 'L');
						$pdf->Cell(25, 4, number_format($ps->harga), 'RB', 0, 'R');
						$pdf->Cell(25, 4, '', 'RB', 1, 'R');	
						$no = $no-1;					
					} else {
						$pdf->Cell(8, 4, $ps->nama_situs, 'L', 0, 'L');
						$pdf->Cell(30, 4, '', '', 0, 'L');
						$pdf->Cell(65, 4, $ps->alamat, 'R', 0, 'L');
						$pdf->Cell(22, 4, $ps->jaminan, 'RB', 0, 'L');
						$pdf->Cell(15, 4, number_format($ps->jumlah,0). ' '. $ps->satuan, 'RB', 0, 'L');
						$pdf->Cell(25, 4, number_format($ps->harga), 'RB', 0, 'R');
						$pdf->Cell(25, 4, number_format($ps->grand_total), 'R', 1, 'R');	
					}
				}
				
				$sr = $ps->id_survey;	
				$no = $no + 1;
			}

			if (empty($ps->taksasi)){
				$pdf->Cell(8, 4, '', 'LB', 0, 'L');	
			} else {
				$pdf->Cell(8, 4, 'Nilai Taksasi ( '.$ps->taksasi. '% Dari Nilai Pasar )', 'LB', 0, 'L');
			}

			$pdf->Cell(32, 4, '', 'B', 0, 'L');
			$pdf->Cell(60, 4, '', 'B', 0, 'L');
			$pdf->Cell(25, 4, '', 'B', 0, 'L');
			$pdf->Cell(15, 4, '', 'B', 0, 'L');
			$pdf->Cell(25, 4, '', 'RB', 0, 'R');

			if (empty($ps->taksasi)){
				$pdf->Cell(25, 4, '', 'LBR', 0, 'L');	
			} else {
				$pdf->Cell(25, 4, number_format($ps->grand_total * ($ps->taksasi / 100)), 'LBR', 0, 'R');
			}

			$pdf->Cell(190, 4, '', 'LR', 1, 'L');
			$pdf->SetFont('Times', 'B', 10);
			$pdf->Cell(190, 5, 'PENILAIAN NILAI PASAR & TAKSASI', 'LRTB', 1, 'C');		
		
			$pdf->SetFont('Times', '', 10);
	
			$sql = "select a.*, b.prosen_taksasi, b.informasi_nilai_pasar, c.satuan From jaminan_nilai_pasar a left join 
			jaminan_pinjaman_header b on a.id_header=b.id left join mst_satuan c on a.id_satuan=c.id
			where b.id_pengajuan = $id and b.id = $p->id ";
			$rpt = $this->db->query($sql)->row_array();
			$psr = $this->db->query($sql)->result();
			
			$total=0;
			foreach ($psr as $ps)
			{
				$pdf->Cell(50, 4, $ps->keterangan, 'L', 0, 'L');
				$pdf->Cell(5, 4, ':', 0, 0, 'L');
				$pdf->Cell(20, 4, number_format($ps->jumlah,0). ' '. $ps->satuan, 0, 0, 'L');
				$pdf->Cell(5, 4, 'x  Rp. ', 0, 0, 'L');
				$pdf->Cell(30, 4, number_format($ps->harga,0), 0, 0, 'R');
				$pdf->Cell(5, 4, '=  Rp. ', 0, 0, 'L');
				$pdf->Cell(30, 4, number_format($ps->total,0), 0, 0, 'R');
				$pdf->Cell(45, 4, '', 'R', 1, 'L');

				$total = $total + $ps->total;
			}

			$pdf->Cell(110, 4, 'NILAI PASAR WAJAR' , 'L', 0, 'L');
			$pdf->Cell(5, 4, '=  Rp. ', 0, 0, 'L');
			$pdf->Cell(30, 4, number_format($total,0), 'T', 0, 'R');
			$pdf->Cell(45, 4, '', 'R', 1, 'L');

			$pdf->Cell(110, 4, 'NILAI TAKSASI ( '. $rpt['prosen_taksasi']. '% x NILAI PASAR WAJAR )' , 'LB', 0, 'L');
			$pdf->Cell(5, 4, '=  Rp. ', 'B', 0, 'L');
			$pdf->Cell(30, 4, number_format($total * ($rpt['prosen_taksasi']/100),0), 'B', 0, 'R');
			$pdf->Cell(45, 4, '', 'RB', 1, 'L');

			// $pdf->SetFont('Times', 'B', 10);
			// $pdf->Cell(190, 5, 'INFORMASI NILAI PASAR', 'LRTB', 1, 'C');	
			$sql = "select a.* from catatan_nilai_pasar a where a.id_header = $p->id and a.id_pengajuan = $id;";
			$catPs = $this->db->query($sql)->row_array();

			$pdf->SetFont('Times', '', 10);
			// $pdf->Cell(190, 4, 'Catatan : ', '', 1, 'L');	
			$pdf->MultiCell(190, 4, 'Catatan : '.$catPs['catatan_nilai_pasar'], 'LRTB', 'L', false);

			// $pdf->Cell(190, 4, '', '', 1, 'L');
		

        	$sql = "select count(id) as recc from jaminan_pinjaman_foto a where a.id_header = $p->id";
			$cekFoto = $this->db->query($sql)->row_array();

            if($cekFoto['recc']>0){
                $pdf->AddPage(); //gambar jaminan di halaman baru

    			$pdf->SetFont('Times', 'B', 10);
    			$pdf->Cell(190, 8, 'FOTO JAMINAN', 'T', 1, 'C');	
    
    			$pdf->SetFont('Times', '', 10);
    			$sql = "select a.* from jaminan_pinjaman_foto a where a.id_header = $p->id order by a.id";
    			$fot = $this->db->query($sql)->result();
    			foreach ($fot as $f)
    			{	
    				
    				$y_awal = $pdf->GetY(); 
    				
    				$pdf->Image('uploads/foto/'.$f->foto_kiri,10,$y_awal,90,50,'JPG','');
    
    				$pdf->SetXY(10,$y_awal+50);
    
    				$pdf->Cell(90, 7, $f->keterangan_kiri, 'B', 01, 'C');
    				$pdf->Cell(90, 3, '', '', 0, 'C');
    						
    				$pdf->Image('uploads/foto/'.$f->foto_kanan,110,$y_awal,90,50,'JPG','');
    
    				$pdf->SetXY(110,$y_awal+50);
    
    				$pdf->Cell(90, 7, $f->keterangan_kanan, 'B', 1, 'C');
    				$pdf->Cell(90, 3, '', '', 1, 'C');
    				// $y_akhir=$y_awal+75; // dan ini dipake buat perhitungan tinggi baris yg lain									
				
			    }
            }			
			
			$pdf->AddPage();
				// $pdf->Cell(190, 4, '', 'LBR', 1, 'L');			
		}

		// $pdf->AddPage();
		
		$sql = "select a.*, b.no_anggota, b.nama_anggota, b.tgl_lahir, b.no_referentor, b.nama_referentor, b.nama_ibu_kandung, 
		b.alamat_ktp, b.alamat_domisili, b.no_hp, b.nama_usaha, b.alamat_usaha, b.no_telp_usaha,
		b.bidang_usaha, b.lama_bekerja, TIMESTAMPDIFF(YEAR, b.tgl_lahir, NOW() ) AS usia, c.jenis_pinjaman,
		d.nama_pengurus as penyusun1, d.jabatan as jabatan1,
		e.nama_pengurus as penyusun2, e.jabatan as jabatan2,
		f.nama_pengurus as penyusun3, f.jabatan as jabatan3,
		g.nama_pengurus as penyusun4, g.jabatan as jabatan4
		from pengajuan_pinjaman a left join anggota b on a.id_anggota=b.id
		left join jenis_pinjaman c on a.id_jenis_pinjaman=c.id
		left join pengurus_koperasi d on a.penyusun1=d.id
		left join pengurus_koperasi e on a.penyusun2=e.id
		left join pengurus_koperasi f on a.penyusun3=f.id
		left join pengurus_koperasi g on a.penyusun4=g.id
		where a.id = $id";

		$rpt = $this->db->query($sql)->row_array();

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TIM PENYUSUN', 1, 1, 'C');	

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(49, 4, $rpt['jabatan1'], 'L', 0, 'C');
		$pdf->Cell(47, 4, $rpt['jabatan2'], '', 0, 'C');
		$pdf->Cell(47, 4, $rpt['jabatan3'], '', 0, 'C');
		$pdf->Cell(47, 4, $rpt['jabatan4'], 'R', 1, 'C');

		$pdf->Cell(49, 14, '', 'L', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', 'R', 1, 'C');

		$pdf->Cell(49, 4, $rpt['penyusun1'], 'LB', 0, 'C');
		$pdf->Cell(47, 4, $rpt['penyusun2'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $rpt['penyusun3'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $rpt['penyusun4'], 'RB', 1, 'C');

		$sql = "select * from pengurus_koperasi where grup = 'REKOMENDASI';";
		$grp = $this->db->query($sql)->row_array();

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TIM REKOMENDASI', 1, 1, 'C');	

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(49, 4, $grp['jabatan'], 'L', 0, 'C');
		$pdf->Cell(47, 4, '', '', 0, 'C');
		$pdf->Cell(47, 4, '', '', 0, 'C');
		$pdf->Cell(47, 4, '', 'R', 1, 'C');

		$pdf->Cell(49, 14, '', 'L', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', 'R', 1, 'C');

		$pdf->Cell(49, 4, $grp['nama_pengurus'], 'LB', 0, 'C');
		$pdf->Cell(47, 4, '', 'B', 0, 'C');
		$pdf->Cell(47, 4, '', 'B', 0, 'C');
		$pdf->Cell(47, 4, '', 'RB', 1, 'C');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TIM KOMITE KEPUTUSAN', 1, 1, 'C');	
		
		$sql = "select sum(plafond_akhir) as baki_debet from fasilitas_pinjaman
		where id_pengajuan = $id";
		$baki = $this->db->query($sql)->row_array();
		$bk = $baki['baki_debet'];
		if($rpt['komite']==1){
			$sql = "select a.*,
			ifnull(d.nama_pengurus,'') as kom1, ifnull(d.jabatan,'') as jabatan1,
			ifnull(e.nama_pengurus,'') as kom2, ifnull(e.jabatan,'') as jabatan2,
			ifnull(f.nama_pengurus,'') as kom3, ifnull(f.jabatan,'') as jabatan3,
			ifnull(g.nama_pengurus,'') as kom4, ifnull(g.jabatan,'') as jabatan4 
			from komite_pum a left join pengurus_koperasi d on a.komite1=d.id
			left join pengurus_koperasi e on a.komite2=e.id
			left join pengurus_koperasi f on a.komite3=f.id
			left join pengurus_koperasi g on a.komite4=g.id
			where $bk between a.baki_debet_from and a.baki_debet_to";
		}else{
			$sql = "select a.*,
			ifnull(d.nama_pengurus,'') as kom1, ifnull(d.jabatan,'') as jabatan1,
			ifnull(e.nama_pengurus,'') as kom2, ifnull(e.jabatan,'') as jabatan2,
			ifnull(f.nama_pengurus,'') as kom3, ifnull(f.jabatan,'') as jabatan3,
			ifnull(g.nama_pengurus,'') as kom4, ifnull(g.jabatan,'') as jabatan4 
			from komite a left join pengurus_koperasi d on a.komite1=d.id
			left join pengurus_koperasi e on a.komite2=e.id
			left join pengurus_koperasi f on a.komite3=f.id
			left join pengurus_koperasi g on a.komite4=g.id
			where $bk between a.baki_debet_from and a.baki_debet_to";	
		};
		$komite = $this->db->query($sql)->row_array();

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(49, 4, $komite['jabatan1'], 'L', 0, 'C');
		$pdf->Cell(47, 4, $komite['jabatan2'], '', 0, 'C');
		$pdf->Cell(47, 4, $komite['jabatan3'], '', 0, 'C');
		$pdf->Cell(47, 4, $komite['jabatan4'], 'R', 1, 'C');

		$pdf->Cell(49, 14, '', 'L', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', '', 0, 'C');
		$pdf->Cell(47, 14, '', 'R', 1, 'C');

		$pdf->Cell(49, 4, $komite['kom1'], 'LB', 0, 'C');
		$pdf->Cell(47, 4, $komite['kom2'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $komite['kom3'], 'B', 0, 'C');
		$pdf->Cell(47, 4, $komite['kom4'], 'RB', 1, 'C');
		
		$pdf->Output();
	}

	public function nilai_pasar($menuid, $id, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pasar'] = $this->pinjaman_model->nilaiPasar($id);
			$data['data_catatan'] = $this->master_model->select_in('catatan_nilai_pasar', '*', "WHERE id_pengajuan = $idRKP and id_header = $id");

    		$this->load->view('pengajuan/nilai_pasar', $data);
	    }
	}

	public function insert_nilai_pasar($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$id = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');

		$data = array(			
			'id_header' => $this->input->post('id_header'),
			'keterangan' => $this->input->post('keterangan'),
			'jumlah' => $this->input->post('jumlah'),
			'id_satuan' => $this->input->post('id_satuan'),
			'harga' => $this->input->post('harga'),
			'total' => $this->input->post('harga') * $this->input->post('jumlah'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('jaminan_nilai_pasar', $data);

		redirect('pengajuan_pinjaman/nilai_pasar/'.$menuid.'/'.$id.'/'.$idRKP);
	}

	public function update_nilai_pasar($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id');
		$idHdr = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');

		$data = array(			
			'id_header' => $this->input->post('id_header'),
			'keterangan' => $this->input->post('keterangan'),
			'jumlah' => $this->input->post('jumlah'),
			'id_satuan' => $this->input->post('id_satuan'),
			'harga' => $this->input->post('harga'),
			'total' => $this->input->post('harga') * $this->input->post('jumlah'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('jaminan_nilai_pasar', $data);

		redirect("pengajuan_pinjaman/nilai_pasar/".$menuid."/".$idHdr."/".$idRKP);
	}	

	public function update_catatan_nilai_pasar($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id');
		$idHdr = $this->input->post('id_header');
		$idRKP = $this->input->post('id_pengajuan');

		$data = array(			
			'catatan_nilai_pasar' => $this->input->post('catatan'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('catatan_nilai_pasar', $data);

		redirect("pengajuan_pinjaman/nilai_pasar/".$menuid."/".$idHdr."/".$idRKP);
	}	

	public function input_jaminan($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jaminan'] = $this->master_model->select_in('jaminan_pinjaman_header','*',"where 1=0");

    		$this->load->view('pengajuan/input_jaminan', $data);
	    }
	}

	public function edit_jaminan($menuid, $idRKP, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jaminan'] = $this->master_model->select_in('jaminan_pinjaman_header','*',"WHERE id_pengajuan = $idRKP and id = $id ");

    		$this->load->view('pengajuan/edit_jaminan', $data);
	    }
	}

	public function update_jaminan($menuid, $idRKP, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$data = array(						
			// 'prosen_taksasi' => $this->input->post('prosen_taksasi'),
			'nilai_ht_fidusia' => $this->input->post('nilai_ht_fidusia'),
			'catatan_rkp' => $this->input->post('catatan_rkp'),
			// 'analisa_agunan_map' => $this->input->post('analisa_agunan_map'),
// 			'informasi_nilai_pasar' => $this->input->post('informasi_nilai_pasar'),
			'catatan_agunan' => $this->input->post('catatan_agunan'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('jaminan_pinjaman_header', $data);

		redirect('pengajuan_pinjaman/jaminan/'.$menuid.'/'.$idRKP);
	}	

	public function update_analisa_agunan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$idRKP = $this->input->post('id_pengajuan');
		$id = $this->input->post('id');
		$data = array(									
			'analisa_agunan' => $this->input->post('catatan'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('analisa_agunan', $data);

		redirect('pengajuan_pinjaman/jaminan/'.$menuid.'/'.$idRKP);
	}	

	public function update_catatan_agunan_rkp($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$idRKP = $this->input->post('id_pengajuan');
		$id = $this->input->post('id');
		$data = array(									
			'catatan_agunan_rkp' => $this->input->post('catatan'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('catatan_agunan_rkp', $data);

		redirect('pengajuan_pinjaman/jaminan/'.$menuid.'/'.$idRKP);
	}	


	public function survey_nilai_pasar($menuid, $id, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$sql="delete From jaminan_nilai_pasar where id_header = $id;";
		$qry = $this->db->query($sql);

		$sql="insert into jaminan_nilai_pasar (id_header, keterangan, jumlah, id_satuan, harga, total,
		create_at, create_by, update_at, update_by)
		select b.id_header, c.jaminan, a.jumlah, a.id_satuan, a.harga, a.total,
		a.create_at, a.create_by, a.update_at, a.update_by From survey_nilai_pasar_detail a left join 
		survey_nilai_pasar_header b on a.id_survey=b.id 
		left join mst_jaminan c on a.id_jaminan=c.id where b.harga_sekarang = 'Ya'
		and b.id_header = $id;";
		$qry = $this->db->query($sql);

		$sql="update jaminan_pinjaman_header set prosen_taksasi = (
		select b.taksasi From survey_nilai_pasar_header b where b.harga_sekarang = 'Ya'
		and b.id_header = $id) where id = $id;";
		$qry = $this->db->query($sql);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_survey'] = $this->pinjaman_model->surveyNilaiPasar($id);
			$data['data_rata'] = $this->pinjaman_model->surveyNilaiPasarRata($id);
			$data['data_footer'] = $this->pinjaman_model->surveyNilaiPasarFooter($id);
			$data['data_now'] = $this->pinjaman_model->surveyNilaiPasarNow($id);

    		$this->load->view('pengajuan/survey_nilai_pasar', $data);
	    }
	}

	public function insert_survey_nilai_pasar($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$id = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');

		$data = array(			
			'id_header' => $this->input->post('id_header'),
			'nama_situs' => $this->input->post('nama_situs'),
			'alamat' => $this->input->post('alamat'),			
			'footer' => $this->input->post('footer'),		
			'taksasi' => $this->input->post('taksasi'),		
			'harga_sekarang' => $this->input->post('harga_sekarang'),		
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('survey_nilai_pasar_header', $data);

		redirect('pengajuan_pinjaman/survey_nilai_pasar/'.$menuid.'/'.$id.'/'.$idRKP);
	}

	public function update_survey_nilai_pasar($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id');
		$idHdr = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');

		$data = array(			
			'id_header' => $this->input->post('id_header'),
			'nama_situs' => $this->input->post('nama_situs'),
			'alamat' => $this->input->post('alamat'),		
			'footer' => $this->input->post('footer'),		
			'taksasi' => $this->input->post('taksasi'),		
			'harga_sekarang' => $this->input->post('harga_sekarang'),		
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('survey_nilai_pasar_header', $data);

		redirect("pengajuan_pinjaman/survey_nilai_pasar/".$menuid."/".$idHdr."/".$idRKP);
	}
	
	public function delete_survey_nilai_pasar($menuid, $idHdr, $idRKP, $id)
	{
		$this->db->where('id', $id);
		$this->db->delete('survey_nilai_pasar_header');

        $this->db->where('id_survey', $id);
    	$this->db->delete('survey_nilai_pasar_detail');
        
		redirect("pengajuan_pinjaman/survey_nilai_pasar/".$menuid."/".$idHdr."/".$idRKP);
	}

	public function survey_nilai_pasar_detail($menuid, $id, $idHdr, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pasar_detail'] = $this->pinjaman_model->surveyNilaiPasarDetail($id);

    		$this->load->view('pengajuan/survey_nilai_pasar_detail', $data);
	    }
	}

	public function insert_survey_nilai_pasar_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$idS = $this->input->post('id_survey');
		$idHdr = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');

		$data = array(			
			'id_survey' => $this->input->post('id_survey'),
			'id_jaminan' => $this->input->post('id_jaminan'),
			'jumlah' => $this->input->post('jumlah'),
			'id_satuan' => $this->input->post('id_satuan'),
			'harga' => $this->input->post('harga'),
			'total' => $this->input->post('harga') * $this->input->post('jumlah'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('survey_nilai_pasar_detail', $data);

		redirect('pengajuan_pinjaman/surveY_nilai_pasar_detail/'.$menuid.'/'.$idS.'/'.$idHdr.'/'.$idRKP);
	}

	public function update_survey_nilai_pasar_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$id = $this->input->post('id');
		$idS = $this->input->post('id_survey');
		$idHdr = $this->input->post('id_header');
		$idRKP = $this->input->post('id_rkp');

		$data = array(			
			'id_jaminan' => $this->input->post('id_jaminan'),
			'jumlah' => $this->input->post('jumlah'),
			'id_satuan' => $this->input->post('id_satuan'),
			'harga' => $this->input->post('harga'),
			'total' => $this->input->post('harga') * $this->input->post('jumlah'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('survey_nilai_pasar_detail', $data);

		redirect("pengajuan_pinjaman/survey_nilai_pasar_detail/".$menuid."/".$idS."/".$idHdr."/".$idRKP);
	}	

	public function delete_survey_nilai_pasar_detail($menuid, $idS, $idHdr, $idRKP, $id)
	{
		$this->db->where('id', $id);
		$this->db->delete('survey_nilai_pasar_detail');

		redirect("pengajuan_pinjaman/survey_nilai_pasar_detail/".$menuid."/".$idS."/".$idHdr."/".$idRKP);
	}

	public function duplikasi_pengajuan_pinjaman($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$sql="insert into pengajuan_pinjaman (no_rkp, tgl_rkp, no_rkp_sebelum, ms_external, id_anggota, tujuan_pinjaman, pekerjaan, id_kategori_usaha, sektor_ekonomi, id_jenis_pinjaman,
		penyusun1, penyusun2, penyusun3, penyusun4, komite, create_by, create_at, update_by, update_at)
		select concat(no_rkp,'-copy'), tgl_rkp, no_rkp_sebelum, ms_external, id_anggota, tujuan_pinjaman, pekerjaan, id_kategori_usaha, sektor_ekonomi, id_jenis_pinjaman, penyusun1,
		penyusun2, penyusun3, penyusun4, komite, create_by, create_at, update_by, update_at
		From pengajuan_pinjaman where id = $idRKP;";
		$qry = $this->db->query($sql);
		
		$data_edit=$this->pinjaman_model->getLastID();
		$id = $data_edit[0]->last_id;

		$sql="insert into fasilitas_pinjaman (id_pengajuan, id_jenis_pinjaman, id_perhitungan_bunga, plafond_awal, baki_debet, usulan_pinjaman, plafond_akhir,
		jangka_waktu, bunga_tahun, provisi, komisi, angsuran_bulan, keterangan, tujuan_pengajuan, is_map, no_rek_pinjaman, periode_awal, periode_akhir, 
		create_at, create_by, update_at, update_by)
		select $id, id_jenis_pinjaman, id_perhitungan_bunga, plafond_awal, baki_debet, usulan_pinjaman, plafond_akhir, 
		jangka_waktu, bunga_tahun, provisi, komisi, angsuran_bulan, keterangan, tujuan_pengajuan, is_map, no_rek_pinjaman, periode_awal, periode_akhir, 
		create_at, create_by, update_at, update_by 
		from fasilitas_pinjaman where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="insert into analisa_agunan (id_pengajuan, analisa_agunan, create_at, create_by, update_at, update_by)
		select $id, analisa_agunan, create_at, create_by, update_at, update_by from analisa_agunan where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="insert into catatan_agunan_rkp (id_pengajuan, catatan_agunan_rkp, create_at, create_by, update_at, update_by)
		select $id, catatan_agunan_rkp, create_at, create_by, update_at, update_by from catatan_agunan_rkp where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="insert into catatan_rekap_rekening (id_pengajuan, catatan, create_at, create_by, update_at, update_by)
		select $id, catatan, create_at, create_by, update_at, update_by from catatan_rekap_rekening where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql = "select id from jaminan_pinjaman_header where id_pengajuan = $idRKP;";
		$cur1 = $this->db->query($sql)->result();
		foreach ($cur1 as $cur)
		{	
			$sql="insert into jaminan_pinjaman_header (id_pengajuan, id_jenis_jaminan, prosen_taksasi, nilai_ht_fidusia, catatan_rkp, analisa_agunan_map, informasi_nilai_pasar,
			catatan_agunan, create_at, create_by, update_at, update_by)
			select $id, id_jenis_jaminan, prosen_taksasi, nilai_ht_fidusia, catatan_rkp, analisa_agunan_map, informasi_nilai_pasar, catatan_agunan,
			create_at, create_by, update_at, update_by from jaminan_pinjaman_header where id_pengajuan = $idRKP and id = $cur->id;";
			$qry = $this->db->query($sql);

			$data_edit = $this->pinjaman_model->getLastIDJaminan();
			$idH = $data_edit[0]->last_id;

			$sql="insert into jaminan_pinjaman_detail (id_header, id_jenis_jaminan, ket_jaminan, create_at, create_by, update_at, update_by)
			select $idH, id_jenis_jaminan, ket_jaminan, create_at, create_by, update_at, update_by from jaminan_pinjaman_detail where id_header = $cur->id;";
			$qry = $this->db->query($sql);

			$sql="insert into jaminan_pinjaman_foto (id_header, keterangan_kiri, foto_kiri, keterangan_kanan, foto_kanan, create_at, create_by, update_at, update_by)
			select $idH, keterangan_kiri, foto_kiri, keterangan_kanan, foto_kanan, create_at, create_by, update_at, update_by from jaminan_pinjaman_foto where id_header = $cur->id;";
			$qry = $this->db->query($sql);

			$sql="insert into jaminan_nilai_pasar (id_header, keterangan, jumlah, id_satuan, harga, total, create_at, create_by, update_at, update_by)
			select $idH, keterangan, jumlah, id_satuan, harga, total, create_at, create_by, update_at, update_by from jaminan_nilai_pasar where id_header = $cur->id;";
			$qry = $this->db->query($sql);

			$sql="insert into catatan_nilai_pasar (id_pengajuan, id_header, catatan_nilai_pasar, create_at, create_by, update_at, update_by)
			select $id, $idH, catatan_nilai_pasar, create_at, create_by, update_at, update_by from catatan_nilai_pasar where id_pengajuan = $idRKP and id_header = $cur->id;";
			$qry = $this->db->query($sql);

			$sql = "select id from survey_nilai_pasar_header where id_header = $cur->id;";
			$survey1 = $this->db->query($sql)->result();
			foreach ($survey1 as $survey)
			{	
				$sql="insert into survey_nilai_pasar_header (id_header, nama_situs, alamat, footer, taksasi, harga_sekarang, create_at, create_by, update_at, update_by)
				select $idH, nama_situs, alamat, footer, taksasi, harga_sekarang, create_at, create_by, update_at, update_by from survey_nilai_pasar_header where id = $survey->id;";
				$qry = $this->db->query($sql);

				$data_edit = $this->pinjaman_model->getLastIDSurvey();
				$idS = $data_edit[0]->last_id;

				$sql="insert into survey_nilai_pasar_detail (id_survey, id_jaminan, jumlah, id_satuan, harga, total, create_at, create_by, update_at, update_by)
				select $idS, id_jaminan, jumlah, id_satuan, harga, total, create_at, create_by, update_at, update_by from survey_nilai_pasar_detail 
				where id_survey = $survey->id;";
				$qry = $this->db->query($sql);				
			}
		}

		$sql="insert into analisa_personal (id_pengajuan, analisa, catatan_pendapatan, kesimpulan, catatan_biaya_ops, catatan_biaya_hdp, 
		catatan_kemampuan, create_by, create_at, update_by, update_at)
		select $id, analisa, catatan_pendapatan, kesimpulan, catatan_biaya_ops, catatan_biaya_hdp, 
		catatan_kemampuan, create_by, create_at, update_by, update_at from analisa_personal where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="insert into analisa_biaya_hidup (id_pengajuan, keterangan, nominal, create_by, create_at, update_by, update_at)
		select $id, keterangan, nominal, create_by, create_at, update_by, update_at from analisa_biaya_hidup where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="insert into analisa_biaya_operasional (id_pengajuan, keterangan, nominal, create_by, create_at, update_by, update_at)
		select $id, keterangan, nominal, create_by, create_at, update_by, update_at from analisa_biaya_operasional where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="insert into biaya_lain (id_pengajuan, keterangan, nominal, create_by, create_at, update_by, update_at)
		select $id, keterangan, nominal, create_by, create_at, update_by, update_at from biaya_lain where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql = "select id from pendapatan_usaha_header where id_pengajuan = $idRKP;";
		$cur2 = $this->db->query($sql)->result();
		foreach ($cur2 as $cur)
		{	
			$sql="insert into pendapatan_usaha_header (id_pengajuan, keterangan, rata_rata_omset, hpp, nett, create_by, create_at, update_by, update_at)
			select $id, keterangan, rata_rata_omset, hpp, nett, create_by, create_at, update_by, update_at from pendapatan_usaha_header where 
			id_pengajuan = $idRKP and id = $cur->id;";
			$qry = $this->db->query($sql);

			$data_edit = $this->pinjaman_model->getLastIDPendapatan();
			$idH = $data_edit[0]->last_id;

			$sql = "insert into pendapatan_usaha_detail (id_header, keterangan, nominal, create_by, create_at, update_by, update_at) 
			select $idH, keterangan, nominal, create_by, create_at, update_by, update_at from pendapatan_usaha_detail where id_header = $cur->id;";
			$qry = $this->db->query($sql);

			$sql = "insert into pendapatan_usaha_foto (id_header, keterangan_kiri, foto_kiri, keterangan_kanan, foto_kanan, create_by, create_at, update_by, update_at)
			select $idH, keterangan_kiri, foto_kiri, keterangan_kanan, foto_kanan, create_by, create_at, update_by, update_at from pendapatan_usaha_foto where id_header = $cur->id;";
			$qry = $this->db->query($sql);
		}

		$sql = "insert into pendapatan_lain (id_pengajuan, keterangan, nominal, create_by, create_at, update_by, update_at)
		select $id, keterangan, nominal, create_by, create_at, update_by, update_at from pendapatan_lain where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql = "select id from rekening_header where id_pengajuan = $idRKP;";
		$cur3 = $this->db->query($sql)->result();
		foreach ($cur3 as $cur)
		{	
			$sql = "insert into rekening_header (id_pengajuan, nama_bank, jenis_rekening, no_rekening, atas_nama, create_by, create_at, update_by, update_at)
			select $id, nama_bank, jenis_rekening, no_rekening, atas_nama, create_by, create_at, update_by, update_at from rekening_header
			where id_pengajuan = $idRKP and id = $cur->id; ";
			$qry = $this->db->query($sql);

			$data_edit = $this->pinjaman_model->getLastIDRek();
			$idH = $data_edit[0]->last_id;

			$sql = "insert into rekening_detail (id_header, periode, debet, debet_frek, kredit, kredit_frek, saldo_tertinggi, saldo_terendah, saldo_rata,
			saldo_akhir_bulan, create_by, create_at, update_by, update_at)
			select $idH, periode, debet, debet_frek, kredit, kredit_frek, saldo_tertinggi, saldo_terendah, saldo_rata,
			saldo_akhir_bulan, create_by, create_at, update_by, update_at from rekening_detail where id_header = $cur->id;";
			$qry = $this->db->query($sql);

		}

		redirect('pengajuan_pinjaman/list/'.$menuid);
	}	

	public function delete_pengajuan_pinjaman($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$sql="delete from pengajuan_pinjaman where id = $idRKP;";
		$qry = $this->db->query($sql);
		
		$sql="delete from fasilitas_pinjaman where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="delete from analisa_agunan where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="delete from catatan_rekap_rekening where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="delete from catatan_agunan_rkp where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql = "select id from jaminan_pinjaman_header where id_pengajuan = $idRKP;";
		$cur1 = $this->db->query($sql)->result();
		foreach ($cur1 as $cur)
		{	
			$sql="delete from jaminan_pinjaman_header where id_pengajuan = $idRKP and id = $cur->id;";
			$qry = $this->db->query($sql);

			$sql="delete from jaminan_pinjaman_detail where id_header = $cur->id;";
			$qry = $this->db->query($sql);

			$sql="delete from jaminan_pinjaman_foto where id_header = $cur->id;";
			$qry = $this->db->query($sql);

			$sql="delete from jaminan_nilai_pasar where id_header = $cur->id;";
			$qry = $this->db->query($sql);

			$sql="delete from catatan_nilai_pasar where id_pengajuan = $idRKP and id_header = $cur->id;";
			$qry = $this->db->query($sql);

			$sql = "select id from survey_nilai_pasar_header where id_header = $cur->id;";
			$survey1 = $this->db->query($sql)->result();
			foreach ($survey1 as $survey)
			{	
				$sql="delete from survey_nilai_pasar_header where id = $survey->id;";
				$qry = $this->db->query($sql);

				$sql="delete from survey_nilai_pasar_detail where id_survey = $survey->id;";
				$qry = $this->db->query($sql);				
			}
		}

		$sql="delete from analisa_personal where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="delete from analisa_biaya_hidup where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="delete from analisa_biaya_operasional where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql="delete from biaya_lain where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql = "select id from pendapatan_usaha_header where id_pengajuan = $idRKP;";
		$cur2 = $this->db->query($sql)->result();
		foreach ($cur2 as $cur)
		{	
			$sql="delete from pendapatan_usaha_header where id_pengajuan = $idRKP and id = $cur->id;";
			$qry = $this->db->query($sql);

			$sql = "delete from pendapatan_usaha_detail where id_header = $cur->id;";
			$qry = $this->db->query($sql);

			$sql = "delete from pendapatan_usaha_foto where id_header = $cur->id;";
			$qry = $this->db->query($sql);
		}

		$sql = "delete from pendapatan_lain where id_pengajuan = $idRKP;";
		$qry = $this->db->query($sql);

		$sql = "select id from rekening_header where id_pengajuan = $idRKP;";
		$cur3 = $this->db->query($sql)->result();
		foreach ($cur3 as $cur)
		{	
			$sql = "delete from rekening_header where id_pengajuan = $idRKP and id = $cur->id; ";
			$qry = $this->db->query($sql);

			$sql = "delete from rekening_detail where id_header = $cur->id;";
			$qry = $this->db->query($sql);

		}

		redirect('pengajuan_pinjaman/list/'.$menuid);
	}	
	
	public function send_to_legal($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$sql = "update pengajuan_pinjaman set send_to_legal = 1 where id = $idRKP ; ";
		$qry = $this->db->query($sql);

		redirect('pengajuan_pinjaman/list/'.$menuid);
	}	

	public function penjamin($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_penjamin']    = $this->master_model->select_in('penjamin_pinjaman', '*', "WHERE id_pengajuan = $id");

    		$this->load->view('pengajuan/penjamin', $data);
	    }
	}

	public function input_penjamin($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_penjamin'] = $this->master_model->select_in('penjamin_pinjaman','*',"where 1=0");

    		$this->load->view('pengajuan/input_penjamin', $data);
	    }
	}

	public function edit_penjamin($menuid, $idRKP, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_penjamin'] = $this->master_model->select_in('penjamin_pinjaman','*',"WHERE id_pengajuan = $idRKP and id = $id ");

    		$this->load->view('pengajuan/edit_penjamin', $data);
	    }
	}

	public function insert_penjamin($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$data = array(			
			'id_pengajuan' => $id,
			'nama_penjamin' => $this->input->post('nama_penjamin'),
			'nik_penjamin' => $this->input->post('nik_penjamin'),
			'tempat_lahir_penjamin' => $this->input->post('tempat_lahir_penjamin'),
			'tanggal_lahir_penjamin' => $this->input->post('tanggal_lahir_penjamin'),
			'alamat_penjamin' => $this->input->post('alamat_penjamin'),
			'pekerjaan_penjamin' => $this->input->post('pekerjaan_penjamin'),			
			'nama_pasangan_penjamin' => $this->input->post('nama_pasangan_penjamin'),
			'nik_pasangan_penjamin' => $this->input->post('nik_pasangan_penjamin'),
			'tempat_lahir_pasangan_penjamin' => $this->input->post('tempat_lahir_pasangan_penjamin'),
			'tanggal_lahir_pasangan_penjamin' => $this->input->post('tanggal_lahir_pasangan_penjamin'),
			'alamat_pasangan_penjamin' => $this->input->post('alamat_pasangan_penjamin'),
			'pekerjaan_pasangan_penjamin' => $this->input->post('pekerjaan_pasangan_penjamin'),	
			'hubungan_pasangan' => $this->input->post('hubungan_pasangan'),	
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('penjamin_pinjaman', $data);

		redirect('pengajuan_pinjaman/penjamin/'.$menuid.'/'.$id);
	}

	public function update_penjamin($menuid, $idRKP, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$data = array(						
			'nama_penjamin' => $this->input->post('nama_penjamin'),
			'nik_penjamin' => $this->input->post('nik_penjamin'),
			'tempat_lahir_penjamin' => $this->input->post('tempat_lahir_penjamin'),
			'tanggal_lahir_penjamin' => $this->input->post('tanggal_lahir_penjamin'),
			'alamat_penjamin' => $this->input->post('alamat_penjamin'),
			'pekerjaan_penjamin' => $this->input->post('pekerjaan_penjamin'),	
			'nama_pasangan_penjamin' => $this->input->post('nama_pasangan_penjamin'),
			'nik_pasangan_penjamin' => $this->input->post('nik_pasangan_penjamin'),
			'tempat_lahir_pasangan_penjamin' => $this->input->post('tempat_lahir_pasangan_penjamin'),
			'tanggal_lahir_pasangan_penjamin' => $this->input->post('tanggal_lahir_pasangan_penjamin'),
			'alamat_pasangan_penjamin' => $this->input->post('alamat_pasangan_penjamin'),
			'pekerjaan_pasangan_penjamin' => $this->input->post('pekerjaan_pasangan_penjamin'),	
			'hubungan_pasangan' => $this->input->post('hubungan_pasangan'),	
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('penjamin_pinjaman', $data);

		redirect('pengajuan_pinjaman/penjamin/'.$menuid.'/'.$idRKP);
	}	
	
	public function delete_penjamin($menuid, $idRKP, $ID)
	{
		$this->db->where('id', $ID);
		$this->db->delete('penjamin_pinjaman');

		redirect('pengajuan_pinjaman/penjamin/'.$menuid.'/'.$idRKP);
	}

	public function send_to_kabag($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$sql = "update pengajuan_pinjaman set send_to_kabag = 1 where id = $idRKP ; ";
		$qry = $this->db->query($sql);

		redirect('perjanjian_pinjaman/list/'.$menuid);
	}	

	public function revisi_analisa($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$sql = "update pengajuan_pinjaman set send_to_legal = 0 where id = $idRKP ; ";
		$qry = $this->db->query($sql);

		redirect('perjanjian_pinjaman/list/'.$menuid);
	}

	public function send_to_admin($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$sql = "update pengajuan_pinjaman set send_to_admin = 1 where id = $idRKP ; ";
		$qry = $this->db->query($sql);

		redirect('perjanjian_pinjaman/listKabag/'.$menuid);
	}	

	public function revisi_legal($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$sql = "update pengajuan_pinjaman set send_to_kabag = 0 where id = $idRKP ; ";
		$qry = $this->db->query($sql);

		redirect('perjanjian_pinjaman/listKabag/'.$menuid);
	}	

	public function revisi_kabag($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$sql = "update pengajuan_pinjaman set send_to_admin = 0 where id = $idRKP ; ";
		$qry = $this->db->query($sql);

		redirect('perjanjian_pinjaman/listAdmin/'.$menuid);
	}
}
?>