<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class payroll_controller extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('transaksi_model');
	}

	public function allowance_deduction($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pheader']   = $this->transaksi_model->trComp(0, 0, 0);

			$this->load->view('payroll/header', $data);
	    }
	}

	public function input_trcomp($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
		$mm = $this->input->post('id_month');
		$yy = $this->input->post('id_year');
		$idComp = $this->input->post('id_component');
		
		if(empty($mm))
		{
			$mm = $this->session->userdata('id_month');
			$yy = $this->session->userdata('id_year');
			$idComp = $this->session->userdata('id_component');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_trcomp']   = $this->transaksi_model->trcomp($mm, $yy, $idComp);

			$this->load->view('payroll/list', $data);
	    }
	}

	public function insert_trcomp($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$data = array(
			'id_month' => $this->input->post('id_month'),
			'id_year' => $this->input->post('id_year'),
			'id_component' => $this->input->post('id_component'),
			'tanggal' => $this->input->post('tanggal'),
			'id_empl' => $this->input->post('id_empl'),
			'amount' => $this->input->post('amount'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1
		);

		$this->session->set_userdata('id_month', $this->input->post('id_month')); 
		$this->session->set_userdata('id_year', $this->input->post('id_year')); 
		$this->session->set_userdata('id_component', $this->input->post('id_component')); 

		$this->db->insert('trcomponent', $data);
		redirect('payroll_controller/input_trcomp/'.$menuid);
	}

	public function payroll_process($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_proses']   = $this->transaksi_model->trComp(0, 0, 0);

			$this->load->view('payroll/process', $data);
	    }
	}

	public function payroll_process1($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
		$mm = $this->input->post('id_month');
		$yy = $this->input->post('id_year');
		$data_tgl=$this->transaksi_model->spGetDate($mm, $yy);
		$dt1 = $data_tgl[0]->first_day;
		$dt2 = $data_tgl[0]->last_day;
		
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_proses']   = $this->transaksi_model->spProsesGaji($mm, $yy, $dt1, $dt2, $user_id);

			$this->load->view('payroll/process_done', $data);
	    }
	}

	public function tax_process($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_proses']   = $this->transaksi_model->trComp(0, 0, 0);

			$this->load->view('payroll/tax_process', $data);
	    }
	}

	public function tax_process1($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
		$mm = $this->input->post('id_month');
		$yy = $this->input->post('id_year');
		
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_proses']   = $this->transaksi_model->spProsesPajak($mm, $yy);

			$this->load->view('payroll/tax_process_done', $data);
	    }
	}

	public function salary_correction($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_proses']   = $this->transaksi_model->trComp(0, 0, 0);

			$this->load->view('payroll/salary_correction', $data);
	    }
	}

	public function salary_correction1($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
		$mm = $this->input->post('id_month');
		$yy = $this->input->post('id_year');
		$empl = $this->input->post('id_empl');
		
		if(empty($mm)){
			$mm = $this->session->userdata('id_month');
			$yy = $this->session->userdata('id_year');
			$empl = $this->session->userdata('id_empl');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_koreksi']   = $this->transaksi_model->spKoreksiGaji($mm, $yy, $empl);

			$this->load->view('payroll/salary_correction1', $data);
	    }
	}

	public function edit_salcor($menuid)
	{
		$ID = $this->input->post('id');	

		$data_edit=$this->master_model->mst_edit_dr('salcor',$ID);
		
		echo'
			<form method="post" action="'.base_url().'payroll_controller/edit_process_salcor/'.$menuid.'" enctype="multipart/form-data">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Salary Correction</h4>
				</div>
				<div class="modal-body">				
					<div class="form-group">
						<label>Month </label>
						<select name="id_month1" class="form-control" disabled>
							<option selected="selected" value="">
								-- Select Month --
							</option>
							';
								$idMonth = $data_edit[0]->id_month;
								$data_month = $this->master_model->select_in('msbulan','*',"ORDER BY id ASC");
								for($a=0; $a < count($data_month); $a++)
								{
									if($idMonth == $data_month[$a]->id)
									{
										$select = 'selected="selected"';
									}else {
										$select = '';
									}
									echo'
										<option value="'.$data_month[$a]->id.'" '.$select.'>
											'.$data_month[$a]->bulan.'
										</option>
									';
								}
							echo'
						</select>
					</div>						
					<div class="form-group">
						<select name="id_month" class="form-control" style="display:none;">
							<option selected="selected" value="">
								-- Select Month --
							</option>
							';
								$idMonth = $data_edit[0]->id_month;
								$data_month = $this->master_model->select_in('msbulan','*',"ORDER BY id ASC");
								for($a=0; $a < count($data_month); $a++)
								{
									if($idMonth == $data_month[$a]->id)
									{
										$select = 'selected="selected"';
									}else {
										$select = '';
									}
									echo'
										<option value="'.$data_month[$a]->id.'" '.$select.'>
											'.$data_month[$a]->bulan.'
										</option>
									';
								}
							echo'
						</select>
					</div>

					<div class="form-group">
						<label>Year</label>
						<input type="text" name="id_year1" value="'.$data_edit[0]->id_year.'" class="form-control" disabled>
					</div>
					<div class="form-group">
						<input type="hidden" name="id_year" value="'.$data_edit[0]->id_year.'" class="form-control" >
					</div>

					<div class="form-group">
						<label>Employee </label>
						<select name="id_empl1" class="form-control" disabled>
							<option selected="selected" value="">
								-- Select Employee --
							</option>
							';
								$idEmpl = $data_edit[0]->id_empl;
								$data_empl = $this->master_model->select_in('msemployee','*',"ORDER BY id ASC");
								for($a=0; $a < count($data_month); $a++)
								{
									if($idEmpl == $data_empl[$a]->id)
									{
										$select = 'selected="selected"';
									}else {
										$select = '';
									}
									echo'
										<option value="'.$data_empl[$a]->id.'" '.$select.'>
											'.$data_empl[$a]->nik.' - '.$data_empl[$a]->name.'
										</option>
									';
								}
							echo'
						</select>
					</div>

					<div class="form-group">
						<select name="id_empl" class="form-control" style="display:none;">
							<option selected="selected" value="">
								-- Select Employee --
							</option>
							';
								$idEmpl = $data_edit[0]->id_empl;
								$data_empl = $this->master_model->select_in('msemployee','*',"ORDER BY id ASC");
								for($a=0; $a < count($data_month); $a++)
								{
									if($idEmpl == $data_empl[$a]->id)
									{
										$select = 'selected="selected"';
									}else {
										$select = '';
									}
									echo'
										<option value="'.$data_empl[$a]->id.'" '.$select.'>
											'.$data_empl[$a]->nik.' - '.$data_empl[$a]->name.'
										</option>
									';
								}
							echo'
						</select>
					</div>

					<div class="form-group">
						<label>Component Code</label>
						<input type="text" name="component_code1" value="'.$data_edit[0]->component_code.'" class="form-control" disabled>
					</div>
					<div class="form-group">
						<input type="hidden" name="component_code" value="'.$data_edit[0]->component_code.'" class="form-control" >
					</div>

					<div class="form-group">
						<label>Component Name</label>
						<input type="text" name="component_name1" value="'.$data_edit[0]->component_name.'" class="form-control" disabled>
					</div>
					<div class="form-group">
						<input type="hidden" name="component_name" value="'.$data_edit[0]->component_name.'" class="form-control" >
					</div>

					<div class="form-group">
						<label>Amount</label>
						<input type="text" name="amount" value="'.$data_edit[0]->amount.'" class="form-control" >
					</div>

                </div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}


	public function edit_process_salcor($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$mm = $this->input->post('id_month');
		$yy = $this->input->post('id_year');
		$empl = $this->input->post('id_empl');
		$comp = $this->input->post('component_code');
		$amt = $this->input->post('amount');

		$this->session->set_userdata('id_month', $this->input->post('id_month')); 
		$this->session->set_userdata('id_year', $this->input->post('id_year')); 
		$this->session->set_userdata('id_empl', $this->input->post('id_empl')); 

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_koreksi']   = $this->transaksi_model->spUpdateGaji($mm, $yy, $empl, $comp, $amt);

			redirect('payroll_controller/salary_correction1/'.$menuid);
			// $this->load->view('payroll/salary_correction1', $data);
	    }
	}

	public function salary_report($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_proses']   = $this->transaksi_model->trComp(0, 0, 0);

			$this->load->view('payroll/salary_report', $data);
	    }
	}

	public function viewSRExcel($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
		$mm = $this->input->post('id_month');
		$yy = $this->input->post('id_year');

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {

			$data['data_sr']    = $this->transaksi_model->spRekapGaji($mm, $yy);

			$this->load->view('payroll/salary_report_excel', $data);
	    }
	}


	public function payroll_report()
	{
		
			$this->load->view('pyreport/payroll_report_view');
		}
		public function pyreport()
		{
			
				$this->load->view('pyreport/pyreport');
			}
	

}
?>
