<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class master_persediaan extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('gallery'); 
		$this->load->helper(array('url','file'));
		$this->load->library('upload');
		$this->load->helper('form'); 
        $this->load->library('form_validation'); 
	}

	public function daftar_persediaan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_persediaan']= $this->master_model->persediaan();

			$this->load->view('persediaan/list', $data);
	    }
	}

	public function input_persediaan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_barang']   = $this->master_model->select_in('mspersediaan','*',"ORDER BY id DESC");
			$this->load->view('persediaan/input_persediaan', $data);
	    }
	}
	
		public function delete_kategori($menuid, $ID)
	{
		

		$this->db->where('id', $ID);
		$this->db->delete('mst_kategori');

	

		
		redirect('master_persediaan/input_persediaan/'.$menuid);
	}
	
	public function delete_merek($menuid, $ID)
	{
		

		$this->db->where('id', $ID);
		$this->db->delete('mst_merek');

	

		
		redirect('master_persediaan/input_persediaan/'.$menuid);
	}
	
		public function delete_warna($menuid, $ID)
	{
		

		$this->db->where('id', $ID);
		$this->db->delete('mst_warna');

	

		
		redirect('master_persediaan/input_persediaan/'.$menuid);
	}
	
		public function delete_uk($menuid, $ID)
	{
		

		$this->db->where('id', $ID);
		$this->db->delete('mst_ukuran');

	

		
		redirect('master_persediaan/input_persediaan/'.$menuid);
	}


	public function insert_kategori_modal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

	
		$data = array(
		
			'kategori' => $_POST["kategori"],
		);


		$this->db->insert('mst_kategori', $data);
		
		$this->load->view('persediaan/input_persediaan');
	}

	public function insert_merek_modal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

	
		$data = array(
		
			'merek' => $_POST["merek"],
		);


		$this->db->insert('mst_merek', $data);
		$this->load->view('persediaan/input_persediaan');
	}

	
	public function insert_model_modal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

	
		$data = array(
		
			'model' => $_POST["model"],
		);


		$this->db->insert('mst_model', $data);
		$this->load->view('persediaan/input_persediaan');
	}

	public function insert_warna_modal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

	
		$data = array(
		
			'warna' => $_POST["warna"],
		);


		$this->db->insert('mst_warna', $data);
		$this->load->view('persediaan/input_persediaan');
	}

	public function insert_ukuran_modal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

	
		$data = array(
		
			'ukuran' => $_POST["ukuran"],
		);


		$this->db->insert('mst_ukuran', $data);
		$this->load->view('persediaan/input_persediaan');
	}

	public function insert_persediaan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$this->load->helper(array('form', 'url')); 
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/product/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'gif|jpg|png|jpeg|bmp|pdf';
		$config['max_size'] = '2048';
		// $config['max_width']  = '1288';
		// $config['max_height']  = '768';
		
		$this->upload->initialize($config);
		  if(!$this->upload->do_upload('photo')){
			  $photo="";
		  }else{
			  $photo=$this->upload->file_name;
		}


	
		$kdbarang = $this->input->post('model');
		$cek = $this->master_model->select_in('mspersediaan','*',"where model = '$kdbarang'");
		if ($cek[0]->model == $kdbarang){
			echo '<script language="javascript">alert("'.$cek[0]->model.' - Model Ini Sudah Ada!");window.history.go(-1);</script>';
			exit();
		}else{

			$data = array(			
				'kategori' => $this->input->post('kategori'),
				'merek' => $this->input->post('merek'),
				'model' => $this->input->post('model'),
				'warna' => $this->input->post('warna'),
				'ukuran' => $this->input->post('ukuran'),
				'harga' => $this->input->post('harga'),
				'keterangan' => $this->input->post('ket'),
				'upload' => $photo,
				'created_at' => date('Y-m-d H:i:s'),
				'created_by' => $user_id1
							
			);
			$this->db->insert('mspersediaan', $data);
			redirect('master_persediaan/daftar_persediaan/'.$menuid);
		}
	}

	public function insert_barang($menuid)
	{
		$id_admin = $this->session->userdata('user_id');
	
		$ID = $this->master_model->mst_last_id('mspersediaan');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $id_admin");
		$user_id1 = $data_admin[0]->name;

		if($_FILES['ImageUpload']['name']=='')
		{
			$kdbarang = $this->input->post('model');
			$cek = $this->master_model->select_in('mspersediaan','*',"where model = '$kdbarang'");
			if ($cek[0]->model == $kdbarang){
				echo '<script language="javascript">alert("'.$cek[0]->model.' - Model Ini Sudah Ada!");window.history.go(-1);</script>';
				exit();
			}else{
	
			
				$data = array(		
					'id' => $ID,
					'kategori' => $this->input->post('kategori'),
					'merek' => $this->input->post('merek'),
					'model' => $this->input->post('model'),
					'warna' => $this->input->post('warna'),
					'ukuran' => $this->input->post('ukuran'),
					'harga' => $this->input->post('harga'),
					'keterangan' => $this->input->post('ket'),
					'created_at' => date('Y-m-d H:i:s'),
					'created_by' => $user_id1
								
				);
				print_r($data);
				die;
				$this->db->insert('mspersediaan', $data);
				//redirect('master_persediaan/daftar_persediaan/'.$menuid);
			}
		}else
		{
			$Image 		= $ID.'.'.substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);
			$Image_temp   = $ID.'_temp.'.substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);

			$config['file_name']      = $ID.'_temp';
			$config['upload_path']    = './uploads/product/';
			$config['allowed_types']  = 'gif|jpg|png|jpeg|';
			$config['max_size']	   = '10000';
			$config['max_width']      = '15000';
			$config['max_height']     = '15000';

			$this->upload->initialize($config);

			if(!$this->upload->do_upload('ImageUpload'))
			{
				$data = array('error' => $this->upload->display_errors('',''));
				$error = $data['error'];
				echo '<script language="javascript">alert("'.$error.'!");window.history.go(-1);</script>';
				exit();
			}else
			{
				$fileImage_temp 	= './uploads/product/'.$Image_temp;
				if (file_exists($fileImage_temp)){unlink($fileImage_temp);}
				$fileImage 	= './uploads/product/'.$Image;
				if (file_exists($fileImage) && $Image!= ''){unlink($fileImage);}
				$config['file_name']      = $ID;
				$this->upload->initialize($config);
				$this->upload->do_upload('ImageUpload');
			}

			$data = array(			
				'id' => $ID,
				'kategori' => $this->input->post('kategori'),
				'merek' => $this->input->post('merek'),
				'model' => $this->input->post('model'),
				'warna' => $this->input->post('warna'),
				'ukuran' => $this->input->post('ukuran'),
				'harga' => $this->input->post('harga'),
				'keterangan' => $this->input->post('ket'),
				'upload' => $Image,
				'created_at' => date('Y-m-d H:i:s'),
				'created_by' => $user_id1
							
			);
			$this->db->insert('mspersediaan', $data);
			
		}

		

		redirect('master_persediaan/daftar_persediaan/'.$menuid);
	}

	public function edit_persediaan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_persediaan']   = $this->master_model->select_in('mspersediaan','*',"where id = $id ORDER BY id DESC");
			$this->load->view('persediaan/edit_persediaan', $data);
	    }
	}

	public function update_persediaan($menuid, $ID)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'kategori' => $this->input->post('kategori'),
			'merek' => $this->input->post('merek'),
			// 'model' => $this->input->post('model'),
			'warna' => $this->input->post('warna'),
			'ukuran' => $this->input->post('ukuran'),
			'harga' => $this->input->post('harga'),
			'keterangan' => $this->input->post('ket'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	

	
	
		$this->db->where('id', $ID);
		$this->db->update('mspersediaan', $data);

		redirect('master_persediaan/daftar_persediaan/'.$menuid);
	}

	public function update_persediaan1($menuid)
	{
		if($_FILES['ImageUpload']['name']=='')
		{
		
			$data = array(
				'name' => $this->input->post('name'),
				'address' => $this->input->post('address'),
				'phone' => $this->input->post('phone'),
				'email' => $this->input->post('email'),
				'news' => $this->input->post('news'),
				'flag' => $this->input->post('publish')
			);
			$this->db->where('ID', 1);
			$this->db->update('config_global', $data);
		}else
		{
			$ID = $this->input->post('id');
			$Image 		= $ID.'.'.substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);
			$Image_temp   = $ID.'_temp.'.substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);


			$config['file_name']      = $ID.'_temp';
			$config['upload_path']    = './uploads/config_global/';
			$config['allowed_types']  = 'gif|jpg|png|jpeg|';
			$config['max_size']	      = '2000';
			$config['max_width']      = '1500';
			$config['max_height']     = '1500';

			$this->upload->initialize($config);

			if(!$this->upload->do_upload('ImageUpload'))
			{
				$data = array('error' => $this->upload->display_errors('',''));
				$error = $data['error'];
				echo '<script language="javascript">alert("'.$error.'!");window.history.go(-1);</script>';
				exit();
			}else
			{
				$fileImage_temp 	= './uploads/config_global/'.$Image_temp;
				if (file_exists($fileImage_temp)){unlink($fileImage_temp);}
				$fileImage 	= './uploads/config_global/'.$Image;
				if (file_exists($fileImage) && $Image!= ''){unlink($fileImage);}
				$config['file_name']      = $ID;
				$this->upload->initialize($config);
				$this->upload->do_upload('ImageUpload');
			}

			$data = array(
				'name'    => $this->input->post('name'),
				'address' => $this->input->post('address'),
				'phone'   => $this->input->post('phone'),
				'email'   => $this->input->post('email'),
				'news'    => $this->input->post('news'),
				'flag'    => $this->input->post('publish'),
				'image'   => $Image
			);
			$this->db->where('ID', 1);
			$this->db->update('config_global', $data);
		}

		redirect('master/config/'.$menuid);
	}


	public function proses_upload(){

        $config['upload_path']   = FCPATH.'/uploads/product/';
        $config['allowed_types'] = 'gif|jpg|png|ico|jpeg|';
        $this->load->library('upload',$config);

        if($this->upload->do_upload('userfile')){
        	$token=$this->input->post('token_foto');
			$nama=$this->upload->data('file_name');
		
        	$this->db->insert('foto',array('nama_foto'=>$nama,'token'=>$token));
        }


	}

	function remove_foto(){

		//Ambil token foto
		$token=$this->input->post('token');

		
		$foto=$this->db->get_where('foto',array('token'=>$token));


		if($foto->num_rows()>0){
			$hasil=$foto->row();
			$nama_foto=$hasil->nama_foto;
			if(file_exists($file=FCPATH.'/uploads/product/'.$nama_foto)){
				unlink($file);
			}
			$this->db->delete('foto',array('token'=>$token));

		}


		echo "{}";
	}

	function dragDropUpload(){ 
        if(!empty($_FILES)){ 
            // File upload configuration 
            $uploadPath = 'uploads/product/'; 
            $config['upload_path'] = $uploadPath; 
            $config['allowed_types'] = '*'; 
             
            // Load and initialize upload library 
            $this->load->library('upload', $config); 
            $this->upload->initialize($config); 
             
            // Upload file to the server 
            if($this->upload->do_upload('userfile')){ 
				$ID = $this->master_model->mst_last_id('mspersediaan');
                $fileData = $this->upload->data(); 
                $uploadData['nama_foto'] = $fileData['file_name']; 
                $uploadData['id_mspersediaan'] = $ID; 
                $uploadData['token'] = $this->input->post('token_foto');
                 
                // Insert files info into the database 
				//$insert = $this->file->insert($uploadData); 
				$this->db->insert('foto', $uploadData);
			
            } 
        } 
	} 
	

	
	public function delete_persediaan($menuid, $ID)
	{
		

		$this->db->where('id', $ID);
		$this->db->delete('mspersediaan');

		$this->db->where('id_mspersediaan', $ID);
		$this->db->delete('foto');

		
		redirect('master_persediaan/daftar_persediaan/'.$menuid);
	}


	
	public function tes($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_persediaan']= $this->master_model->persediaan();
			$data['title'] = 'Gallery Archive'; 
			$this->load->view('tes/list', $data);
	    }
	}

	public function tes_input($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_barang']   = $this->master_model->select_in('mspersediaan','*',"ORDER BY id DESC");
			
			$this->load->view('tes/input_tes', $data);
	    }
	}

	public function edit_tes($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_persediaan']   = $this->master_model->select_in('mspersediaan','*',"where id = $id ORDER BY id DESC");
			$this->load->view('tes/edit_tes', $data);
	    }
	}

	public function load_dropzone()
	{
		$ds = DIRECTORY_SEPARATOR; 
	
		$result  = array();
		$storeFolder ="uploads/foto/";
		$query= $this->master_model->select_in('foto','*',"where id_mspersediaan= '7' ORDER BY id DESC");
		//$query=$this->db->get_where('foto',array('id_mspersediaan'=>'7'));
		
		if($query->num_rows() >  0){
			while($file=mysqli_fetch_array($query)){
				if ( '.'!=$file && '..'!=$file) {      
					$obj['name'] = $file['nama_foto'];
					$obj['size'] = filesize($storeFolder.$ds.$file['nama_foto']);
					$obj['id'] = $file['id'];
					$result[] = $obj;
				}
			}
		}
		header('Content-type: text/json');             
		header('Content-type: application/json');
		echo json_encode($result);
		

	}


	public function gallery(){ 

      
        $data = array(); 
         
        // Get messages from the session 
        if($this->session->userdata('success_msg')){ 
            $data['success_msg'] = $this->session->userdata('success_msg'); 
            $this->session->unset_userdata('success_msg'); 
        } 
        if($this->session->userdata('error_msg')){ 
            $data['error_msg'] = $this->session->userdata('error_msg'); 
            $this->session->unset_userdata('error_msg'); 
        } 
 
        $data['gallery'] = $this->gallery->getRows(); 
        $data['title'] = 'Gallery Archive'; 
         
        // Load the list page view 
        $this->load->view('tes/templates/header', $data); 
        $this->load->view('tes/gallerry/index', $data); 
        $this->load->view('tes/templates/footer'); 
	} 
	

	public function add_gallery(){ 

		
        $data = $galleryData = array(); 
        $errorUpload = ''; 
         
        // If add request is submitted 
        if($this->input->post('imgSubmit')){ 
            // Form field validation rules 
            $this->form_validation->set_rules('title', 'gallery title', 'required'); 
             
            // Prepare gallery data 
            $galleryData = array( 
                'title' => $this->input->post('title') 
            ); 
			 
		
            // Validate submitted form data 
            if($this->form_validation->run() == true){ 
                // Insert gallery data 
                $insert = $this->gallery->insert($galleryData); 
                $galleryID = $insert;  
                 
                if($insert){ 
                    if(!empty($_FILES['images']['name'])){ 
                        $filesCount = count($_FILES['images']['name']); 
                        for($i = 0; $i < $filesCount; $i++){ 
                            $_FILES['file']['name']     = $_FILES['images']['name'][$i]; 
                            $_FILES['file']['type']     = $_FILES['images']['type'][$i]; 
                            $_FILES['file']['tmp_name'] = $_FILES['images']['tmp_name'][$i]; 
                            $_FILES['file']['error']    = $_FILES['images']['error'][$i]; 
                            $_FILES['file']['size']     = $_FILES['images']['size'][$i]; 
                             
                            // File upload configuration 
                            $uploadPath = 'uploads/foto/'; 
                            $config['upload_path'] = $uploadPath; 
                            $config['allowed_types'] = 'jpg|jpeg|png|gif'; 
                             
                            // Load and initialize upload library 
                            $this->load->library('upload', $config); 
                            $this->upload->initialize($config); 
                             
                            // Upload file to server 
                            if($this->upload->do_upload('file')){ 
                                // Uploaded file data 
                                $fileData = $this->upload->data(); 
                                $uploadData[$i]['gallery_id'] = $galleryID; 
                                $uploadData[$i]['file_name'] = $fileData['file_name']; 
                                $uploadData[$i]['uploaded_on'] = date("Y-m-d H:i:s"); 
                            }else{ 
                                $errorUpload .= $fileImages[$key].'('.$this->upload->display_errors('', '').') | ';  
                            } 
                        } 
                         
                        // File upload error message 
                        $errorUpload = !empty($errorUpload)?' Upload Error: '.trim($errorUpload, ' | '):''; 
                         
                        if(!empty($uploadData)){ 
                            // Insert files info into the database 
                            $insert = $this->gallery->insertImage($uploadData); 
                        } 
                    } 
                     
                    $this->session->set_userdata('success_msg', 'Gallery has been added successfully.'.$errorUpload); 
					redirect('master_persediaan/gallery/');
                }else{ 
                    $data['error_msg'] = 'Some problems occurred, please try again.'; 
                } 
            } 
        } 
         
        $data['gallery'] = $galleryData; 
        $data['title'] = 'Create Gallery'; 
        $data['action'] = 'Add'; 
         
        // Load the add page view 
		$this->load->view('tes/templates/header', $data); 
        $this->load->view('tes/gallerry/add_edit', $data); 
		$this->load->view('tes/templates/footer'); 
		
		
	} 
	
	public function view($id){ 
        $data = array(); 
         
        // Check whether id is not empty 
        if(!empty($id)){ 
            $data['gallery'] = $this->gallery->getRows($id); 
            $data['title'] = $data['gallery']['title']; 
             
            // Load the details page view 
            $this->load->view('tes/templates/header', $data); 
            $this->load->view('tes/gallerry/view', $data); 
            $this->load->view('tes/templates/footer'); 
        }else{ 
            redirect($this->controller); 
        } 
	} 


	public function update_image($menuid, $id)
	{
		$data = $galleryData = array(); 
         
        // Get gallery data 
		$galleryData = $this->gallery->getfoto($id); 
		
         
        // If update request is submitted 
        if($this->input->post('imgSubmit')){ 
            // Form field validation rules 
            $this->form_validation->set_rules('title', 'gallery title', 'required'); 
             
            // Prepare gallery data 
            $galleryData = array( 
                'title' => $this->input->post('title') 
            ); 
             
            // Validate submitted form data 
            if($this->form_validation->run() == true){ 
                // Update gallery data 
                $update = $this->gallery->update($galleryData, $id); 
 
                if($update){ 
                    if(!empty($_FILES['images']['name'])){ 
                        $filesCount = count($_FILES['images']['name']); 
                        for($i = 0; $i < $filesCount; $i++){ 
                            $_FILES['file']['name']     = $_FILES['images']['name'][$i]; 
                            $_FILES['file']['type']     = $_FILES['images']['type'][$i]; 
                            $_FILES['file']['tmp_name'] = $_FILES['images']['tmp_name'][$i]; 
                            $_FILES['file']['error']    = $_FILES['images']['error'][$i]; 
                            $_FILES['file']['size']     = $_FILES['images']['size'][$i]; 
                             
                            // File upload configuration 
                            $uploadPath = 'uploads/product/'; 
                            $config['upload_path'] = $uploadPath; 
                            $config['allowed_types'] = 'jpg|jpeg|png|gif'; 
                             
                            // Load and initialize upload library 
                            $this->load->library('upload', $config); 
                            $this->upload->initialize($config); 
                             
                            // Upload file to server 
                            if($this->upload->do_upload('file')){ 
                                // Uploaded file data 
                                $fileData = $this->upload->data(); 
                                $uploadData[$i]['id_mspersediaan'] = $id; 
                                $uploadData[$i]['nama_foto'] = $fileData['file_name']; 
                                $uploadData[$i]['updated_at'] = date("Y-m-d H:i:s"); 
                            }else{ 
                                $errorUpload .= $fileImages[$key].'('.$this->upload->display_errors('', '').') | ';  
                            } 
                        } 
                         
                        // File upload error message 
                        $errorUpload = !empty($errorUpload)?'Upload Error: '.trim($errorUpload, ' | '):''; 
                         
                        if(!empty($uploadData)){ 
                            // Insert files data into the database 
                            $insert = $this->gallery->insertImage($uploadData); 
                        } 
                    } 
 
                    $this->session->set_userdata('success_msg', 'Gallery has been updated successfully.'.$errorUpload); 
					redirect('master_persediaan/edit_images/'.$menuid.'/'.$id.'');
                }else{ 
                    $data['error_msg'] = 'Some problems occurred, please try again.'; 
                } 
            } 
		} 
		
 
         
       
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['gallery'] = $galleryData; 

			$data['title'] = 'Update Gallery'; 
			$data['action'] = 'Edit'; 
	    	$data['data_persediaan']   = $this->master_model->select_in('mspersediaan','*',"where id = $id ORDER BY id DESC");
			$this->load->view('tes/edit_tes', $data);
	    }
	}

	public function edit_images($menuid, $id)
	{
		$data = $galleryData = array(); 
         
        // Get gallery data 
		$galleryData = $this->gallery->getfoto($id); 
		
		

         
        // If update request is submitted 
        if($this->input->post('imgSubmit')){ 
            // Form field validation rules 
            $this->form_validation->set_rules('title', 'gallery title', 'required'); 
             
            // Prepare gallery data 
            $galleryData = array( 
                'title' => $this->input->post('title') 
            ); 
             
            // Validate submitted form data 
            if($this->form_validation->run() == true){ 
                // Update gallery data 
                $update = $this->gallery->update($galleryData, $id); 
 
                if($update){ 
                    if(!empty($_FILES['images']['name'])){ 
                        $filesCount = count($_FILES['images']['name']); 
                        for($i = 0; $i < $filesCount; $i++){ 
                            $_FILES['file']['name']     = $_FILES['images']['name'][$i]; 
                            $_FILES['file']['type']     = $_FILES['images']['type'][$i]; 
                            $_FILES['file']['tmp_name'] = $_FILES['images']['tmp_name'][$i]; 
                            $_FILES['file']['error']    = $_FILES['images']['error'][$i]; 
                            $_FILES['file']['size']     = $_FILES['images']['size'][$i]; 
                             
                            // File upload configuration 
                            $uploadPath = 'uploads/product/'; 
                            $config['upload_path'] = $uploadPath; 
                            $config['allowed_types'] = 'jpg|jpeg|png|gif'; 
                             
                            // Load and initialize upload library 
                            $this->load->library('upload', $config); 
                            $this->upload->initialize($config); 
                             
                            // Upload file to server 
                            if($this->upload->do_upload('file')){ 
                                // Uploaded file data 
                                $fileData = $this->upload->data(); 
                                $uploadData[$i]['id_mspersediaan'] = $id; 
                                $uploadData[$i]['nama_foto'] = $fileData['file_name']; 
                                $uploadData[$i]['updated_at'] = date("Y-m-d H:i:s"); 
                            }else{ 
                                $errorUpload .= $fileImages[$key].'('.$this->upload->display_errors('', '').') | ';  
                            } 
                        } 
                         
                        // File upload error message 
                        $errorUpload = !empty($errorUpload)?'Upload Error: '.trim($errorUpload, ' | '):''; 
                         
                        if(!empty($uploadData)){ 
                            // Insert files data into the database 
                            $insert = $this->gallery->insertImage($uploadData); 
                        } 
                    } 
 
                    $this->session->set_userdata('success_msg', 'Gallery has been updated successfully.'.$errorUpload); 
					redirect('master_persediaan/edit_images/'.$menuid.'/'.$id.'');
                }else{ 
                    $data['error_msg'] = 'Some problems occurred, please try again.'; 
                } 
            } 
		} 
		
 
         
       
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['gallery'] = $galleryData; 

			$data['title'] = 'Update Gallery'; 
			$data['action'] = 'Edit'; 
	    	$data['data_persediaan']   = $this->master_model->select_in('mspersediaan','*',"where id = $id ORDER BY id DESC");
			$this->load->view('persediaan/edit_persediaan', $data);
	    }
	}

	public function edit($id){ 
        $data = $galleryData = array(); 
         
        // Get gallery data 
        $galleryData = $this->gallery->getRows($id); 
	
        // If update request is submitted 
        if($this->input->post('imgSubmit')){ 
            // Form field validation rules 
            $this->form_validation->set_rules('title', 'gallery title', 'required'); 
             
            // Prepare gallery data 
            $galleryData = array( 
                'title' => $this->input->post('title') 
            ); 
             
            // Validate submitted form data 
            if($this->form_validation->run() == true){ 
                // Update gallery data 
                $update = $this->gallery->update($galleryData, $id); 
 
                if($update){ 
                    if(!empty($_FILES['images']['name'])){ 
                        $filesCount = count($_FILES['images']['name']); 
                        for($i = 0; $i < $filesCount; $i++){ 
                            $_FILES['file']['name']     = $_FILES['images']['name'][$i]; 
                            $_FILES['file']['type']     = $_FILES['images']['type'][$i]; 
                            $_FILES['file']['tmp_name'] = $_FILES['images']['tmp_name'][$i]; 
                            $_FILES['file']['error']    = $_FILES['images']['error'][$i]; 
                            $_FILES['file']['size']     = $_FILES['images']['size'][$i]; 
                             
                            // File upload configuration 
                            $uploadPath = 'uploads/foto/'; 
                            $config['upload_path'] = $uploadPath; 
                            $config['allowed_types'] = 'jpg|jpeg|png|gif'; 
                             
                            // Load and initialize upload library 
                            $this->load->library('upload', $config); 
                            $this->upload->initialize($config); 
                             
                            // Upload file to server 
                            if($this->upload->do_upload('file')){ 
                                // Uploaded file data 
                                $fileData = $this->upload->data(); 
                                $uploadData[$i]['gallery_id'] = $id; 
                                $uploadData[$i]['file_name'] = $fileData['file_name']; 
                                $uploadData[$i]['uploaded_on'] = date("Y-m-d H:i:s"); 
                            }else{ 
                                $errorUpload .= $fileImages[$key].'('.$this->upload->display_errors('', '').') | ';  
                            } 
                        } 
                         
                        // File upload error message 
                        $errorUpload = !empty($errorUpload)?'Upload Error: '.trim($errorUpload, ' | '):''; 
                         
                        if(!empty($uploadData)){ 
                            // Insert files data into the database 
                            $insert = $this->gallery->insertImage($uploadData); 
                        } 
                    } 
 
                    $this->session->set_userdata('success_msg', 'Gallery has been updated successfully.'.$errorUpload); 
					redirect('master_persediaan/gallery/');
                }else{ 
                    $data['error_msg'] = 'Some problems occurred, please try again.'; 
                } 
            } 
        } 
 
         
        $data['gallery'] = $galleryData; 
        $data['title'] = 'Update Gallery'; 
        $data['action'] = 'Edit'; 
         
        // Load the edit page view 
        $this->load->view('tes/templates/header', $data); 
        $this->load->view('tes/gallerry/add_edit', $data); 
        $this->load->view('tes/templates/footer'); 
    } 
     
    public function block($id){ 
        // Check whether gallery id is not empty 
        if($id){ 
            // Update gallery status 
            $data = array('status' => 0); 
            $update = $this->gallery->update($data, $id); 
             
            if($update){ 
                $this->session->set_userdata('success_msg', 'Gallery has been blocked successfully.'); 
            }else{ 
                $this->session->set_userdata('error_msg', 'Some problems occurred, please try again.'); 
            } 
        } 
 
        redirect($this->controller); 
    } 
     
    public function unblock($id){ 
        // Check whether gallery id is not empty 
        if($id){ 
            // Update gallery status 
            $data = array('status' => 1); 
            $update = $this->gallery->update($data, $id); 
             
            if($update){ 
                $this->session->set_userdata('success_msg', 'Gallery has been activated successfully.'); 
            }else{ 
                $this->session->set_userdata('error_msg', 'Some problems occurred, please try again.'); 
            } 
        } 
 
        redirect($this->controller); 
    } 
     
    public function delete($id){ 
        // Check whether id is not empty 
        if($id){ 
            $galleryData = $this->gallery->getRows($id); 
             
            // Delete gallery data 
            $delete = $this->gallery->delete($id); 
             
            if($delete){ 
                // Delete images data  
                $condition = array('gallery_id' => $id);  
                $deleteImg = $this->gallery->deleteImage($condition);  
                  
                // Remove files from the server  
                if(!empty($galleryData['images'])){  
                    foreach($galleryData['images'] as $img){  
                        @unlink('uploads/foto/'.$img['file_name']);  
                    }  
                }  
                 
                $this->session->set_userdata('success_msg', 'Gallery has been removed successfully.'); 
            }else{ 
                $this->session->set_userdata('error_msg', 'Some problems occurred, please try again.'); 
            } 
        } 
 
        redirect('master_persediaan/gallery/');
    } 
     
    public function deleteImage(){ 
        $status  = 'err';  
        // If post request is submitted via ajax 
        if($this->input->post('id')){ 
			$id = $this->input->post('id'); 
			echo($id);
			
            $imgData = $this->gallery->getImgRow($id); 
             
            // Delete image data 
            $con = array('id' => $id); 
            $delete = $this->gallery->deleteImage($con); 
             
            if($delete){ 
                // Remove files from the server  
                @unlink('uploads/product/'.$imgData['nama_foto']);  
                $status = 'ok';  
            } 
        } 
        echo $status;die;  
	} 
	

	public function delete_image($menuid, $ID, $id)
	{
		

		$this->db->where('id', $id);
		$this->db->delete('foto');


		
		redirect('master_persediaan/edit_images/'.$menuid.'/'.$ID);
	}


}
?>
