<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class lembur extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('lembur_model');
		date_default_timezone_set('Asia/Jakarta');
	}


	public function pengajuan_lembur($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('lembur/pengajuan_lembur', $data);
	    }
	}

	public function calculateTimeDifference()
    {        
        $start_time = $this->input->post('start_time');
		$end_time = $this->input->post('end_time');
	
		// Buat objek DateTime untuk start_time dan end_time
		$start_datetime = new DateTime($start_time);
		$end_datetime = new DateTime($end_time);
	
		// Hitung selisih waktu menggunakan diff
		$interval = $start_datetime->diff($end_datetime);
	
		// Dapatkan selisih waktu dalam jam dan menit
		$hours = $interval->h;
		$minutes = $interval->i;

		// Kirim hasil perhitungan ke tampilan sebagai respons JSON
		$result = [
			'hours' => $hours,
			'minutes' => $minutes,
		];

        echo json_encode($result);
    }

	public function update_status_lembur($menuid) {
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
								
		$id = $this->input->post('id');
		$persetujuan = $this->input->post('persetujuan_lembur');

		if($persetujuan==0){
			$data = array(
				'tindakan_hrd' => $this->input->post('tindakan'),
				'tgl_tindakan_hrd' => date('Y-m-d'),				
				'update_at' => date('Y-m-d H:i:s'),
				'update_by' => $user_id1			
			);

		} else {
			if($pengelola==0){
				$data = array(
					'tindakan_hrd' => $this->input->post('tindakan'),
					'tgl_tindakan_hrd' => date('Y-m-d'),				
					'update_at' => date('Y-m-d H:i:s'),
					'update_by' => $user_id1			
				);
			} else {
				$data = array(
					'tindakan_kadiv' => $this->input->post('tindakan'),
					'tgl_tindakan_kadiv' => date('Y-m-d'),
					'update_at' => date('Y-m-d H:i:s'),
					'update_by' => $user_id1			
				);
	
			}	
		}
		
		$this->db->where('id', $id);
		$this->db->update('tr_permohonan_lembur', $data);

		redirect('lembur/daftar_pengajuan/'.$menuid);

	}

	
	public function get_end_time() {
        // Menerima data waktu dari permintaan POST AJAX
        $startTimeValue = $this->input->post('start_time');

        // Melakukan perhitungan end_time
        $endTime = $this->calculateEndTime($startTimeValue);

        // Menyusun hasil dalam format JSON
        $result = ['end_time' => $endTime];

        // Mengirim hasil sebagai respons JSON
        header('Content-Type: application/json');
        echo json_encode($result);
    }

	// Fungsi untuk menghitung end_time
    private function calculateEndTime($startTimeValue) {
		
		$startTimestamp = strtotime($startTimeValue);
		$endTimestamp = $startTimestamp + 4 * 60 * 60;
		$endTime = date('H:i', $endTimestamp);
		
		$calculatedEndTime = $endTime;
	
        return $calculatedEndTime;
    }
		
	public function insert_pengajuan_lembur($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_permohonan'));
		$tgl_permohonan = $date->format('Y-m-d');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_lembur'));
		$tgl_lembur = $date->format('Y-m-d');

		$data = array(
			'id_pengelola' => $this->input->post('id_pengelola'),
			'tgl_permohonan' => $tgl_permohonan,
			'keperluan' => $this->input->post('keperluan'),
			'tgl_lembur' => $tgl_lembur,
			'jam_mulai' => $this->input->post('jam_mulai'),
			'jam_akhir' => $this->input->post('jam_akhir'),
			'lama_lembur' => $this->input->post('lama_lembur'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);
		
	
		
	
		$this->db->insert('tr_permohonan_lembur', $data);
		
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['modal_message'] = 'Permohonan lembur anda berhasil di kirim dan akan di review oleh Kadiv';
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('lembur/pengajuan_lembur', $data);
	    }
	}	

	public function daftar_pengajuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
		if(empty($pengelola)){
			$pengelola = 0;
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_lembur']   = $this->lembur_model->pengajuan_lembur($pengelola);

			$this->load->view('lembur/daftar_pengajuan', $data);
	    }
	}

    public function riwayat_lembur($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
		if(empty($pengelola)){
			$pengelola = 0;
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_lembur']   = $this->lembur_model->riwayat_lembur($pengelola);

			$this->load->view('lembur/riwayat_pengajuan', $data);
	    }
	}
	
	public function laporan_lembur($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_lembur']   = $this->master_model->select_in('tr_permohonan_lembur','*',"where 1=0");
			$this->load->view('lembur/laporan_lembur', $data);
	    }
	}
	
	public function detail_lap_lembur($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal1]'));
		$tanggal1 = $date->format('Y-m-d');
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal2]'));
		$tanggal2 = $date->format('Y-m-d');

		if (empty($tanggal1)){
			$tanggal1 = $this->session->userdata('tanggal1');
			$tanggal2 = $this->session->userdata('tanggal2');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_lembur']   = $this->lembur_model->laporanlembur($tanggal1, $tanggal2);
			$this->load->view('lembur/detail_lembur', $data);
	    }
	}
	
	public function excel_lembur($menuid, $tanggal1, $tanggal2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_lembur']   = $this->lembur_model->laporanlembur($tanggal1, $tanggal2);
			$this->load->view('lembur/excel_lembur', $data);
	    }
	}
}
?>
